package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBConfig invokes the clickhouse.DescribeDBConfig API synchronously
func (client *Client) DescribeDBConfig(request *DescribeDBConfigRequest) (response *DescribeDBConfigResponse, err error) {
	response = CreateDescribeDBConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBConfigWithChan invokes the clickhouse.DescribeDBConfig API asynchronously
func (client *Client) DescribeDBConfigWithChan(request *DescribeDBConfigRequest) (<-chan *DescribeDBConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeDBConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBConfigWithCallback invokes the clickhouse.DescribeDBConfig API asynchronously
func (client *Client) DescribeDBConfigWithCallback(request *DescribeDBConfigRequest, callback func(response *DescribeDBConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBConfigRequest is the request struct for api DescribeDBConfig
type DescribeDBConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBConfigResponse is the response struct for api DescribeDBConfig
type DescribeDBConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Config    string `json:"Config" xml:"Config"`
}

// CreateDescribeDBConfigRequest creates a request to invoke DescribeDBConfig API
func CreateDescribeDBConfigRequest() (request *DescribeDBConfigRequest) {
	request = &DescribeDBConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeDBConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBConfigResponse creates a response to parse from DescribeDBConfig response
func CreateDescribeDBConfigResponse() (response *DescribeDBConfigResponse) {
	response = &DescribeDBConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
