package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishCabIvr invokes the cloudcallcenter.PublishCabIvr API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/publishcabivr.html
func (client *Client) PublishCabIvr(request *PublishCabIvrRequest) (response *PublishCabIvrResponse, err error) {
	response = CreatePublishCabIvrResponse()
	err = client.DoAction(request, response)
	return
}

// PublishCabIvrWithChan invokes the cloudcallcenter.PublishCabIvr API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/publishcabivr.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PublishCabIvrWithChan(request *PublishCabIvrRequest) (<-chan *PublishCabIvrResponse, <-chan error) {
	responseChan := make(chan *PublishCabIvrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishCabIvr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishCabIvrWithCallback invokes the cloudcallcenter.PublishCabIvr API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/publishcabivr.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PublishCabIvrWithCallback(request *PublishCabIvrRequest, callback func(response *PublishCabIvrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishCabIvrResponse
		var err error
		defer close(result)
		response, err = client.PublishCabIvr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishCabIvrRequest is the request struct for api PublishCabIvr
type PublishCabIvrRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// PublishCabIvrResponse is the response struct for api PublishCabIvr
type PublishCabIvrResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ContactFlowId  string `json:"ContactFlowId" xml:"ContactFlowId"`
}

// CreatePublishCabIvrRequest creates a request to invoke PublishCabIvr API
func CreatePublishCabIvrRequest() (request *PublishCabIvrRequest) {
	request = &PublishCabIvrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "PublishCabIvr", "", "")
	request.Method = requests.POST
	return
}

// CreatePublishCabIvrResponse creates a response to parse from PublishCabIvr response
func CreatePublishCabIvrResponse() (response *PublishCabIvrResponse) {
	response = &PublishCabIvrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
