package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPageConfigTemplate invokes the cloudwf.GetPageConfigTemplate API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getpageconfigtemplate.html
func (client *Client) GetPageConfigTemplate(request *GetPageConfigTemplateRequest) (response *GetPageConfigTemplateResponse, err error) {
	response = CreateGetPageConfigTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// GetPageConfigTemplateWithChan invokes the cloudwf.GetPageConfigTemplate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getpageconfigtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPageConfigTemplateWithChan(request *GetPageConfigTemplateRequest) (<-chan *GetPageConfigTemplateResponse, <-chan error) {
	responseChan := make(chan *GetPageConfigTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPageConfigTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPageConfigTemplateWithCallback invokes the cloudwf.GetPageConfigTemplate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getpageconfigtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPageConfigTemplateWithCallback(request *GetPageConfigTemplateRequest, callback func(response *GetPageConfigTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPageConfigTemplateResponse
		var err error
		defer close(result)
		response, err = client.GetPageConfigTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPageConfigTemplateRequest is the request struct for api GetPageConfigTemplate
type GetPageConfigTemplateRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// GetPageConfigTemplateResponse is the response struct for api GetPageConfigTemplate
type GetPageConfigTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetPageConfigTemplateRequest creates a request to invoke GetPageConfigTemplate API
func CreateGetPageConfigTemplateRequest() (request *GetPageConfigTemplateRequest) {
	request = &GetPageConfigTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetPageConfigTemplate", "cloudwf", "openAPI")
	return
}

// CreateGetPageConfigTemplateResponse creates a response to parse from GetPageConfigTemplate response
func CreateGetPageConfigTemplateResponse() (response *GetPageConfigTemplateResponse) {
	response = &GetPageConfigTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
