package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepoTagScanList invokes the cr.GetRepoTagScanList API synchronously
func (client *Client) GetRepoTagScanList(request *GetRepoTagScanListRequest) (response *GetRepoTagScanListResponse, err error) {
	response = CreateGetRepoTagScanListResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepoTagScanListWithChan invokes the cr.GetRepoTagScanList API asynchronously
func (client *Client) GetRepoTagScanListWithChan(request *GetRepoTagScanListRequest) (<-chan *GetRepoTagScanListResponse, <-chan error) {
	responseChan := make(chan *GetRepoTagScanListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepoTagScanList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepoTagScanListWithCallback invokes the cr.GetRepoTagScanList API asynchronously
func (client *Client) GetRepoTagScanListWithCallback(request *GetRepoTagScanListRequest, callback func(response *GetRepoTagScanListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepoTagScanListResponse
		var err error
		defer close(result)
		response, err = client.GetRepoTagScanList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepoTagScanListRequest is the request struct for api GetRepoTagScanList
type GetRepoTagScanListRequest struct {
	*requests.RoaRequest
	Severity      string           `position:"Query" name:"Severity"`
	RepoNamespace string           `position:"Path" name:"RepoNamespace"`
	RepoName      string           `position:"Path" name:"RepoName"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	Tag           string           `position:"Path" name:"Tag"`
	Page          requests.Integer `position:"Query" name:"Page"`
}

// GetRepoTagScanListResponse is the response struct for api GetRepoTagScanList
type GetRepoTagScanListResponse struct {
	*responses.BaseResponse
}

// CreateGetRepoTagScanListRequest creates a request to invoke GetRepoTagScanList API
func CreateGetRepoTagScanListRequest() (request *GetRepoTagScanListRequest) {
	request = &GetRepoTagScanListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetRepoTagScanList", "/repos/[RepoNamespace]/[RepoName]/tags/[Tag]/scanResult", "acr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRepoTagScanListResponse creates a response to parse from GetRepoTagScanList response
func CreateGetRepoTagScanListResponse() (response *GetRepoTagScanListResponse) {
	response = &GetRepoTagScanListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
