package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateServiceLinkedRole invokes the dbfs.CreateServiceLinkedRole API synchronously
func (client *Client) CreateServiceLinkedRole(request *CreateServiceLinkedRoleRequest) (response *CreateServiceLinkedRoleResponse, err error) {
	response = CreateCreateServiceLinkedRoleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServiceLinkedRoleWithChan invokes the dbfs.CreateServiceLinkedRole API asynchronously
func (client *Client) CreateServiceLinkedRoleWithChan(request *CreateServiceLinkedRoleRequest) (<-chan *CreateServiceLinkedRoleResponse, <-chan error) {
	responseChan := make(chan *CreateServiceLinkedRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateServiceLinkedRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServiceLinkedRoleWithCallback invokes the dbfs.CreateServiceLinkedRole API asynchronously
func (client *Client) CreateServiceLinkedRoleWithCallback(request *CreateServiceLinkedRoleRequest, callback func(response *CreateServiceLinkedRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServiceLinkedRoleResponse
		var err error
		defer close(result)
		response, err = client.CreateServiceLinkedRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServiceLinkedRoleRequest is the request struct for api CreateServiceLinkedRole
type CreateServiceLinkedRoleRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
}

// CreateServiceLinkedRoleResponse is the response struct for api CreateServiceLinkedRole
type CreateServiceLinkedRoleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateServiceLinkedRoleRequest creates a request to invoke CreateServiceLinkedRole API
func CreateCreateServiceLinkedRoleRequest() (request *CreateServiceLinkedRoleRequest) {
	request = &CreateServiceLinkedRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "CreateServiceLinkedRole", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateServiceLinkedRoleResponse creates a response to parse from CreateServiceLinkedRole response
func CreateCreateServiceLinkedRoleResponse() (response *CreateServiceLinkedRoleResponse) {
	response = &CreateServiceLinkedRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
