package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePublishGroupTask invokes the dms_enterprise.CreatePublishGroupTask API synchronously
func (client *Client) CreatePublishGroupTask(request *CreatePublishGroupTaskRequest) (response *CreatePublishGroupTaskResponse, err error) {
	response = CreateCreatePublishGroupTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePublishGroupTaskWithChan invokes the dms_enterprise.CreatePublishGroupTask API asynchronously
func (client *Client) CreatePublishGroupTaskWithChan(request *CreatePublishGroupTaskRequest) (<-chan *CreatePublishGroupTaskResponse, <-chan error) {
	responseChan := make(chan *CreatePublishGroupTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePublishGroupTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePublishGroupTaskWithCallback invokes the dms_enterprise.CreatePublishGroupTask API asynchronously
func (client *Client) CreatePublishGroupTaskWithCallback(request *CreatePublishGroupTaskRequest, callback func(response *CreatePublishGroupTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePublishGroupTaskResponse
		var err error
		defer close(result)
		response, err = client.CreatePublishGroupTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePublishGroupTaskRequest is the request struct for api CreatePublishGroupTask
type CreatePublishGroupTaskRequest struct {
	*requests.RpcRequest
	OrderId         requests.Integer `position:"Query" name:"OrderId"`
	Tid             requests.Integer `position:"Query" name:"Tid"`
	DbId            requests.Integer `position:"Query" name:"DbId"`
	PlanTime        string           `position:"Query" name:"PlanTime"`
	Logic           requests.Boolean `position:"Query" name:"Logic"`
	PublishStrategy string           `position:"Query" name:"PublishStrategy"`
}

// CreatePublishGroupTaskResponse is the response struct for api CreatePublishGroupTask
type CreatePublishGroupTaskResponse struct {
	*responses.BaseResponse
	TaskId       int64  `json:"TaskId" xml:"TaskId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateCreatePublishGroupTaskRequest creates a request to invoke CreatePublishGroupTask API
func CreateCreatePublishGroupTaskRequest() (request *CreatePublishGroupTaskRequest) {
	request = &CreatePublishGroupTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreatePublishGroupTask", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePublishGroupTaskResponse creates a response to parse from CreatePublishGroupTask response
func CreateCreatePublishGroupTaskResponse() (response *CreatePublishGroupTaskResponse) {
	response = &CreatePublishGroupTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
