package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOrders invokes the dms_enterprise.ListOrders API synchronously
func (client *Client) ListOrders(request *ListOrdersRequest) (response *ListOrdersResponse, err error) {
	response = CreateListOrdersResponse()
	err = client.DoAction(request, response)
	return
}

// ListOrdersWithChan invokes the dms_enterprise.ListOrders API asynchronously
func (client *Client) ListOrdersWithChan(request *ListOrdersRequest) (<-chan *ListOrdersResponse, <-chan error) {
	responseChan := make(chan *ListOrdersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOrders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOrdersWithCallback invokes the dms_enterprise.ListOrders API asynchronously
func (client *Client) ListOrdersWithCallback(request *ListOrdersRequest, callback func(response *ListOrdersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOrdersResponse
		var err error
		defer close(result)
		response, err = client.ListOrders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOrdersRequest is the request struct for api ListOrders
type ListOrdersRequest struct {
	*requests.RpcRequest
	OrderStatus     string           `position:"Query" name:"OrderStatus"`
	SearchContent   string           `position:"Query" name:"SearchContent"`
	SearchDateType  string           `position:"Query" name:"SearchDateType"`
	EndTime         string           `position:"Query" name:"EndTime"`
	StartTime       string           `position:"Query" name:"StartTime"`
	Tid             requests.Integer `position:"Query" name:"Tid"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PluginType      string           `position:"Query" name:"PluginType"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	OrderResultType string           `position:"Query" name:"OrderResultType"`
}

// ListOrdersResponse is the response struct for api ListOrders
type ListOrdersResponse struct {
	*responses.BaseResponse
	TotalCount   int64  `json:"TotalCount" xml:"TotalCount"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Orders       Orders `json:"Orders" xml:"Orders"`
}

// CreateListOrdersRequest creates a request to invoke ListOrders API
func CreateListOrdersRequest() (request *ListOrdersRequest) {
	request = &ListOrdersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListOrders", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOrdersResponse creates a response to parse from ListOrders response
func CreateListOrdersResponse() (response *ListOrdersResponse) {
	response = &ListOrdersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
