package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPrivateIp invokes the eais.GetPrivateIp API synchronously
func (client *Client) GetPrivateIp(request *GetPrivateIpRequest) (response *GetPrivateIpResponse, err error) {
	response = CreateGetPrivateIpResponse()
	err = client.DoAction(request, response)
	return
}

// GetPrivateIpWithChan invokes the eais.GetPrivateIp API asynchronously
func (client *Client) GetPrivateIpWithChan(request *GetPrivateIpRequest) (<-chan *GetPrivateIpResponse, <-chan error) {
	responseChan := make(chan *GetPrivateIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPrivateIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPrivateIpWithCallback invokes the eais.GetPrivateIp API asynchronously
func (client *Client) GetPrivateIpWithCallback(request *GetPrivateIpRequest, callback func(response *GetPrivateIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPrivateIpResponse
		var err error
		defer close(result)
		response, err = client.GetPrivateIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPrivateIpRequest is the request struct for api GetPrivateIp
type GetPrivateIpRequest struct {
	*requests.RpcRequest
	ClientInstanceId string `position:"Query" name:"ClientInstanceId"`
}

// GetPrivateIpResponse is the response struct for api GetPrivateIp
type GetPrivateIpResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	PrivateIp string `json:"PrivateIp" xml:"PrivateIp"`
}

// CreateGetPrivateIpRequest creates a request to invoke GetPrivateIp API
func CreateGetPrivateIpRequest() (request *GetPrivateIpRequest) {
	request = &GetPrivateIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "GetPrivateIp", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPrivateIpResponse creates a response to parse from GetPrivateIp response
func CreateGetPrivateIpResponse() (response *GetPrivateIpResponse) {
	response = &GetPrivateIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
