package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGrayEnvironment invokes the edas.DeleteGrayEnvironment API synchronously
func (client *Client) DeleteGrayEnvironment(request *DeleteGrayEnvironmentRequest) (response *DeleteGrayEnvironmentResponse, err error) {
	response = CreateDeleteGrayEnvironmentResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGrayEnvironmentWithChan invokes the edas.DeleteGrayEnvironment API asynchronously
func (client *Client) DeleteGrayEnvironmentWithChan(request *DeleteGrayEnvironmentRequest) (<-chan *DeleteGrayEnvironmentResponse, <-chan error) {
	responseChan := make(chan *DeleteGrayEnvironmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGrayEnvironment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGrayEnvironmentWithCallback invokes the edas.DeleteGrayEnvironment API asynchronously
func (client *Client) DeleteGrayEnvironmentWithCallback(request *DeleteGrayEnvironmentRequest, callback func(response *DeleteGrayEnvironmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGrayEnvironmentResponse
		var err error
		defer close(result)
		response, err = client.DeleteGrayEnvironment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGrayEnvironmentRequest is the request struct for api DeleteGrayEnvironment
type DeleteGrayEnvironmentRequest struct {
	*requests.RoaRequest
	LogicalRegionId string `position:"Query" name:"LogicalRegionId"`
	PointcutName    string `position:"Query" name:"PointcutName"`
}

// DeleteGrayEnvironmentResponse is the response struct for api DeleteGrayEnvironment
type DeleteGrayEnvironmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteGrayEnvironmentRequest creates a request to invoke DeleteGrayEnvironment API
func CreateDeleteGrayEnvironmentRequest() (request *DeleteGrayEnvironmentRequest) {
	request = &DeleteGrayEnvironmentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteGrayEnvironment", "/pop/v5/gray/env", "Edas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteGrayEnvironmentResponse creates a response to parse from DeleteGrayEnvironment response
func CreateDeleteGrayEnvironmentResponse() (response *DeleteGrayEnvironmentResponse) {
	response = &DeleteGrayEnvironmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
