package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSnapshotSetting invokes the elasticsearch.UpdateSnapshotSetting API synchronously
func (client *Client) UpdateSnapshotSetting(request *UpdateSnapshotSettingRequest) (response *UpdateSnapshotSettingResponse, err error) {
	response = CreateUpdateSnapshotSettingResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSnapshotSettingWithChan invokes the elasticsearch.UpdateSnapshotSetting API asynchronously
func (client *Client) UpdateSnapshotSettingWithChan(request *UpdateSnapshotSettingRequest) (<-chan *UpdateSnapshotSettingResponse, <-chan error) {
	responseChan := make(chan *UpdateSnapshotSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSnapshotSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSnapshotSettingWithCallback invokes the elasticsearch.UpdateSnapshotSetting API asynchronously
func (client *Client) UpdateSnapshotSettingWithCallback(request *UpdateSnapshotSettingRequest, callback func(response *UpdateSnapshotSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSnapshotSettingResponse
		var err error
		defer close(result)
		response, err = client.UpdateSnapshotSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSnapshotSettingRequest is the request struct for api UpdateSnapshotSetting
type UpdateSnapshotSettingRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// UpdateSnapshotSettingResponse is the response struct for api UpdateSnapshotSetting
type UpdateSnapshotSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateUpdateSnapshotSettingRequest creates a request to invoke UpdateSnapshotSetting API
func CreateUpdateSnapshotSettingRequest() (request *UpdateSnapshotSettingRequest) {
	request = &UpdateSnapshotSettingRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateSnapshotSetting", "/openapi/instances/[InstanceId]/snapshot-setting", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSnapshotSettingResponse creates a response to parse from UpdateSnapshotSetting response
func CreateUpdateSnapshotSettingResponse() (response *UpdateSnapshotSettingResponse) {
	response = &UpdateSnapshotSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
