package imageseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentFood invokes the imageseg.SegmentFood API synchronously
func (client *Client) SegmentFood(request *SegmentFoodRequest) (response *SegmentFoodResponse, err error) {
	response = CreateSegmentFoodResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentFoodWithChan invokes the imageseg.SegmentFood API asynchronously
func (client *Client) SegmentFoodWithChan(request *SegmentFoodRequest) (<-chan *SegmentFoodResponse, <-chan error) {
	responseChan := make(chan *SegmentFoodResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentFood(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentFoodWithCallback invokes the imageseg.SegmentFood API asynchronously
func (client *Client) SegmentFoodWithCallback(request *SegmentFoodRequest, callback func(response *SegmentFoodResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentFoodResponse
		var err error
		defer close(result)
		response, err = client.SegmentFood(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentFoodRequest is the request struct for api SegmentFood
type SegmentFoodRequest struct {
	*requests.RpcRequest
	ReturnForm string `position:"Query" name:"ReturnForm"`
	ImageURL   string `position:"Query" name:"ImageURL"`
}

// SegmentFoodResponse is the response struct for api SegmentFood
type SegmentFoodResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentFoodRequest creates a request to invoke SegmentFood API
func CreateSegmentFoodRequest() (request *SegmentFoodRequest) {
	request = &SegmentFoodRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageseg", "2019-12-30", "SegmentFood", "imageseg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSegmentFoodResponse creates a response to parse from SegmentFood response
func CreateSegmentFoodResponse() (response *SegmentFoodResponse) {
	response = &SegmentFoodResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
