package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateUserIsolationState invokes the linkwan.UpdateUserIsolationState API synchronously
func (client *Client) UpdateUserIsolationState(request *UpdateUserIsolationStateRequest) (response *UpdateUserIsolationStateResponse, err error) {
	response = CreateUpdateUserIsolationStateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateUserIsolationStateWithChan invokes the linkwan.UpdateUserIsolationState API asynchronously
func (client *Client) UpdateUserIsolationStateWithChan(request *UpdateUserIsolationStateRequest) (<-chan *UpdateUserIsolationStateResponse, <-chan error) {
	responseChan := make(chan *UpdateUserIsolationStateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateUserIsolationState(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateUserIsolationStateWithCallback invokes the linkwan.UpdateUserIsolationState API asynchronously
func (client *Client) UpdateUserIsolationStateWithCallback(request *UpdateUserIsolationStateRequest, callback func(response *UpdateUserIsolationStateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateUserIsolationStateResponse
		var err error
		defer close(result)
		response, err = client.UpdateUserIsolationState(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateUserIsolationStateRequest is the request struct for api UpdateUserIsolationState
type UpdateUserIsolationStateRequest struct {
	*requests.RpcRequest
	Isolated    requests.Boolean `position:"Query" name:"Isolated"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// UpdateUserIsolationStateResponse is the response struct for api UpdateUserIsolationState
type UpdateUserIsolationStateResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateUserIsolationStateRequest creates a request to invoke UpdateUserIsolationState API
func CreateUpdateUserIsolationStateRequest() (request *UpdateUserIsolationStateRequest) {
	request = &UpdateUserIsolationStateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "UpdateUserIsolationState", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateUserIsolationStateResponse creates a response to parse from UpdateUserIsolationState response
func CreateUpdateUserIsolationStateResponse() (response *UpdateUserIsolationStateResponse) {
	response = &UpdateUserIsolationStateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
