package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCommodity invokes the market.CreateCommodity API synchronously
// api document: https://help.aliyun.com/api/market/createcommodity.html
func (client *Client) CreateCommodity(request *CreateCommodityRequest) (response *CreateCommodityResponse, err error) {
	response = CreateCreateCommodityResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCommodityWithChan invokes the market.CreateCommodity API asynchronously
// api document: https://help.aliyun.com/api/market/createcommodity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCommodityWithChan(request *CreateCommodityRequest) (<-chan *CreateCommodityResponse, <-chan error) {
	responseChan := make(chan *CreateCommodityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCommodity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCommodityWithCallback invokes the market.CreateCommodity API asynchronously
// api document: https://help.aliyun.com/api/market/createcommodity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCommodityWithCallback(request *CreateCommodityRequest, callback func(response *CreateCommodityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCommodityResponse
		var err error
		defer close(result)
		response, err = client.CreateCommodity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCommodityRequest is the request struct for api CreateCommodity
type CreateCommodityRequest struct {
	*requests.RpcRequest
	ApplicationId string `position:"Query" name:"ApplicationId"`
	Content       string `position:"Body" name:"Content"`
}

// CreateCommodityResponse is the response struct for api CreateCommodity
type CreateCommodityResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Success   bool      `json:"Success" xml:"Success"`
	Commodity Commodity `json:"Commodity" xml:"Commodity"`
}

// CreateCreateCommodityRequest creates a request to invoke CreateCommodity API
func CreateCreateCommodityRequest() (request *CreateCommodityRequest) {
	request = &CreateCommodityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "CreateCommodity", "yunmarket", "openAPI")
	return
}

// CreateCreateCommodityResponse creates a response to parse from CreateCommodity response
func CreateCreateCommodityResponse() (response *CreateCommodityResponse) {
	response = &CreateCommodityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
