package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBlackListClients invokes the nas.DescribeBlackListClients API synchronously
func (client *Client) DescribeBlackListClients(request *DescribeBlackListClientsRequest) (response *DescribeBlackListClientsResponse, err error) {
	response = CreateDescribeBlackListClientsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBlackListClientsWithChan invokes the nas.DescribeBlackListClients API asynchronously
func (client *Client) DescribeBlackListClientsWithChan(request *DescribeBlackListClientsRequest) (<-chan *DescribeBlackListClientsResponse, <-chan error) {
	responseChan := make(chan *DescribeBlackListClientsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBlackListClients(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBlackListClientsWithCallback invokes the nas.DescribeBlackListClients API asynchronously
func (client *Client) DescribeBlackListClientsWithCallback(request *DescribeBlackListClientsRequest, callback func(response *DescribeBlackListClientsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBlackListClientsResponse
		var err error
		defer close(result)
		response, err = client.DescribeBlackListClients(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBlackListClientsRequest is the request struct for api DescribeBlackListClients
type DescribeBlackListClientsRequest struct {
	*requests.RpcRequest
	ClientIP     string `position:"Query" name:"ClientIP"`
	FileSystemId string `position:"Query" name:"FileSystemId"`
}

// DescribeBlackListClientsResponse is the response struct for api DescribeBlackListClients
type DescribeBlackListClientsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Clients   string `json:"Clients" xml:"Clients"`
}

// CreateDescribeBlackListClientsRequest creates a request to invoke DescribeBlackListClients API
func CreateDescribeBlackListClientsRequest() (request *DescribeBlackListClientsRequest) {
	request = &DescribeBlackListClientsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DescribeBlackListClients", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeBlackListClientsResponse creates a response to parse from DescribeBlackListClients response
func CreateDescribeBlackListClientsResponse() (response *DescribeBlackListClientsResponse) {
	response = &DescribeBlackListClientsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
