package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListModels invokes the nlp_automl.ListModels API synchronously
func (client *Client) ListModels(request *ListModelsRequest) (response *ListModelsResponse, err error) {
	response = CreateListModelsResponse()
	err = client.DoAction(request, response)
	return
}

// ListModelsWithChan invokes the nlp_automl.ListModels API asynchronously
func (client *Client) ListModelsWithChan(request *ListModelsRequest) (<-chan *ListModelsResponse, <-chan error) {
	responseChan := make(chan *ListModelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListModels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListModelsWithCallback invokes the nlp_automl.ListModels API asynchronously
func (client *Client) ListModelsWithCallback(request *ListModelsRequest, callback func(response *ListModelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListModelsResponse
		var err error
		defer close(result)
		response, err = client.ListModels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListModelsRequest is the request struct for api ListModels
type ListModelsRequest struct {
	*requests.RpcRequest
	Product    string           `position:"Body" name:"Product"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	ProjectId  requests.Integer `position:"Body" name:"ProjectId"`
}

// ListModelsResponse is the response struct for api ListModels
type ListModelsResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
	Code      int                    `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	Success   bool                   `json:"Success" xml:"Success"`
}

// CreateListModelsRequest creates a request to invoke ListModels API
func CreateListModelsRequest() (request *ListModelsRequest) {
	request = &ListModelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-11-11", "ListModels", "nlpautoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListModelsResponse creates a response to parse from ListModels response
func CreateListModelsResponse() (response *ListModelsResponse) {
	response = &ListModelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
