package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTrustedServiceStatus invokes the resourcemanager.ListTrustedServiceStatus API synchronously
func (client *Client) ListTrustedServiceStatus(request *ListTrustedServiceStatusRequest) (response *ListTrustedServiceStatusResponse, err error) {
	response = CreateListTrustedServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListTrustedServiceStatusWithChan invokes the resourcemanager.ListTrustedServiceStatus API asynchronously
func (client *Client) ListTrustedServiceStatusWithChan(request *ListTrustedServiceStatusRequest) (<-chan *ListTrustedServiceStatusResponse, <-chan error) {
	responseChan := make(chan *ListTrustedServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTrustedServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTrustedServiceStatusWithCallback invokes the resourcemanager.ListTrustedServiceStatus API asynchronously
func (client *Client) ListTrustedServiceStatusWithCallback(request *ListTrustedServiceStatusRequest, callback func(response *ListTrustedServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTrustedServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.ListTrustedServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTrustedServiceStatusRequest is the request struct for api ListTrustedServiceStatus
type ListTrustedServiceStatusRequest struct {
	*requests.RpcRequest
	AdminAccountId string           `position:"Query" name:"AdminAccountId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
}

// ListTrustedServiceStatusResponse is the response struct for api ListTrustedServiceStatus
type ListTrustedServiceStatusResponse struct {
	*responses.BaseResponse
	TotalCount               int                      `json:"TotalCount" xml:"TotalCount"`
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	PageSize                 int                      `json:"PageSize" xml:"PageSize"`
	PageNumber               int                      `json:"PageNumber" xml:"PageNumber"`
	EnabledServicePrincipals EnabledServicePrincipals `json:"EnabledServicePrincipals" xml:"EnabledServicePrincipals"`
}

// CreateListTrustedServiceStatusRequest creates a request to invoke ListTrustedServiceStatus API
func CreateListTrustedServiceStatusRequest() (request *ListTrustedServiceStatusRequest) {
	request = &ListTrustedServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "ListTrustedServiceStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateListTrustedServiceStatusResponse creates a response to parse from ListTrustedServiceStatus response
func CreateListTrustedServiceStatusResponse() (response *ListTrustedServiceStatusResponse) {
	response = &ListTrustedServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
