package subscription

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateContact invokes the subscription.UpdateContact API synchronously
// api document: https://help.aliyun.com/api/subscription/updatecontact.html
func (client *Client) UpdateContact(request *UpdateContactRequest) (response *UpdateContactResponse, err error) {
	response = CreateUpdateContactResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateContactWithChan invokes the subscription.UpdateContact API asynchronously
// api document: https://help.aliyun.com/api/subscription/updatecontact.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateContactWithChan(request *UpdateContactRequest) (<-chan *UpdateContactResponse, <-chan error) {
	responseChan := make(chan *UpdateContactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateContact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateContactWithCallback invokes the subscription.UpdateContact API asynchronously
// api document: https://help.aliyun.com/api/subscription/updatecontact.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateContactWithCallback(request *UpdateContactRequest, callback func(response *UpdateContactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateContactResponse
		var err error
		defer close(result)
		response, err = client.UpdateContact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateContactRequest is the request struct for api UpdateContact
type UpdateContactRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	ContactId   requests.Integer `position:"Body" name:"ContactId"`
	Mobile      string           `position:"Body" name:"Mobile"`
	Locale      string           `position:"Query" name:"Locale"`
	Name        string           `position:"Body" name:"Name"`
	Email       string           `position:"Body" name:"Email"`
}

// UpdateContactResponse is the response struct for api UpdateContact
type UpdateContactResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateUpdateContactRequest creates a request to invoke UpdateContact API
func CreateUpdateContactRequest() (request *UpdateContactRequest) {
	request = &UpdateContactRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Subscription", "2021-01-15", "UpdateContact", "", "")
	return
}

// CreateUpdateContactResponse creates a response to parse from UpdateContact response
func CreateUpdateContactResponse() (response *UpdateContactResponse) {
	response = &UpdateContactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
