/* vim: set sw=8 ts=8 si : */
/* Author: Guido Socher, Copyright: GPL */
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <strings.h>
#include <string.h>
#include <sys/ioctl.h>
#include <linux/cdrom.h>
#include <sys/types.h>
#include <fcntl.h>


/* This string can be read by the Unix program "what" */
#define VERINFO "@(#)Version: 0.3"

static int opt_d=0;
static int opt_s=-1;
static char *dev;
/*end global data*/

void help()
{
        printf("cdspeed -- decrease the speed of you cdrom to get\n\
faster access times\n\
\n\
USAGE: cdspeed [-h] [-d device] -s speed\n\
\n\
OPTIONS:-h this help\n\
        -d use the given device instead of /dev/cdrom\n\
        -s set the speed. The argument is a integer.\n\
	   Zero means restore full speed.\n\
\n\
Modern cdrom drives are too fast. It can take several seconds\n\
on a 60x speed cdrom drive to spin it up and read data from\n\
the drive.  The result is that these drives are just a lot slower\n\
than a 8x or 24x drive.  This is especially true if you are only\n\
occasionally (e.g every 5 seconds) reading a small file. This\n\
utility limits the speed, makes the drive less noisy and the\n\
access time faster.\n\
\n\
EXAMPLE:\n\
 cdspeed -s 12\n\
\n");

#ifdef VERINFO
	puts(VERINFO);
#endif
	exit(0);
}

int main(int argc, char *argv[])
{
	/* The following things are used for getopt: */
        extern char *optarg;
        extern int optind;
        extern int opterr;
	int ch,i,cdfd;

	opterr = 0;
	while ((ch = getopt(argc, argv, "hd:s:")) != -1) {
		switch (ch) {
		case 'd':
			opt_d=1;
			dev=(char *)malloc(strlen(optarg)+1);
			strcpy(dev,optarg);
			break;
		case 's':
			opt_s=atoi(optarg);
			if (opt_s < 0 || opt_s > 128 || *optarg < '0' || *optarg > '9'){
				fprintf(stderr, "ERROR: speed out of range\n");
				exit(1);
			}
			break;
		case 'h':
			help(); /*no break, help does not return */
		case '?':
		default :
			fprintf(stderr, "ERROR: No such option. -h for help.\n");
			exit(1);
		/*no default action for case */
		}
	}
	if (opt_s == -1){
		help();
	}
	if (opt_d == 0){
		dev="/dev/cdrom";
	}
	cdfd=open(dev, O_RDONLY|O_NONBLOCK);
	if (cdfd <0){
		fprintf(stderr,"ERROR: can not open %s\n",dev);
		exit(1);
	}
	if ((ioctl(cdfd,CDROM_SELECT_SPEED,opt_s))<0){
		fprintf(stderr,"ERROR: unable to set speed to %d\n",opt_s);
		exit(1);
	}
	close(cdfd);
	return(0);
}
