/*
 * noexec - a runner for anoter program, which will be unable to 
 * create child process.
 * Copyright (C) 2003 Valery Reznic <valery_reznic@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <ctype.h>

#include <config.h>
#include "noexec_macro.h"

static void usage(char *PgmName)
{
   fprintf(
      stderr, 
"Usage: %s [<options>] arguments\n"
"\n"
"Where <options> are:\n"
"  -l <lib>      - filename of noexec lib, which should be preload.\n"
"  -L <path>     - path to noexec lib, which should be preload.\n"
"  -h            - print this help\n"
"  -v            - print version information.\n"
,
PgmName
);
}

static void print_version(char *PgmName)
{
   fprintf(
      stderr,
"%s version %s\n"
"Copyrigth (C) 2003 Valery Reznic\n"
"\n"
"This is free software; see the sources for copying conditions.\n"
"\n"
"Report bugs to <valery_reznic@users.sourceforge.net>\n"
,
      PgmName, VERSION
   );
}
int main(int argc, char *argv[])
{
   char *PreloadLibraryPath = PRELOAD_LIBRARY_PATH;
   char *PreloadLibraryName = PRELOAD_LIBRARY_NAME;
                       
   char  *PgmName;    /* Program Name */
   int    res;        /* functions' call  result */

   PgmName  = argv[0];

   if (argc == 0) {
      usage(PgmName);
      exit(1);
   }

   while (1) {
      // I need to stop option processing on the first non-option arg,
      // so, i need '+' here.
      res = getopt(argc, argv, "+l:L:hv");
      if (res == -1) break;
      switch (res) {
         case 'l':
            PreloadLibraryName = optarg;
         break;

         case 'L':
            PreloadLibraryPath = optarg;
         break;

         case 'h':
            usage(PgmName);
         exit(0);

         case 'v':
            print_version(PgmName);
         exit(0);

         case '?':
         exit(1);

         default: /* Should not get here */
            fprintf(stderr, "%s: internal error - getopt (opt = '%c')\n", PgmName, res);
         exit(1);
      }
   }

   switch (argc - optind) {
      case 0: /* no arguments */
         fprintf(stderr, "%s: missing argument(s).\n", PgmName);
      exit(1);

      default:
         /* We have argument(s), ok */
      break;
   }

   /* Option parsing successfully finished !!! */

   /* Now prepend noexec lib to LD_PRELOAD */
   {
      char *LD_PRELOAD;
      char *LD_PRELOAD_NEW;

      LD_PRELOAD = getenv("LD_PRELOAD");

      if (LD_PRELOAD == NULL) LD_PRELOAD = "";
      /* I need add our library to LD_PRELOAD */
      /* len + ' ' + len(LD_PRELOAD)    + 0 */
      MY_MALLOC(
	  LD_PRELOAD_NEW, 
	  strlen(PreloadLibraryPath) + 1 + strlen(PreloadLibraryName) + 1 + strlen(LD_PRELOAD) + 1
      );
      sprintf(
         LD_PRELOAD_NEW,
	 "%s/%s %s",
	 PreloadLibraryPath,
	 PreloadLibraryName,
	 LD_PRELOAD
      );
      SETENV("LD_PRELOAD", LD_PRELOAD_NEW);

      execvp(argv[optind], &argv[optind]);
   }
   /* Exec should not return. If we here it's an error. */
   _MY_FPRINTF("exec", argv[optind]);
   exit(1);
   return 1; /* Dummy, to make compiler happy */
}
