<p style="float:right"><img align="right" src="docs/dir-zzip-64.png" /></p>

[![make check](https://github.com/gdraheim/zziplib/actions/workflows/makecheck.yml/badge.svg?event=push&branch=develop)](https://github.com/gdraheim/zziplib/actions/workflows/makecheck.yml)
[![py style](https://github.com/gdraheim/zziplib/actions/workflows/stylecheck.yml/badge.svg?event=push&branch=develop)](https://github.com/gdraheim/zziplib/actions/workflows/stylecheck.yml)
[![py types](https://github.com/gdraheim/zziplib/actions/workflows/typecheck.yml/badge.svg?event=push&branch=develop)](https://github.com/gdraheim/zziplib/actions/workflows/typecheck.yml)
[![py types](https://github.com/gdraheim/zziplib/actions/workflows/clangformat.yml/badge.svg?event=push&branch=develop)](https://github.com/gdraheim/zziplib/actions/workflows/clangformat.yml)
[![coverage](https://img.shields.io/badge/233%20test-50%25%20coverage-brightgreen)](https://github.com/gdraheim/zziplib/blob/master/test/zziptests.py)

... **please switch to 'cmake' based builds** ... 

The zziplib provides read access to zipped files in a zip-archive,
using compression based solely on free algorithms provided by zlib.
It also provides a functionality to overlay the archive filesystem
with the filesystem of the operating system environment.

The origins of the project go back to the 1999 when Tomi Ollila
did explore the details of the zip format. It was adopted by
Guido Draheim in 2000 making the source code portable to many
platforms. Originally maintained on Sourceforge it moved to
GitHub in 2017 for easier collobaration with other projects.

> also check out the original [README](README) file

**DOCUMENTATION**

* [Library Overview](docs/README.MD) .... and for more details, see http://zziplib.sourceforge.net/
* [copying](docs/copying.htm.md)
  [developer](docs/developer.htm.md)
  [functions](docs/functions.htm.md)
  [php](docs/zip-php.htm.md)
  [referentials](docs/referentials.htm.md)
  [future](docs/future.htm.md)
  [notes](docs/notes.htm.md)
  [64on32](docs/64on32.htm.md)
  [download](docs/download.htm.md)
  [history](docs/history.htm.md)
* [zzip:](docs/zzip-index.htm.md) 
  [basics](docs/zzip-basics.htm.md)
  [api](docs/zzip-api.htm.md)
  [crypt](docs/zzip-crypt.htm.md)
  [cryptoid](docs/zzip-cryptoid.htm.md)
  [extio](docs/zzip-extio.htm.md)
  [extras](docs/zzip-extras.htm.md)
  [file](docs/zzip-file.htm.md)
  [parse](docs/zzip-parse.htm.md)
  [sdl-rwops](docs/zzip-rwops.htm.md)
  [xor](docs/zzip-xor.htm.md)
  [zip](docs/zzip-zip.htm.md)
  [sfx-make](docs/sfx-make.htm.md)
* [zziplib](docs/zziplib.html)
  [mmapped](docs/mmapped.htm.md)
  [fseeko](docs/fseeko.htm.md)
  [download](docs/download.htm.md)
  [faq](docs/faq.htm.md)
