// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpointsmsvoice

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateConfigurationSet = "CreateConfigurationSet"

// CreateConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationSet for more information on using the CreateConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigurationSetRequest method.
//    req, resp := client.CreateConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/CreateConfigurationSet
func (c *PinpointSMSVoice) CreateConfigurationSetRequest(input *CreateConfigurationSetInput) (req *request.Request, output *CreateConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/sms-voice/configuration-sets",
	}

	if input == nil {
		input = &CreateConfigurationSetInput{}
	}

	output = &CreateConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConfigurationSet API operation for Amazon Pinpoint SMS and Voice Service.
//
// Create a new configuration set. After you create the configuration set, you
// can add one or more event destinations to it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS and Voice Service's
// API operation CreateConfigurationSet for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   You've issued too many requests to the resource. Wait a few minutes, and
//   then try again.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * InternalServiceErrorException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/CreateConfigurationSet
func (c *PinpointSMSVoice) CreateConfigurationSet(input *CreateConfigurationSetInput) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetWithContext is the same as CreateConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoice) CreateConfigurationSetWithContext(ctx aws.Context, input *CreateConfigurationSetInput, opts ...request.Option) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationSetEventDestination = "CreateConfigurationSetEventDestination"

// CreateConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationSetEventDestination for more information on using the CreateConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigurationSetEventDestinationRequest method.
//    req, resp := client.CreateConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/CreateConfigurationSetEventDestination
func (c *PinpointSMSVoice) CreateConfigurationSetEventDestinationRequest(input *CreateConfigurationSetEventDestinationInput) (req *request.Request, output *CreateConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSetEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations",
	}

	if input == nil {
		input = &CreateConfigurationSetEventDestinationInput{}
	}

	output = &CreateConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConfigurationSetEventDestination API operation for Amazon Pinpoint SMS and Voice Service.
//
// Create a new event destination in a configuration set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS and Voice Service's
// API operation CreateConfigurationSetEventDestination for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * InternalServiceErrorException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   You've issued too many requests to the resource. Wait a few minutes, and
//   then try again.
//
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/CreateConfigurationSetEventDestination
func (c *PinpointSMSVoice) CreateConfigurationSetEventDestination(input *CreateConfigurationSetEventDestinationInput) (*CreateConfigurationSetEventDestinationOutput, error) {
	req, out := c.CreateConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetEventDestinationWithContext is the same as CreateConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoice) CreateConfigurationSetEventDestinationWithContext(ctx aws.Context, input *CreateConfigurationSetEventDestinationInput, opts ...request.Option) (*CreateConfigurationSetEventDestinationOutput, error) {
	req, out := c.CreateConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSet = "DeleteConfigurationSet"

// DeleteConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationSet for more information on using the DeleteConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationSetRequest method.
//    req, resp := client.DeleteConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/DeleteConfigurationSet
func (c *PinpointSMSVoice) DeleteConfigurationSetRequest(input *DeleteConfigurationSetInput) (req *request.Request, output *DeleteConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/sms-voice/configuration-sets/{ConfigurationSetName}",
	}

	if input == nil {
		input = &DeleteConfigurationSetInput{}
	}

	output = &DeleteConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationSet API operation for Amazon Pinpoint SMS and Voice Service.
//
// Deletes an existing configuration set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS and Voice Service's
// API operation DeleteConfigurationSet for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   You've issued too many requests to the resource. Wait a few minutes, and
//   then try again.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * InternalServiceErrorException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/DeleteConfigurationSet
func (c *PinpointSMSVoice) DeleteConfigurationSet(input *DeleteConfigurationSetInput) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetWithContext is the same as DeleteConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoice) DeleteConfigurationSetWithContext(ctx aws.Context, input *DeleteConfigurationSetInput, opts ...request.Option) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSetEventDestination = "DeleteConfigurationSetEventDestination"

// DeleteConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationSetEventDestination for more information on using the DeleteConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationSetEventDestinationRequest method.
//    req, resp := client.DeleteConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/DeleteConfigurationSetEventDestination
func (c *PinpointSMSVoice) DeleteConfigurationSetEventDestinationRequest(input *DeleteConfigurationSetEventDestinationInput) (req *request.Request, output *DeleteConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSetEventDestination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
	}

	if input == nil {
		input = &DeleteConfigurationSetEventDestinationInput{}
	}

	output = &DeleteConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationSetEventDestination API operation for Amazon Pinpoint SMS and Voice Service.
//
// Deletes an event destination in a configuration set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS and Voice Service's
// API operation DeleteConfigurationSetEventDestination for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   You've issued too many requests to the resource. Wait a few minutes, and
//   then try again.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * InternalServiceErrorException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/DeleteConfigurationSetEventDestination
func (c *PinpointSMSVoice) DeleteConfigurationSetEventDestination(input *DeleteConfigurationSetEventDestinationInput) (*DeleteConfigurationSetEventDestinationOutput, error) {
	req, out := c.DeleteConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetEventDestinationWithContext is the same as DeleteConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoice) DeleteConfigurationSetEventDestinationWithContext(ctx aws.Context, input *DeleteConfigurationSetEventDestinationInput, opts ...request.Option) (*DeleteConfigurationSetEventDestinationOutput, error) {
	req, out := c.DeleteConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfigurationSetEventDestinations = "GetConfigurationSetEventDestinations"

// GetConfigurationSetEventDestinationsRequest generates a "aws/request.Request" representing the
// client's request for the GetConfigurationSetEventDestinations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfigurationSetEventDestinations for more information on using the GetConfigurationSetEventDestinations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConfigurationSetEventDestinationsRequest method.
//    req, resp := client.GetConfigurationSetEventDestinationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/GetConfigurationSetEventDestinations
func (c *PinpointSMSVoice) GetConfigurationSetEventDestinationsRequest(input *GetConfigurationSetEventDestinationsInput) (req *request.Request, output *GetConfigurationSetEventDestinationsOutput) {
	op := &request.Operation{
		Name:       opGetConfigurationSetEventDestinations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations",
	}

	if input == nil {
		input = &GetConfigurationSetEventDestinationsInput{}
	}

	output = &GetConfigurationSetEventDestinationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfigurationSetEventDestinations API operation for Amazon Pinpoint SMS and Voice Service.
//
// Obtain information about an event destination, including the types of events
// it reports, the Amazon Resource Name (ARN) of the destination, and the name
// of the event destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS and Voice Service's
// API operation GetConfigurationSetEventDestinations for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   You've issued too many requests to the resource. Wait a few minutes, and
//   then try again.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * InternalServiceErrorException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/GetConfigurationSetEventDestinations
func (c *PinpointSMSVoice) GetConfigurationSetEventDestinations(input *GetConfigurationSetEventDestinationsInput) (*GetConfigurationSetEventDestinationsOutput, error) {
	req, out := c.GetConfigurationSetEventDestinationsRequest(input)
	return out, req.Send()
}

// GetConfigurationSetEventDestinationsWithContext is the same as GetConfigurationSetEventDestinations with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfigurationSetEventDestinations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoice) GetConfigurationSetEventDestinationsWithContext(ctx aws.Context, input *GetConfigurationSetEventDestinationsInput, opts ...request.Option) (*GetConfigurationSetEventDestinationsOutput, error) {
	req, out := c.GetConfigurationSetEventDestinationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConfigurationSets = "ListConfigurationSets"

// ListConfigurationSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurationSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurationSets for more information on using the ListConfigurationSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigurationSetsRequest method.
//    req, resp := client.ListConfigurationSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/ListConfigurationSets
func (c *PinpointSMSVoice) ListConfigurationSetsRequest(input *ListConfigurationSetsInput) (req *request.Request, output *ListConfigurationSetsOutput) {
	op := &request.Operation{
		Name:       opListConfigurationSets,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/sms-voice/configuration-sets",
	}

	if input == nil {
		input = &ListConfigurationSetsInput{}
	}

	output = &ListConfigurationSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurationSets API operation for Amazon Pinpoint SMS and Voice Service.
//
// List all of the configuration sets associated with your Amazon Pinpoint account
// in the current region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS and Voice Service's
// API operation ListConfigurationSets for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   You've issued too many requests to the resource. Wait a few minutes, and
//   then try again.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * InternalServiceErrorException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/ListConfigurationSets
func (c *PinpointSMSVoice) ListConfigurationSets(input *ListConfigurationSetsInput) (*ListConfigurationSetsOutput, error) {
	req, out := c.ListConfigurationSetsRequest(input)
	return out, req.Send()
}

// ListConfigurationSetsWithContext is the same as ListConfigurationSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurationSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoice) ListConfigurationSetsWithContext(ctx aws.Context, input *ListConfigurationSetsInput, opts ...request.Option) (*ListConfigurationSetsOutput, error) {
	req, out := c.ListConfigurationSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendVoiceMessage = "SendVoiceMessage"

// SendVoiceMessageRequest generates a "aws/request.Request" representing the
// client's request for the SendVoiceMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendVoiceMessage for more information on using the SendVoiceMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendVoiceMessageRequest method.
//    req, resp := client.SendVoiceMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/SendVoiceMessage
func (c *PinpointSMSVoice) SendVoiceMessageRequest(input *SendVoiceMessageInput) (req *request.Request, output *SendVoiceMessageOutput) {
	op := &request.Operation{
		Name:       opSendVoiceMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/sms-voice/voice/message",
	}

	if input == nil {
		input = &SendVoiceMessageInput{}
	}

	output = &SendVoiceMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendVoiceMessage API operation for Amazon Pinpoint SMS and Voice Service.
//
// Create a new voice message and send it to a recipient's phone number.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS and Voice Service's
// API operation SendVoiceMessage for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   You've issued too many requests to the resource. Wait a few minutes, and
//   then try again.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * InternalServiceErrorException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/SendVoiceMessage
func (c *PinpointSMSVoice) SendVoiceMessage(input *SendVoiceMessageInput) (*SendVoiceMessageOutput, error) {
	req, out := c.SendVoiceMessageRequest(input)
	return out, req.Send()
}

// SendVoiceMessageWithContext is the same as SendVoiceMessage with the addition of
// the ability to pass a context and additional request options.
//
// See SendVoiceMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoice) SendVoiceMessageWithContext(ctx aws.Context, input *SendVoiceMessageInput, opts ...request.Option) (*SendVoiceMessageOutput, error) {
	req, out := c.SendVoiceMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfigurationSetEventDestination = "UpdateConfigurationSetEventDestination"

// UpdateConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfigurationSetEventDestination for more information on using the UpdateConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConfigurationSetEventDestinationRequest method.
//    req, resp := client.UpdateConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/UpdateConfigurationSetEventDestination
func (c *PinpointSMSVoice) UpdateConfigurationSetEventDestinationRequest(input *UpdateConfigurationSetEventDestinationInput) (req *request.Request, output *UpdateConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateConfigurationSetEventDestination,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
	}

	if input == nil {
		input = &UpdateConfigurationSetEventDestinationInput{}
	}

	output = &UpdateConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConfigurationSetEventDestination API operation for Amazon Pinpoint SMS and Voice Service.
//
// Update an event destination in a configuration set. An event destination
// is a location that you publish information about your voice calls to. For
// example, you can log an event to an Amazon CloudWatch destination when a
// call fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS and Voice Service's
// API operation UpdateConfigurationSetEventDestination for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   You've issued too many requests to the resource. Wait a few minutes, and
//   then try again.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * InternalServiceErrorException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/UpdateConfigurationSetEventDestination
func (c *PinpointSMSVoice) UpdateConfigurationSetEventDestination(input *UpdateConfigurationSetEventDestinationInput) (*UpdateConfigurationSetEventDestinationOutput, error) {
	req, out := c.UpdateConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// UpdateConfigurationSetEventDestinationWithContext is the same as UpdateConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoice) UpdateConfigurationSetEventDestinationWithContext(ctx aws.Context, input *UpdateConfigurationSetEventDestinationInput, opts ...request.Option) (*UpdateConfigurationSetEventDestinationOutput, error) {
	req, out := c.UpdateConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The resource specified in your request already exists.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input you provided is invalid.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that defines a message that contains text formatted using Amazon
// Pinpoint Voice Instructions markup.
type CallInstructionsMessageType struct {
	_ struct{} `type:"structure"`

	// The language to use when delivering the message. For a complete list of supported
	// languages, see the Amazon Polly Developer Guide.
	Text *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallInstructionsMessageType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallInstructionsMessageType) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *CallInstructionsMessageType) SetText(v string) *CallInstructionsMessageType {
	s.Text = &v
	return s
}

// An object that contains information about an event destination that sends
// data to Amazon CloudWatch Logs.
type CloudWatchLogsDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon Identity and Access Management
	// (IAM) role that is able to write event data to an Amazon CloudWatch destination.
	IamRoleArn *string `type:"string"`

	// The name of the Amazon CloudWatch Log Group that you want to record events
	// in.
	LogGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDestination) GoString() string {
	return s.String()
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CloudWatchLogsDestination) SetIamRoleArn(v string) *CloudWatchLogsDestination {
	s.IamRoleArn = &v
	return s
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *CloudWatchLogsDestination) SetLogGroupArn(v string) *CloudWatchLogsDestination {
	s.LogGroupArn = &v
	return s
}

// Create a new event destination in a configuration set.
type CreateConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// An object that defines a single event destination.
	EventDestination *EventDestinationDefinition `type:"structure"`

	// A name that identifies the event destination.
	EventDestinationName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *CreateConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetEventDestination(v *EventDestinationDefinition) *CreateConfigurationSetEventDestinationInput {
	s.EventDestination = v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *CreateConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An empty object that indicates that the event destination was created successfully.
type CreateConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// A request to create a new configuration set.
type CreateConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// The name that you want to give the configuration set.
	ConfigurationSetName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetInput) GoString() string {
	return s.String()
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetInput) SetConfigurationSetName(v string) *CreateConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// An empty object that indicates that the configuration set was successfully
// created.
type CreateConfigurationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetOutput) GoString() string {
	return s.String()
}

type DeleteConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// EventDestinationName is a required field
	EventDestinationName *string `location:"uri" locationName:"EventDestinationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestinationName != nil && len(*s.EventDestinationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventDestinationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *DeleteConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *DeleteConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *DeleteConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An empty object that indicates that the event destination was deleted successfully.
type DeleteConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

type DeleteConfigurationSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetInput) SetConfigurationSetName(v string) *DeleteConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// An empty object that indicates that the configuration set was deleted successfully.
type DeleteConfigurationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetOutput) GoString() string {
	return s.String()
}

// An object that defines an event destination.
type EventDestination struct {
	_ struct{} `type:"structure"`

	// An object that contains information about an event destination that sends
	// data to Amazon CloudWatch Logs.
	CloudWatchLogsDestination *CloudWatchLogsDestination `type:"structure"`

	// Indicates whether or not the event destination is enabled. If the event destination
	// is enabled, then Amazon Pinpoint sends response data to the specified event
	// destination.
	Enabled *bool `type:"boolean"`

	// An object that contains information about an event destination that sends
	// data to Amazon Kinesis Data Firehose.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// An array of EventDestination objects. Each EventDestination object includes
	// ARNs and other information that define an event destination.
	MatchingEventTypes []*string `type:"list" enum:"EventType"`

	// A name that identifies the event destination configuration.
	Name *string `type:"string"`

	// An object that contains information about an event destination that sends
	// data to Amazon SNS.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventDestination) GoString() string {
	return s.String()
}

// SetCloudWatchLogsDestination sets the CloudWatchLogsDestination field's value.
func (s *EventDestination) SetCloudWatchLogsDestination(v *CloudWatchLogsDestination) *EventDestination {
	s.CloudWatchLogsDestination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventDestination) SetEnabled(v bool) *EventDestination {
	s.Enabled = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *EventDestination) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *EventDestination {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *EventDestination) SetMatchingEventTypes(v []*string) *EventDestination {
	s.MatchingEventTypes = v
	return s
}

// SetName sets the Name field's value.
func (s *EventDestination) SetName(v string) *EventDestination {
	s.Name = &v
	return s
}

// SetSnsDestination sets the SnsDestination field's value.
func (s *EventDestination) SetSnsDestination(v *SnsDestination) *EventDestination {
	s.SnsDestination = v
	return s
}

// An object that defines a single event destination.
type EventDestinationDefinition struct {
	_ struct{} `type:"structure"`

	// An object that contains information about an event destination that sends
	// data to Amazon CloudWatch Logs.
	CloudWatchLogsDestination *CloudWatchLogsDestination `type:"structure"`

	// Indicates whether or not the event destination is enabled. If the event destination
	// is enabled, then Amazon Pinpoint sends response data to the specified event
	// destination.
	Enabled *bool `type:"boolean"`

	// An object that contains information about an event destination that sends
	// data to Amazon Kinesis Data Firehose.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// An array of EventDestination objects. Each EventDestination object includes
	// ARNs and other information that define an event destination.
	MatchingEventTypes []*string `type:"list" enum:"EventType"`

	// An object that contains information about an event destination that sends
	// data to Amazon SNS.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventDestinationDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventDestinationDefinition) GoString() string {
	return s.String()
}

// SetCloudWatchLogsDestination sets the CloudWatchLogsDestination field's value.
func (s *EventDestinationDefinition) SetCloudWatchLogsDestination(v *CloudWatchLogsDestination) *EventDestinationDefinition {
	s.CloudWatchLogsDestination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventDestinationDefinition) SetEnabled(v bool) *EventDestinationDefinition {
	s.Enabled = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *EventDestinationDefinition) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *EventDestinationDefinition {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *EventDestinationDefinition) SetMatchingEventTypes(v []*string) *EventDestinationDefinition {
	s.MatchingEventTypes = v
	return s
}

// SetSnsDestination sets the SnsDestination field's value.
func (s *EventDestinationDefinition) SetSnsDestination(v *SnsDestination) *EventDestinationDefinition {
	s.SnsDestination = v
	return s
}

type GetConfigurationSetEventDestinationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationSetEventDestinationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationSetEventDestinationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigurationSetEventDestinationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfigurationSetEventDestinationsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *GetConfigurationSetEventDestinationsInput) SetConfigurationSetName(v string) *GetConfigurationSetEventDestinationsInput {
	s.ConfigurationSetName = &v
	return s
}

// An object that contains information about an event destination.
type GetConfigurationSetEventDestinationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of EventDestination objects. Each EventDestination object includes
	// ARNs and other information that define an event destination.
	EventDestinations []*EventDestination `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationSetEventDestinationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationSetEventDestinationsOutput) GoString() string {
	return s.String()
}

// SetEventDestinations sets the EventDestinations field's value.
func (s *GetConfigurationSetEventDestinationsOutput) SetEventDestinations(v []*EventDestination) *GetConfigurationSetEventDestinationsOutput {
	s.EventDestinations = v
	return s
}

// The API encountered an unexpected error and couldn't complete the request.
// You might be able to successfully issue the request again in the future.
type InternalServiceErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServiceErrorException(v protocol.ResponseMetadata) error {
	return &InternalServiceErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceErrorException) Code() string {
	return "InternalServiceErrorException"
}

// Message returns the exception's message.
func (s *InternalServiceErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceErrorException) OrigErr() error {
	return nil
}

func (s *InternalServiceErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains information about an event destination that sends
// data to Amazon Kinesis Data Firehose.
type KinesisFirehoseDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that can write data to an Amazon
	// Kinesis Data Firehose stream.
	DeliveryStreamArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose destination
	// that you want to use in the event destination.
	IamRoleArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseDestination) GoString() string {
	return s.String()
}

// SetDeliveryStreamArn sets the DeliveryStreamArn field's value.
func (s *KinesisFirehoseDestination) SetDeliveryStreamArn(v string) *KinesisFirehoseDestination {
	s.DeliveryStreamArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *KinesisFirehoseDestination) SetIamRoleArn(v string) *KinesisFirehoseDestination {
	s.IamRoleArn = &v
	return s
}

// There are too many instances of the specified resource type.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListConfigurationSetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	PageSize *string `location:"querystring" locationName:"PageSize" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationSetsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationSetsInput) SetNextToken(v string) *ListConfigurationSetsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListConfigurationSetsInput) SetPageSize(v string) *ListConfigurationSetsInput {
	s.PageSize = &v
	return s
}

// An object that contains information about the configuration sets for your
// account in the current region.
type ListConfigurationSetsOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains a list of configuration sets for your account in
	// the current region.
	ConfigurationSets []*string `type:"list"`

	// A token returned from a previous call to ListConfigurationSets to indicate
	// the position in the list of configuration sets.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationSetsOutput) GoString() string {
	return s.String()
}

// SetConfigurationSets sets the ConfigurationSets field's value.
func (s *ListConfigurationSetsOutput) SetConfigurationSets(v []*string) *ListConfigurationSetsOutput {
	s.ConfigurationSets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationSetsOutput) SetNextToken(v string) *ListConfigurationSetsOutput {
	s.NextToken = &v
	return s
}

// The resource you attempted to access doesn't exist.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that defines a message that contains unformatted text.
type PlainTextMessageType struct {
	_ struct{} `type:"structure"`

	// The language to use when delivering the message. For a complete list of supported
	// languages, see the Amazon Polly Developer Guide.
	LanguageCode *string `type:"string"`

	// The plain (not SSML-formatted) text to deliver to the recipient.
	Text *string `type:"string"`

	// The name of the voice that you want to use to deliver the message. For a
	// complete list of supported voices, see the Amazon Polly Developer Guide.
	VoiceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlainTextMessageType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlainTextMessageType) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *PlainTextMessageType) SetLanguageCode(v string) *PlainTextMessageType {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *PlainTextMessageType) SetText(v string) *PlainTextMessageType {
	s.Text = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *PlainTextMessageType) SetVoiceId(v string) *PlainTextMessageType {
	s.VoiceId = &v
	return s
}

// An object that defines a message that contains SSML-formatted text.
type SSMLMessageType struct {
	_ struct{} `type:"structure"`

	// The language to use when delivering the message. For a complete list of supported
	// languages, see the Amazon Polly Developer Guide.
	LanguageCode *string `type:"string"`

	// The SSML-formatted text to deliver to the recipient.
	Text *string `type:"string"`

	// The name of the voice that you want to use to deliver the message. For a
	// complete list of supported voices, see the Amazon Polly Developer Guide.
	VoiceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SSMLMessageType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SSMLMessageType) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *SSMLMessageType) SetLanguageCode(v string) *SSMLMessageType {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *SSMLMessageType) SetText(v string) *SSMLMessageType {
	s.Text = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *SSMLMessageType) SetVoiceId(v string) *SSMLMessageType {
	s.VoiceId = &v
	return s
}

// A request to create and send a new voice message.
type SendVoiceMessageInput struct {
	_ struct{} `type:"structure"`

	// The phone number that appears on recipients' devices when they receive the
	// message.
	CallerId *string `type:"string"`

	// The name of the configuration set that you want to use to send the message.
	ConfigurationSetName *string `type:"string"`

	// An object that contains a voice message and information about the recipient
	// that you want to send it to.
	Content *VoiceMessageContent `type:"structure"`

	// The phone number that you want to send the voice message to.
	DestinationPhoneNumber *string `type:"string"`

	// The phone number that Amazon Pinpoint should use to send the voice message.
	// This isn't necessarily the phone number that appears on recipients' devices
	// when they receive the message, because you can specify a CallerId parameter
	// in the request.
	OriginationPhoneNumber *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendVoiceMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendVoiceMessageInput) GoString() string {
	return s.String()
}

// SetCallerId sets the CallerId field's value.
func (s *SendVoiceMessageInput) SetCallerId(v string) *SendVoiceMessageInput {
	s.CallerId = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendVoiceMessageInput) SetConfigurationSetName(v string) *SendVoiceMessageInput {
	s.ConfigurationSetName = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SendVoiceMessageInput) SetContent(v *VoiceMessageContent) *SendVoiceMessageInput {
	s.Content = v
	return s
}

// SetDestinationPhoneNumber sets the DestinationPhoneNumber field's value.
func (s *SendVoiceMessageInput) SetDestinationPhoneNumber(v string) *SendVoiceMessageInput {
	s.DestinationPhoneNumber = &v
	return s
}

// SetOriginationPhoneNumber sets the OriginationPhoneNumber field's value.
func (s *SendVoiceMessageInput) SetOriginationPhoneNumber(v string) *SendVoiceMessageInput {
	s.OriginationPhoneNumber = &v
	return s
}

// An object that that contains the Message ID of a Voice message that was sent
// successfully.
type SendVoiceMessageOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the voice message.
	MessageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendVoiceMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendVoiceMessageOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendVoiceMessageOutput) SetMessageId(v string) *SendVoiceMessageOutput {
	s.MessageId = &v
	return s
}

// An object that contains information about an event destination that sends
// data to Amazon SNS.
type SnsDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish
	// events to.
	TopicArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnsDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnsDestination) GoString() string {
	return s.String()
}

// SetTopicArn sets the TopicArn field's value.
func (s *SnsDestination) SetTopicArn(v string) *SnsDestination {
	s.TopicArn = &v
	return s
}

// You've issued too many requests to the resource. Wait a few minutes, and
// then try again.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that defines a request to update an existing event destination.
type UpdateConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// An object that defines a single event destination.
	EventDestination *EventDestinationDefinition `type:"structure"`

	// EventDestinationName is a required field
	EventDestinationName *string `location:"uri" locationName:"EventDestinationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestinationName != nil && len(*s.EventDestinationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventDestinationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *UpdateConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetEventDestination(v *EventDestinationDefinition) *UpdateConfigurationSetEventDestinationInput {
	s.EventDestination = v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *UpdateConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An empty object that indicates that the event destination was updated successfully.
type UpdateConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// An object that contains a voice message and information about the recipient
// that you want to send it to.
type VoiceMessageContent struct {
	_ struct{} `type:"structure"`

	// An object that defines a message that contains text formatted using Amazon
	// Pinpoint Voice Instructions markup.
	CallInstructionsMessage *CallInstructionsMessageType `type:"structure"`

	// An object that defines a message that contains unformatted text.
	PlainTextMessage *PlainTextMessageType `type:"structure"`

	// An object that defines a message that contains SSML-formatted text.
	SSMLMessage *SSMLMessageType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceMessageContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceMessageContent) GoString() string {
	return s.String()
}

// SetCallInstructionsMessage sets the CallInstructionsMessage field's value.
func (s *VoiceMessageContent) SetCallInstructionsMessage(v *CallInstructionsMessageType) *VoiceMessageContent {
	s.CallInstructionsMessage = v
	return s
}

// SetPlainTextMessage sets the PlainTextMessage field's value.
func (s *VoiceMessageContent) SetPlainTextMessage(v *PlainTextMessageType) *VoiceMessageContent {
	s.PlainTextMessage = v
	return s
}

// SetSSMLMessage sets the SSMLMessage field's value.
func (s *VoiceMessageContent) SetSSMLMessage(v *SSMLMessageType) *VoiceMessageContent {
	s.SSMLMessage = v
	return s
}

// The types of events that are sent to the event destination.
const (
	// EventTypeInitiatedCall is a EventType enum value
	EventTypeInitiatedCall = "INITIATED_CALL"

	// EventTypeRinging is a EventType enum value
	EventTypeRinging = "RINGING"

	// EventTypeAnswered is a EventType enum value
	EventTypeAnswered = "ANSWERED"

	// EventTypeCompletedCall is a EventType enum value
	EventTypeCompletedCall = "COMPLETED_CALL"

	// EventTypeBusy is a EventType enum value
	EventTypeBusy = "BUSY"

	// EventTypeFailed is a EventType enum value
	EventTypeFailed = "FAILED"

	// EventTypeNoAnswer is a EventType enum value
	EventTypeNoAnswer = "NO_ANSWER"
)

// EventType_Values returns all elements of the EventType enum
func EventType_Values() []string {
	return []string{
		EventTypeInitiatedCall,
		EventTypeRinging,
		EventTypeAnswered,
		EventTypeCompletedCall,
		EventTypeBusy,
		EventTypeFailed,
		EventTypeNoAnswer,
	}
}
