#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2002, 2021 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

if test $# -ne 5; then
  echo "ERROR: parameters error"
  exit 1
fi

if [ -e "/bin/awk" ];
then
  COMMAND_AWK="/bin/awk"
elif [ -e "/usr/bin/awk" ];
then
  COMMAND_AWK="/usr/bin/awk"
else
  echo "ERROR: awk command not found"
  exit 1
fi

if test -x "/bin/echo"; then
  COMMAND_ECHO="/bin/echo"
else
  echo "NX> 500 Error: echo command not found."
  exit 1
fi

if test -x "/sbin/ip"; then
  COMMAND_IP="/sbin/ip"
elif test -x "/bin/ip"; then
  COMMAND_IP="/bin/ip"
else
  if test -x "/sbin/ifconfig"; then
    COMMAND_IP=""
    COMMAND_IFCONFIG="/sbin/ifconfig"
  else
    echo "NX> 500 Error: ifconfig nor ip command not found."
    exit 1
  fi
fi

if test -x "/bin/cut"; then
  COMMAND_CUT="/bin/cut"
elif test -x "/usr/bin/cut"; then
  COMMAND_CUT="/usr/bin/cut"
else
  echo "NX> 500 Error: cut command not found."
  exit 1
fi

errorMsg ()
{
  ${COMMAND_ECHO} "NX> 500 Error: $1"
  if test "x$2" = "x1"; then
    exit 1
  fi
}

if test -e "/etc/NX/player/localhost/player.cfg"; then
  BIN_DIR=$($COMMAND_AWK -F'"' '/^PlayerRoot/ {print $2}' /etc/NX/player/localhost/player.cfg)
elif test -e "/etc/NX/server/localhost/node.cfg"; then
  BIN_DIR=$($COMMAND_AWK -F'"' '/^NodeRoot/ {print $2}' /etc/NX/server/localhost/node.cfg)
elif test -e "/etc/NX/node/localhost/node.cfg"; then
  BIN_DIR=$($COMMAND_AWK -F'"' '/^NodeRoot/ {print $2}' /etc/NX/node/localhost/node.cfg)
else
  errorMsg "Cannot stat files: /etc/NX/player/localhost/player.cfg and /etc/NX/server/localhost/node.cfg." "1"
fi

NX_BIN="/bin/"

NXTUNCTL_NAME="nxtunctl"
NXTUNCTL_NAME_PATH="$BIN_DIR$NX_BIN$NXTUNCTL_NAME"

addInterface()
{
  STATUS=`$NXTUNCTL_NAME_PATH -u $1 -b`

  if test "x$STATUS" == "x"; then
    errorMsg "nxtunctl running error." "1"
  else
    if test "${COMMAND_IP}" != ""; then
      #
      # Use ip command.
      #

      ${COMMAND_IP} link set dev ${STATUS} up
      ${COMMAND_IP} addr add ${2}/255.255.255.252 dev ${STATUS}

      #
      # Get MAC address of created interface.
      #

      mac=$(${COMMAND_IP} addr)

      mac=${mac#*${STATUS}*link/ether}
    else
      #
      # Use ifconfig command.
      #

      ${COMMAND_IFCONFIG} $STATUS $2 netmask 255.255.255.252 up

      #
      # Get MAC address of created interface.
      #

      mac=$(${COMMAND_IFCONFIG})

      #
      # Depends on distribution, there are
      # different keywords in front of MAC address.
      #

      if [[ ${mac} == *"HWaddr"* ]]; then
        mac=${mac#*${STATUS}*HWaddr}
      elif [[ ${mac} == *"ether"* ]]; then
        mac=${mac#*${STATUS}*ether}
      else
        echo "NX> 500 Error: Cannot find MAC address"
        exit 1
      fi
    fi

    mac=$(${COMMAND_ECHO} $mac | ${COMMAND_CUT} -d ' ' -f 1)

    mac=${mac//":"/""}

    ${COMMAND_ECHO} "$STATUS|$mac"
  fi

  return 0;
}

case "$3" in
'--add')       addInterface "$4" "$5"       ;;
esac

