#include <sys/types.h>
#include <pwd.h>
#include <grp.h>
#include "sancp.h"

void SChangeUserGroup(void){
	struct passwd *pw;
	struct group *gr;

	extern gvars gVars;

	gVars.uid=getuid();
	gVars.gid=getgid();

	if(gVars.username!=NULL){

		if((gVars.uid = atoi(gVars.username)) == 0)
		{
			pw = getpwnam(gVars.username);
			if(pw == NULL){
				syslog(LOG_ERR,"User \"%s\" unknown\n", gVars.username);
				exit(0);

			}
	      		gVars.uid = pw->pw_uid;
		}
		else
		{
			pw = getpwuid(gVars.uid);
			if(pw == NULL){
				syslog(LOG_ERR,"Can not obtain username for uid: %lu\n", (u_long) gVars.uid);
		    	 	exit(0);
			}
		}
		gVars.gid = pw->pw_gid;
	}
	
	if(gVars.groupname != NULL){

        	if((gVars.gid = atoi(gVars.groupname)) == 0)
	        {
	            gr = getgrnam(gVars.groupname);
	
	            if(gr == NULL)
		    {
	                 syslog(LOG_ERR,"Group \"%s\" unknown\n", gVars.groupname);
		    	 exit(0);
		    }
	
	            gVars.gid = gr->gr_gid;
		}
	}
	if(gVars.groupname != NULL)
	{
		if(setgid(gVars.gid) < 0){
			syslog(LOG_ERR,"Can not set gid: %lu\n", (u_long) gVars.gid);
			exit(0);
		}
	}

	if(gVars.username != NULL)
	{
		if(gVars.groupname == NULL)
		{
			if(setgid(gVars.gid) < 0){
				syslog(LOG_ERR,"Can not set gid: %lu\n", (u_long) gVars.gid);
				exit(0);
		
			}
		}
		if(getuid() == 0 && initgroups(gVars.username, gVars.gid) < 0){
			syslog(LOG_ERR,"Can not initgroups(%s,%lu)", gVars.username, (u_long) gVars.gid);
			exit(0);
		}
		endgrent();
		endpwent();
 		if(setuid(gVars.uid) < 0){
			syslog(LOG_ERR,"Can not set uid: %lu\n", (u_long) gVars.uid);
		    	 exit(0);
		}
	}
}

