#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 495
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 143
#define ALIAS_COUNT 0
#define TOKEN_COUNT 74
#define EXTERNAL_TOKEN_COUNT 11
#define FIELD_COUNT 2
#define MAX_ALIAS_SEQUENCE_LENGTH 12
#define PRODUCTION_ID_COUNT 5

enum ts_symbol_identifiers {
  sym_Name = 1,
  anon_sym_LT_QMARK = 2,
  anon_sym_xml = 3,
  anon_sym_QMARK_GT = 4,
  anon_sym_standalone = 5,
  anon_sym_SQUOTE = 6,
  anon_sym_yes = 7,
  anon_sym_no = 8,
  anon_sym_DQUOTE = 9,
  anon_sym_LT_BANG = 10,
  anon_sym_DOCTYPE = 11,
  anon_sym_LBRACK = 12,
  anon_sym_RBRACK = 13,
  anon_sym_GT = 14,
  anon_sym_LT = 15,
  anon_sym_SLASH_GT = 16,
  anon_sym_LT_SLASH = 17,
  anon_sym_RBRACK_RBRACK_GT = 18,
  anon_sym_LT_BANG_LBRACK = 19,
  anon_sym_CDATA = 20,
  anon_sym_xml_DASHstylesheet = 21,
  anon_sym_xml_DASHmodel = 22,
  aux_sym_PseudoAttValue_token1 = 23,
  aux_sym_PseudoAttValue_token2 = 24,
  anon_sym_ELEMENT = 25,
  anon_sym_EMPTY = 26,
  anon_sym_ANY = 27,
  anon_sym_LPAREN = 28,
  anon_sym_POUNDPCDATA = 29,
  anon_sym_PIPE = 30,
  anon_sym_RPAREN = 31,
  anon_sym_STAR = 32,
  anon_sym_QMARK = 33,
  anon_sym_PLUS = 34,
  anon_sym_COMMA = 35,
  anon_sym_ATTLIST = 36,
  sym_TokenizedType = 37,
  anon_sym_NOTATION = 38,
  anon_sym_POUNDREQUIRED = 39,
  anon_sym_POUNDIMPLIED = 40,
  anon_sym_POUNDFIXED = 41,
  anon_sym_ENTITY = 42,
  anon_sym_PERCENT = 43,
  aux_sym_EntityValue_token1 = 44,
  aux_sym_EntityValue_token2 = 45,
  anon_sym_NDATA = 46,
  anon_sym_SEMI = 47,
  sym__S = 48,
  sym_Nmtoken = 49,
  anon_sym_AMP = 50,
  anon_sym_AMP_POUND = 51,
  aux_sym_CharRef_token1 = 52,
  anon_sym_AMP_POUNDx = 53,
  aux_sym_CharRef_token2 = 54,
  anon_sym_SYSTEM = 55,
  anon_sym_PUBLIC = 56,
  aux_sym_SystemLiteral_token1 = 57,
  aux_sym_SystemLiteral_token2 = 58,
  aux_sym_PubidLiteral_token1 = 59,
  aux_sym_PubidLiteral_token2 = 60,
  anon_sym_version = 61,
  sym_VersionNum = 62,
  anon_sym_encoding = 63,
  sym_EncName = 64,
  anon_sym_EQ = 65,
  sym_PITarget = 66,
  sym__pi_content = 67,
  sym_Comment = 68,
  sym_CharData = 69,
  sym_CData = 70,
  sym__start_tag_name = 71,
  sym__end_tag_name = 72,
  sym__erroneous_end_name = 73,
  sym_document = 74,
  sym_prolog = 75,
  sym__Misc = 76,
  sym_XMLDecl = 77,
  sym__SDDecl = 78,
  sym_doctypedecl = 79,
  aux_sym__intSubset = 80,
  sym_element = 81,
  sym_EmptyElemTag = 82,
  sym_Attribute = 83,
  sym_STag = 84,
  sym_ETag = 85,
  sym_content = 86,
  sym_CDSect = 87,
  sym_CDStart = 88,
  sym_StyleSheetPI = 89,
  sym_XmlModelPI = 90,
  sym_PseudoAtt = 91,
  sym_PseudoAttValue = 92,
  sym__markupdecl = 93,
  sym__DeclSep = 94,
  sym_elementdecl = 95,
  sym_contentspec = 96,
  sym_Mixed = 97,
  sym_children = 98,
  sym__cp = 99,
  sym__choice = 100,
  sym_AttlistDecl = 101,
  sym_AttDef = 102,
  sym__AttType = 103,
  sym_StringType = 104,
  sym__EnumeratedType = 105,
  sym_NotationType = 106,
  sym_Enumeration = 107,
  sym_DefaultDecl = 108,
  sym__EntityDecl = 109,
  sym_GEDecl = 110,
  sym_PEDecl = 111,
  sym_EntityValue = 112,
  sym_NDataDecl = 113,
  sym_NotationDecl = 114,
  sym_PEReference = 115,
  sym__Reference = 116,
  sym_EntityRef = 117,
  sym_CharRef = 118,
  sym_AttValue = 119,
  sym_ExternalID = 120,
  sym_PublicID = 121,
  sym_SystemLiteral = 122,
  sym_PubidLiteral = 123,
  sym__VersionInfo = 124,
  sym__EncodingDecl = 125,
  sym_PI = 126,
  sym__Eq = 127,
  aux_sym_document_repeat1 = 128,
  aux_sym_EmptyElemTag_repeat1 = 129,
  aux_sym_content_repeat1 = 130,
  aux_sym_StyleSheetPI_repeat1 = 131,
  aux_sym_PseudoAttValue_repeat1 = 132,
  aux_sym_PseudoAttValue_repeat2 = 133,
  aux_sym_Mixed_repeat1 = 134,
  aux_sym_Mixed_repeat2 = 135,
  aux_sym__choice_repeat1 = 136,
  aux_sym__choice_repeat2 = 137,
  aux_sym_AttlistDecl_repeat1 = 138,
  aux_sym_NotationType_repeat1 = 139,
  aux_sym_Enumeration_repeat1 = 140,
  aux_sym_EntityValue_repeat1 = 141,
  aux_sym_EntityValue_repeat2 = 142,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_Name] = "Name",
  [anon_sym_LT_QMARK] = "<\?",
  [anon_sym_xml] = "xml",
  [anon_sym_QMARK_GT] = "\?>",
  [anon_sym_standalone] = "standalone",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_yes] = "yes",
  [anon_sym_no] = "no",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_LT_BANG] = "<!",
  [anon_sym_DOCTYPE] = "DOCTYPE",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_RBRACK_RBRACK_GT] = "]]>",
  [anon_sym_LT_BANG_LBRACK] = "<![",
  [anon_sym_CDATA] = "CDATA",
  [anon_sym_xml_DASHstylesheet] = "xml-stylesheet",
  [anon_sym_xml_DASHmodel] = "xml-model",
  [aux_sym_PseudoAttValue_token1] = "PseudoAttValue_token1",
  [aux_sym_PseudoAttValue_token2] = "PseudoAttValue_token2",
  [anon_sym_ELEMENT] = "ELEMENT",
  [anon_sym_EMPTY] = "EMPTY",
  [anon_sym_ANY] = "ANY",
  [anon_sym_LPAREN] = "(",
  [anon_sym_POUNDPCDATA] = "#PCDATA",
  [anon_sym_PIPE] = "|",
  [anon_sym_RPAREN] = ")",
  [anon_sym_STAR] = "*",
  [anon_sym_QMARK] = "\?",
  [anon_sym_PLUS] = "+",
  [anon_sym_COMMA] = ",",
  [anon_sym_ATTLIST] = "ATTLIST",
  [sym_TokenizedType] = "TokenizedType",
  [anon_sym_NOTATION] = "NOTATION",
  [anon_sym_POUNDREQUIRED] = "#REQUIRED",
  [anon_sym_POUNDIMPLIED] = "#IMPLIED",
  [anon_sym_POUNDFIXED] = "#FIXED",
  [anon_sym_ENTITY] = "ENTITY",
  [anon_sym_PERCENT] = "%",
  [aux_sym_EntityValue_token1] = "EntityValue_token1",
  [aux_sym_EntityValue_token2] = "EntityValue_token2",
  [anon_sym_NDATA] = "NDATA",
  [anon_sym_SEMI] = ";",
  [sym__S] = "_S",
  [sym_Nmtoken] = "Nmtoken",
  [anon_sym_AMP] = "&",
  [anon_sym_AMP_POUND] = "&#",
  [aux_sym_CharRef_token1] = "CharRef_token1",
  [anon_sym_AMP_POUNDx] = "&#x",
  [aux_sym_CharRef_token2] = "CharRef_token2",
  [anon_sym_SYSTEM] = "SYSTEM",
  [anon_sym_PUBLIC] = "PUBLIC",
  [aux_sym_SystemLiteral_token1] = "URI",
  [aux_sym_SystemLiteral_token2] = "URI",
  [aux_sym_PubidLiteral_token1] = "PubidLiteral_token1",
  [aux_sym_PubidLiteral_token2] = "PubidLiteral_token2",
  [anon_sym_version] = "version",
  [sym_VersionNum] = "VersionNum",
  [anon_sym_encoding] = "encoding",
  [sym_EncName] = "EncName",
  [anon_sym_EQ] = "=",
  [sym_PITarget] = "PITarget",
  [sym__pi_content] = "_pi_content",
  [sym_Comment] = "Comment",
  [sym_CharData] = "CharData",
  [sym_CData] = "CData",
  [sym__start_tag_name] = "Name",
  [sym__end_tag_name] = "Name",
  [sym__erroneous_end_name] = "_erroneous_end_name",
  [sym_document] = "document",
  [sym_prolog] = "prolog",
  [sym__Misc] = "_Misc",
  [sym_XMLDecl] = "XMLDecl",
  [sym__SDDecl] = "_SDDecl",
  [sym_doctypedecl] = "doctypedecl",
  [aux_sym__intSubset] = "_intSubset",
  [sym_element] = "element",
  [sym_EmptyElemTag] = "EmptyElemTag",
  [sym_Attribute] = "Attribute",
  [sym_STag] = "STag",
  [sym_ETag] = "ETag",
  [sym_content] = "content",
  [sym_CDSect] = "CDSect",
  [sym_CDStart] = "CDStart",
  [sym_StyleSheetPI] = "StyleSheetPI",
  [sym_XmlModelPI] = "XmlModelPI",
  [sym_PseudoAtt] = "PseudoAtt",
  [sym_PseudoAttValue] = "PseudoAttValue",
  [sym__markupdecl] = "_markupdecl",
  [sym__DeclSep] = "_DeclSep",
  [sym_elementdecl] = "elementdecl",
  [sym_contentspec] = "contentspec",
  [sym_Mixed] = "Mixed",
  [sym_children] = "children",
  [sym__cp] = "_cp",
  [sym__choice] = "_choice",
  [sym_AttlistDecl] = "AttlistDecl",
  [sym_AttDef] = "AttDef",
  [sym__AttType] = "_AttType",
  [sym_StringType] = "StringType",
  [sym__EnumeratedType] = "_EnumeratedType",
  [sym_NotationType] = "NotationType",
  [sym_Enumeration] = "Enumeration",
  [sym_DefaultDecl] = "DefaultDecl",
  [sym__EntityDecl] = "_EntityDecl",
  [sym_GEDecl] = "GEDecl",
  [sym_PEDecl] = "PEDecl",
  [sym_EntityValue] = "EntityValue",
  [sym_NDataDecl] = "NDataDecl",
  [sym_NotationDecl] = "NotationDecl",
  [sym_PEReference] = "PEReference",
  [sym__Reference] = "_Reference",
  [sym_EntityRef] = "EntityRef",
  [sym_CharRef] = "CharRef",
  [sym_AttValue] = "AttValue",
  [sym_ExternalID] = "ExternalID",
  [sym_PublicID] = "PublicID",
  [sym_SystemLiteral] = "SystemLiteral",
  [sym_PubidLiteral] = "PubidLiteral",
  [sym__VersionInfo] = "_VersionInfo",
  [sym__EncodingDecl] = "_EncodingDecl",
  [sym_PI] = "PI",
  [sym__Eq] = "_Eq",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_EmptyElemTag_repeat1] = "EmptyElemTag_repeat1",
  [aux_sym_content_repeat1] = "content_repeat1",
  [aux_sym_StyleSheetPI_repeat1] = "StyleSheetPI_repeat1",
  [aux_sym_PseudoAttValue_repeat1] = "PseudoAttValue_repeat1",
  [aux_sym_PseudoAttValue_repeat2] = "PseudoAttValue_repeat2",
  [aux_sym_Mixed_repeat1] = "Mixed_repeat1",
  [aux_sym_Mixed_repeat2] = "Mixed_repeat2",
  [aux_sym__choice_repeat1] = "_choice_repeat1",
  [aux_sym__choice_repeat2] = "_choice_repeat2",
  [aux_sym_AttlistDecl_repeat1] = "AttlistDecl_repeat1",
  [aux_sym_NotationType_repeat1] = "NotationType_repeat1",
  [aux_sym_Enumeration_repeat1] = "Enumeration_repeat1",
  [aux_sym_EntityValue_repeat1] = "EntityValue_repeat1",
  [aux_sym_EntityValue_repeat2] = "EntityValue_repeat2",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_Name] = sym_Name,
  [anon_sym_LT_QMARK] = anon_sym_LT_QMARK,
  [anon_sym_xml] = anon_sym_xml,
  [anon_sym_QMARK_GT] = anon_sym_QMARK_GT,
  [anon_sym_standalone] = anon_sym_standalone,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_yes] = anon_sym_yes,
  [anon_sym_no] = anon_sym_no,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_LT_BANG] = anon_sym_LT_BANG,
  [anon_sym_DOCTYPE] = anon_sym_DOCTYPE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_RBRACK_RBRACK_GT] = anon_sym_RBRACK_RBRACK_GT,
  [anon_sym_LT_BANG_LBRACK] = anon_sym_LT_BANG_LBRACK,
  [anon_sym_CDATA] = anon_sym_CDATA,
  [anon_sym_xml_DASHstylesheet] = anon_sym_xml_DASHstylesheet,
  [anon_sym_xml_DASHmodel] = anon_sym_xml_DASHmodel,
  [aux_sym_PseudoAttValue_token1] = aux_sym_PseudoAttValue_token1,
  [aux_sym_PseudoAttValue_token2] = aux_sym_PseudoAttValue_token2,
  [anon_sym_ELEMENT] = anon_sym_ELEMENT,
  [anon_sym_EMPTY] = anon_sym_EMPTY,
  [anon_sym_ANY] = anon_sym_ANY,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_POUNDPCDATA] = anon_sym_POUNDPCDATA,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_ATTLIST] = anon_sym_ATTLIST,
  [sym_TokenizedType] = sym_TokenizedType,
  [anon_sym_NOTATION] = anon_sym_NOTATION,
  [anon_sym_POUNDREQUIRED] = anon_sym_POUNDREQUIRED,
  [anon_sym_POUNDIMPLIED] = anon_sym_POUNDIMPLIED,
  [anon_sym_POUNDFIXED] = anon_sym_POUNDFIXED,
  [anon_sym_ENTITY] = anon_sym_ENTITY,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [aux_sym_EntityValue_token1] = aux_sym_EntityValue_token1,
  [aux_sym_EntityValue_token2] = aux_sym_EntityValue_token2,
  [anon_sym_NDATA] = anon_sym_NDATA,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym__S] = sym__S,
  [sym_Nmtoken] = sym_Nmtoken,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_AMP_POUND] = anon_sym_AMP_POUND,
  [aux_sym_CharRef_token1] = aux_sym_CharRef_token1,
  [anon_sym_AMP_POUNDx] = anon_sym_AMP_POUNDx,
  [aux_sym_CharRef_token2] = aux_sym_CharRef_token2,
  [anon_sym_SYSTEM] = anon_sym_SYSTEM,
  [anon_sym_PUBLIC] = anon_sym_PUBLIC,
  [aux_sym_SystemLiteral_token1] = aux_sym_SystemLiteral_token1,
  [aux_sym_SystemLiteral_token2] = aux_sym_SystemLiteral_token1,
  [aux_sym_PubidLiteral_token1] = aux_sym_PubidLiteral_token1,
  [aux_sym_PubidLiteral_token2] = aux_sym_PubidLiteral_token2,
  [anon_sym_version] = anon_sym_version,
  [sym_VersionNum] = sym_VersionNum,
  [anon_sym_encoding] = anon_sym_encoding,
  [sym_EncName] = sym_EncName,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym_PITarget] = sym_PITarget,
  [sym__pi_content] = sym__pi_content,
  [sym_Comment] = sym_Comment,
  [sym_CharData] = sym_CharData,
  [sym_CData] = sym_CData,
  [sym__start_tag_name] = sym_Name,
  [sym__end_tag_name] = sym_Name,
  [sym__erroneous_end_name] = sym__erroneous_end_name,
  [sym_document] = sym_document,
  [sym_prolog] = sym_prolog,
  [sym__Misc] = sym__Misc,
  [sym_XMLDecl] = sym_XMLDecl,
  [sym__SDDecl] = sym__SDDecl,
  [sym_doctypedecl] = sym_doctypedecl,
  [aux_sym__intSubset] = aux_sym__intSubset,
  [sym_element] = sym_element,
  [sym_EmptyElemTag] = sym_EmptyElemTag,
  [sym_Attribute] = sym_Attribute,
  [sym_STag] = sym_STag,
  [sym_ETag] = sym_ETag,
  [sym_content] = sym_content,
  [sym_CDSect] = sym_CDSect,
  [sym_CDStart] = sym_CDStart,
  [sym_StyleSheetPI] = sym_StyleSheetPI,
  [sym_XmlModelPI] = sym_XmlModelPI,
  [sym_PseudoAtt] = sym_PseudoAtt,
  [sym_PseudoAttValue] = sym_PseudoAttValue,
  [sym__markupdecl] = sym__markupdecl,
  [sym__DeclSep] = sym__DeclSep,
  [sym_elementdecl] = sym_elementdecl,
  [sym_contentspec] = sym_contentspec,
  [sym_Mixed] = sym_Mixed,
  [sym_children] = sym_children,
  [sym__cp] = sym__cp,
  [sym__choice] = sym__choice,
  [sym_AttlistDecl] = sym_AttlistDecl,
  [sym_AttDef] = sym_AttDef,
  [sym__AttType] = sym__AttType,
  [sym_StringType] = sym_StringType,
  [sym__EnumeratedType] = sym__EnumeratedType,
  [sym_NotationType] = sym_NotationType,
  [sym_Enumeration] = sym_Enumeration,
  [sym_DefaultDecl] = sym_DefaultDecl,
  [sym__EntityDecl] = sym__EntityDecl,
  [sym_GEDecl] = sym_GEDecl,
  [sym_PEDecl] = sym_PEDecl,
  [sym_EntityValue] = sym_EntityValue,
  [sym_NDataDecl] = sym_NDataDecl,
  [sym_NotationDecl] = sym_NotationDecl,
  [sym_PEReference] = sym_PEReference,
  [sym__Reference] = sym__Reference,
  [sym_EntityRef] = sym_EntityRef,
  [sym_CharRef] = sym_CharRef,
  [sym_AttValue] = sym_AttValue,
  [sym_ExternalID] = sym_ExternalID,
  [sym_PublicID] = sym_PublicID,
  [sym_SystemLiteral] = sym_SystemLiteral,
  [sym_PubidLiteral] = sym_PubidLiteral,
  [sym__VersionInfo] = sym__VersionInfo,
  [sym__EncodingDecl] = sym__EncodingDecl,
  [sym_PI] = sym_PI,
  [sym__Eq] = sym__Eq,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_EmptyElemTag_repeat1] = aux_sym_EmptyElemTag_repeat1,
  [aux_sym_content_repeat1] = aux_sym_content_repeat1,
  [aux_sym_StyleSheetPI_repeat1] = aux_sym_StyleSheetPI_repeat1,
  [aux_sym_PseudoAttValue_repeat1] = aux_sym_PseudoAttValue_repeat1,
  [aux_sym_PseudoAttValue_repeat2] = aux_sym_PseudoAttValue_repeat2,
  [aux_sym_Mixed_repeat1] = aux_sym_Mixed_repeat1,
  [aux_sym_Mixed_repeat2] = aux_sym_Mixed_repeat2,
  [aux_sym__choice_repeat1] = aux_sym__choice_repeat1,
  [aux_sym__choice_repeat2] = aux_sym__choice_repeat2,
  [aux_sym_AttlistDecl_repeat1] = aux_sym_AttlistDecl_repeat1,
  [aux_sym_NotationType_repeat1] = aux_sym_NotationType_repeat1,
  [aux_sym_Enumeration_repeat1] = aux_sym_Enumeration_repeat1,
  [aux_sym_EntityValue_repeat1] = aux_sym_EntityValue_repeat1,
  [aux_sym_EntityValue_repeat2] = aux_sym_EntityValue_repeat2,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_Name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xml] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_standalone] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_no] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOCTYPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_BANG_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CDATA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xml_DASHstylesheet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xml_DASHmodel] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_PseudoAttValue_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_PseudoAttValue_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_ELEMENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EMPTY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ANY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDPCDATA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATTLIST] = {
    .visible = true,
    .named = false,
  },
  [sym_TokenizedType] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NOTATION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDREQUIRED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDIMPLIED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDFIXED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENTITY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_EntityValue_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_EntityValue_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_NDATA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym__S] = {
    .visible = false,
    .named = true,
  },
  [sym_Nmtoken] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_POUND] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_CharRef_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_AMP_POUNDx] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_CharRef_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SYSTEM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PUBLIC] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_SystemLiteral_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_SystemLiteral_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_PubidLiteral_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_PubidLiteral_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_version] = {
    .visible = true,
    .named = false,
  },
  [sym_VersionNum] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_encoding] = {
    .visible = true,
    .named = false,
  },
  [sym_EncName] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_PITarget] = {
    .visible = true,
    .named = true,
  },
  [sym__pi_content] = {
    .visible = false,
    .named = true,
  },
  [sym_Comment] = {
    .visible = true,
    .named = true,
  },
  [sym_CharData] = {
    .visible = true,
    .named = true,
  },
  [sym_CData] = {
    .visible = true,
    .named = true,
  },
  [sym__start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__erroneous_end_name] = {
    .visible = false,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_prolog] = {
    .visible = true,
    .named = true,
  },
  [sym__Misc] = {
    .visible = false,
    .named = true,
  },
  [sym_XMLDecl] = {
    .visible = true,
    .named = true,
  },
  [sym__SDDecl] = {
    .visible = false,
    .named = true,
  },
  [sym_doctypedecl] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__intSubset] = {
    .visible = false,
    .named = false,
  },
  [sym_element] = {
    .visible = true,
    .named = true,
  },
  [sym_EmptyElemTag] = {
    .visible = true,
    .named = true,
  },
  [sym_Attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_STag] = {
    .visible = true,
    .named = true,
  },
  [sym_ETag] = {
    .visible = true,
    .named = true,
  },
  [sym_content] = {
    .visible = true,
    .named = true,
  },
  [sym_CDSect] = {
    .visible = true,
    .named = true,
  },
  [sym_CDStart] = {
    .visible = true,
    .named = true,
  },
  [sym_StyleSheetPI] = {
    .visible = true,
    .named = true,
  },
  [sym_XmlModelPI] = {
    .visible = true,
    .named = true,
  },
  [sym_PseudoAtt] = {
    .visible = true,
    .named = true,
  },
  [sym_PseudoAttValue] = {
    .visible = true,
    .named = true,
  },
  [sym__markupdecl] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__DeclSep] = {
    .visible = false,
    .named = true,
  },
  [sym_elementdecl] = {
    .visible = true,
    .named = true,
  },
  [sym_contentspec] = {
    .visible = true,
    .named = true,
  },
  [sym_Mixed] = {
    .visible = true,
    .named = true,
  },
  [sym_children] = {
    .visible = true,
    .named = true,
  },
  [sym__cp] = {
    .visible = false,
    .named = true,
  },
  [sym__choice] = {
    .visible = false,
    .named = true,
  },
  [sym_AttlistDecl] = {
    .visible = true,
    .named = true,
  },
  [sym_AttDef] = {
    .visible = true,
    .named = true,
  },
  [sym__AttType] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_StringType] = {
    .visible = true,
    .named = true,
  },
  [sym__EnumeratedType] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_NotationType] = {
    .visible = true,
    .named = true,
  },
  [sym_Enumeration] = {
    .visible = true,
    .named = true,
  },
  [sym_DefaultDecl] = {
    .visible = true,
    .named = true,
  },
  [sym__EntityDecl] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_GEDecl] = {
    .visible = true,
    .named = true,
  },
  [sym_PEDecl] = {
    .visible = true,
    .named = true,
  },
  [sym_EntityValue] = {
    .visible = true,
    .named = true,
  },
  [sym_NDataDecl] = {
    .visible = true,
    .named = true,
  },
  [sym_NotationDecl] = {
    .visible = true,
    .named = true,
  },
  [sym_PEReference] = {
    .visible = true,
    .named = true,
  },
  [sym__Reference] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_EntityRef] = {
    .visible = true,
    .named = true,
  },
  [sym_CharRef] = {
    .visible = true,
    .named = true,
  },
  [sym_AttValue] = {
    .visible = true,
    .named = true,
  },
  [sym_ExternalID] = {
    .visible = true,
    .named = true,
  },
  [sym_PublicID] = {
    .visible = true,
    .named = true,
  },
  [sym_SystemLiteral] = {
    .visible = true,
    .named = true,
  },
  [sym_PubidLiteral] = {
    .visible = true,
    .named = true,
  },
  [sym__VersionInfo] = {
    .visible = false,
    .named = true,
  },
  [sym__EncodingDecl] = {
    .visible = false,
    .named = true,
  },
  [sym_PI] = {
    .visible = true,
    .named = true,
  },
  [sym__Eq] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_EmptyElemTag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_StyleSheetPI_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_PseudoAttValue_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_PseudoAttValue_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_Mixed_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_Mixed_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__choice_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__choice_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_AttlistDecl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_NotationType_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_Enumeration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_EntityValue_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_EntityValue_repeat2] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_content = 1,
  field_root = 2,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_content] = "content",
  [field_root] = "root",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_root, 0},
  [1] =
    {field_root, 1},
  [2] =
    {field_root, 2},
  [3] =
    {field_content, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 46,
  [49] = 45,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 41,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 65,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 40,
  [102] = 40,
  [103] = 79,
  [104] = 77,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 34,
  [111] = 76,
  [112] = 112,
  [113] = 34,
  [114] = 79,
  [115] = 77,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 38,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 34,
  [143] = 143,
  [144] = 77,
  [145] = 79,
  [146] = 40,
  [147] = 77,
  [148] = 79,
  [149] = 149,
  [150] = 150,
  [151] = 40,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 36,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 66,
  [173] = 165,
  [174] = 174,
  [175] = 70,
  [176] = 176,
  [177] = 78,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 37,
  [199] = 199,
  [200] = 42,
  [201] = 81,
  [202] = 202,
  [203] = 178,
  [204] = 204,
  [205] = 39,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 186,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 169,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 76,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 280,
  [309] = 280,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 38,
  [321] = 321,
  [322] = 235,
  [323] = 323,
  [324] = 324,
  [325] = 253,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 307,
  [331] = 291,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 427,
  [456] = 432,
  [457] = 452,
  [458] = 458,
  [459] = 454,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 436,
  [465] = 465,
  [466] = 427,
  [467] = 432,
  [468] = 452,
  [469] = 436,
  [470] = 427,
  [471] = 432,
  [472] = 436,
  [473] = 427,
  [474] = 432,
  [475] = 462,
  [476] = 434,
  [477] = 435,
  [478] = 429,
  [479] = 426,
  [480] = 425,
  [481] = 420,
  [482] = 396,
  [483] = 429,
  [484] = 426,
  [485] = 425,
  [486] = 420,
  [487] = 396,
  [488] = 429,
  [489] = 426,
  [490] = 425,
  [491] = 396,
  [492] = 429,
  [493] = 426,
  [494] = 425,
};

static TSCharacterRange aux_sym_PubidLiteral_token1_character_set_1[] = {
  {'\n', '\n'}, {'\r', '\r'}, {' ', '!'}, {'#', '%'}, {'\'', ';'}, {'=', '='}, {'?', 'Z'}, {'_', '_'},
  {'a', 'z'},
};

static TSCharacterRange aux_sym_PubidLiteral_token2_character_set_1[] = {
  {'\n', '\n'}, {'\r', '\r'}, {' ', '!'}, {'#', '%'}, {'(', ';'}, {'=', '='}, {'?', 'Z'}, {'_', '_'},
  {'a', 'z'},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(42);
      ADVANCE_MAP(
        '"', 46,
        '#', 64,
        '%', 91,
        '&', 132,
        '\'', 45,
        '(', 74,
        ')', 77,
        '*', 78,
        '+', 80,
        ',', 81,
        '/', 62,
        '1', 61,
        ';', 94,
        '<', 53,
        '=', 143,
        '>', 52,
        '?', 79,
        'E', 66,
        'I', 63,
        'N', 65,
        '[', 49,
        ']', 51,
        '_', 72,
        '|', 76,
        '\t', 69,
        '\n', 69,
        '\r', 69,
        ' ', 69,
        '-', 71,
        '.', 71,
        ':', 71,
        0xb7, 71,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      if (lookahead != 0) ADVANCE(60);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '"', 46,
        '#', 28,
        '%', 91,
        '\'', 45,
        '(', 74,
        ')', 77,
        '*', 78,
        '+', 80,
        ',', 81,
        '/', 7,
        '>', 52,
        '?', 79,
        '[', 49,
        ']', 36,
        '|', 76,
        '\t', 95,
        '\n', 95,
        '\r', 95,
        ' ', 95,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(46);
      if (lookahead == '%') ADVANCE(91);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead != 0 &&
          lookahead != '<') ADVANCE(92);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(46);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead != 0 &&
          lookahead != '<') ADVANCE(60);
      END_STATE();
    case 4:
      if (lookahead == '%') ADVANCE(91);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '\'') ADVANCE(45);
      if (lookahead == '<') ADVANCE(55);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '\'') ADVANCE(45);
      if (lookahead != 0 &&
          lookahead != '<') ADVANCE(73);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(38);
      END_STATE();
    case 7:
      if (lookahead == '>') ADVANCE(56);
      END_STATE();
    case 8:
      if (lookahead == '>') ADVANCE(58);
      END_STATE();
    case 9:
      if (lookahead == '>') ADVANCE(44);
      END_STATE();
    case 10:
      if (lookahead == '?') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(95);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 11:
      if (lookahead == 'A') ADVANCE(32);
      END_STATE();
    case 12:
      if (lookahead == 'A') ADVANCE(75);
      END_STATE();
    case 13:
      if (lookahead == 'C') ADVANCE(14);
      END_STATE();
    case 14:
      if (lookahead == 'D') ADVANCE(11);
      END_STATE();
    case 15:
      if (lookahead == 'D') ADVANCE(90);
      END_STATE();
    case 16:
      if (lookahead == 'D') ADVANCE(89);
      END_STATE();
    case 17:
      if (lookahead == 'D') ADVANCE(88);
      END_STATE();
    case 18:
      if (lookahead == 'E') ADVANCE(30);
      END_STATE();
    case 19:
      if (lookahead == 'E') ADVANCE(15);
      END_STATE();
    case 20:
      if (lookahead == 'E') ADVANCE(16);
      END_STATE();
    case 21:
      if (lookahead == 'E') ADVANCE(17);
      END_STATE();
    case 22:
      if (lookahead == 'F') ADVANCE(23);
      if (lookahead == 'I') ADVANCE(27);
      if (lookahead == 'R') ADVANCE(18);
      END_STATE();
    case 23:
      if (lookahead == 'I') ADVANCE(34);
      END_STATE();
    case 24:
      if (lookahead == 'I') ADVANCE(31);
      END_STATE();
    case 25:
      if (lookahead == 'I') ADVANCE(20);
      END_STATE();
    case 26:
      if (lookahead == 'L') ADVANCE(25);
      END_STATE();
    case 27:
      if (lookahead == 'M') ADVANCE(29);
      END_STATE();
    case 28:
      if (lookahead == 'P') ADVANCE(13);
      END_STATE();
    case 29:
      if (lookahead == 'P') ADVANCE(26);
      END_STATE();
    case 30:
      if (lookahead == 'Q') ADVANCE(33);
      END_STATE();
    case 31:
      if (lookahead == 'R') ADVANCE(21);
      END_STATE();
    case 32:
      if (lookahead == 'T') ADVANCE(12);
      END_STATE();
    case 33:
      if (lookahead == 'U') ADVANCE(24);
      END_STATE();
    case 34:
      if (lookahead == 'X') ADVANCE(19);
      END_STATE();
    case 35:
      if (lookahead == '[') ADVANCE(59);
      END_STATE();
    case 36:
      if (lookahead == ']') ADVANCE(8);
      END_STATE();
    case 37:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(95);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(131);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      END_STATE();
    case 40:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 41:
      if (eof) ADVANCE(42);
      ADVANCE_MAP(
        '"', 46,
        '#', 22,
        '%', 91,
        '\'', 45,
        '(', 74,
        ')', 77,
        '*', 78,
        '+', 80,
        ',', 81,
        '/', 7,
        '1', 6,
        ';', 94,
        '<', 54,
        '=', 143,
        '>', 52,
        '?', 79,
        'E', 113,
        'I', 96,
        'N', 111,
        '[', 49,
        ']', 50,
        '|', 76,
        '\t', 95,
        '\n', 95,
        '\r', 95,
        ' ', 95,
      );
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LT_QMARK);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_QMARK_GT);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_LT_BANG);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_LT_BANG);
      if (lookahead == '[') ADVANCE(59);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      if (lookahead == ']') ADVANCE(8);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(48);
      if (lookahead == '/') ADVANCE(57);
      if (lookahead == '?') ADVANCE(43);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(47);
      if (lookahead == '?') ADVANCE(43);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '/') ADVANCE(57);
      if (lookahead == '?') ADVANCE(43);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK_GT);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_LT_BANG_LBRACK);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == '.') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      if (lookahead == '-' ||
          lookahead == ':' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(131);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == '>') ADVANCE(56);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == 'D') ADVANCE(82);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == 'F') ADVANCE(23);
      if (lookahead == 'I') ADVANCE(27);
      if (lookahead == 'P') ADVANCE(13);
      if (lookahead == 'R') ADVANCE(18);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == 'M') ADVANCE(120);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == 'N') ADVANCE(119);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(95);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ':' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(131);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(131);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token1);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(aux_sym_PseudoAttValue_token2);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_POUNDPCDATA);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_TokenizedType);
      if (lookahead == 'R') ADVANCE(97);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_TokenizedType);
      if (lookahead == 'R') ADVANCE(100);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_TokenizedType);
      if (lookahead == 'S') ADVANCE(86);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_TokenizedType);
      if (lookahead == 'S') ADVANCE(87);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_TokenizedType);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_TokenizedType);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_POUNDREQUIRED);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_POUNDIMPLIED);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_POUNDFIXED);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_EntityValue_token1);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_EntityValue_token2);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym__S);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'D') ADVANCE(83);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'E') ADVANCE(103);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'E') ADVANCE(112);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'E') ADVANCE(117);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'E') ADVANCE(104);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'E') ADVANCE(118);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'E') ADVANCE(114);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'F') ADVANCE(84);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'F') ADVANCE(85);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'I') ADVANCE(121);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'I') ADVANCE(99);
      if (lookahead == 'Y') ADVANCE(86);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'I') ADVANCE(124);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'I') ADVANCE(101);
      if (lookahead == 'Y') ADVANCE(87);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'K') ADVANCE(98);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'K') ADVANCE(102);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'M') ADVANCE(123);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'N') ADVANCE(84);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'N') ADVANCE(122);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'N') ADVANCE(85);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'O') ADVANCE(109);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'O') ADVANCE(110);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'S') ADVANCE(86);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'S') ADVANCE(87);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'T') ADVANCE(105);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'T') ADVANCE(115);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'T') ADVANCE(106);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'T') ADVANCE(107);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'T') ADVANCE(116);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == 'T') ADVANCE(108);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == ':' ||
          lookahead == 0xb7) ADVANCE(127);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_Name);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(127);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_Nmtoken);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ':' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(131);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_Nmtoken);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ':' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(131);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_Nmtoken);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ':' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(131);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_Nmtoken);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb7) ADVANCE(131);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '#') ADVANCE(133);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_AMP_POUND);
      if (lookahead == 'x') ADVANCE(135);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_CharRef_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_AMP_POUNDx);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_CharRef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_SystemLiteral_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(137);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_SystemLiteral_token2);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_PubidLiteral_token1);
      if (set_contains(aux_sym_PubidLiteral_token1_character_set_1, 9, lookahead)) ADVANCE(139);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_PubidLiteral_token2);
      if (set_contains(aux_sym_PubidLiteral_token2_character_set_1, 9, lookahead)) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_VersionNum);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_EncName);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'A', 1,
        'C', 2,
        'D', 3,
        'E', 4,
        'N', 5,
        'P', 6,
        'S', 7,
        'e', 8,
        'n', 9,
        's', 10,
        'v', 11,
        'x', 12,
        'y', 13,
      );
      END_STATE();
    case 1:
      if (lookahead == 'N') ADVANCE(14);
      if (lookahead == 'T') ADVANCE(15);
      END_STATE();
    case 2:
      if (lookahead == 'D') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'O') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'L') ADVANCE(18);
      if (lookahead == 'M') ADVANCE(19);
      if (lookahead == 'N') ADVANCE(20);
      END_STATE();
    case 5:
      if (lookahead == 'D') ADVANCE(21);
      if (lookahead == 'O') ADVANCE(22);
      END_STATE();
    case 6:
      if (lookahead == 'U') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'Y') ADVANCE(24);
      END_STATE();
    case 8:
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 10:
      if (lookahead == 't') ADVANCE(27);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 12:
      if (lookahead == 'm') ADVANCE(29);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 14:
      if (lookahead == 'Y') ADVANCE(31);
      END_STATE();
    case 15:
      if (lookahead == 'T') ADVANCE(32);
      END_STATE();
    case 16:
      if (lookahead == 'A') ADVANCE(33);
      END_STATE();
    case 17:
      if (lookahead == 'C') ADVANCE(34);
      END_STATE();
    case 18:
      if (lookahead == 'E') ADVANCE(35);
      END_STATE();
    case 19:
      if (lookahead == 'P') ADVANCE(36);
      END_STATE();
    case 20:
      if (lookahead == 'T') ADVANCE(37);
      END_STATE();
    case 21:
      if (lookahead == 'A') ADVANCE(38);
      END_STATE();
    case 22:
      if (lookahead == 'T') ADVANCE(39);
      END_STATE();
    case 23:
      if (lookahead == 'B') ADVANCE(40);
      END_STATE();
    case 24:
      if (lookahead == 'S') ADVANCE(41);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(42);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_no);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(43);
      END_STATE();
    case 28:
      if (lookahead == 'r') ADVANCE(44);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(45);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(46);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_ANY);
      END_STATE();
    case 32:
      if (lookahead == 'L') ADVANCE(47);
      END_STATE();
    case 33:
      if (lookahead == 'T') ADVANCE(48);
      END_STATE();
    case 34:
      if (lookahead == 'T') ADVANCE(49);
      END_STATE();
    case 35:
      if (lookahead == 'M') ADVANCE(50);
      END_STATE();
    case 36:
      if (lookahead == 'T') ADVANCE(51);
      END_STATE();
    case 37:
      if (lookahead == 'I') ADVANCE(52);
      END_STATE();
    case 38:
      if (lookahead == 'T') ADVANCE(53);
      END_STATE();
    case 39:
      if (lookahead == 'A') ADVANCE(54);
      END_STATE();
    case 40:
      if (lookahead == 'L') ADVANCE(55);
      END_STATE();
    case 41:
      if (lookahead == 'T') ADVANCE(56);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(57);
      END_STATE();
    case 43:
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 44:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_xml);
      if (lookahead == '-') ADVANCE(60);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_yes);
      END_STATE();
    case 47:
      if (lookahead == 'I') ADVANCE(61);
      END_STATE();
    case 48:
      if (lookahead == 'A') ADVANCE(62);
      END_STATE();
    case 49:
      if (lookahead == 'Y') ADVANCE(63);
      END_STATE();
    case 50:
      if (lookahead == 'E') ADVANCE(64);
      END_STATE();
    case 51:
      if (lookahead == 'Y') ADVANCE(65);
      END_STATE();
    case 52:
      if (lookahead == 'T') ADVANCE(66);
      END_STATE();
    case 53:
      if (lookahead == 'A') ADVANCE(67);
      END_STATE();
    case 54:
      if (lookahead == 'T') ADVANCE(68);
      END_STATE();
    case 55:
      if (lookahead == 'I') ADVANCE(69);
      END_STATE();
    case 56:
      if (lookahead == 'E') ADVANCE(70);
      END_STATE();
    case 57:
      if (lookahead == 'd') ADVANCE(71);
      END_STATE();
    case 58:
      if (lookahead == 'd') ADVANCE(72);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(73);
      END_STATE();
    case 60:
      if (lookahead == 'm') ADVANCE(74);
      if (lookahead == 's') ADVANCE(75);
      END_STATE();
    case 61:
      if (lookahead == 'S') ADVANCE(76);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_CDATA);
      END_STATE();
    case 63:
      if (lookahead == 'P') ADVANCE(77);
      END_STATE();
    case 64:
      if (lookahead == 'N') ADVANCE(78);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_EMPTY);
      END_STATE();
    case 66:
      if (lookahead == 'Y') ADVANCE(79);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_NDATA);
      END_STATE();
    case 68:
      if (lookahead == 'I') ADVANCE(80);
      END_STATE();
    case 69:
      if (lookahead == 'C') ADVANCE(81);
      END_STATE();
    case 70:
      if (lookahead == 'M') ADVANCE(82);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(84);
      END_STATE();
    case 73:
      if (lookahead == 'o') ADVANCE(85);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(86);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 76:
      if (lookahead == 'T') ADVANCE(88);
      END_STATE();
    case 77:
      if (lookahead == 'E') ADVANCE(89);
      END_STATE();
    case 78:
      if (lookahead == 'T') ADVANCE(90);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_ENTITY);
      END_STATE();
    case 80:
      if (lookahead == 'O') ADVANCE(91);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PUBLIC);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_SYSTEM);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 86:
      if (lookahead == 'd') ADVANCE(95);
      END_STATE();
    case 87:
      if (lookahead == 'y') ADVANCE(96);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_ATTLIST);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_DOCTYPE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_ELEMENT);
      END_STATE();
    case 91:
      if (lookahead == 'N') ADVANCE(97);
      END_STATE();
    case 92:
      if (lookahead == 'g') ADVANCE(98);
      END_STATE();
    case 93:
      if (lookahead == 'o') ADVANCE(99);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_version);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 96:
      if (lookahead == 'l') ADVANCE(101);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_NOTATION);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_encoding);
      END_STATE();
    case 99:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 100:
      if (lookahead == 'l') ADVANCE(103);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(105);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_xml_DASHmodel);
      END_STATE();
    case 104:
      if (lookahead == 's') ADVANCE(106);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_standalone);
      END_STATE();
    case 106:
      if (lookahead == 'h') ADVANCE(107);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_xml_DASHstylesheet);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 41, .external_lex_state = 2},
  [2] = {.lex_state = 4, .external_lex_state = 3},
  [3] = {.lex_state = 4, .external_lex_state = 3},
  [4] = {.lex_state = 4, .external_lex_state = 3},
  [5] = {.lex_state = 4, .external_lex_state = 3},
  [6] = {.lex_state = 41, .external_lex_state = 2},
  [7] = {.lex_state = 41, .external_lex_state = 2},
  [8] = {.lex_state = 41, .external_lex_state = 2},
  [9] = {.lex_state = 41, .external_lex_state = 2},
  [10] = {.lex_state = 41, .external_lex_state = 2},
  [11] = {.lex_state = 41, .external_lex_state = 2},
  [12] = {.lex_state = 41, .external_lex_state = 2},
  [13] = {.lex_state = 41, .external_lex_state = 2},
  [14] = {.lex_state = 41, .external_lex_state = 2},
  [15] = {.lex_state = 41, .external_lex_state = 2},
  [16] = {.lex_state = 41, .external_lex_state = 2},
  [17] = {.lex_state = 41, .external_lex_state = 2},
  [18] = {.lex_state = 41, .external_lex_state = 2},
  [19] = {.lex_state = 41, .external_lex_state = 2},
  [20] = {.lex_state = 41, .external_lex_state = 2},
  [21] = {.lex_state = 4},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 41, .external_lex_state = 2},
  [24] = {.lex_state = 41},
  [25] = {.lex_state = 41},
  [26] = {.lex_state = 4},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 41},
  [29] = {.lex_state = 4},
  [30] = {.lex_state = 41, .external_lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 41, .external_lex_state = 2},
  [33] = {.lex_state = 41, .external_lex_state = 2},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 41},
  [36] = {.lex_state = 4, .external_lex_state = 3},
  [37] = {.lex_state = 4, .external_lex_state = 3},
  [38] = {.lex_state = 4, .external_lex_state = 3},
  [39] = {.lex_state = 4, .external_lex_state = 3},
  [40] = {.lex_state = 4, .external_lex_state = 3},
  [41] = {.lex_state = 5},
  [42] = {.lex_state = 4, .external_lex_state = 3},
  [43] = {.lex_state = 3},
  [44] = {.lex_state = 5},
  [45] = {.lex_state = 3},
  [46] = {.lex_state = 5},
  [47] = {.lex_state = 41},
  [48] = {.lex_state = 5},
  [49] = {.lex_state = 3},
  [50] = {.lex_state = 41},
  [51] = {.lex_state = 5},
  [52] = {.lex_state = 4, .external_lex_state = 3},
  [53] = {.lex_state = 41},
  [54] = {.lex_state = 41},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 41, .external_lex_state = 2},
  [57] = {.lex_state = 41, .external_lex_state = 2},
  [58] = {.lex_state = 41, .external_lex_state = 2},
  [59] = {.lex_state = 41, .external_lex_state = 2},
  [60] = {.lex_state = 41, .external_lex_state = 2},
  [61] = {.lex_state = 41, .external_lex_state = 2},
  [62] = {.lex_state = 4, .external_lex_state = 3},
  [63] = {.lex_state = 5},
  [64] = {.lex_state = 4, .external_lex_state = 3},
  [65] = {.lex_state = 3},
  [66] = {.lex_state = 4, .external_lex_state = 3},
  [67] = {.lex_state = 3},
  [68] = {.lex_state = 41},
  [69] = {.lex_state = 5},
  [70] = {.lex_state = 4, .external_lex_state = 3},
  [71] = {.lex_state = 3},
  [72] = {.lex_state = 41, .external_lex_state = 2},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 41, .external_lex_state = 2},
  [75] = {.lex_state = 4, .external_lex_state = 3},
  [76] = {.lex_state = 4, .external_lex_state = 3},
  [77] = {.lex_state = 4, .external_lex_state = 3},
  [78] = {.lex_state = 4, .external_lex_state = 3},
  [79] = {.lex_state = 4, .external_lex_state = 3},
  [80] = {.lex_state = 4, .external_lex_state = 3},
  [81] = {.lex_state = 4, .external_lex_state = 3},
  [82] = {.lex_state = 41, .external_lex_state = 2},
  [83] = {.lex_state = 41, .external_lex_state = 2},
  [84] = {.lex_state = 41, .external_lex_state = 2},
  [85] = {.lex_state = 41, .external_lex_state = 2},
  [86] = {.lex_state = 41},
  [87] = {.lex_state = 41},
  [88] = {.lex_state = 41},
  [89] = {.lex_state = 41},
  [90] = {.lex_state = 41},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 41},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 41},
  [96] = {.lex_state = 41},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 41},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 4},
  [103] = {.lex_state = 4},
  [104] = {.lex_state = 4},
  [105] = {.lex_state = 41, .external_lex_state = 2},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 41, .external_lex_state = 2},
  [108] = {.lex_state = 41, .external_lex_state = 2},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 2},
  [111] = {.lex_state = 41, .external_lex_state = 2},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 4},
  [114] = {.lex_state = 2},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 41, .external_lex_state = 2},
  [118] = {.lex_state = 41},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 41, .external_lex_state = 2},
  [122] = {.lex_state = 1},
  [123] = {.lex_state = 41, .external_lex_state = 2},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 1},
  [126] = {.lex_state = 41, .external_lex_state = 2},
  [127] = {.lex_state = 41, .external_lex_state = 2},
  [128] = {.lex_state = 41},
  [129] = {.lex_state = 41},
  [130] = {.lex_state = 41},
  [131] = {.lex_state = 41, .external_lex_state = 2},
  [132] = {.lex_state = 41},
  [133] = {.lex_state = 41},
  [134] = {.lex_state = 41},
  [135] = {.lex_state = 41},
  [136] = {.lex_state = 41},
  [137] = {.lex_state = 41},
  [138] = {.lex_state = 41},
  [139] = {.lex_state = 41},
  [140] = {.lex_state = 41, .external_lex_state = 2},
  [141] = {.lex_state = 41},
  [142] = {.lex_state = 41, .external_lex_state = 2},
  [143] = {.lex_state = 41},
  [144] = {.lex_state = 3},
  [145] = {.lex_state = 3},
  [146] = {.lex_state = 3},
  [147] = {.lex_state = 5},
  [148] = {.lex_state = 5},
  [149] = {.lex_state = 41, .external_lex_state = 2},
  [150] = {.lex_state = 41},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 41, .external_lex_state = 2},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 41},
  [155] = {.lex_state = 41},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 41, .external_lex_state = 2},
  [158] = {.lex_state = 41},
  [159] = {.lex_state = 41, .external_lex_state = 2},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 10},
  [164] = {.lex_state = 41, .external_lex_state = 2},
  [165] = {.lex_state = 1, .external_lex_state = 4},
  [166] = {.lex_state = 41},
  [167] = {.lex_state = 41},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 41, .external_lex_state = 4},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 41, .external_lex_state = 2},
  [172] = {.lex_state = 41, .external_lex_state = 2},
  [173] = {.lex_state = 1, .external_lex_state = 4},
  [174] = {.lex_state = 41, .external_lex_state = 4},
  [175] = {.lex_state = 41, .external_lex_state = 2},
  [176] = {.lex_state = 41},
  [177] = {.lex_state = 41, .external_lex_state = 2},
  [178] = {.lex_state = 1, .external_lex_state = 4},
  [179] = {.lex_state = 41, .external_lex_state = 2},
  [180] = {.lex_state = 41},
  [181] = {.lex_state = 41},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 41},
  [184] = {.lex_state = 41, .external_lex_state = 2},
  [185] = {.lex_state = 41},
  [186] = {.lex_state = 41, .external_lex_state = 4},
  [187] = {.lex_state = 41},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 41, .external_lex_state = 2},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 41},
  [192] = {.lex_state = 41, .external_lex_state = 2},
  [193] = {.lex_state = 41},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 41},
  [196] = {.lex_state = 41},
  [197] = {.lex_state = 41},
  [198] = {.lex_state = 41, .external_lex_state = 2},
  [199] = {.lex_state = 41},
  [200] = {.lex_state = 41, .external_lex_state = 2},
  [201] = {.lex_state = 41, .external_lex_state = 2},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 1, .external_lex_state = 4},
  [204] = {.lex_state = 41},
  [205] = {.lex_state = 41, .external_lex_state = 2},
  [206] = {.lex_state = 41},
  [207] = {.lex_state = 41},
  [208] = {.lex_state = 41, .external_lex_state = 2},
  [209] = {.lex_state = 41, .external_lex_state = 4},
  [210] = {.lex_state = 41, .external_lex_state = 2},
  [211] = {.lex_state = 41},
  [212] = {.lex_state = 41},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1, .external_lex_state = 5},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 41},
  [217] = {.lex_state = 41, .external_lex_state = 4},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 41},
  [220] = {.lex_state = 41},
  [221] = {.lex_state = 41},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 41},
  [224] = {.lex_state = 41},
  [225] = {.lex_state = 41, .external_lex_state = 4},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 41},
  [228] = {.lex_state = 41},
  [229] = {.lex_state = 41},
  [230] = {.lex_state = 41},
  [231] = {.lex_state = 10},
  [232] = {.lex_state = 41},
  [233] = {.lex_state = 1, .external_lex_state = 5},
  [234] = {.lex_state = 10},
  [235] = {.lex_state = 41, .external_lex_state = 4},
  [236] = {.lex_state = 41},
  [237] = {.lex_state = 41},
  [238] = {.lex_state = 41},
  [239] = {.lex_state = 41},
  [240] = {.lex_state = 41},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 41},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 41},
  [246] = {.lex_state = 41},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 41},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 41},
  [251] = {.lex_state = 10},
  [252] = {.lex_state = 41},
  [253] = {.lex_state = 41, .external_lex_state = 4},
  [254] = {.lex_state = 41},
  [255] = {.lex_state = 10},
  [256] = {.lex_state = 41, .external_lex_state = 4},
  [257] = {.lex_state = 41},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 41},
  [260] = {.lex_state = 41},
  [261] = {.lex_state = 41},
  [262] = {.lex_state = 41},
  [263] = {.lex_state = 10},
  [264] = {.lex_state = 41},
  [265] = {.lex_state = 10},
  [266] = {.lex_state = 41},
  [267] = {.lex_state = 41},
  [268] = {.lex_state = 41},
  [269] = {.lex_state = 41},
  [270] = {.lex_state = 10},
  [271] = {.lex_state = 10},
  [272] = {.lex_state = 41},
  [273] = {.lex_state = 10},
  [274] = {.lex_state = 10},
  [275] = {.lex_state = 10},
  [276] = {.lex_state = 41},
  [277] = {.lex_state = 41},
  [278] = {.lex_state = 41},
  [279] = {.lex_state = 41},
  [280] = {.lex_state = 10},
  [281] = {.lex_state = 41},
  [282] = {.lex_state = 41},
  [283] = {.lex_state = 10},
  [284] = {.lex_state = 10},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 41},
  [287] = {.lex_state = 10},
  [288] = {.lex_state = 41},
  [289] = {.lex_state = 41},
  [290] = {.lex_state = 41},
  [291] = {.lex_state = 41},
  [292] = {.lex_state = 41},
  [293] = {.lex_state = 41},
  [294] = {.lex_state = 37},
  [295] = {.lex_state = 41},
  [296] = {.lex_state = 41},
  [297] = {.lex_state = 41},
  [298] = {.lex_state = 41},
  [299] = {.lex_state = 41},
  [300] = {.lex_state = 41},
  [301] = {.lex_state = 41},
  [302] = {.lex_state = 41},
  [303] = {.lex_state = 41},
  [304] = {.lex_state = 1, .external_lex_state = 6},
  [305] = {.lex_state = 10},
  [306] = {.lex_state = 41},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 10},
  [309] = {.lex_state = 10},
  [310] = {.lex_state = 41},
  [311] = {.lex_state = 41},
  [312] = {.lex_state = 41},
  [313] = {.lex_state = 41},
  [314] = {.lex_state = 41},
  [315] = {.lex_state = 41},
  [316] = {.lex_state = 41},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 1},
  [319] = {.lex_state = 41},
  [320] = {.lex_state = 41},
  [321] = {.lex_state = 41},
  [322] = {.lex_state = 41},
  [323] = {.lex_state = 41},
  [324] = {.lex_state = 41},
  [325] = {.lex_state = 41},
  [326] = {.lex_state = 41},
  [327] = {.lex_state = 10},
  [328] = {.lex_state = 41},
  [329] = {.lex_state = 41},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 41},
  [332] = {.lex_state = 41},
  [333] = {.lex_state = 41},
  [334] = {.lex_state = 1, .external_lex_state = 6},
  [335] = {.lex_state = 41},
  [336] = {.lex_state = 41},
  [337] = {.lex_state = 41},
  [338] = {.lex_state = 41},
  [339] = {.lex_state = 41},
  [340] = {.lex_state = 41},
  [341] = {.lex_state = 41},
  [342] = {.lex_state = 41},
  [343] = {.lex_state = 41},
  [344] = {.lex_state = 41},
  [345] = {.lex_state = 41},
  [346] = {.lex_state = 41},
  [347] = {.lex_state = 41},
  [348] = {.lex_state = 41},
  [349] = {.lex_state = 41},
  [350] = {.lex_state = 1},
  [351] = {.lex_state = 41},
  [352] = {.lex_state = 1},
  [353] = {.lex_state = 10},
  [354] = {.lex_state = 10},
  [355] = {.lex_state = 10},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 41},
  [358] = {.lex_state = 41},
  [359] = {.lex_state = 41},
  [360] = {.lex_state = 37},
  [361] = {.lex_state = 41},
  [362] = {.lex_state = 41},
  [363] = {.lex_state = 41},
  [364] = {.lex_state = 41},
  [365] = {.lex_state = 41},
  [366] = {.lex_state = 41},
  [367] = {.lex_state = 41},
  [368] = {.lex_state = 41},
  [369] = {.lex_state = 41},
  [370] = {.lex_state = 10},
  [371] = {.lex_state = 41},
  [372] = {.lex_state = 37},
  [373] = {.lex_state = 10},
  [374] = {.lex_state = 41},
  [375] = {.lex_state = 41},
  [376] = {.lex_state = 41},
  [377] = {.lex_state = 40},
  [378] = {.lex_state = 41},
  [379] = {.lex_state = 1},
  [380] = {.lex_state = 138},
  [381] = {.lex_state = 37},
  [382] = {.lex_state = 41},
  [383] = {.lex_state = 41},
  [384] = {.lex_state = 41},
  [385] = {.lex_state = 41},
  [386] = {.lex_state = 41},
  [387] = {.lex_state = 137},
  [388] = {.lex_state = 41},
  [389] = {.lex_state = 41},
  [390] = {.lex_state = 140},
  [391] = {.lex_state = 139},
  [392] = {.lex_state = 41},
  [393] = {.lex_state = 41},
  [394] = {.lex_state = 37},
  [395] = {.lex_state = 41},
  [396] = {.lex_state = 1},
  [397] = {.lex_state = 41},
  [398] = {.lex_state = 41},
  [399] = {.lex_state = 41},
  [400] = {.lex_state = 41},
  [401] = {.lex_state = 41},
  [402] = {.lex_state = 41},
  [403] = {.lex_state = 41},
  [404] = {.lex_state = 41},
  [405] = {.lex_state = 41},
  [406] = {.lex_state = 41},
  [407] = {.lex_state = 41},
  [408] = {.lex_state = 41},
  [409] = {.lex_state = 41},
  [410] = {.lex_state = 41},
  [411] = {.lex_state = 41},
  [412] = {.lex_state = 41},
  [413] = {.lex_state = 41},
  [414] = {.lex_state = 41},
  [415] = {.lex_state = 41},
  [416] = {.lex_state = 41},
  [417] = {.lex_state = 41},
  [418] = {.lex_state = 10},
  [419] = {.lex_state = 1},
  [420] = {.lex_state = 0, .external_lex_state = 7},
  [421] = {.lex_state = 41},
  [422] = {.lex_state = 37},
  [423] = {.lex_state = 41},
  [424] = {.lex_state = 41},
  [425] = {.lex_state = 39},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 41},
  [428] = {.lex_state = 40},
  [429] = {.lex_state = 1},
  [430] = {.lex_state = 1},
  [431] = {.lex_state = 41},
  [432] = {.lex_state = 41},
  [433] = {.lex_state = 1},
  [434] = {.lex_state = 0, .external_lex_state = 8},
  [435] = {.lex_state = 0, .external_lex_state = 9},
  [436] = {.lex_state = 41},
  [437] = {.lex_state = 41},
  [438] = {.lex_state = 41},
  [439] = {.lex_state = 41},
  [440] = {.lex_state = 41},
  [441] = {.lex_state = 41},
  [442] = {.lex_state = 41},
  [443] = {.lex_state = 41},
  [444] = {.lex_state = 41},
  [445] = {.lex_state = 10},
  [446] = {.lex_state = 41},
  [447] = {.lex_state = 41},
  [448] = {.lex_state = 41},
  [449] = {.lex_state = 41},
  [450] = {.lex_state = 41},
  [451] = {.lex_state = 41},
  [452] = {.lex_state = 10},
  [453] = {.lex_state = 41},
  [454] = {.lex_state = 41},
  [455] = {.lex_state = 41},
  [456] = {.lex_state = 41},
  [457] = {.lex_state = 10},
  [458] = {.lex_state = 1},
  [459] = {.lex_state = 41},
  [460] = {.lex_state = 41},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0, .external_lex_state = 10},
  [463] = {.lex_state = 1},
  [464] = {.lex_state = 41},
  [465] = {.lex_state = 41},
  [466] = {.lex_state = 41},
  [467] = {.lex_state = 41},
  [468] = {.lex_state = 10},
  [469] = {.lex_state = 41},
  [470] = {.lex_state = 41},
  [471] = {.lex_state = 41},
  [472] = {.lex_state = 41},
  [473] = {.lex_state = 41},
  [474] = {.lex_state = 41},
  [475] = {.lex_state = 0, .external_lex_state = 10},
  [476] = {.lex_state = 0, .external_lex_state = 8},
  [477] = {.lex_state = 0, .external_lex_state = 9},
  [478] = {.lex_state = 1},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 39},
  [481] = {.lex_state = 0, .external_lex_state = 7},
  [482] = {.lex_state = 1},
  [483] = {.lex_state = 1},
  [484] = {.lex_state = 1},
  [485] = {.lex_state = 39},
  [486] = {.lex_state = 0, .external_lex_state = 7},
  [487] = {.lex_state = 1},
  [488] = {.lex_state = 1},
  [489] = {.lex_state = 1},
  [490] = {.lex_state = 39},
  [491] = {.lex_state = 1},
  [492] = {.lex_state = 1},
  [493] = {.lex_state = 1},
  [494] = {.lex_state = 39},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_Name] = ACTIONS(1),
    [anon_sym_LT_QMARK] = ACTIONS(1),
    [anon_sym_xml] = ACTIONS(1),
    [anon_sym_standalone] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_yes] = ACTIONS(1),
    [anon_sym_no] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_LT_BANG] = ACTIONS(1),
    [anon_sym_DOCTYPE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_RBRACK_RBRACK_GT] = ACTIONS(1),
    [anon_sym_LT_BANG_LBRACK] = ACTIONS(1),
    [anon_sym_CDATA] = ACTIONS(1),
    [anon_sym_xml_DASHstylesheet] = ACTIONS(1),
    [anon_sym_xml_DASHmodel] = ACTIONS(1),
    [aux_sym_PseudoAttValue_token1] = ACTIONS(1),
    [aux_sym_PseudoAttValue_token2] = ACTIONS(1),
    [anon_sym_ELEMENT] = ACTIONS(1),
    [anon_sym_EMPTY] = ACTIONS(1),
    [anon_sym_ANY] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_POUNDPCDATA] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_ATTLIST] = ACTIONS(1),
    [sym_TokenizedType] = ACTIONS(1),
    [anon_sym_NOTATION] = ACTIONS(1),
    [anon_sym_POUNDREQUIRED] = ACTIONS(1),
    [anon_sym_POUNDIMPLIED] = ACTIONS(1),
    [anon_sym_POUNDFIXED] = ACTIONS(1),
    [anon_sym_ENTITY] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [aux_sym_EntityValue_token1] = ACTIONS(1),
    [aux_sym_EntityValue_token2] = ACTIONS(1),
    [anon_sym_NDATA] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [sym__S] = ACTIONS(1),
    [sym_Nmtoken] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_AMP_POUND] = ACTIONS(1),
    [aux_sym_CharRef_token1] = ACTIONS(1),
    [anon_sym_AMP_POUNDx] = ACTIONS(1),
    [aux_sym_CharRef_token2] = ACTIONS(1),
    [anon_sym_SYSTEM] = ACTIONS(1),
    [anon_sym_PUBLIC] = ACTIONS(1),
    [anon_sym_version] = ACTIONS(1),
    [sym_VersionNum] = ACTIONS(1),
    [anon_sym_encoding] = ACTIONS(1),
    [sym_EncName] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [sym_PITarget] = ACTIONS(1),
    [sym__pi_content] = ACTIONS(1),
    [sym_Comment] = ACTIONS(1),
    [sym_CharData] = ACTIONS(1),
    [sym_CData] = ACTIONS(1),
    [sym__start_tag_name] = ACTIONS(1),
    [sym__end_tag_name] = ACTIONS(1),
    [sym__erroneous_end_name] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(461),
    [sym_prolog] = STATE(202),
    [sym__Misc] = STATE(32),
    [sym_XMLDecl] = STATE(20),
    [sym_doctypedecl] = STATE(60),
    [sym_element] = STATE(61),
    [sym_EmptyElemTag] = STATE(200),
    [sym_STag] = STATE(3),
    [sym_StyleSheetPI] = STATE(32),
    [sym_XmlModelPI] = STATE(32),
    [sym_PI] = STATE(32),
    [aux_sym_document_repeat1] = STATE(32),
    [anon_sym_LT_QMARK] = ACTIONS(3),
    [anon_sym_LT_BANG] = ACTIONS(5),
    [anon_sym_LT] = ACTIONS(7),
    [sym__S] = ACTIONS(9),
    [sym_Comment] = ACTIONS(11),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 15,
    ACTIONS(13), 1,
      anon_sym_LT_QMARK,
    ACTIONS(15), 1,
      anon_sym_LT,
    ACTIONS(17), 1,
      anon_sym_LT_SLASH,
    ACTIONS(19), 1,
      anon_sym_LT_BANG_LBRACK,
    ACTIONS(21), 1,
      anon_sym_AMP,
    ACTIONS(23), 1,
      anon_sym_AMP_POUND,
    ACTIONS(25), 1,
      anon_sym_AMP_POUNDx,
    STATE(2), 1,
      sym_STag,
    STATE(39), 1,
      sym_ETag,
    STATE(42), 1,
      sym_EmptyElemTag,
    STATE(307), 1,
      sym_content,
    STATE(334), 1,
      sym_CDStart,
    ACTIONS(27), 2,
      sym_Comment,
      sym_CharData,
    STATE(40), 2,
      sym_EntityRef,
      sym_CharRef,
    STATE(4), 5,
      sym_element,
      sym_CDSect,
      sym__Reference,
      sym_PI,
      aux_sym_content_repeat1,
  [52] = 15,
    ACTIONS(13), 1,
      anon_sym_LT_QMARK,
    ACTIONS(15), 1,
      anon_sym_LT,
    ACTIONS(19), 1,
      anon_sym_LT_BANG_LBRACK,
    ACTIONS(21), 1,
      anon_sym_AMP,
    ACTIONS(23), 1,
      anon_sym_AMP_POUND,
    ACTIONS(25), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(29), 1,
      anon_sym_LT_SLASH,
    STATE(2), 1,
      sym_STag,
    STATE(42), 1,
      sym_EmptyElemTag,
    STATE(205), 1,
      sym_ETag,
    STATE(330), 1,
      sym_content,
    STATE(334), 1,
      sym_CDStart,
    ACTIONS(27), 2,
      sym_Comment,
      sym_CharData,
    STATE(40), 2,
      sym_EntityRef,
      sym_CharRef,
    STATE(4), 5,
      sym_element,
      sym_CDSect,
      sym__Reference,
      sym_PI,
      aux_sym_content_repeat1,
  [104] = 13,
    ACTIONS(13), 1,
      anon_sym_LT_QMARK,
    ACTIONS(15), 1,
      anon_sym_LT,
    ACTIONS(19), 1,
      anon_sym_LT_BANG_LBRACK,
    ACTIONS(21), 1,
      anon_sym_AMP,
    ACTIONS(23), 1,
      anon_sym_AMP_POUND,
    ACTIONS(25), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(31), 1,
      anon_sym_LT_SLASH,
    STATE(2), 1,
      sym_STag,
    STATE(42), 1,
      sym_EmptyElemTag,
    STATE(334), 1,
      sym_CDStart,
    ACTIONS(33), 2,
      sym_Comment,
      sym_CharData,
    STATE(40), 2,
      sym_EntityRef,
      sym_CharRef,
    STATE(5), 5,
      sym_element,
      sym_CDSect,
      sym__Reference,
      sym_PI,
      aux_sym_content_repeat1,
  [150] = 13,
    ACTIONS(35), 1,
      anon_sym_LT_QMARK,
    ACTIONS(38), 1,
      anon_sym_LT,
    ACTIONS(41), 1,
      anon_sym_LT_SLASH,
    ACTIONS(43), 1,
      anon_sym_LT_BANG_LBRACK,
    ACTIONS(46), 1,
      anon_sym_AMP,
    ACTIONS(49), 1,
      anon_sym_AMP_POUND,
    ACTIONS(52), 1,
      anon_sym_AMP_POUNDx,
    STATE(2), 1,
      sym_STag,
    STATE(42), 1,
      sym_EmptyElemTag,
    STATE(334), 1,
      sym_CDStart,
    ACTIONS(55), 2,
      sym_Comment,
      sym_CharData,
    STATE(40), 2,
      sym_EntityRef,
      sym_CharRef,
    STATE(5), 5,
      sym_element,
      sym_CDSect,
      sym__Reference,
      sym_PI,
      aux_sym_content_repeat1,
  [196] = 11,
    ACTIONS(3), 1,
      anon_sym_LT_QMARK,
    ACTIONS(5), 1,
      anon_sym_LT_BANG,
    ACTIONS(7), 1,
      anon_sym_LT,
    STATE(3), 1,
      sym_STag,
    STATE(20), 1,
      sym_XMLDecl,
    STATE(60), 1,
      sym_doctypedecl,
    STATE(72), 1,
      sym_element,
    STATE(188), 1,
      sym_prolog,
    STATE(200), 1,
      sym_EmptyElemTag,
    ACTIONS(11), 2,
      sym_Comment,
      sym__S,
    STATE(32), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [235] = 9,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(62), 1,
      anon_sym_RBRACK,
    ACTIONS(64), 1,
      sym__S,
    ACTIONS(66), 1,
      sym_Comment,
    STATE(10), 1,
      aux_sym__intSubset,
    STATE(176), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [268] = 9,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(64), 1,
      sym__S,
    ACTIONS(66), 1,
      sym_Comment,
    ACTIONS(68), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      aux_sym__intSubset,
    STATE(176), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [301] = 9,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(66), 1,
      sym_Comment,
    ACTIONS(68), 1,
      anon_sym_RBRACK,
    ACTIONS(70), 1,
      sym__S,
    STATE(11), 1,
      aux_sym__intSubset,
    STATE(176), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [334] = 9,
    ACTIONS(72), 1,
      anon_sym_LT_QMARK,
    ACTIONS(75), 1,
      anon_sym_LT_BANG,
    ACTIONS(78), 1,
      anon_sym_RBRACK,
    ACTIONS(80), 1,
      sym__S,
    ACTIONS(83), 1,
      sym_Comment,
    STATE(10), 1,
      aux_sym__intSubset,
    STATE(176), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [367] = 9,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(64), 1,
      sym__S,
    ACTIONS(66), 1,
      sym_Comment,
    ACTIONS(86), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      aux_sym__intSubset,
    STATE(176), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [400] = 9,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(66), 1,
      sym_Comment,
    ACTIONS(86), 1,
      anon_sym_RBRACK,
    ACTIONS(88), 1,
      sym__S,
    STATE(14), 1,
      aux_sym__intSubset,
    STATE(176), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [433] = 9,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(66), 1,
      sym_Comment,
    ACTIONS(90), 1,
      anon_sym_RBRACK,
    ACTIONS(92), 1,
      sym__S,
    STATE(8), 1,
      aux_sym__intSubset,
    STATE(176), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [466] = 9,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(64), 1,
      sym__S,
    ACTIONS(66), 1,
      sym_Comment,
    ACTIONS(94), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      aux_sym__intSubset,
    STATE(176), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [499] = 9,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(66), 1,
      sym_Comment,
    ACTIONS(94), 1,
      anon_sym_RBRACK,
    ACTIONS(96), 1,
      sym__S,
    STATE(7), 1,
      aux_sym__intSubset,
    STATE(176), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [532] = 7,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(66), 1,
      sym_Comment,
    ACTIONS(68), 1,
      anon_sym_RBRACK,
    STATE(167), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [559] = 7,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(66), 1,
      sym_Comment,
    ACTIONS(86), 1,
      anon_sym_RBRACK,
    STATE(167), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [586] = 7,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(66), 1,
      sym_Comment,
    ACTIONS(94), 1,
      anon_sym_RBRACK,
    STATE(167), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [613] = 7,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(62), 1,
      anon_sym_RBRACK,
    ACTIONS(66), 1,
      sym_Comment,
    STATE(167), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [640] = 6,
    ACTIONS(5), 1,
      anon_sym_LT_BANG,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(100), 1,
      anon_sym_LT,
    STATE(74), 1,
      sym_doctypedecl,
    ACTIONS(102), 2,
      sym_Comment,
      sym__S,
    STATE(23), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [664] = 8,
    ACTIONS(104), 1,
      anon_sym_SQUOTE,
    ACTIONS(106), 1,
      anon_sym_PERCENT,
    ACTIONS(108), 1,
      aux_sym_EntityValue_token2,
    ACTIONS(110), 1,
      anon_sym_AMP,
    ACTIONS(112), 1,
      anon_sym_AMP_POUND,
    ACTIONS(114), 1,
      anon_sym_AMP_POUNDx,
    STATE(102), 2,
      sym_EntityRef,
      sym_CharRef,
    STATE(26), 3,
      sym_PEReference,
      sym__Reference,
      aux_sym_EntityValue_repeat2,
  [692] = 8,
    ACTIONS(104), 1,
      anon_sym_DQUOTE,
    ACTIONS(116), 1,
      anon_sym_PERCENT,
    ACTIONS(118), 1,
      aux_sym_EntityValue_token1,
    ACTIONS(120), 1,
      anon_sym_AMP,
    ACTIONS(122), 1,
      anon_sym_AMP_POUND,
    ACTIONS(124), 1,
      anon_sym_AMP_POUNDx,
    STATE(101), 2,
      sym_EntityRef,
      sym_CharRef,
    STATE(27), 3,
      sym_PEReference,
      sym__Reference,
      aux_sym_EntityValue_repeat1,
  [720] = 6,
    ACTIONS(5), 1,
      anon_sym_LT_BANG,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(126), 1,
      anon_sym_LT,
    STATE(59), 1,
      sym_doctypedecl,
    ACTIONS(128), 2,
      sym_Comment,
      sym__S,
    STATE(33), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [744] = 5,
    STATE(96), 1,
      aux_sym_Mixed_repeat1,
    STATE(166), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
    ACTIONS(132), 3,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
    ACTIONS(130), 5,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [766] = 8,
    ACTIONS(134), 1,
      anon_sym_CDATA,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_TokenizedType,
    ACTIONS(140), 1,
      anon_sym_NOTATION,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    STATE(297), 1,
      sym__AttType,
    STATE(298), 2,
      sym_NotationType,
      sym_Enumeration,
    STATE(295), 3,
      sym_StringType,
      sym__EnumeratedType,
      sym_PEReference,
  [794] = 8,
    ACTIONS(106), 1,
      anon_sym_PERCENT,
    ACTIONS(110), 1,
      anon_sym_AMP,
    ACTIONS(112), 1,
      anon_sym_AMP_POUND,
    ACTIONS(114), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(144), 1,
      anon_sym_SQUOTE,
    ACTIONS(146), 1,
      aux_sym_EntityValue_token2,
    STATE(102), 2,
      sym_EntityRef,
      sym_CharRef,
    STATE(29), 3,
      sym_PEReference,
      sym__Reference,
      aux_sym_EntityValue_repeat2,
  [822] = 8,
    ACTIONS(116), 1,
      anon_sym_PERCENT,
    ACTIONS(120), 1,
      anon_sym_AMP,
    ACTIONS(122), 1,
      anon_sym_AMP_POUND,
    ACTIONS(124), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(144), 1,
      anon_sym_DQUOTE,
    ACTIONS(148), 1,
      aux_sym_EntityValue_token1,
    STATE(101), 2,
      sym_EntityRef,
      sym_CharRef,
    STATE(31), 3,
      sym_PEReference,
      sym__Reference,
      aux_sym_EntityValue_repeat1,
  [850] = 5,
    STATE(95), 1,
      aux_sym_Mixed_repeat1,
    STATE(185), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
    ACTIONS(132), 3,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
    ACTIONS(130), 5,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [872] = 8,
    ACTIONS(150), 1,
      anon_sym_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_PERCENT,
    ACTIONS(155), 1,
      aux_sym_EntityValue_token2,
    ACTIONS(158), 1,
      anon_sym_AMP,
    ACTIONS(161), 1,
      anon_sym_AMP_POUND,
    ACTIONS(164), 1,
      anon_sym_AMP_POUNDx,
    STATE(102), 2,
      sym_EntityRef,
      sym_CharRef,
    STATE(29), 3,
      sym_PEReference,
      sym__Reference,
      aux_sym_EntityValue_repeat2,
  [900] = 6,
    ACTIONS(58), 1,
      anon_sym_LT_QMARK,
    ACTIONS(60), 1,
      anon_sym_LT_BANG,
    ACTIONS(66), 1,
      sym_Comment,
    STATE(167), 1,
      sym__markupdecl,
    STATE(296), 2,
      sym_GEDecl,
      sym_PEDecl,
    STATE(290), 5,
      sym_elementdecl,
      sym_AttlistDecl,
      sym__EntityDecl,
      sym_NotationDecl,
      sym_PI,
  [924] = 8,
    ACTIONS(167), 1,
      anon_sym_DQUOTE,
    ACTIONS(169), 1,
      anon_sym_PERCENT,
    ACTIONS(172), 1,
      aux_sym_EntityValue_token1,
    ACTIONS(175), 1,
      anon_sym_AMP,
    ACTIONS(178), 1,
      anon_sym_AMP_POUND,
    ACTIONS(181), 1,
      anon_sym_AMP_POUNDx,
    STATE(101), 2,
      sym_EntityRef,
      sym_CharRef,
    STATE(31), 3,
      sym_PEReference,
      sym__Reference,
      aux_sym_EntityValue_repeat1,
  [952] = 6,
    ACTIONS(5), 1,
      anon_sym_LT_BANG,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(100), 1,
      anon_sym_LT,
    STATE(74), 1,
      sym_doctypedecl,
    ACTIONS(128), 2,
      sym_Comment,
      sym__S,
    STATE(33), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [976] = 5,
    ACTIONS(186), 1,
      anon_sym_LT_QMARK,
    ACTIONS(189), 1,
      anon_sym_LT,
    ACTIONS(184), 2,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
    ACTIONS(191), 2,
      sym_Comment,
      sym__S,
    STATE(33), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [998] = 1,
    ACTIONS(194), 10,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
      sym_Name,
  [1011] = 1,
    ACTIONS(196), 9,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [1023] = 2,
    ACTIONS(200), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(198), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1037] = 2,
    ACTIONS(204), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(202), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1051] = 2,
    ACTIONS(208), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(206), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1065] = 2,
    ACTIONS(212), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(210), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1079] = 2,
    ACTIONS(216), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(214), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1093] = 7,
    ACTIONS(218), 1,
      anon_sym_SQUOTE,
    ACTIONS(220), 1,
      aux_sym_PseudoAttValue_token2,
    ACTIONS(222), 1,
      anon_sym_AMP,
    ACTIONS(224), 1,
      anon_sym_AMP_POUND,
    ACTIONS(226), 1,
      anon_sym_AMP_POUNDx,
    STATE(69), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat2,
    STATE(151), 2,
      sym_EntityRef,
      sym_CharRef,
  [1117] = 2,
    ACTIONS(230), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(228), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1131] = 7,
    ACTIONS(232), 1,
      anon_sym_DQUOTE,
    ACTIONS(234), 1,
      aux_sym_PseudoAttValue_token1,
    ACTIONS(236), 1,
      anon_sym_AMP,
    ACTIONS(238), 1,
      anon_sym_AMP_POUND,
    ACTIONS(240), 1,
      anon_sym_AMP_POUNDx,
    STATE(55), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat1,
    STATE(146), 2,
      sym_EntityRef,
      sym_CharRef,
  [1155] = 7,
    ACTIONS(222), 1,
      anon_sym_AMP,
    ACTIONS(224), 1,
      anon_sym_AMP_POUND,
    ACTIONS(226), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(232), 1,
      anon_sym_SQUOTE,
    ACTIONS(242), 1,
      aux_sym_PseudoAttValue_token2,
    STATE(51), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat2,
    STATE(151), 2,
      sym_EntityRef,
      sym_CharRef,
  [1179] = 7,
    ACTIONS(236), 1,
      anon_sym_AMP,
    ACTIONS(238), 1,
      anon_sym_AMP_POUND,
    ACTIONS(240), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(244), 1,
      anon_sym_DQUOTE,
    ACTIONS(246), 1,
      aux_sym_PseudoAttValue_token1,
    STATE(65), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat1,
    STATE(146), 2,
      sym_EntityRef,
      sym_CharRef,
  [1203] = 7,
    ACTIONS(222), 1,
      anon_sym_AMP,
    ACTIONS(224), 1,
      anon_sym_AMP_POUND,
    ACTIONS(226), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(244), 1,
      anon_sym_SQUOTE,
    ACTIONS(248), 1,
      aux_sym_PseudoAttValue_token2,
    STATE(41), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat2,
    STATE(151), 2,
      sym_EntityRef,
      sym_CharRef,
  [1227] = 1,
    ACTIONS(250), 9,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [1239] = 7,
    ACTIONS(222), 1,
      anon_sym_AMP,
    ACTIONS(224), 1,
      anon_sym_AMP_POUND,
    ACTIONS(226), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(252), 1,
      anon_sym_SQUOTE,
    ACTIONS(254), 1,
      aux_sym_PseudoAttValue_token2,
    STATE(63), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat2,
    STATE(151), 2,
      sym_EntityRef,
      sym_CharRef,
  [1263] = 7,
    ACTIONS(236), 1,
      anon_sym_AMP,
    ACTIONS(238), 1,
      anon_sym_AMP_POUND,
    ACTIONS(240), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(252), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      aux_sym_PseudoAttValue_token1,
    STATE(67), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat1,
    STATE(146), 2,
      sym_EntityRef,
      sym_CharRef,
  [1287] = 1,
    ACTIONS(258), 9,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [1299] = 7,
    ACTIONS(220), 1,
      aux_sym_PseudoAttValue_token2,
    ACTIONS(222), 1,
      anon_sym_AMP,
    ACTIONS(224), 1,
      anon_sym_AMP_POUND,
    ACTIONS(226), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(260), 1,
      anon_sym_SQUOTE,
    STATE(69), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat2,
    STATE(151), 2,
      sym_EntityRef,
      sym_CharRef,
  [1323] = 2,
    ACTIONS(264), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(262), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1337] = 1,
    ACTIONS(266), 9,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [1349] = 7,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(268), 1,
      anon_sym_SQUOTE,
    ACTIONS(270), 1,
      anon_sym_DQUOTE,
    ACTIONS(274), 1,
      anon_sym_POUNDFIXED,
    STATE(367), 1,
      sym_DefaultDecl,
    ACTIONS(272), 2,
      anon_sym_POUNDREQUIRED,
      anon_sym_POUNDIMPLIED,
    STATE(365), 2,
      sym_PEReference,
      sym_AttValue,
  [1373] = 7,
    ACTIONS(236), 1,
      anon_sym_AMP,
    ACTIONS(238), 1,
      anon_sym_AMP_POUND,
    ACTIONS(240), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(260), 1,
      anon_sym_DQUOTE,
    ACTIONS(276), 1,
      aux_sym_PseudoAttValue_token1,
    STATE(71), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat1,
    STATE(146), 2,
      sym_EntityRef,
      sym_CharRef,
  [1397] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(278), 1,
      ts_builtin_sym_end,
    ACTIONS(280), 2,
      sym_Comment,
      sym__S,
    STATE(85), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1415] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(282), 1,
      ts_builtin_sym_end,
    ACTIONS(128), 2,
      sym_Comment,
      sym__S,
    STATE(33), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1433] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(284), 1,
      anon_sym_LT,
    ACTIONS(128), 2,
      sym_Comment,
      sym__S,
    STATE(33), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1451] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(284), 1,
      anon_sym_LT,
    ACTIONS(286), 2,
      sym_Comment,
      sym__S,
    STATE(84), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1469] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(100), 1,
      anon_sym_LT,
    ACTIONS(288), 2,
      sym_Comment,
      sym__S,
    STATE(83), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1487] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(290), 1,
      ts_builtin_sym_end,
    ACTIONS(292), 2,
      sym_Comment,
      sym__S,
    STATE(82), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1505] = 2,
    ACTIONS(296), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(294), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1519] = 7,
    ACTIONS(220), 1,
      aux_sym_PseudoAttValue_token2,
    ACTIONS(222), 1,
      anon_sym_AMP,
    ACTIONS(224), 1,
      anon_sym_AMP_POUND,
    ACTIONS(226), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(298), 1,
      anon_sym_SQUOTE,
    STATE(69), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat2,
    STATE(151), 2,
      sym_EntityRef,
      sym_CharRef,
  [1543] = 2,
    ACTIONS(302), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(300), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1557] = 7,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(236), 1,
      anon_sym_AMP,
    ACTIONS(238), 1,
      anon_sym_AMP_POUND,
    ACTIONS(240), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(276), 1,
      aux_sym_PseudoAttValue_token1,
    STATE(71), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat1,
    STATE(146), 2,
      sym_EntityRef,
      sym_CharRef,
  [1581] = 2,
    ACTIONS(306), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(304), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1595] = 7,
    ACTIONS(236), 1,
      anon_sym_AMP,
    ACTIONS(238), 1,
      anon_sym_AMP_POUND,
    ACTIONS(240), 1,
      anon_sym_AMP_POUNDx,
    ACTIONS(276), 1,
      aux_sym_PseudoAttValue_token1,
    ACTIONS(298), 1,
      anon_sym_DQUOTE,
    STATE(71), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat1,
    STATE(146), 2,
      sym_EntityRef,
      sym_CharRef,
  [1619] = 1,
    ACTIONS(308), 9,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [1631] = 7,
    ACTIONS(310), 1,
      anon_sym_SQUOTE,
    ACTIONS(312), 1,
      aux_sym_PseudoAttValue_token2,
    ACTIONS(315), 1,
      anon_sym_AMP,
    ACTIONS(318), 1,
      anon_sym_AMP_POUND,
    ACTIONS(321), 1,
      anon_sym_AMP_POUNDx,
    STATE(69), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat2,
    STATE(151), 2,
      sym_EntityRef,
      sym_CharRef,
  [1655] = 2,
    ACTIONS(326), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(324), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1669] = 7,
    ACTIONS(328), 1,
      anon_sym_DQUOTE,
    ACTIONS(330), 1,
      aux_sym_PseudoAttValue_token1,
    ACTIONS(333), 1,
      anon_sym_AMP,
    ACTIONS(336), 1,
      anon_sym_AMP_POUND,
    ACTIONS(339), 1,
      anon_sym_AMP_POUNDx,
    STATE(71), 2,
      sym__Reference,
      aux_sym_PseudoAttValue_repeat1,
    STATE(146), 2,
      sym_EntityRef,
      sym_CharRef,
  [1693] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(342), 1,
      ts_builtin_sym_end,
    ACTIONS(344), 2,
      sym_Comment,
      sym__S,
    STATE(57), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1711] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    STATE(135), 1,
      sym__choice,
    STATE(323), 1,
      sym_contentspec,
    ACTIONS(346), 2,
      anon_sym_EMPTY,
      anon_sym_ANY,
    STATE(326), 3,
      sym_Mixed,
      sym_children,
      sym_PEReference,
  [1733] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(126), 1,
      anon_sym_LT,
    ACTIONS(350), 2,
      sym_Comment,
      sym__S,
    STATE(58), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1751] = 2,
    ACTIONS(354), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(352), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1765] = 2,
    ACTIONS(358), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(356), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1779] = 2,
    ACTIONS(362), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(360), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1793] = 2,
    ACTIONS(366), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(364), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1807] = 2,
    ACTIONS(370), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(368), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1821] = 2,
    ACTIONS(374), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(372), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1835] = 2,
    ACTIONS(378), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(376), 6,
      sym_Comment,
      sym_CharData,
      anon_sym_LT_QMARK,
      anon_sym_LT_SLASH,
      anon_sym_LT_BANG_LBRACK,
      anon_sym_AMP_POUNDx,
  [1849] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(380), 1,
      ts_builtin_sym_end,
    ACTIONS(128), 2,
      sym_Comment,
      sym__S,
    STATE(33), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1867] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(126), 1,
      anon_sym_LT,
    ACTIONS(128), 2,
      sym_Comment,
      sym__S,
    STATE(33), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1885] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(382), 1,
      anon_sym_LT,
    ACTIONS(128), 2,
      sym_Comment,
      sym__S,
    STATE(33), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1903] = 4,
    ACTIONS(98), 1,
      anon_sym_LT_QMARK,
    ACTIONS(384), 1,
      ts_builtin_sym_end,
    ACTIONS(128), 2,
      sym_Comment,
      sym__S,
    STATE(33), 5,
      sym__Misc,
      sym_StyleSheetPI,
      sym_XmlModelPI,
      sym_PI,
      aux_sym_document_repeat1,
  [1921] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_RPAREN,
    ACTIONS(390), 1,
      sym__S,
    STATE(89), 1,
      aux_sym__choice_repeat1,
    ACTIONS(386), 2,
      anon_sym_PIPE,
      anon_sym_COMMA,
    STATE(138), 2,
      sym_PEReference,
      aux_sym__choice_repeat2,
  [1942] = 2,
    ACTIONS(132), 3,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
    ACTIONS(130), 5,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [1955] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(392), 1,
      anon_sym_RPAREN,
    ACTIONS(394), 1,
      sym__S,
    STATE(90), 1,
      aux_sym__choice_repeat1,
    ACTIONS(386), 2,
      anon_sym_PIPE,
      anon_sym_COMMA,
    STATE(132), 2,
      sym_PEReference,
      aux_sym__choice_repeat2,
  [1976] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(396), 1,
      anon_sym_RPAREN,
    ACTIONS(398), 1,
      sym__S,
    STATE(118), 1,
      aux_sym__choice_repeat1,
    ACTIONS(386), 2,
      anon_sym_PIPE,
      anon_sym_COMMA,
    STATE(158), 2,
      sym_PEReference,
      aux_sym__choice_repeat2,
  [1997] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_RPAREN,
    ACTIONS(390), 1,
      sym__S,
    STATE(118), 1,
      aux_sym__choice_repeat1,
    ACTIONS(386), 2,
      anon_sym_PIPE,
      anon_sym_COMMA,
    STATE(138), 2,
      sym_PEReference,
      aux_sym__choice_repeat2,
  [2018] = 8,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(400), 1,
      sym_Name,
    ACTIONS(402), 1,
      anon_sym_LPAREN,
    ACTIONS(404), 1,
      anon_sym_POUNDPCDATA,
    ACTIONS(406), 1,
      sym__S,
    STATE(24), 1,
      sym_PEReference,
    STATE(87), 1,
      sym__choice,
    STATE(88), 1,
      sym__cp,
  [2043] = 7,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(408), 1,
      anon_sym_PIPE,
    ACTIONS(410), 1,
      anon_sym_RPAREN,
    ACTIONS(412), 1,
      sym__S,
    STATE(96), 1,
      aux_sym_Mixed_repeat1,
    STATE(166), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [2065] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(400), 1,
      sym_Name,
    ACTIONS(402), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      sym__S,
    STATE(88), 1,
      sym__cp,
    STATE(87), 2,
      sym__choice,
      sym_PEReference,
  [2085] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(400), 1,
      sym_Name,
    ACTIONS(402), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      sym__S,
    STATE(154), 1,
      sym__cp,
    STATE(87), 2,
      sym__choice,
      sym_PEReference,
  [2105] = 7,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(408), 1,
      anon_sym_PIPE,
    ACTIONS(418), 1,
      anon_sym_RPAREN,
    ACTIONS(420), 1,
      sym__S,
    STATE(134), 1,
      aux_sym_Mixed_repeat1,
    STATE(207), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [2127] = 7,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(408), 1,
      anon_sym_PIPE,
    ACTIONS(422), 1,
      anon_sym_RPAREN,
    ACTIONS(424), 1,
      sym__S,
    STATE(134), 1,
      aux_sym_Mixed_repeat1,
    STATE(195), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [2149] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(400), 1,
      sym_Name,
    ACTIONS(402), 1,
      anon_sym_LPAREN,
    ACTIONS(426), 1,
      sym__S,
    STATE(139), 1,
      sym__cp,
    STATE(87), 2,
      sym__choice,
      sym_PEReference,
  [2169] = 7,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(400), 1,
      sym_Name,
    ACTIONS(402), 1,
      anon_sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDPCDATA,
    STATE(28), 1,
      sym_PEReference,
    STATE(86), 1,
      sym__cp,
    STATE(87), 1,
      sym__choice,
  [2191] = 7,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(408), 1,
      anon_sym_PIPE,
    ACTIONS(430), 1,
      anon_sym_RPAREN,
    ACTIONS(432), 1,
      sym__S,
    STATE(95), 1,
      aux_sym_Mixed_repeat1,
    STATE(185), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [2213] = 6,
    ACTIONS(434), 1,
      anon_sym_SQUOTE,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    ACTIONS(438), 1,
      anon_sym_SYSTEM,
    ACTIONS(440), 1,
      anon_sym_PUBLIC,
    STATE(248), 1,
      sym_ExternalID,
    STATE(310), 1,
      sym_EntityValue,
  [2232] = 2,
    ACTIONS(216), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(214), 4,
      anon_sym_DQUOTE,
      anon_sym_PERCENT,
      aux_sym_EntityValue_token1,
      anon_sym_AMP_POUNDx,
  [2243] = 2,
    ACTIONS(216), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(214), 4,
      anon_sym_SQUOTE,
      anon_sym_PERCENT,
      aux_sym_EntityValue_token2,
      anon_sym_AMP_POUNDx,
  [2254] = 2,
    ACTIONS(370), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(368), 4,
      anon_sym_SQUOTE,
      anon_sym_PERCENT,
      aux_sym_EntityValue_token2,
      anon_sym_AMP_POUNDx,
  [2265] = 2,
    ACTIONS(362), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(360), 4,
      anon_sym_SQUOTE,
      anon_sym_PERCENT,
      aux_sym_EntityValue_token2,
      anon_sym_AMP_POUNDx,
  [2276] = 2,
    ACTIONS(444), 1,
      anon_sym_LT,
    ACTIONS(442), 5,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2287] = 5,
    ACTIONS(434), 1,
      anon_sym_SQUOTE,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    ACTIONS(438), 1,
      anon_sym_SYSTEM,
    ACTIONS(440), 1,
      anon_sym_PUBLIC,
    STATE(302), 2,
      sym_EntityValue,
      sym_ExternalID,
  [2304] = 2,
    ACTIONS(448), 1,
      anon_sym_LT,
    ACTIONS(446), 5,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2315] = 2,
    ACTIONS(452), 1,
      anon_sym_LT,
    ACTIONS(450), 5,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2326] = 5,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(438), 1,
      anon_sym_SYSTEM,
    ACTIONS(454), 1,
      anon_sym_PUBLIC,
    STATE(438), 1,
      sym_PEReference,
    STATE(314), 2,
      sym_ExternalID,
      sym_PublicID,
  [2343] = 2,
    ACTIONS(456), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(194), 4,
      anon_sym_DQUOTE,
      anon_sym_PERCENT,
      aux_sym_EntityValue_token1,
      anon_sym_AMP_POUNDx,
  [2354] = 2,
    ACTIONS(358), 1,
      anon_sym_LT,
    ACTIONS(356), 5,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2365] = 5,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(400), 1,
      sym_Name,
    ACTIONS(402), 1,
      anon_sym_LPAREN,
    STATE(86), 1,
      sym__cp,
    STATE(87), 2,
      sym__choice,
      sym_PEReference,
  [2382] = 2,
    ACTIONS(456), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(194), 4,
      anon_sym_SQUOTE,
      anon_sym_PERCENT,
      aux_sym_EntityValue_token2,
      anon_sym_AMP_POUNDx,
  [2393] = 2,
    ACTIONS(370), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(368), 4,
      anon_sym_DQUOTE,
      anon_sym_PERCENT,
      aux_sym_EntityValue_token1,
      anon_sym_AMP_POUNDx,
  [2404] = 2,
    ACTIONS(362), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(360), 4,
      anon_sym_DQUOTE,
      anon_sym_PERCENT,
      aux_sym_EntityValue_token1,
      anon_sym_AMP_POUNDx,
  [2415] = 5,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(400), 1,
      sym_Name,
    ACTIONS(402), 1,
      anon_sym_LPAREN,
    STATE(154), 1,
      sym__cp,
    STATE(87), 2,
      sym__choice,
      sym_PEReference,
  [2432] = 2,
    ACTIONS(460), 1,
      anon_sym_LT,
    ACTIONS(458), 5,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2443] = 4,
    ACTIONS(467), 1,
      sym__S,
    STATE(118), 1,
      aux_sym__choice_repeat1,
    ACTIONS(462), 2,
      anon_sym_PIPE,
      anon_sym_COMMA,
    ACTIONS(465), 2,
      anon_sym_RPAREN,
      anon_sym_PERCENT,
  [2458] = 5,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(400), 1,
      sym_Name,
    ACTIONS(402), 1,
      anon_sym_LPAREN,
    STATE(155), 1,
      sym__cp,
    STATE(87), 2,
      sym__choice,
      sym_PEReference,
  [2475] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(470), 1,
      sym_Name,
    ACTIONS(472), 1,
      anon_sym_PIPE,
    ACTIONS(474), 1,
      sym__S,
    STATE(124), 1,
      aux_sym_NotationType_repeat1,
    STATE(349), 1,
      sym_PEReference,
  [2494] = 2,
    ACTIONS(478), 1,
      anon_sym_LT,
    ACTIONS(476), 5,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2505] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(472), 1,
      anon_sym_PIPE,
    ACTIONS(474), 1,
      sym__S,
    ACTIONS(480), 1,
      sym_Name,
    STATE(125), 1,
      aux_sym_NotationType_repeat1,
    STATE(343), 1,
      sym_PEReference,
  [2524] = 2,
    ACTIONS(484), 1,
      anon_sym_LT,
    ACTIONS(482), 5,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2535] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(472), 1,
      anon_sym_PIPE,
    ACTIONS(474), 1,
      sym__S,
    ACTIONS(480), 1,
      sym_Name,
    STATE(153), 1,
      aux_sym_NotationType_repeat1,
    STATE(343), 1,
      sym_PEReference,
  [2554] = 6,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(472), 1,
      anon_sym_PIPE,
    ACTIONS(474), 1,
      sym__S,
    ACTIONS(486), 1,
      sym_Name,
    STATE(153), 1,
      aux_sym_NotationType_repeat1,
    STATE(339), 1,
      sym_PEReference,
  [2573] = 2,
    ACTIONS(208), 1,
      anon_sym_LT,
    ACTIONS(206), 5,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2584] = 2,
    ACTIONS(490), 1,
      anon_sym_LT,
    ACTIONS(488), 4,
      sym_Comment,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2594] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_RPAREN,
    STATE(228), 1,
      sym_PEReference,
    ACTIONS(492), 2,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [2608] = 1,
    ACTIONS(494), 5,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [2616] = 5,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(430), 1,
      anon_sym_RPAREN,
    ACTIONS(496), 1,
      anon_sym_PIPE,
    STATE(185), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [2632] = 2,
    ACTIONS(500), 1,
      anon_sym_LT,
    ACTIONS(498), 4,
      sym_Comment,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2642] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_RPAREN,
    ACTIONS(502), 1,
      sym__S,
    STATE(141), 2,
      sym_PEReference,
      aux_sym__choice_repeat2,
  [2656] = 5,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(418), 1,
      anon_sym_RPAREN,
    ACTIONS(496), 1,
      anon_sym_PIPE,
    STATE(207), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [2672] = 4,
    ACTIONS(504), 1,
      anon_sym_PIPE,
    ACTIONS(509), 1,
      sym__S,
    STATE(134), 1,
      aux_sym_Mixed_repeat1,
    ACTIONS(507), 2,
      anon_sym_RPAREN,
      anon_sym_PERCENT,
  [2686] = 2,
    ACTIONS(512), 2,
      anon_sym_GT,
      sym__S,
    ACTIONS(514), 3,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
  [2696] = 5,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(496), 1,
      anon_sym_PIPE,
    ACTIONS(516), 1,
      anon_sym_RPAREN,
    STATE(206), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [2712] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(396), 1,
      anon_sym_RPAREN,
    STATE(228), 1,
      sym_PEReference,
    ACTIONS(492), 2,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [2726] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(396), 1,
      anon_sym_RPAREN,
    ACTIONS(518), 1,
      sym__S,
    STATE(141), 2,
      sym_PEReference,
      aux_sym__choice_repeat2,
  [2740] = 1,
    ACTIONS(465), 5,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [2748] = 2,
    ACTIONS(522), 1,
      anon_sym_LT,
    ACTIONS(520), 4,
      sym_Comment,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2758] = 4,
    ACTIONS(524), 1,
      anon_sym_RPAREN,
    ACTIONS(526), 1,
      anon_sym_PERCENT,
    ACTIONS(529), 1,
      sym__S,
    STATE(141), 2,
      sym_PEReference,
      aux_sym__choice_repeat2,
  [2772] = 1,
    ACTIONS(194), 5,
      sym_Comment,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      anon_sym_RBRACK,
      sym__S,
  [2780] = 5,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(496), 1,
      anon_sym_PIPE,
    ACTIONS(532), 1,
      anon_sym_RPAREN,
    STATE(191), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [2796] = 2,
    ACTIONS(362), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(360), 3,
      anon_sym_DQUOTE,
      aux_sym_PseudoAttValue_token1,
      anon_sym_AMP_POUNDx,
  [2806] = 2,
    ACTIONS(370), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(368), 3,
      anon_sym_DQUOTE,
      aux_sym_PseudoAttValue_token1,
      anon_sym_AMP_POUNDx,
  [2816] = 2,
    ACTIONS(216), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(214), 3,
      anon_sym_DQUOTE,
      aux_sym_PseudoAttValue_token1,
      anon_sym_AMP_POUNDx,
  [2826] = 2,
    ACTIONS(362), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(360), 3,
      anon_sym_SQUOTE,
      aux_sym_PseudoAttValue_token2,
      anon_sym_AMP_POUNDx,
  [2836] = 2,
    ACTIONS(370), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(368), 3,
      anon_sym_SQUOTE,
      aux_sym_PseudoAttValue_token2,
      anon_sym_AMP_POUNDx,
  [2846] = 2,
    ACTIONS(536), 1,
      anon_sym_LT,
    ACTIONS(534), 4,
      sym_Comment,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      sym__S,
  [2856] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(538), 1,
      anon_sym_RPAREN,
    STATE(228), 1,
      sym_PEReference,
    ACTIONS(492), 2,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [2870] = 2,
    ACTIONS(216), 2,
      anon_sym_AMP,
      anon_sym_AMP_POUND,
    ACTIONS(214), 3,
      anon_sym_SQUOTE,
      aux_sym_PseudoAttValue_token2,
      anon_sym_AMP_POUNDx,
  [2880] = 1,
    ACTIONS(540), 5,
      sym_Comment,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      anon_sym_RBRACK,
      sym__S,
  [2888] = 4,
    ACTIONS(544), 1,
      anon_sym_PIPE,
    ACTIONS(547), 1,
      sym__S,
    STATE(153), 1,
      aux_sym_NotationType_repeat1,
    ACTIONS(542), 2,
      anon_sym_PERCENT,
      sym_Name,
  [2902] = 1,
    ACTIONS(550), 5,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [2910] = 1,
    ACTIONS(552), 5,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_PERCENT,
      sym__S,
  [2918] = 5,
    ACTIONS(438), 1,
      anon_sym_SYSTEM,
    ACTIONS(440), 1,
      anon_sym_PUBLIC,
    ACTIONS(554), 1,
      anon_sym_LBRACK,
    ACTIONS(556), 1,
      anon_sym_GT,
    STATE(232), 1,
      sym_ExternalID,
  [2934] = 1,
    ACTIONS(78), 5,
      sym_Comment,
      anon_sym_LT_QMARK,
      anon_sym_LT_BANG,
      anon_sym_RBRACK,
      sym__S,
  [2942] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(538), 1,
      anon_sym_RPAREN,
    ACTIONS(558), 1,
      sym__S,
    STATE(141), 2,
      sym_PEReference,
      aux_sym__choice_repeat2,
  [2956] = 1,
    ACTIONS(198), 4,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      sym__S,
  [2963] = 1,
    ACTIONS(560), 4,
      anon_sym_PIPE,
      anon_sym_PERCENT,
      sym__S,
      sym_Name,
  [2970] = 2,
    ACTIONS(562), 1,
      sym__S,
    ACTIONS(542), 3,
      anon_sym_PIPE,
      anon_sym_PERCENT,
      sym_Name,
  [2979] = 1,
    ACTIONS(542), 4,
      anon_sym_PIPE,
      anon_sym_PERCENT,
      sym__S,
      sym_Name,
  [2986] = 4,
    ACTIONS(565), 1,
      anon_sym_QMARK_GT,
    ACTIONS(567), 1,
      sym__S,
    STATE(273), 1,
      sym__EncodingDecl,
    STATE(287), 1,
      sym__SDDecl,
  [2999] = 2,
    ACTIONS(571), 1,
      anon_sym_LT,
    ACTIONS(569), 3,
      sym_Comment,
      anon_sym_LT_QMARK,
      sym__S,
  [3008] = 4,
    ACTIONS(573), 1,
      sym_Name,
    ACTIONS(575), 1,
      anon_sym_GT,
    ACTIONS(577), 1,
      anon_sym_SLASH_GT,
    STATE(256), 1,
      sym_Attribute,
  [3021] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(430), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [3034] = 3,
    ACTIONS(579), 1,
      anon_sym_PERCENT,
    ACTIONS(581), 1,
      sym__S,
    STATE(152), 2,
      sym__DeclSep,
      sym_PEReference,
  [3045] = 2,
    ACTIONS(585), 1,
      sym__S,
    ACTIONS(583), 3,
      anon_sym_PIPE,
      anon_sym_PERCENT,
      sym_Name,
  [3054] = 4,
    ACTIONS(588), 1,
      anon_sym_GT,
    ACTIONS(590), 1,
      anon_sym_SLASH_GT,
    ACTIONS(592), 1,
      sym__S,
    STATE(174), 1,
      aux_sym_EmptyElemTag_repeat1,
  [3067] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(594), 1,
      sym_Name,
    ACTIONS(596), 1,
      sym__S,
    STATE(180), 1,
      sym_PEReference,
  [3080] = 2,
    ACTIONS(600), 1,
      anon_sym_LT,
    ACTIONS(598), 3,
      sym_Comment,
      anon_sym_LT_QMARK,
      sym__S,
  [3089] = 1,
    ACTIONS(304), 4,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      sym__S,
  [3096] = 4,
    ACTIONS(573), 1,
      sym_Name,
    ACTIONS(575), 1,
      anon_sym_GT,
    ACTIONS(602), 1,
      anon_sym_SLASH_GT,
    STATE(256), 1,
      sym_Attribute,
  [3109] = 3,
    ACTIONS(606), 1,
      sym__S,
    STATE(174), 1,
      aux_sym_EmptyElemTag_repeat1,
    ACTIONS(604), 2,
      anon_sym_GT,
      anon_sym_SLASH_GT,
  [3120] = 1,
    ACTIONS(324), 4,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      sym__S,
  [3127] = 3,
    ACTIONS(579), 1,
      anon_sym_PERCENT,
    ACTIONS(609), 1,
      sym__S,
    STATE(157), 2,
      sym__DeclSep,
      sym_PEReference,
  [3138] = 1,
    ACTIONS(364), 4,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      sym__S,
  [3145] = 4,
    ACTIONS(573), 1,
      sym_Name,
    ACTIONS(588), 1,
      anon_sym_GT,
    ACTIONS(590), 1,
      anon_sym_SLASH_GT,
    STATE(256), 1,
      sym_Attribute,
  [3158] = 2,
    ACTIONS(613), 1,
      anon_sym_LT,
    ACTIONS(611), 3,
      sym_Comment,
      anon_sym_LT_QMARK,
      sym__S,
  [3167] = 1,
    ACTIONS(507), 4,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_PERCENT,
      sym__S,
  [3174] = 4,
    ACTIONS(615), 1,
      anon_sym_PIPE,
    ACTIONS(618), 1,
      anon_sym_RPAREN,
    ACTIONS(620), 1,
      sym__S,
    STATE(181), 1,
      aux_sym_Enumeration_repeat1,
  [3187] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(623), 1,
      sym_Name,
    ACTIONS(625), 1,
      sym__S,
    STATE(212), 1,
      sym_PEReference,
  [3200] = 4,
    ACTIONS(627), 1,
      anon_sym_PIPE,
    ACTIONS(629), 1,
      anon_sym_RPAREN,
    ACTIONS(631), 1,
      sym__S,
    STATE(181), 1,
      aux_sym_Enumeration_repeat1,
  [3213] = 2,
    ACTIONS(635), 1,
      anon_sym_LT,
    ACTIONS(633), 3,
      sym_Comment,
      anon_sym_LT_QMARK,
      sym__S,
  [3222] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(516), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [3235] = 4,
    ACTIONS(637), 1,
      anon_sym_GT,
    ACTIONS(639), 1,
      anon_sym_SLASH_GT,
    ACTIONS(641), 1,
      sym__S,
    STATE(169), 1,
      aux_sym_EmptyElemTag_repeat1,
  [3248] = 3,
    ACTIONS(643), 1,
      anon_sym_GT,
    ACTIONS(645), 1,
      sym__S,
    STATE(187), 2,
      sym_AttDef,
      aux_sym_AttlistDecl_repeat1,
  [3259] = 4,
    ACTIONS(648), 1,
      anon_sym_LT,
    STATE(3), 1,
      sym_STag,
    STATE(56), 1,
      sym_element,
    STATE(200), 1,
      sym_EmptyElemTag,
  [3272] = 2,
    ACTIONS(652), 1,
      anon_sym_LT,
    ACTIONS(650), 3,
      sym_Comment,
      anon_sym_LT_QMARK,
      sym__S,
  [3281] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(654), 1,
      sym_Name,
    ACTIONS(656), 1,
      anon_sym_GT,
    STATE(319), 1,
      sym_PEReference,
  [3294] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(658), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [3307] = 2,
    ACTIONS(662), 1,
      anon_sym_LT,
    ACTIONS(660), 3,
      sym_Comment,
      anon_sym_LT_QMARK,
      sym__S,
  [3316] = 1,
    ACTIONS(664), 4,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_PERCENT,
      sym__S,
  [3323] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(666), 1,
      sym_Name,
    ACTIONS(668), 1,
      sym__S,
    STATE(120), 1,
      sym_PEReference,
  [3336] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(418), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [3349] = 4,
    ACTIONS(627), 1,
      anon_sym_PIPE,
    ACTIONS(670), 1,
      anon_sym_RPAREN,
    ACTIONS(672), 1,
      sym__S,
    STATE(181), 1,
      aux_sym_Enumeration_repeat1,
  [3362] = 4,
    ACTIONS(627), 1,
      anon_sym_PIPE,
    ACTIONS(670), 1,
      anon_sym_RPAREN,
    ACTIONS(672), 1,
      sym__S,
    STATE(183), 1,
      aux_sym_Enumeration_repeat1,
  [3375] = 1,
    ACTIONS(202), 4,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      sym__S,
  [3382] = 4,
    ACTIONS(674), 1,
      anon_sym_RPAREN,
    ACTIONS(676), 1,
      anon_sym_PERCENT,
    STATE(199), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [3395] = 1,
    ACTIONS(228), 4,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      sym__S,
  [3402] = 1,
    ACTIONS(376), 4,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      sym__S,
  [3409] = 4,
    ACTIONS(648), 1,
      anon_sym_LT,
    STATE(3), 1,
      sym_STag,
    STATE(72), 1,
      sym_element,
    STATE(200), 1,
      sym_EmptyElemTag,
  [3422] = 4,
    ACTIONS(573), 1,
      sym_Name,
    ACTIONS(588), 1,
      anon_sym_GT,
    ACTIONS(679), 1,
      anon_sym_SLASH_GT,
    STATE(256), 1,
      sym_Attribute,
  [3435] = 3,
    ACTIONS(681), 1,
      anon_sym_GT,
    ACTIONS(683), 1,
      sym__S,
    STATE(211), 2,
      sym_AttDef,
      aux_sym_AttlistDecl_repeat1,
  [3446] = 1,
    ACTIONS(210), 4,
      sym_Comment,
      ts_builtin_sym_end,
      anon_sym_LT_QMARK,
      sym__S,
  [3453] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(685), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [3466] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(532), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      aux_sym_Mixed_repeat2,
    STATE(269), 1,
      sym_PEReference,
  [3479] = 2,
    ACTIONS(689), 1,
      anon_sym_LT,
    ACTIONS(687), 3,
      sym_Comment,
      anon_sym_LT_QMARK,
      sym__S,
  [3488] = 4,
    ACTIONS(637), 1,
      anon_sym_GT,
    ACTIONS(691), 1,
      anon_sym_SLASH_GT,
    ACTIONS(693), 1,
      sym__S,
    STATE(217), 1,
      aux_sym_EmptyElemTag_repeat1,
  [3501] = 2,
    ACTIONS(697), 1,
      anon_sym_LT,
    ACTIONS(695), 3,
      sym_Comment,
      anon_sym_LT_QMARK,
      sym__S,
  [3510] = 3,
    ACTIONS(699), 1,
      anon_sym_GT,
    ACTIONS(701), 1,
      sym__S,
    STATE(187), 2,
      sym_AttDef,
      aux_sym_AttlistDecl_repeat1,
  [3521] = 1,
    ACTIONS(703), 4,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_PERCENT,
      sym__S,
  [3528] = 4,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(654), 1,
      sym_Name,
    ACTIONS(699), 1,
      anon_sym_GT,
    STATE(319), 1,
      sym_PEReference,
  [3541] = 4,
    ACTIONS(705), 1,
      anon_sym_xml,
    ACTIONS(707), 1,
      anon_sym_xml_DASHstylesheet,
    ACTIONS(709), 1,
      anon_sym_xml_DASHmodel,
    ACTIONS(711), 1,
      sym_PITarget,
  [3554] = 4,
    ACTIONS(713), 1,
      anon_sym_ELEMENT,
    ACTIONS(715), 1,
      anon_sym_ATTLIST,
    ACTIONS(717), 1,
      anon_sym_NOTATION,
    ACTIONS(719), 1,
      anon_sym_ENTITY,
  [3567] = 4,
    ACTIONS(627), 1,
      anon_sym_PIPE,
    ACTIONS(721), 1,
      anon_sym_RPAREN,
    ACTIONS(723), 1,
      sym__S,
    STATE(196), 1,
      aux_sym_Enumeration_repeat1,
  [3580] = 4,
    ACTIONS(588), 1,
      anon_sym_GT,
    ACTIONS(679), 1,
      anon_sym_SLASH_GT,
    ACTIONS(725), 1,
      sym__S,
    STATE(174), 1,
      aux_sym_EmptyElemTag_repeat1,
  [3593] = 3,
    ACTIONS(727), 1,
      sym_Name,
    ACTIONS(729), 1,
      anon_sym_PERCENT,
    STATE(399), 1,
      sym_PEReference,
  [3603] = 3,
    ACTIONS(731), 1,
      sym__S,
    ACTIONS(733), 1,
      anon_sym_EQ,
    STATE(313), 1,
      sym__Eq,
  [3613] = 1,
    ACTIONS(735), 3,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      sym__S,
  [3619] = 3,
    ACTIONS(737), 1,
      anon_sym_SQUOTE,
    ACTIONS(739), 1,
      anon_sym_DQUOTE,
    STATE(229), 1,
      sym_SystemLiteral,
  [3629] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(741), 1,
      sym_Name,
    STATE(369), 1,
      sym_PEReference,
  [3639] = 3,
    ACTIONS(731), 1,
      sym__S,
    ACTIONS(733), 1,
      anon_sym_EQ,
    STATE(329), 1,
      sym__Eq,
  [3649] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(396), 1,
      anon_sym_RPAREN,
    STATE(228), 1,
      sym_PEReference,
  [3659] = 1,
    ACTIONS(743), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__S,
  [3665] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(745), 1,
      sym_Name,
    STATE(193), 1,
      sym_PEReference,
  [3675] = 1,
    ACTIONS(747), 3,
      anon_sym_LBRACK,
      anon_sym_GT,
      sym__S,
  [3681] = 1,
    ACTIONS(524), 3,
      anon_sym_RPAREN,
      anon_sym_PERCENT,
      sym__S,
  [3687] = 1,
    ACTIONS(749), 3,
      anon_sym_LBRACK,
      anon_sym_GT,
      sym__S,
  [3693] = 2,
    ACTIONS(753), 1,
      anon_sym_STAR,
    ACTIONS(751), 2,
      anon_sym_GT,
      sym__S,
  [3701] = 3,
    ACTIONS(755), 1,
      anon_sym_QMARK_GT,
    ACTIONS(757), 1,
      sym__S,
    STATE(251), 1,
      aux_sym_StyleSheetPI_repeat1,
  [3711] = 3,
    ACTIONS(759), 1,
      anon_sym_LBRACK,
    ACTIONS(761), 1,
      anon_sym_GT,
    ACTIONS(763), 1,
      sym__S,
  [3721] = 3,
    ACTIONS(707), 1,
      anon_sym_xml_DASHstylesheet,
    ACTIONS(709), 1,
      anon_sym_xml_DASHmodel,
    ACTIONS(711), 1,
      sym_PITarget,
  [3731] = 3,
    ACTIONS(765), 1,
      anon_sym_QMARK_GT,
    ACTIONS(767), 1,
      sym__S,
    STATE(271), 1,
      aux_sym_StyleSheetPI_repeat1,
  [3741] = 1,
    ACTIONS(769), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__S,
  [3747] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(538), 1,
      anon_sym_RPAREN,
    STATE(228), 1,
      sym_PEReference,
  [3757] = 3,
    ACTIONS(771), 1,
      anon_sym_SQUOTE,
    ACTIONS(773), 1,
      anon_sym_DQUOTE,
    STATE(305), 1,
      sym_PseudoAttValue,
  [3767] = 1,
    ACTIONS(775), 3,
      anon_sym_LBRACK,
      anon_sym_GT,
      sym__S,
  [3773] = 2,
    ACTIONS(779), 1,
      anon_sym_STAR,
    ACTIONS(777), 2,
      anon_sym_GT,
      sym__S,
  [3781] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(781), 1,
      anon_sym_RPAREN,
    STATE(228), 1,
      sym_PEReference,
  [3791] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(783), 1,
      sym_Name,
    STATE(397), 1,
      sym_PEReference,
  [3801] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(785), 1,
      sym_Name,
    STATE(204), 1,
      sym_PEReference,
  [3811] = 2,
    ACTIONS(789), 1,
      anon_sym_STAR,
    ACTIONS(787), 2,
      anon_sym_GT,
      sym__S,
  [3819] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(791), 1,
      sym_Name,
    STATE(378), 1,
      sym_PEReference,
  [3829] = 2,
    ACTIONS(795), 1,
      sym__S,
    ACTIONS(793), 2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [3837] = 1,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      sym__S,
  [3843] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(623), 1,
      sym_Name,
    STATE(212), 1,
      sym_PEReference,
  [3853] = 3,
    ACTIONS(797), 1,
      anon_sym_GT,
    ACTIONS(799), 1,
      sym__S,
    STATE(286), 1,
      sym_NDataDecl,
  [3863] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(801), 1,
      sym_Name,
    STATE(122), 1,
      sym_PEReference,
  [3873] = 3,
    ACTIONS(731), 1,
      sym__S,
    ACTIONS(733), 1,
      anon_sym_EQ,
    STATE(324), 1,
      sym__Eq,
  [3883] = 3,
    ACTIONS(803), 1,
      anon_sym_QMARK_GT,
    ACTIONS(805), 1,
      sym__S,
    STATE(265), 1,
      aux_sym_StyleSheetPI_repeat1,
  [3893] = 3,
    ACTIONS(807), 1,
      anon_sym_SQUOTE,
    ACTIONS(809), 1,
      anon_sym_DQUOTE,
    STATE(225), 1,
      sym_AttValue,
  [3903] = 1,
    ACTIONS(811), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__S,
  [3909] = 3,
    ACTIONS(268), 1,
      anon_sym_SQUOTE,
    ACTIONS(270), 1,
      anon_sym_DQUOTE,
    STATE(348), 1,
      sym_AttValue,
  [3919] = 3,
    ACTIONS(803), 1,
      anon_sym_QMARK_GT,
    ACTIONS(813), 1,
      sym_Name,
    STATE(283), 1,
      sym_PseudoAtt,
  [3929] = 1,
    ACTIONS(604), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__S,
  [3935] = 3,
    ACTIONS(731), 1,
      sym__S,
    ACTIONS(733), 1,
      anon_sym_EQ,
    STATE(252), 1,
      sym__Eq,
  [3945] = 3,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    ACTIONS(654), 1,
      sym_Name,
    STATE(319), 1,
      sym_PEReference,
  [3955] = 3,
    ACTIONS(815), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_DQUOTE,
    STATE(299), 1,
      sym_PubidLiteral,
  [3965] = 3,
    ACTIONS(815), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_DQUOTE,
    STATE(300), 1,
      sym_PubidLiteral,
  [3975] = 3,
    ACTIONS(815), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_DQUOTE,
    STATE(392), 1,
      sym_PubidLiteral,
  [3985] = 3,
    ACTIONS(819), 1,
      anon_sym_LBRACK,
    ACTIONS(821), 1,
      anon_sym_GT,
    ACTIONS(823), 1,
      sym__S,
  [3995] = 3,
    ACTIONS(813), 1,
      sym_Name,
    ACTIONS(825), 1,
      anon_sym_QMARK_GT,
    STATE(283), 1,
      sym_PseudoAtt,
  [4005] = 3,
    ACTIONS(737), 1,
      anon_sym_SQUOTE,
    ACTIONS(739), 1,
      anon_sym_DQUOTE,
    STATE(238), 1,
      sym_SystemLiteral,
  [4015] = 3,
    ACTIONS(827), 1,
      anon_sym_QMARK_GT,
    ACTIONS(829), 1,
      sym__S,
    STATE(265), 1,
      aux_sym_StyleSheetPI_repeat1,
  [4025] = 2,
    ACTIONS(834), 1,
      sym__S,
    ACTIONS(832), 2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [4033] = 2,
    ACTIONS(838), 1,
      anon_sym_STAR,
    ACTIONS(836), 2,
      anon_sym_GT,
      sym__S,
  [4041] = 1,
    ACTIONS(840), 3,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      sym__S,
  [4047] = 2,
    ACTIONS(844), 1,
      sym__S,
    ACTIONS(842), 2,
      anon_sym_RPAREN,
      anon_sym_PERCENT,
  [4055] = 3,
    ACTIONS(813), 1,
      sym_Name,
    ACTIONS(846), 1,
      anon_sym_QMARK_GT,
    STATE(283), 1,
      sym_PseudoAtt,
  [4065] = 3,
    ACTIONS(848), 1,
      anon_sym_QMARK_GT,
    ACTIONS(850), 1,
      sym__S,
    STATE(265), 1,
      aux_sym_StyleSheetPI_repeat1,
  [4075] = 3,
    ACTIONS(731), 1,
      sym__S,
    ACTIONS(733), 1,
      anon_sym_EQ,
    STATE(237), 1,
      sym__Eq,
  [4085] = 3,
    ACTIONS(852), 1,
      anon_sym_QMARK_GT,
    ACTIONS(854), 1,
      sym__S,
    STATE(355), 1,
      sym__SDDecl,
  [4095] = 3,
    ACTIONS(813), 1,
      sym_Name,
    ACTIONS(848), 1,
      anon_sym_QMARK_GT,
    STATE(283), 1,
      sym_PseudoAtt,
  [4105] = 3,
    ACTIONS(852), 1,
      anon_sym_QMARK_GT,
    ACTIONS(856), 1,
      anon_sym_standalone,
    ACTIONS(858), 1,
      anon_sym_encoding,
  [4115] = 1,
    ACTIONS(860), 2,
      anon_sym_PERCENT,
      sym__S,
  [4120] = 1,
    ACTIONS(356), 2,
      anon_sym_PERCENT,
      sym__S,
  [4125] = 1,
    ACTIONS(862), 2,
      anon_sym_PERCENT,
      sym__S,
  [4130] = 1,
    ACTIONS(864), 2,
      anon_sym_GT,
      sym__S,
  [4135] = 2,
    ACTIONS(866), 1,
      anon_sym_QMARK_GT,
    ACTIONS(868), 1,
      sym__S,
  [4142] = 1,
    ACTIONS(870), 2,
      anon_sym_GT,
      sym__S,
  [4147] = 1,
    ACTIONS(872), 2,
      anon_sym_PERCENT,
      sym__S,
  [4152] = 1,
    ACTIONS(827), 2,
      anon_sym_QMARK_GT,
      sym__S,
  [4157] = 2,
    ACTIONS(856), 1,
      anon_sym_standalone,
    ACTIONS(874), 1,
      anon_sym_QMARK_GT,
  [4164] = 2,
    ACTIONS(876), 1,
      anon_sym_GT,
    ACTIONS(878), 1,
      anon_sym_NDATA,
  [4171] = 2,
    ACTIONS(876), 1,
      anon_sym_GT,
    ACTIONS(880), 1,
      sym__S,
  [4178] = 2,
    ACTIONS(852), 1,
      anon_sym_QMARK_GT,
    ACTIONS(882), 1,
      sym__S,
  [4185] = 1,
    ACTIONS(884), 2,
      anon_sym_PERCENT,
      sym__S,
  [4190] = 1,
    ACTIONS(886), 2,
      anon_sym_PERCENT,
      sym__S,
  [4195] = 1,
    ACTIONS(888), 2,
      anon_sym_PERCENT,
      sym__S,
  [4200] = 2,
    ACTIONS(890), 1,
      anon_sym_GT,
    ACTIONS(892), 1,
      sym__S,
  [4207] = 1,
    ACTIONS(894), 2,
      anon_sym_PERCENT,
      sym__S,
  [4212] = 1,
    ACTIONS(896), 2,
      anon_sym_GT,
      sym__S,
  [4217] = 2,
    ACTIONS(898), 1,
      sym__S,
    ACTIONS(900), 1,
      sym_Nmtoken,
  [4224] = 1,
    ACTIONS(902), 2,
      anon_sym_GT,
      sym__S,
  [4229] = 1,
    ACTIONS(904), 2,
      anon_sym_PERCENT,
      sym__S,
  [4234] = 2,
    ACTIONS(906), 1,
      anon_sym_GT,
    ACTIONS(908), 1,
      sym__S,
  [4241] = 1,
    ACTIONS(910), 2,
      anon_sym_GT,
      sym__S,
  [4246] = 2,
    ACTIONS(912), 1,
      anon_sym_GT,
    ACTIONS(914), 1,
      sym__S,
  [4253] = 1,
    ACTIONS(912), 2,
      anon_sym_GT,
      sym__S,
  [4258] = 1,
    ACTIONS(916), 2,
      anon_sym_PERCENT,
      sym__S,
  [4263] = 2,
    ACTIONS(918), 1,
      anon_sym_GT,
    ACTIONS(920), 1,
      sym__S,
  [4270] = 1,
    ACTIONS(922), 2,
      anon_sym_GT,
      sym__S,
  [4275] = 1,
    ACTIONS(924), 2,
      sym_CData,
      anon_sym_RBRACK_RBRACK_GT,
  [4280] = 1,
    ACTIONS(926), 2,
      anon_sym_QMARK_GT,
      sym__S,
  [4285] = 1,
    ACTIONS(928), 2,
      anon_sym_PERCENT,
      sym__S,
  [4290] = 2,
    ACTIONS(17), 1,
      anon_sym_LT_SLASH,
    STATE(81), 1,
      sym_ETag,
  [4297] = 2,
    ACTIONS(930), 1,
      anon_sym_QMARK_GT,
    ACTIONS(932), 1,
      sym__S,
  [4304] = 2,
    ACTIONS(934), 1,
      anon_sym_QMARK_GT,
    ACTIONS(936), 1,
      sym__S,
  [4311] = 2,
    ACTIONS(797), 1,
      anon_sym_GT,
    ACTIONS(938), 1,
      sym__S,
  [4318] = 1,
    ACTIONS(787), 2,
      anon_sym_GT,
      sym__S,
  [4323] = 2,
    ACTIONS(940), 1,
      sym__S,
    STATE(163), 1,
      sym__VersionInfo,
  [4330] = 2,
    ACTIONS(942), 1,
      anon_sym_SQUOTE,
    ACTIONS(944), 1,
      anon_sym_DQUOTE,
  [4337] = 2,
    ACTIONS(946), 1,
      anon_sym_GT,
    ACTIONS(948), 1,
      sym__S,
  [4344] = 1,
    ACTIONS(674), 2,
      anon_sym_RPAREN,
      anon_sym_PERCENT,
  [4349] = 1,
    ACTIONS(950), 2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [4354] = 1,
    ACTIONS(952), 2,
      anon_sym_yes,
      anon_sym_no,
  [4359] = 1,
    ACTIONS(954), 2,
      anon_sym_yes,
      anon_sym_no,
  [4364] = 2,
    ACTIONS(643), 1,
      anon_sym_GT,
    ACTIONS(956), 1,
      sym__S,
  [4371] = 1,
    ACTIONS(206), 2,
      anon_sym_PERCENT,
      sym__S,
  [4376] = 1,
    ACTIONS(959), 2,
      anon_sym_PERCENT,
      sym__S,
  [4381] = 1,
    ACTIONS(769), 2,
      anon_sym_GT,
      sym__S,
  [4386] = 2,
    ACTIONS(961), 1,
      anon_sym_GT,
    ACTIONS(963), 1,
      sym__S,
  [4393] = 2,
    ACTIONS(965), 1,
      anon_sym_SQUOTE,
    ACTIONS(967), 1,
      anon_sym_DQUOTE,
  [4400] = 1,
    ACTIONS(811), 2,
      anon_sym_GT,
      sym__S,
  [4405] = 1,
    ACTIONS(969), 2,
      anon_sym_GT,
      sym__S,
  [4410] = 1,
    ACTIONS(971), 2,
      anon_sym_QMARK_GT,
      sym__S,
  [4415] = 2,
    ACTIONS(973), 1,
      anon_sym_GT,
    ACTIONS(975), 1,
      sym__S,
  [4422] = 2,
    ACTIONS(977), 1,
      anon_sym_SQUOTE,
    ACTIONS(979), 1,
      anon_sym_DQUOTE,
  [4429] = 2,
    ACTIONS(29), 1,
      anon_sym_LT_SLASH,
    STATE(201), 1,
      sym_ETag,
  [4436] = 2,
    ACTIONS(981), 1,
      anon_sym_GT,
    ACTIONS(983), 1,
      sym__S,
  [4443] = 1,
    ACTIONS(985), 2,
      anon_sym_GT,
      sym__S,
  [4448] = 2,
    ACTIONS(761), 1,
      anon_sym_GT,
    ACTIONS(987), 1,
      sym__S,
  [4455] = 2,
    ACTIONS(989), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(991), 1,
      sym_CData,
  [4462] = 1,
    ACTIONS(993), 2,
      anon_sym_GT,
      sym__S,
  [4467] = 1,
    ACTIONS(995), 2,
      anon_sym_GT,
      sym__S,
  [4472] = 2,
    ACTIONS(997), 1,
      anon_sym_GT,
    ACTIONS(999), 1,
      sym__S,
  [4479] = 1,
    ACTIONS(1001), 2,
      anon_sym_PERCENT,
      sym__S,
  [4484] = 2,
    ACTIONS(1003), 1,
      anon_sym_RPAREN,
    ACTIONS(1005), 1,
      sym__S,
  [4491] = 1,
    ACTIONS(1007), 2,
      anon_sym_GT,
      sym__S,
  [4496] = 1,
    ACTIONS(1009), 2,
      anon_sym_PERCENT,
      sym__S,
  [4501] = 1,
    ACTIONS(1011), 2,
      anon_sym_GT,
      sym__S,
  [4506] = 2,
    ACTIONS(1013), 1,
      anon_sym_RPAREN,
    ACTIONS(1015), 1,
      sym__S,
  [4513] = 1,
    ACTIONS(751), 2,
      anon_sym_GT,
      sym__S,
  [4518] = 2,
    ACTIONS(1017), 1,
      anon_sym_GT,
    ACTIONS(1019), 1,
      sym__S,
  [4525] = 1,
    ACTIONS(1021), 2,
      anon_sym_GT,
      sym__S,
  [4530] = 1,
    ACTIONS(1023), 2,
      anon_sym_GT,
      sym__S,
  [4535] = 1,
    ACTIONS(1025), 2,
      anon_sym_GT,
      sym__S,
  [4540] = 2,
    ACTIONS(1027), 1,
      anon_sym_RPAREN,
    ACTIONS(1029), 1,
      sym__S,
  [4547] = 2,
    ACTIONS(1031), 1,
      sym_Name,
    ACTIONS(1033), 1,
      sym__S,
  [4554] = 1,
    ACTIONS(832), 2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [4559] = 2,
    ACTIONS(573), 1,
      sym_Name,
    STATE(256), 1,
      sym_Attribute,
  [4566] = 1,
    ACTIONS(1035), 2,
      anon_sym_QMARK_GT,
      sym__S,
  [4571] = 1,
    ACTIONS(1037), 2,
      anon_sym_QMARK_GT,
      sym__S,
  [4576] = 2,
    ACTIONS(874), 1,
      anon_sym_QMARK_GT,
    ACTIONS(1039), 1,
      sym__S,
  [4583] = 2,
    ACTIONS(813), 1,
      sym_Name,
    STATE(283), 1,
      sym_PseudoAtt,
  [4590] = 1,
    ACTIONS(492), 2,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [4595] = 2,
    ACTIONS(142), 1,
      anon_sym_PERCENT,
    STATE(228), 1,
      sym_PEReference,
  [4602] = 2,
    ACTIONS(1041), 1,
      anon_sym_PIPE,
    ACTIONS(1043), 1,
      anon_sym_RPAREN,
  [4609] = 2,
    ACTIONS(1045), 1,
      sym__S,
    ACTIONS(1047), 1,
      sym_Nmtoken,
  [4616] = 1,
    ACTIONS(1049), 2,
      anon_sym_GT,
      sym__S,
  [4621] = 2,
    ACTIONS(670), 1,
      anon_sym_RPAREN,
    ACTIONS(1041), 1,
      anon_sym_PIPE,
  [4628] = 1,
    ACTIONS(1051), 2,
      anon_sym_GT,
      sym__S,
  [4633] = 2,
    ACTIONS(1017), 1,
      anon_sym_GT,
    ACTIONS(1053), 1,
      anon_sym_LBRACK,
  [4640] = 1,
    ACTIONS(1055), 2,
      anon_sym_GT,
      sym__S,
  [4645] = 1,
    ACTIONS(1057), 2,
      anon_sym_GT,
      sym__S,
  [4650] = 1,
    ACTIONS(1059), 2,
      anon_sym_GT,
      sym__S,
  [4655] = 1,
    ACTIONS(1061), 2,
      anon_sym_PERCENT,
      sym__S,
  [4660] = 1,
    ACTIONS(1063), 2,
      anon_sym_GT,
      sym__S,
  [4665] = 1,
    ACTIONS(1065), 2,
      anon_sym_QMARK_GT,
      sym__S,
  [4670] = 1,
    ACTIONS(777), 2,
      anon_sym_GT,
      sym__S,
  [4675] = 2,
    ACTIONS(1067), 1,
      sym__S,
    ACTIONS(1069), 1,
      sym_Nmtoken,
  [4682] = 1,
    ACTIONS(1071), 2,
      anon_sym_QMARK_GT,
      sym__S,
  [4687] = 2,
    ACTIONS(1073), 1,
      anon_sym_GT,
    ACTIONS(1075), 1,
      sym__S,
  [4694] = 2,
    ACTIONS(629), 1,
      anon_sym_RPAREN,
    ACTIONS(1041), 1,
      anon_sym_PIPE,
  [4701] = 1,
    ACTIONS(1077), 2,
      anon_sym_GT,
      sym__S,
  [4706] = 1,
    ACTIONS(1079), 1,
      sym_EncName,
  [4710] = 1,
    ACTIONS(1081), 1,
      sym__S,
  [4714] = 1,
    ACTIONS(1083), 1,
      sym_Name,
  [4718] = 1,
    ACTIONS(1085), 1,
      aux_sym_SystemLiteral_token2,
  [4722] = 1,
    ACTIONS(1069), 1,
      sym_Nmtoken,
  [4726] = 1,
    ACTIONS(1087), 1,
      anon_sym_DQUOTE,
  [4730] = 1,
    ACTIONS(779), 1,
      anon_sym_STAR,
  [4734] = 1,
    ACTIONS(1087), 1,
      anon_sym_SQUOTE,
  [4738] = 1,
    ACTIONS(1089), 1,
      anon_sym_DQUOTE,
  [4742] = 1,
    ACTIONS(1091), 1,
      sym__S,
  [4746] = 1,
    ACTIONS(1093), 1,
      aux_sym_SystemLiteral_token1,
  [4750] = 1,
    ACTIONS(1095), 1,
      sym__S,
  [4754] = 1,
    ACTIONS(1097), 1,
      anon_sym_STAR,
  [4758] = 1,
    ACTIONS(1099), 1,
      aux_sym_PubidLiteral_token2,
  [4762] = 1,
    ACTIONS(1101), 1,
      aux_sym_PubidLiteral_token1,
  [4766] = 1,
    ACTIONS(914), 1,
      sym__S,
  [4770] = 1,
    ACTIONS(1103), 1,
      sym__S,
  [4774] = 1,
    ACTIONS(1105), 1,
      sym_Nmtoken,
  [4778] = 1,
    ACTIONS(1041), 1,
      anon_sym_PIPE,
  [4782] = 1,
    ACTIONS(1107), 1,
      sym_Name,
  [4786] = 1,
    ACTIONS(1109), 1,
      sym__S,
  [4790] = 1,
    ACTIONS(1111), 1,
      anon_sym_PIPE,
  [4794] = 1,
    ACTIONS(1113), 1,
      sym__S,
  [4798] = 1,
    ACTIONS(1115), 1,
      sym_VersionNum,
  [4802] = 1,
    ACTIONS(496), 1,
      anon_sym_PIPE,
  [4806] = 1,
    ACTIONS(997), 1,
      anon_sym_GT,
  [4810] = 1,
    ACTIONS(753), 1,
      anon_sym_STAR,
  [4814] = 1,
    ACTIONS(1117), 1,
      anon_sym_SQUOTE,
  [4818] = 1,
    ACTIONS(1117), 1,
      anon_sym_DQUOTE,
  [4822] = 1,
    ACTIONS(1017), 1,
      anon_sym_GT,
  [4826] = 1,
    ACTIONS(1119), 1,
      sym__S,
  [4830] = 1,
    ACTIONS(1121), 1,
      sym__S,
  [4834] = 1,
    ACTIONS(1123), 1,
      anon_sym_SQUOTE,
  [4838] = 1,
    ACTIONS(1013), 1,
      anon_sym_RPAREN,
  [4842] = 1,
    ACTIONS(1125), 1,
      sym__S,
  [4846] = 1,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
  [4850] = 1,
    ACTIONS(1003), 1,
      anon_sym_RPAREN,
  [4854] = 1,
    ACTIONS(1127), 1,
      anon_sym_GT,
  [4858] = 1,
    ACTIONS(1129), 1,
      sym__S,
  [4862] = 1,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
  [4866] = 1,
    ACTIONS(1133), 1,
      anon_sym_RPAREN,
  [4870] = 1,
    ACTIONS(874), 1,
      anon_sym_QMARK_GT,
  [4874] = 1,
    ACTIONS(1135), 1,
      anon_sym_version,
  [4878] = 1,
    ACTIONS(1137), 1,
      sym__pi_content,
  [4882] = 1,
    ACTIONS(1139), 1,
      sym_VersionNum,
  [4886] = 1,
    ACTIONS(1141), 1,
      sym_Nmtoken,
  [4890] = 1,
    ACTIONS(973), 1,
      anon_sym_GT,
  [4894] = 1,
    ACTIONS(1143), 1,
      anon_sym_LBRACK,
  [4898] = 1,
    ACTIONS(1145), 1,
      aux_sym_CharRef_token2,
  [4902] = 1,
    ACTIONS(1145), 1,
      aux_sym_CharRef_token1,
  [4906] = 1,
    ACTIONS(1147), 1,
      anon_sym_SEMI,
  [4910] = 1,
    ACTIONS(1149), 1,
      sym_EncName,
  [4914] = 1,
    ACTIONS(1151), 1,
      sym_Name,
  [4918] = 1,
    ACTIONS(1153), 1,
      anon_sym_CDATA,
  [4922] = 1,
    ACTIONS(1073), 1,
      anon_sym_GT,
  [4926] = 1,
    ACTIONS(1155), 1,
      anon_sym_SEMI,
  [4930] = 1,
    ACTIONS(1157), 1,
      anon_sym_RBRACK_RBRACK_GT,
  [4934] = 1,
    ACTIONS(1159), 1,
      sym_PITarget,
  [4938] = 1,
    ACTIONS(1161), 1,
      sym__end_tag_name,
  [4942] = 1,
    ACTIONS(1163), 1,
      anon_sym_SEMI,
  [4946] = 1,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
  [4950] = 1,
    ACTIONS(1165), 1,
      sym__S,
  [4954] = 1,
    ACTIONS(1167), 1,
      anon_sym_GT,
  [4958] = 1,
    ACTIONS(1169), 1,
      anon_sym_DQUOTE,
  [4962] = 1,
    ACTIONS(1169), 1,
      anon_sym_SQUOTE,
  [4966] = 1,
    ACTIONS(789), 1,
      anon_sym_STAR,
  [4970] = 1,
    ACTIONS(1171), 1,
      sym__S,
  [4974] = 1,
    ACTIONS(1173), 1,
      sym__S,
  [4978] = 1,
    ACTIONS(1175), 1,
      anon_sym_QMARK_GT,
  [4982] = 1,
    ACTIONS(1177), 1,
      anon_sym_EQ,
  [4986] = 1,
    ACTIONS(1179), 1,
      anon_sym_GT,
  [4990] = 1,
    ACTIONS(1181), 1,
      sym__S,
  [4994] = 1,
    ACTIONS(1183), 1,
      anon_sym_GT,
  [4998] = 1,
    ACTIONS(1185), 1,
      sym__S,
  [5002] = 1,
    ACTIONS(1187), 1,
      sym__S,
  [5006] = 1,
    ACTIONS(1189), 1,
      anon_sym_QMARK_GT,
  [5010] = 1,
    ACTIONS(1191), 1,
      sym__S,
  [5014] = 1,
    ACTIONS(1193), 1,
      anon_sym_GT,
  [5018] = 1,
    ACTIONS(1195), 1,
      anon_sym_SEMI,
  [5022] = 1,
    ACTIONS(1197), 1,
      anon_sym_SEMI,
  [5026] = 1,
    ACTIONS(1199), 1,
      anon_sym_QMARK_GT,
  [5030] = 1,
    ACTIONS(1201), 1,
      sym_Name,
  [5034] = 1,
    ACTIONS(1203), 1,
      anon_sym_GT,
  [5038] = 1,
    ACTIONS(876), 1,
      anon_sym_GT,
  [5042] = 1,
    ACTIONS(1205), 1,
      ts_builtin_sym_end,
  [5046] = 1,
    ACTIONS(1207), 1,
      sym__start_tag_name,
  [5050] = 1,
    ACTIONS(1209), 1,
      anon_sym_DOCTYPE,
  [5054] = 1,
    ACTIONS(1211), 1,
      anon_sym_SEMI,
  [5058] = 1,
    ACTIONS(1213), 1,
      anon_sym_GT,
  [5062] = 1,
    ACTIONS(1215), 1,
      anon_sym_SEMI,
  [5066] = 1,
    ACTIONS(1217), 1,
      anon_sym_SEMI,
  [5070] = 1,
    ACTIONS(1219), 1,
      anon_sym_QMARK_GT,
  [5074] = 1,
    ACTIONS(1221), 1,
      anon_sym_SEMI,
  [5078] = 1,
    ACTIONS(1223), 1,
      anon_sym_SEMI,
  [5082] = 1,
    ACTIONS(1225), 1,
      anon_sym_SEMI,
  [5086] = 1,
    ACTIONS(1227), 1,
      anon_sym_SEMI,
  [5090] = 1,
    ACTIONS(1229), 1,
      anon_sym_SEMI,
  [5094] = 1,
    ACTIONS(1231), 1,
      anon_sym_SEMI,
  [5098] = 1,
    ACTIONS(1233), 1,
      sym__start_tag_name,
  [5102] = 1,
    ACTIONS(1235), 1,
      sym_PITarget,
  [5106] = 1,
    ACTIONS(1237), 1,
      sym__end_tag_name,
  [5110] = 1,
    ACTIONS(1239), 1,
      sym_Name,
  [5114] = 1,
    ACTIONS(1241), 1,
      aux_sym_CharRef_token1,
  [5118] = 1,
    ACTIONS(1241), 1,
      aux_sym_CharRef_token2,
  [5122] = 1,
    ACTIONS(1243), 1,
      sym__pi_content,
  [5126] = 1,
    ACTIONS(1031), 1,
      sym_Name,
  [5130] = 1,
    ACTIONS(1245), 1,
      sym_Name,
  [5134] = 1,
    ACTIONS(1247), 1,
      aux_sym_CharRef_token1,
  [5138] = 1,
    ACTIONS(1247), 1,
      aux_sym_CharRef_token2,
  [5142] = 1,
    ACTIONS(1249), 1,
      sym__pi_content,
  [5146] = 1,
    ACTIONS(1251), 1,
      sym_Name,
  [5150] = 1,
    ACTIONS(1253), 1,
      sym_Name,
  [5154] = 1,
    ACTIONS(1255), 1,
      aux_sym_CharRef_token1,
  [5158] = 1,
    ACTIONS(1255), 1,
      aux_sym_CharRef_token2,
  [5162] = 1,
    ACTIONS(1257), 1,
      sym_Name,
  [5166] = 1,
    ACTIONS(1259), 1,
      sym_Name,
  [5170] = 1,
    ACTIONS(1261), 1,
      aux_sym_CharRef_token1,
  [5174] = 1,
    ACTIONS(1261), 1,
      aux_sym_CharRef_token2,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 52,
  [SMALL_STATE(4)] = 104,
  [SMALL_STATE(5)] = 150,
  [SMALL_STATE(6)] = 196,
  [SMALL_STATE(7)] = 235,
  [SMALL_STATE(8)] = 268,
  [SMALL_STATE(9)] = 301,
  [SMALL_STATE(10)] = 334,
  [SMALL_STATE(11)] = 367,
  [SMALL_STATE(12)] = 400,
  [SMALL_STATE(13)] = 433,
  [SMALL_STATE(14)] = 466,
  [SMALL_STATE(15)] = 499,
  [SMALL_STATE(16)] = 532,
  [SMALL_STATE(17)] = 559,
  [SMALL_STATE(18)] = 586,
  [SMALL_STATE(19)] = 613,
  [SMALL_STATE(20)] = 640,
  [SMALL_STATE(21)] = 664,
  [SMALL_STATE(22)] = 692,
  [SMALL_STATE(23)] = 720,
  [SMALL_STATE(24)] = 744,
  [SMALL_STATE(25)] = 766,
  [SMALL_STATE(26)] = 794,
  [SMALL_STATE(27)] = 822,
  [SMALL_STATE(28)] = 850,
  [SMALL_STATE(29)] = 872,
  [SMALL_STATE(30)] = 900,
  [SMALL_STATE(31)] = 924,
  [SMALL_STATE(32)] = 952,
  [SMALL_STATE(33)] = 976,
  [SMALL_STATE(34)] = 998,
  [SMALL_STATE(35)] = 1011,
  [SMALL_STATE(36)] = 1023,
  [SMALL_STATE(37)] = 1037,
  [SMALL_STATE(38)] = 1051,
  [SMALL_STATE(39)] = 1065,
  [SMALL_STATE(40)] = 1079,
  [SMALL_STATE(41)] = 1093,
  [SMALL_STATE(42)] = 1117,
  [SMALL_STATE(43)] = 1131,
  [SMALL_STATE(44)] = 1155,
  [SMALL_STATE(45)] = 1179,
  [SMALL_STATE(46)] = 1203,
  [SMALL_STATE(47)] = 1227,
  [SMALL_STATE(48)] = 1239,
  [SMALL_STATE(49)] = 1263,
  [SMALL_STATE(50)] = 1287,
  [SMALL_STATE(51)] = 1299,
  [SMALL_STATE(52)] = 1323,
  [SMALL_STATE(53)] = 1337,
  [SMALL_STATE(54)] = 1349,
  [SMALL_STATE(55)] = 1373,
  [SMALL_STATE(56)] = 1397,
  [SMALL_STATE(57)] = 1415,
  [SMALL_STATE(58)] = 1433,
  [SMALL_STATE(59)] = 1451,
  [SMALL_STATE(60)] = 1469,
  [SMALL_STATE(61)] = 1487,
  [SMALL_STATE(62)] = 1505,
  [SMALL_STATE(63)] = 1519,
  [SMALL_STATE(64)] = 1543,
  [SMALL_STATE(65)] = 1557,
  [SMALL_STATE(66)] = 1581,
  [SMALL_STATE(67)] = 1595,
  [SMALL_STATE(68)] = 1619,
  [SMALL_STATE(69)] = 1631,
  [SMALL_STATE(70)] = 1655,
  [SMALL_STATE(71)] = 1669,
  [SMALL_STATE(72)] = 1693,
  [SMALL_STATE(73)] = 1711,
  [SMALL_STATE(74)] = 1733,
  [SMALL_STATE(75)] = 1751,
  [SMALL_STATE(76)] = 1765,
  [SMALL_STATE(77)] = 1779,
  [SMALL_STATE(78)] = 1793,
  [SMALL_STATE(79)] = 1807,
  [SMALL_STATE(80)] = 1821,
  [SMALL_STATE(81)] = 1835,
  [SMALL_STATE(82)] = 1849,
  [SMALL_STATE(83)] = 1867,
  [SMALL_STATE(84)] = 1885,
  [SMALL_STATE(85)] = 1903,
  [SMALL_STATE(86)] = 1921,
  [SMALL_STATE(87)] = 1942,
  [SMALL_STATE(88)] = 1955,
  [SMALL_STATE(89)] = 1976,
  [SMALL_STATE(90)] = 1997,
  [SMALL_STATE(91)] = 2018,
  [SMALL_STATE(92)] = 2043,
  [SMALL_STATE(93)] = 2065,
  [SMALL_STATE(94)] = 2085,
  [SMALL_STATE(95)] = 2105,
  [SMALL_STATE(96)] = 2127,
  [SMALL_STATE(97)] = 2149,
  [SMALL_STATE(98)] = 2169,
  [SMALL_STATE(99)] = 2191,
  [SMALL_STATE(100)] = 2213,
  [SMALL_STATE(101)] = 2232,
  [SMALL_STATE(102)] = 2243,
  [SMALL_STATE(103)] = 2254,
  [SMALL_STATE(104)] = 2265,
  [SMALL_STATE(105)] = 2276,
  [SMALL_STATE(106)] = 2287,
  [SMALL_STATE(107)] = 2304,
  [SMALL_STATE(108)] = 2315,
  [SMALL_STATE(109)] = 2326,
  [SMALL_STATE(110)] = 2343,
  [SMALL_STATE(111)] = 2354,
  [SMALL_STATE(112)] = 2365,
  [SMALL_STATE(113)] = 2382,
  [SMALL_STATE(114)] = 2393,
  [SMALL_STATE(115)] = 2404,
  [SMALL_STATE(116)] = 2415,
  [SMALL_STATE(117)] = 2432,
  [SMALL_STATE(118)] = 2443,
  [SMALL_STATE(119)] = 2458,
  [SMALL_STATE(120)] = 2475,
  [SMALL_STATE(121)] = 2494,
  [SMALL_STATE(122)] = 2505,
  [SMALL_STATE(123)] = 2524,
  [SMALL_STATE(124)] = 2535,
  [SMALL_STATE(125)] = 2554,
  [SMALL_STATE(126)] = 2573,
  [SMALL_STATE(127)] = 2584,
  [SMALL_STATE(128)] = 2594,
  [SMALL_STATE(129)] = 2608,
  [SMALL_STATE(130)] = 2616,
  [SMALL_STATE(131)] = 2632,
  [SMALL_STATE(132)] = 2642,
  [SMALL_STATE(133)] = 2656,
  [SMALL_STATE(134)] = 2672,
  [SMALL_STATE(135)] = 2686,
  [SMALL_STATE(136)] = 2696,
  [SMALL_STATE(137)] = 2712,
  [SMALL_STATE(138)] = 2726,
  [SMALL_STATE(139)] = 2740,
  [SMALL_STATE(140)] = 2748,
  [SMALL_STATE(141)] = 2758,
  [SMALL_STATE(142)] = 2772,
  [SMALL_STATE(143)] = 2780,
  [SMALL_STATE(144)] = 2796,
  [SMALL_STATE(145)] = 2806,
  [SMALL_STATE(146)] = 2816,
  [SMALL_STATE(147)] = 2826,
  [SMALL_STATE(148)] = 2836,
  [SMALL_STATE(149)] = 2846,
  [SMALL_STATE(150)] = 2856,
  [SMALL_STATE(151)] = 2870,
  [SMALL_STATE(152)] = 2880,
  [SMALL_STATE(153)] = 2888,
  [SMALL_STATE(154)] = 2902,
  [SMALL_STATE(155)] = 2910,
  [SMALL_STATE(156)] = 2918,
  [SMALL_STATE(157)] = 2934,
  [SMALL_STATE(158)] = 2942,
  [SMALL_STATE(159)] = 2956,
  [SMALL_STATE(160)] = 2963,
  [SMALL_STATE(161)] = 2970,
  [SMALL_STATE(162)] = 2979,
  [SMALL_STATE(163)] = 2986,
  [SMALL_STATE(164)] = 2999,
  [SMALL_STATE(165)] = 3008,
  [SMALL_STATE(166)] = 3021,
  [SMALL_STATE(167)] = 3034,
  [SMALL_STATE(168)] = 3045,
  [SMALL_STATE(169)] = 3054,
  [SMALL_STATE(170)] = 3067,
  [SMALL_STATE(171)] = 3080,
  [SMALL_STATE(172)] = 3089,
  [SMALL_STATE(173)] = 3096,
  [SMALL_STATE(174)] = 3109,
  [SMALL_STATE(175)] = 3120,
  [SMALL_STATE(176)] = 3127,
  [SMALL_STATE(177)] = 3138,
  [SMALL_STATE(178)] = 3145,
  [SMALL_STATE(179)] = 3158,
  [SMALL_STATE(180)] = 3167,
  [SMALL_STATE(181)] = 3174,
  [SMALL_STATE(182)] = 3187,
  [SMALL_STATE(183)] = 3200,
  [SMALL_STATE(184)] = 3213,
  [SMALL_STATE(185)] = 3222,
  [SMALL_STATE(186)] = 3235,
  [SMALL_STATE(187)] = 3248,
  [SMALL_STATE(188)] = 3259,
  [SMALL_STATE(189)] = 3272,
  [SMALL_STATE(190)] = 3281,
  [SMALL_STATE(191)] = 3294,
  [SMALL_STATE(192)] = 3307,
  [SMALL_STATE(193)] = 3316,
  [SMALL_STATE(194)] = 3323,
  [SMALL_STATE(195)] = 3336,
  [SMALL_STATE(196)] = 3349,
  [SMALL_STATE(197)] = 3362,
  [SMALL_STATE(198)] = 3375,
  [SMALL_STATE(199)] = 3382,
  [SMALL_STATE(200)] = 3395,
  [SMALL_STATE(201)] = 3402,
  [SMALL_STATE(202)] = 3409,
  [SMALL_STATE(203)] = 3422,
  [SMALL_STATE(204)] = 3435,
  [SMALL_STATE(205)] = 3446,
  [SMALL_STATE(206)] = 3453,
  [SMALL_STATE(207)] = 3466,
  [SMALL_STATE(208)] = 3479,
  [SMALL_STATE(209)] = 3488,
  [SMALL_STATE(210)] = 3501,
  [SMALL_STATE(211)] = 3510,
  [SMALL_STATE(212)] = 3521,
  [SMALL_STATE(213)] = 3528,
  [SMALL_STATE(214)] = 3541,
  [SMALL_STATE(215)] = 3554,
  [SMALL_STATE(216)] = 3567,
  [SMALL_STATE(217)] = 3580,
  [SMALL_STATE(218)] = 3593,
  [SMALL_STATE(219)] = 3603,
  [SMALL_STATE(220)] = 3613,
  [SMALL_STATE(221)] = 3619,
  [SMALL_STATE(222)] = 3629,
  [SMALL_STATE(223)] = 3639,
  [SMALL_STATE(224)] = 3649,
  [SMALL_STATE(225)] = 3659,
  [SMALL_STATE(226)] = 3665,
  [SMALL_STATE(227)] = 3675,
  [SMALL_STATE(228)] = 3681,
  [SMALL_STATE(229)] = 3687,
  [SMALL_STATE(230)] = 3693,
  [SMALL_STATE(231)] = 3701,
  [SMALL_STATE(232)] = 3711,
  [SMALL_STATE(233)] = 3721,
  [SMALL_STATE(234)] = 3731,
  [SMALL_STATE(235)] = 3741,
  [SMALL_STATE(236)] = 3747,
  [SMALL_STATE(237)] = 3757,
  [SMALL_STATE(238)] = 3767,
  [SMALL_STATE(239)] = 3773,
  [SMALL_STATE(240)] = 3781,
  [SMALL_STATE(241)] = 3791,
  [SMALL_STATE(242)] = 3801,
  [SMALL_STATE(243)] = 3811,
  [SMALL_STATE(244)] = 3819,
  [SMALL_STATE(245)] = 3829,
  [SMALL_STATE(246)] = 3837,
  [SMALL_STATE(247)] = 3843,
  [SMALL_STATE(248)] = 3853,
  [SMALL_STATE(249)] = 3863,
  [SMALL_STATE(250)] = 3873,
  [SMALL_STATE(251)] = 3883,
  [SMALL_STATE(252)] = 3893,
  [SMALL_STATE(253)] = 3903,
  [SMALL_STATE(254)] = 3909,
  [SMALL_STATE(255)] = 3919,
  [SMALL_STATE(256)] = 3929,
  [SMALL_STATE(257)] = 3935,
  [SMALL_STATE(258)] = 3945,
  [SMALL_STATE(259)] = 3955,
  [SMALL_STATE(260)] = 3965,
  [SMALL_STATE(261)] = 3975,
  [SMALL_STATE(262)] = 3985,
  [SMALL_STATE(263)] = 3995,
  [SMALL_STATE(264)] = 4005,
  [SMALL_STATE(265)] = 4015,
  [SMALL_STATE(266)] = 4025,
  [SMALL_STATE(267)] = 4033,
  [SMALL_STATE(268)] = 4041,
  [SMALL_STATE(269)] = 4047,
  [SMALL_STATE(270)] = 4055,
  [SMALL_STATE(271)] = 4065,
  [SMALL_STATE(272)] = 4075,
  [SMALL_STATE(273)] = 4085,
  [SMALL_STATE(274)] = 4095,
  [SMALL_STATE(275)] = 4105,
  [SMALL_STATE(276)] = 4115,
  [SMALL_STATE(277)] = 4120,
  [SMALL_STATE(278)] = 4125,
  [SMALL_STATE(279)] = 4130,
  [SMALL_STATE(280)] = 4135,
  [SMALL_STATE(281)] = 4142,
  [SMALL_STATE(282)] = 4147,
  [SMALL_STATE(283)] = 4152,
  [SMALL_STATE(284)] = 4157,
  [SMALL_STATE(285)] = 4164,
  [SMALL_STATE(286)] = 4171,
  [SMALL_STATE(287)] = 4178,
  [SMALL_STATE(288)] = 4185,
  [SMALL_STATE(289)] = 4190,
  [SMALL_STATE(290)] = 4195,
  [SMALL_STATE(291)] = 4200,
  [SMALL_STATE(292)] = 4207,
  [SMALL_STATE(293)] = 4212,
  [SMALL_STATE(294)] = 4217,
  [SMALL_STATE(295)] = 4224,
  [SMALL_STATE(296)] = 4229,
  [SMALL_STATE(297)] = 4234,
  [SMALL_STATE(298)] = 4241,
  [SMALL_STATE(299)] = 4246,
  [SMALL_STATE(300)] = 4253,
  [SMALL_STATE(301)] = 4258,
  [SMALL_STATE(302)] = 4263,
  [SMALL_STATE(303)] = 4270,
  [SMALL_STATE(304)] = 4275,
  [SMALL_STATE(305)] = 4280,
  [SMALL_STATE(306)] = 4285,
  [SMALL_STATE(307)] = 4290,
  [SMALL_STATE(308)] = 4297,
  [SMALL_STATE(309)] = 4304,
  [SMALL_STATE(310)] = 4311,
  [SMALL_STATE(311)] = 4318,
  [SMALL_STATE(312)] = 4323,
  [SMALL_STATE(313)] = 4330,
  [SMALL_STATE(314)] = 4337,
  [SMALL_STATE(315)] = 4344,
  [SMALL_STATE(316)] = 4349,
  [SMALL_STATE(317)] = 4354,
  [SMALL_STATE(318)] = 4359,
  [SMALL_STATE(319)] = 4364,
  [SMALL_STATE(320)] = 4371,
  [SMALL_STATE(321)] = 4376,
  [SMALL_STATE(322)] = 4381,
  [SMALL_STATE(323)] = 4386,
  [SMALL_STATE(324)] = 4393,
  [SMALL_STATE(325)] = 4400,
  [SMALL_STATE(326)] = 4405,
  [SMALL_STATE(327)] = 4410,
  [SMALL_STATE(328)] = 4415,
  [SMALL_STATE(329)] = 4422,
  [SMALL_STATE(330)] = 4429,
  [SMALL_STATE(331)] = 4436,
  [SMALL_STATE(332)] = 4443,
  [SMALL_STATE(333)] = 4448,
  [SMALL_STATE(334)] = 4455,
  [SMALL_STATE(335)] = 4462,
  [SMALL_STATE(336)] = 4467,
  [SMALL_STATE(337)] = 4472,
  [SMALL_STATE(338)] = 4479,
  [SMALL_STATE(339)] = 4484,
  [SMALL_STATE(340)] = 4491,
  [SMALL_STATE(341)] = 4496,
  [SMALL_STATE(342)] = 4501,
  [SMALL_STATE(343)] = 4506,
  [SMALL_STATE(344)] = 4513,
  [SMALL_STATE(345)] = 4518,
  [SMALL_STATE(346)] = 4525,
  [SMALL_STATE(347)] = 4530,
  [SMALL_STATE(348)] = 4535,
  [SMALL_STATE(349)] = 4540,
  [SMALL_STATE(350)] = 4547,
  [SMALL_STATE(351)] = 4554,
  [SMALL_STATE(352)] = 4559,
  [SMALL_STATE(353)] = 4566,
  [SMALL_STATE(354)] = 4571,
  [SMALL_STATE(355)] = 4576,
  [SMALL_STATE(356)] = 4583,
  [SMALL_STATE(357)] = 4590,
  [SMALL_STATE(358)] = 4595,
  [SMALL_STATE(359)] = 4602,
  [SMALL_STATE(360)] = 4609,
  [SMALL_STATE(361)] = 4616,
  [SMALL_STATE(362)] = 4621,
  [SMALL_STATE(363)] = 4628,
  [SMALL_STATE(364)] = 4633,
  [SMALL_STATE(365)] = 4640,
  [SMALL_STATE(366)] = 4645,
  [SMALL_STATE(367)] = 4650,
  [SMALL_STATE(368)] = 4655,
  [SMALL_STATE(369)] = 4660,
  [SMALL_STATE(370)] = 4665,
  [SMALL_STATE(371)] = 4670,
  [SMALL_STATE(372)] = 4675,
  [SMALL_STATE(373)] = 4682,
  [SMALL_STATE(374)] = 4687,
  [SMALL_STATE(375)] = 4694,
  [SMALL_STATE(376)] = 4701,
  [SMALL_STATE(377)] = 4706,
  [SMALL_STATE(378)] = 4710,
  [SMALL_STATE(379)] = 4714,
  [SMALL_STATE(380)] = 4718,
  [SMALL_STATE(381)] = 4722,
  [SMALL_STATE(382)] = 4726,
  [SMALL_STATE(383)] = 4730,
  [SMALL_STATE(384)] = 4734,
  [SMALL_STATE(385)] = 4738,
  [SMALL_STATE(386)] = 4742,
  [SMALL_STATE(387)] = 4746,
  [SMALL_STATE(388)] = 4750,
  [SMALL_STATE(389)] = 4754,
  [SMALL_STATE(390)] = 4758,
  [SMALL_STATE(391)] = 4762,
  [SMALL_STATE(392)] = 4766,
  [SMALL_STATE(393)] = 4770,
  [SMALL_STATE(394)] = 4774,
  [SMALL_STATE(395)] = 4778,
  [SMALL_STATE(396)] = 4782,
  [SMALL_STATE(397)] = 4786,
  [SMALL_STATE(398)] = 4790,
  [SMALL_STATE(399)] = 4794,
  [SMALL_STATE(400)] = 4798,
  [SMALL_STATE(401)] = 4802,
  [SMALL_STATE(402)] = 4806,
  [SMALL_STATE(403)] = 4810,
  [SMALL_STATE(404)] = 4814,
  [SMALL_STATE(405)] = 4818,
  [SMALL_STATE(406)] = 4822,
  [SMALL_STATE(407)] = 4826,
  [SMALL_STATE(408)] = 4830,
  [SMALL_STATE(409)] = 4834,
  [SMALL_STATE(410)] = 4838,
  [SMALL_STATE(411)] = 4842,
  [SMALL_STATE(412)] = 4846,
  [SMALL_STATE(413)] = 4850,
  [SMALL_STATE(414)] = 4854,
  [SMALL_STATE(415)] = 4858,
  [SMALL_STATE(416)] = 4862,
  [SMALL_STATE(417)] = 4866,
  [SMALL_STATE(418)] = 4870,
  [SMALL_STATE(419)] = 4874,
  [SMALL_STATE(420)] = 4878,
  [SMALL_STATE(421)] = 4882,
  [SMALL_STATE(422)] = 4886,
  [SMALL_STATE(423)] = 4890,
  [SMALL_STATE(424)] = 4894,
  [SMALL_STATE(425)] = 4898,
  [SMALL_STATE(426)] = 4902,
  [SMALL_STATE(427)] = 4906,
  [SMALL_STATE(428)] = 4910,
  [SMALL_STATE(429)] = 4914,
  [SMALL_STATE(430)] = 4918,
  [SMALL_STATE(431)] = 4922,
  [SMALL_STATE(432)] = 4926,
  [SMALL_STATE(433)] = 4930,
  [SMALL_STATE(434)] = 4934,
  [SMALL_STATE(435)] = 4938,
  [SMALL_STATE(436)] = 4942,
  [SMALL_STATE(437)] = 4946,
  [SMALL_STATE(438)] = 4950,
  [SMALL_STATE(439)] = 4954,
  [SMALL_STATE(440)] = 4958,
  [SMALL_STATE(441)] = 4962,
  [SMALL_STATE(442)] = 4966,
  [SMALL_STATE(443)] = 4970,
  [SMALL_STATE(444)] = 4974,
  [SMALL_STATE(445)] = 4978,
  [SMALL_STATE(446)] = 4982,
  [SMALL_STATE(447)] = 4986,
  [SMALL_STATE(448)] = 4990,
  [SMALL_STATE(449)] = 4994,
  [SMALL_STATE(450)] = 4998,
  [SMALL_STATE(451)] = 5002,
  [SMALL_STATE(452)] = 5006,
  [SMALL_STATE(453)] = 5010,
  [SMALL_STATE(454)] = 5014,
  [SMALL_STATE(455)] = 5018,
  [SMALL_STATE(456)] = 5022,
  [SMALL_STATE(457)] = 5026,
  [SMALL_STATE(458)] = 5030,
  [SMALL_STATE(459)] = 5034,
  [SMALL_STATE(460)] = 5038,
  [SMALL_STATE(461)] = 5042,
  [SMALL_STATE(462)] = 5046,
  [SMALL_STATE(463)] = 5050,
  [SMALL_STATE(464)] = 5054,
  [SMALL_STATE(465)] = 5058,
  [SMALL_STATE(466)] = 5062,
  [SMALL_STATE(467)] = 5066,
  [SMALL_STATE(468)] = 5070,
  [SMALL_STATE(469)] = 5074,
  [SMALL_STATE(470)] = 5078,
  [SMALL_STATE(471)] = 5082,
  [SMALL_STATE(472)] = 5086,
  [SMALL_STATE(473)] = 5090,
  [SMALL_STATE(474)] = 5094,
  [SMALL_STATE(475)] = 5098,
  [SMALL_STATE(476)] = 5102,
  [SMALL_STATE(477)] = 5106,
  [SMALL_STATE(478)] = 5110,
  [SMALL_STATE(479)] = 5114,
  [SMALL_STATE(480)] = 5118,
  [SMALL_STATE(481)] = 5122,
  [SMALL_STATE(482)] = 5126,
  [SMALL_STATE(483)] = 5130,
  [SMALL_STATE(484)] = 5134,
  [SMALL_STATE(485)] = 5138,
  [SMALL_STATE(486)] = 5142,
  [SMALL_STATE(487)] = 5146,
  [SMALL_STATE(488)] = 5150,
  [SMALL_STATE(489)] = 5154,
  [SMALL_STATE(490)] = 5158,
  [SMALL_STATE(491)] = 5162,
  [SMALL_STATE(492)] = 5166,
  [SMALL_STATE(493)] = 5170,
  [SMALL_STATE(494)] = 5174,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(462),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(475),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(429),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(426),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [31] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_content, 1, 0, 0),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [35] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_content_repeat1, 2, 0, 0), SHIFT_REPEAT(434),
  [38] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_content_repeat1, 2, 0, 0), SHIFT_REPEAT(475),
  [41] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_content_repeat1, 2, 0, 0),
  [43] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_content_repeat1, 2, 0, 0), SHIFT_REPEAT(430),
  [46] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_content_repeat1, 2, 0, 0), SHIFT_REPEAT(429),
  [49] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_content_repeat1, 2, 0, 0), SHIFT_REPEAT(426),
  [52] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_content_repeat1, 2, 0, 0), SHIFT_REPEAT(425),
  [55] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_content_repeat1, 2, 0, 0), SHIFT_REPEAT(5),
  [58] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [60] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [62] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [64] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [66] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [68] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [70] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [72] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__intSubset, 2, 0, 0), SHIFT_REPEAT(476),
  [75] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__intSubset, 2, 0, 0), SHIFT_REPEAT(215),
  [78] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__intSubset, 2, 0, 0),
  [80] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__intSubset, 2, 0, 0), SHIFT_REPEAT(30),
  [83] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__intSubset, 2, 0, 0), SHIFT_REPEAT(290),
  [86] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [88] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [90] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [92] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [94] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [96] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [98] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [100] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_prolog, 1, 0, 0),
  [102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [110] = {.entry = {.count = 1, .reusable = false}}, SHIFT(488),
  [112] = {.entry = {.count = 1, .reusable = false}}, SHIFT(489),
  [114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [120] = {.entry = {.count = 1, .reusable = false}}, SHIFT(492),
  [122] = {.entry = {.count = 1, .reusable = false}}, SHIFT(493),
  [124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [126] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_prolog, 2, 0, 0),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__cp, 1, 0, 0),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_EntityValue_repeat2, 2, 0, 0),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_EntityValue_repeat2, 2, 0, 0), SHIFT_REPEAT(487),
  [155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_EntityValue_repeat2, 2, 0, 0), SHIFT_REPEAT(29),
  [158] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_EntityValue_repeat2, 2, 0, 0), SHIFT_REPEAT(488),
  [161] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_EntityValue_repeat2, 2, 0, 0), SHIFT_REPEAT(489),
  [164] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_EntityValue_repeat2, 2, 0, 0), SHIFT_REPEAT(490),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_EntityValue_repeat1, 2, 0, 0),
  [169] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_EntityValue_repeat1, 2, 0, 0), SHIFT_REPEAT(491),
  [172] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_EntityValue_repeat1, 2, 0, 0), SHIFT_REPEAT(31),
  [175] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_EntityValue_repeat1, 2, 0, 0), SHIFT_REPEAT(492),
  [178] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_EntityValue_repeat1, 2, 0, 0), SHIFT_REPEAT(493),
  [181] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_EntityValue_repeat1, 2, 0, 0), SHIFT_REPEAT(494),
  [184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0),
  [186] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(233),
  [189] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0),
  [191] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(33),
  [194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_PEReference, 3, 0, 0),
  [196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__choice, 4, 0, 0),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ETag, 4, 0, 0),
  [200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ETag, 4, 0, 0),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_EmptyElemTag, 3, 0, 0),
  [204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_EmptyElemTag, 3, 0, 0),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_PI, 3, 0, 0),
  [208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_PI, 3, 0, 0),
  [210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 2, 0, 0),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 2, 0, 0),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__Reference, 1, 0, 0),
  [216] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__Reference, 1, 0, 0),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [222] = {.entry = {.count = 1, .reusable = false}}, SHIFT(478),
  [224] = {.entry = {.count = 1, .reusable = false}}, SHIFT(479),
  [226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 1, 0, 0),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 1, 0, 0),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [236] = {.entry = {.count = 1, .reusable = false}}, SHIFT(483),
  [238] = {.entry = {.count = 1, .reusable = false}}, SHIFT(484),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__choice, 7, 0, 0),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__choice, 6, 0, 0),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STag, 3, 0, 0),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STag, 3, 0, 0),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__choice, 5, 0, 0),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 3, 0, 3),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 3, 0, 2),
  [284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_prolog, 3, 0, 0),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1, 0, 1),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STag, 5, 0, 0),
  [296] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STag, 5, 0, 0),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_CDSect, 2, 0, 0),
  [302] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_CDSect, 2, 0, 0),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_EmptyElemTag, 4, 0, 0),
  [306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_EmptyElemTag, 4, 0, 0),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__choice, 3, 0, 0),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_PseudoAttValue_repeat2, 2, 0, 0),
  [312] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_PseudoAttValue_repeat2, 2, 0, 0), SHIFT_REPEAT(69),
  [315] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_PseudoAttValue_repeat2, 2, 0, 0), SHIFT_REPEAT(478),
  [318] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_PseudoAttValue_repeat2, 2, 0, 0), SHIFT_REPEAT(479),
  [321] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_PseudoAttValue_repeat2, 2, 0, 0), SHIFT_REPEAT(480),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ETag, 3, 0, 0),
  [326] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ETag, 3, 0, 0),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_PseudoAttValue_repeat1, 2, 0, 0),
  [330] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_PseudoAttValue_repeat1, 2, 0, 0), SHIFT_REPEAT(71),
  [333] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_PseudoAttValue_repeat1, 2, 0, 0), SHIFT_REPEAT(483),
  [336] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_PseudoAttValue_repeat1, 2, 0, 0), SHIFT_REPEAT(484),
  [339] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_PseudoAttValue_repeat1, 2, 0, 0), SHIFT_REPEAT(485),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 2, 0, 2),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_CDSect, 3, 0, 0),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_CDSect, 3, 0, 0),
  [356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_PI, 5, 0, 0),
  [358] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_PI, 5, 0, 0),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_CharRef, 3, 0, 0),
  [362] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_CharRef, 3, 0, 0),
  [364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_EmptyElemTag, 5, 0, 0),
  [366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_EmptyElemTag, 5, 0, 0),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_EntityRef, 3, 0, 0),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_EntityRef, 3, 0, 0),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STag, 4, 0, 0),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STag, 4, 0, 0),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 3, 0, 0),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 3, 0, 0),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 2, 0, 1),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_prolog, 4, 0, 0),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 4, 0, 3),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [442] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_StyleSheetPI, 5, 0, 0),
  [444] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_StyleSheetPI, 5, 0, 0),
  [446] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_XmlModelPI, 5, 0, 0),
  [448] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_XmlModelPI, 5, 0, 0),
  [450] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_StyleSheetPI, 4, 0, 0),
  [452] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_StyleSheetPI, 4, 0, 0),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [456] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_PEReference, 3, 0, 0),
  [458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_XmlModelPI, 4, 0, 0),
  [460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_XmlModelPI, 4, 0, 0),
  [462] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__choice_repeat1, 2, 0, 0), SHIFT_REPEAT(97),
  [465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__choice_repeat1, 2, 0, 0),
  [467] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__choice_repeat1, 2, 0, 0), SHIFT_REPEAT(357),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_XmlModelPI, 3, 0, 0),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_XmlModelPI, 3, 0, 0),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_StyleSheetPI, 3, 0, 0),
  [484] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_StyleSheetPI, 3, 0, 0),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_XMLDecl, 6, 0, 0),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_XMLDecl, 6, 0, 0),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__cp, 2, 0, 0),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_XMLDecl, 4, 0, 0),
  [500] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_XMLDecl, 4, 0, 0),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [504] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_Mixed_repeat1, 2, 0, 0), SHIFT_REPEAT(170),
  [507] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_Mixed_repeat1, 2, 0, 0),
  [509] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_Mixed_repeat1, 2, 0, 0), SHIFT_REPEAT(401),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_children, 1, 0, 0),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_XMLDecl, 5, 0, 0),
  [522] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_XMLDecl, 5, 0, 0),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__choice_repeat2, 2, 0, 0),
  [526] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__choice_repeat2, 2, 0, 0), SHIFT_REPEAT(482),
  [529] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__choice_repeat2, 2, 0, 0), SHIFT_REPEAT(358),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [534] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_XMLDecl, 7, 0, 0),
  [536] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_XMLDecl, 7, 0, 0),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__intSubset, 3, 0, 0),
  [542] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_NotationType_repeat1, 2, 0, 0),
  [544] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_NotationType_repeat1, 2, 0, 0), SHIFT_REPEAT(168),
  [547] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_NotationType_repeat1, 2, 0, 0), SHIFT_REPEAT(398),
  [550] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__choice_repeat1, 3, 0, 0),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__choice_repeat1, 4, 0, 0),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_NotationType_repeat1, 3, 0, 0),
  [562] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_NotationType_repeat1, 2, 0, 0), SHIFT_REPEAT(160),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [569] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctypedecl, 7, 0, 0),
  [571] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctypedecl, 7, 0, 0),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_NotationType_repeat1, 1, 0, 0),
  [585] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_NotationType_repeat1, 1, 0, 0), SHIFT_REPEAT(162),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctypedecl, 12, 0, 0),
  [600] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctypedecl, 12, 0, 0),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_EmptyElemTag_repeat1, 2, 0, 0),
  [606] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_EmptyElemTag_repeat1, 2, 0, 0), SHIFT_REPEAT(352),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [611] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctypedecl, 11, 0, 0),
  [613] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctypedecl, 11, 0, 0),
  [615] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_Enumeration_repeat1, 2, 0, 0), SHIFT_REPEAT(360),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_Enumeration_repeat1, 2, 0, 0),
  [620] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_Enumeration_repeat1, 2, 0, 0), SHIFT_REPEAT(395),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctypedecl, 5, 0, 0),
  [635] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctypedecl, 5, 0, 0),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_AttlistDecl_repeat1, 2, 0, 0),
  [645] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_AttlistDecl_repeat1, 2, 0, 0), SHIFT_REPEAT(258),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [650] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctypedecl, 8, 0, 0),
  [652] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctypedecl, 8, 0, 0),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [660] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctypedecl, 6, 0, 0),
  [662] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctypedecl, 6, 0, 0),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_Mixed_repeat1, 4, 0, 0),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_Mixed_repeat2, 2, 0, 0),
  [676] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_Mixed_repeat2, 2, 0, 0), SHIFT_REPEAT(482),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctypedecl, 9, 0, 0),
  [689] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctypedecl, 9, 0, 0),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctypedecl, 10, 0, 0),
  [697] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctypedecl, 10, 0, 0),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_Mixed_repeat1, 3, 0, 0),
  [705] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_Enumeration_repeat1, 4, 0, 0),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [743] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Attribute, 3, 0, 0),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [747] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_SystemLiteral, 3, 0, 0),
  [749] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ExternalID, 5, 0, 0),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Mixed, 5, 0, 0),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [769] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_AttValue, 3, 0, 4),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ExternalID, 3, 0, 0),
  [777] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Mixed, 6, 0, 0),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Mixed, 4, 0, 0),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [793] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__Eq, 1, 0, 0),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_AttValue, 2, 0, 0),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_StyleSheetPI_repeat1, 2, 0, 0),
  [829] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_StyleSheetPI_repeat1, 2, 0, 0), SHIFT_REPEAT(356),
  [832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__Eq, 2, 0, 0),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Mixed, 3, 0, 0),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_Enumeration_repeat1, 3, 0, 0),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_Mixed_repeat2, 1, 0, 0),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_AttlistDecl, 5, 0, 0),
  [862] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_AttlistDecl, 7, 0, 0),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_EntityValue, 2, 0, 0),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_children, 2, 0, 0),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_GEDecl, 7, 0, 0),
  [874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elementdecl, 7, 0, 0),
  [886] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NotationDecl, 7, 0, 0),
  [888] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__markupdecl, 1, 0, 0),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elementdecl, 8, 0, 0),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_StringType, 1, 0, 0),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [902] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__AttType, 1, 0, 0),
  [904] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__EntityDecl, 1, 0, 0),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_AttDef, 4, 0, 0),
  [908] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__EnumeratedType, 1, 0, 0),
  [912] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_PublicID, 3, 0, 0),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [916] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NotationDecl, 8, 0, 0),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [922] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_EntityValue, 3, 0, 4),
  [924] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_CDStart, 3, 0, 0),
  [926] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_PseudoAtt, 3, 0, 0),
  [928] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_GEDecl, 8, 0, 0),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [950] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__Eq, 3, 0, 0),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [956] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_AttlistDecl_repeat1, 2, 0, 0), SHIFT(25),
  [959] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_AttlistDecl, 6, 0, 0),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contentspec, 1, 0, 0),
  [971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_PseudoAttValue, 2, 0, 0),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_PubidLiteral, 3, 0, 0),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [993] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NotationType, 9, 0, 0),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NotationType, 8, 0, 0),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1001] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_PEDecl, 9, 0, 0),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1007] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NotationType, 7, 0, 0),
  [1009] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_GEDecl, 9, 0, 0),
  [1011] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NotationType, 6, 0, 0),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1021] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Enumeration, 6, 0, 0),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Mixed, 8, 0, 0),
  [1025] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_DefaultDecl, 3, 0, 0),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1035] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__EncodingDecl, 6, 0, 0),
  [1037] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__SDDecl, 6, 0, 0),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1049] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Enumeration, 3, 0, 0),
  [1051] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Enumeration, 5, 0, 0),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1055] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_DefaultDecl, 1, 0, 0),
  [1057] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Mixed, 7, 0, 0),
  [1059] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_AttDef, 6, 0, 0),
  [1061] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_PEDecl, 10, 0, 0),
  [1063] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NDataDecl, 4, 0, 0),
  [1065] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__VersionInfo, 6, 0, 0),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1071] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_PseudoAttValue, 3, 0, 4),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1077] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_Enumeration, 4, 0, 0),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1205] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_PITarget = 0,
  ts_external_token__pi_content = 1,
  ts_external_token_Comment = 2,
  ts_external_token_CharData = 3,
  ts_external_token_CData = 4,
  ts_external_token_xml_DASHmodel = 5,
  ts_external_token_xml_DASHstylesheet = 6,
  ts_external_token__start_tag_name = 7,
  ts_external_token__end_tag_name = 8,
  ts_external_token__erroneous_end_name = 9,
  ts_external_token_SLASH_GT = 10,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_PITarget] = sym_PITarget,
  [ts_external_token__pi_content] = sym__pi_content,
  [ts_external_token_Comment] = sym_Comment,
  [ts_external_token_CharData] = sym_CharData,
  [ts_external_token_CData] = sym_CData,
  [ts_external_token_xml_DASHmodel] = anon_sym_xml_DASHmodel,
  [ts_external_token_xml_DASHstylesheet] = anon_sym_xml_DASHstylesheet,
  [ts_external_token__start_tag_name] = sym__start_tag_name,
  [ts_external_token__end_tag_name] = sym__end_tag_name,
  [ts_external_token__erroneous_end_name] = sym__erroneous_end_name,
  [ts_external_token_SLASH_GT] = anon_sym_SLASH_GT,
};

static const bool ts_external_scanner_states[11][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_PITarget] = true,
    [ts_external_token__pi_content] = true,
    [ts_external_token_Comment] = true,
    [ts_external_token_CharData] = true,
    [ts_external_token_CData] = true,
    [ts_external_token_xml_DASHmodel] = true,
    [ts_external_token_xml_DASHstylesheet] = true,
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__end_tag_name] = true,
    [ts_external_token__erroneous_end_name] = true,
    [ts_external_token_SLASH_GT] = true,
  },
  [2] = {
    [ts_external_token_Comment] = true,
  },
  [3] = {
    [ts_external_token_Comment] = true,
    [ts_external_token_CharData] = true,
  },
  [4] = {
    [ts_external_token_SLASH_GT] = true,
  },
  [5] = {
    [ts_external_token_PITarget] = true,
    [ts_external_token_xml_DASHmodel] = true,
    [ts_external_token_xml_DASHstylesheet] = true,
  },
  [6] = {
    [ts_external_token_CData] = true,
  },
  [7] = {
    [ts_external_token__pi_content] = true,
  },
  [8] = {
    [ts_external_token_PITarget] = true,
  },
  [9] = {
    [ts_external_token__end_tag_name] = true,
  },
  [10] = {
    [ts_external_token__start_tag_name] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_xml_external_scanner_create(void);
void tree_sitter_xml_external_scanner_destroy(void *);
bool tree_sitter_xml_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_xml_external_scanner_serialize(void *, char *);
void tree_sitter_xml_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_xml(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_Name,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_xml_external_scanner_create,
      tree_sitter_xml_external_scanner_destroy,
      tree_sitter_xml_external_scanner_scan,
      tree_sitter_xml_external_scanner_serialize,
      tree_sitter_xml_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
