#!/bin/sh
# create a new debian package for MoleInvasion

VERSION="0.4"
MOLE_DIR=moleinvasion-$VERSION
OUTDIR=/tmp/$$/$MOLE_DIR

if [ "$(basename $PWD)" != "debian" ]
then
	echo "You're not in the debian directory ..."
	exit 1
fi

echo "Copying for building in $OUTDIR ..."
mkdir -p $OUTDIR || exit 2
# copy base dir to build dir
cd ..
cp -rfp debian/ font/ gfx/ lin/ lvl/ snd/ src/ txt/ music/ $OUTDIR || exit 2
#mkdir -p $OUTDIR/music/
cd $OUTDIR || exit 2

#clean
find . -type d -name ".svn" -exec rm -rf {} \; 2>/dev/null

#saving devian/
mv debian/ ..

#creating tarball
cd ..
tar cvfz moleinvasion_$VERSION.orig.tar.gz $MOLE_DIR/

#restore devian/
mv debian/ $MOLE_DIR/
cd $MOLE_DIR/

#build
dpkg-buildpackage -rfakeroot -uc -us
if [ $? -ne 0 ]
then
	echo "Error in creating package ..."
	exit 1
fi

# verif
cd ..
lintian -X menus -vi *.changes
pwd
ls -l
