package bluetoothemulation

import (
	"fmt"
	"strings"
)

// Code generated by cdproto-gen. DO NOT EDIT.

// CentralState indicates the various states of Central.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-CentralState
type CentralState string

// String returns the CentralState as string value.
func (t CentralState) String() string {
	return string(t)
}

// CentralState values.
const (
	CentralStateAbsent     CentralState = "absent"
	CentralStatePoweredOff CentralState = "powered-off"
	CentralStatePoweredOn  CentralState = "powered-on"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CentralState) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CentralState(s) {
	case CentralStateAbsent:
		*t = CentralStateAbsent
	case CentralStatePoweredOff:
		*t = CentralStatePoweredOff
	case CentralStatePoweredOn:
		*t = CentralStatePoweredOn
	default:
		return fmt.Errorf("unknown CentralState value: %v", s)
	}
	return nil
}

// GATTOperationType indicates the various types of GATT event.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-GATTOperationType
type GATTOperationType string

// String returns the GATTOperationType as string value.
func (t GATTOperationType) String() string {
	return string(t)
}

// GATTOperationType values.
const (
	GATTOperationTypeConnection GATTOperationType = "connection"
	GATTOperationTypeDiscovery  GATTOperationType = "discovery"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *GATTOperationType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch GATTOperationType(s) {
	case GATTOperationTypeConnection:
		*t = GATTOperationTypeConnection
	case GATTOperationTypeDiscovery:
		*t = GATTOperationTypeDiscovery
	default:
		return fmt.Errorf("unknown GATTOperationType value: %v", s)
	}
	return nil
}

// ManufacturerData stores the manufacturer data.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-ManufacturerData
type ManufacturerData struct {
	Key  int64  `json:"key"`  // Company identifier https://bitbucket.org/bluetooth-SIG/public/src/main/assigned_numbers/company_identifiers/company_identifiers.yaml https://usb.org/developers
	Data string `json:"data"` // Manufacturer-specific data
}

// ScanRecord stores the byte data of the advertisement packet sent by a
// Bluetooth device.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-ScanRecord
type ScanRecord struct {
	Name             string              `json:"name,omitempty,omitzero"`
	UUIDs            []string            `json:"uuids,omitempty,omitzero"`
	Appearance       int64               `json:"appearance,omitempty,omitzero"`       // Stores the external appearance description of the device.
	TxPower          int64               `json:"txPower,omitempty,omitzero"`          // Stores the transmission power of a broadcasting device.
	ManufacturerData []*ManufacturerData `json:"manufacturerData,omitempty,omitzero"` // Key is the company identifier and the value is an array of bytes of manufacturer specific data.
}

// ScanEntry stores the advertisement packet information that is sent by a
// Bluetooth device.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-ScanEntry
type ScanEntry struct {
	DeviceAddress string      `json:"deviceAddress"`
	Rssi          int64       `json:"rssi"`
	ScanRecord    *ScanRecord `json:"scanRecord"`
}

// CharacteristicProperties describes the properties of a characteristic.
// This follows Bluetooth Core Specification BT 4.2 Vol 3 Part G 3.3.1.
// Characteristic Properties.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-CharacteristicProperties
type CharacteristicProperties struct {
	Broadcast                 bool `json:"broadcast"`
	Read                      bool `json:"read"`
	WriteWithoutResponse      bool `json:"writeWithoutResponse"`
	Write                     bool `json:"write"`
	Notify                    bool `json:"notify"`
	Indicate                  bool `json:"indicate"`
	AuthenticatedSignedWrites bool `json:"authenticatedSignedWrites"`
	ExtendedProperties        bool `json:"extendedProperties"`
}
