package pwa

import (
	"fmt"
	"strings"
)

// Code generated by cdproto-gen. DO NOT EDIT.

// FileHandlerAccept the following types are the replica of
// https://crsrc.org/c/chrome/browser/web_applications/proto/web_app_os_integration_state.proto;drc=9910d3be894c8f142c977ba1023f30a656bc13fc;l=67.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PWA#type-FileHandlerAccept
type FileHandlerAccept struct {
	MediaType      string   `json:"mediaType"` // New name of the mimetype according to https://www.iana.org/assignments/media-types/media-types.xhtml
	FileExtensions []string `json:"fileExtensions"`
}

// FileHandler [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PWA#type-FileHandler
type FileHandler struct {
	Action      string               `json:"action"`
	Accepts     []*FileHandlerAccept `json:"accepts"`
	DisplayName string               `json:"displayName"`
}

// DisplayMode if user prefers opening the app in browser or an app window.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PWA#type-DisplayMode
type DisplayMode string

// String returns the DisplayMode as string value.
func (t DisplayMode) String() string {
	return string(t)
}

// DisplayMode values.
const (
	DisplayModeStandalone DisplayMode = "standalone"
	DisplayModeBrowser    DisplayMode = "browser"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *DisplayMode) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch DisplayMode(s) {
	case DisplayModeStandalone:
		*t = DisplayModeStandalone
	case DisplayModeBrowser:
		*t = DisplayModeBrowser
	default:
		return fmt.Errorf("unknown DisplayMode value: %v", s)
	}
	return nil
}
