// Package target provides the Chrome DevTools Protocol
// commands, types, and events for the Target domain.
//
// Supports additional targets discovery and allows to attach to them.
//
// Generated by the cdproto-gen command.
package target

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// ActivateTargetParams activates (focuses) the target.
type ActivateTargetParams struct {
	TargetID ID `json:"targetId"`
}

// ActivateTarget activates (focuses) the target.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-activateTarget
//
// parameters:
//
//	targetID
func ActivateTarget(targetID ID) *ActivateTargetParams {
	return &ActivateTargetParams{
		TargetID: targetID,
	}
}

// Do executes Target.activateTarget against the provided context.
func (p *ActivateTargetParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandActivateTarget, p, nil)
}

// AttachToTargetParams attaches to the target with given id.
type AttachToTargetParams struct {
	TargetID ID   `json:"targetId"`
	Flatten  bool `json:"flatten"` // Enables "flat" access to the session via specifying sessionId attribute in the commands. We plan to make this the default, deprecate non-flattened mode, and eventually retire it. See crbug.com/991325.
}

// AttachToTarget attaches to the target with given id.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-attachToTarget
//
// parameters:
//
//	targetID
func AttachToTarget(targetID ID) *AttachToTargetParams {
	return &AttachToTargetParams{
		TargetID: targetID,
		Flatten:  false,
	}
}

// WithFlatten enables "flat" access to the session via specifying sessionId
// attribute in the commands. We plan to make this the default, deprecate
// non-flattened mode, and eventually retire it. See crbug.com/991325.
func (p AttachToTargetParams) WithFlatten(flatten bool) *AttachToTargetParams {
	p.Flatten = flatten
	return &p
}

// AttachToTargetReturns return values.
type AttachToTargetReturns struct {
	SessionID SessionID `json:"sessionId,omitempty,omitzero"` // Id assigned to the session.
}

// Do executes Target.attachToTarget against the provided context.
//
// returns:
//
//	sessionID - Id assigned to the session.
func (p *AttachToTargetParams) Do(ctx context.Context) (sessionID SessionID, err error) {
	// execute
	var res AttachToTargetReturns
	err = cdp.Execute(ctx, CommandAttachToTarget, p, &res)
	if err != nil {
		return "", err
	}

	return res.SessionID, nil
}

// AttachToBrowserTargetParams attaches to the browser target, only uses flat
// sessionId mode.
type AttachToBrowserTargetParams struct{}

// AttachToBrowserTarget attaches to the browser target, only uses flat
// sessionId mode.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-attachToBrowserTarget
func AttachToBrowserTarget() *AttachToBrowserTargetParams {
	return &AttachToBrowserTargetParams{}
}

// AttachToBrowserTargetReturns return values.
type AttachToBrowserTargetReturns struct {
	SessionID SessionID `json:"sessionId,omitempty,omitzero"` // Id assigned to the session.
}

// Do executes Target.attachToBrowserTarget against the provided context.
//
// returns:
//
//	sessionID - Id assigned to the session.
func (p *AttachToBrowserTargetParams) Do(ctx context.Context) (sessionID SessionID, err error) {
	// execute
	var res AttachToBrowserTargetReturns
	err = cdp.Execute(ctx, CommandAttachToBrowserTarget, nil, &res)
	if err != nil {
		return "", err
	}

	return res.SessionID, nil
}

// CloseTargetParams closes the target. If the target is a page that gets
// closed too.
type CloseTargetParams struct {
	TargetID ID `json:"targetId"`
}

// CloseTarget closes the target. If the target is a page that gets closed
// too.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-closeTarget
//
// parameters:
//
//	targetID
func CloseTarget(targetID ID) *CloseTargetParams {
	return &CloseTargetParams{
		TargetID: targetID,
	}
}

// Do executes Target.closeTarget against the provided context.
func (p *CloseTargetParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandCloseTarget, p, nil)
}

// ExposeDevToolsProtocolParams inject object to the target's main frame that
// provides a communication channel with browser target. Injected object will be
// available as window[bindingName]. The object has the following API: -
// binding.send(json) - a method to send messages over the remote debugging
// protocol - binding.onmessage = json => handleMessage(json) - a callback that
// will be called for the protocol notifications and command responses.
type ExposeDevToolsProtocolParams struct {
	TargetID           ID     `json:"targetId"`
	BindingName        string `json:"bindingName,omitempty,omitzero"` // Binding name, 'cdp' if not specified.
	InheritPermissions bool   `json:"inheritPermissions"`             // If true, inherits the current root session's permissions (default: false).
}

// ExposeDevToolsProtocol inject object to the target's main frame that
// provides a communication channel with browser target. Injected object will be
// available as window[bindingName]. The object has the following API: -
// binding.send(json) - a method to send messages over the remote debugging
// protocol - binding.onmessage = json => handleMessage(json) - a callback that
// will be called for the protocol notifications and command responses.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-exposeDevToolsProtocol
//
// parameters:
//
//	targetID
func ExposeDevToolsProtocol(targetID ID) *ExposeDevToolsProtocolParams {
	return &ExposeDevToolsProtocolParams{
		TargetID:           targetID,
		InheritPermissions: false,
	}
}

// WithBindingName binding name, 'cdp' if not specified.
func (p ExposeDevToolsProtocolParams) WithBindingName(bindingName string) *ExposeDevToolsProtocolParams {
	p.BindingName = bindingName
	return &p
}

// WithInheritPermissions if true, inherits the current root session's
// permissions (default: false).
func (p ExposeDevToolsProtocolParams) WithInheritPermissions(inheritPermissions bool) *ExposeDevToolsProtocolParams {
	p.InheritPermissions = inheritPermissions
	return &p
}

// Do executes Target.exposeDevToolsProtocol against the provided context.
func (p *ExposeDevToolsProtocolParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandExposeDevToolsProtocol, p, nil)
}

// CreateBrowserContextParams creates a new empty BrowserContext. Similar to
// an incognito profile but you can have more than one.
type CreateBrowserContextParams struct {
	DisposeOnDetach                   bool     `json:"disposeOnDetach"`                                      // If specified, disposes this context when debugging session disconnects.
	ProxyServer                       string   `json:"proxyServer,omitempty,omitzero"`                       // Proxy server, similar to the one passed to --proxy-server
	ProxyBypassList                   string   `json:"proxyBypassList,omitempty,omitzero"`                   // Proxy bypass list, similar to the one passed to --proxy-bypass-list
	OriginsWithUniversalNetworkAccess []string `json:"originsWithUniversalNetworkAccess,omitempty,omitzero"` // An optional list of origins to grant unlimited cross-origin access to. Parts of the URL other than those constituting origin are ignored.
}

// CreateBrowserContext creates a new empty BrowserContext. Similar to an
// incognito profile but you can have more than one.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-createBrowserContext
//
// parameters:
func CreateBrowserContext() *CreateBrowserContextParams {
	return &CreateBrowserContextParams{
		DisposeOnDetach: false,
	}
}

// WithDisposeOnDetach if specified, disposes this context when debugging
// session disconnects.
func (p CreateBrowserContextParams) WithDisposeOnDetach(disposeOnDetach bool) *CreateBrowserContextParams {
	p.DisposeOnDetach = disposeOnDetach
	return &p
}

// WithProxyServer proxy server, similar to the one passed to --proxy-server.
func (p CreateBrowserContextParams) WithProxyServer(proxyServer string) *CreateBrowserContextParams {
	p.ProxyServer = proxyServer
	return &p
}

// WithProxyBypassList proxy bypass list, similar to the one passed to
// --proxy-bypass-list.
func (p CreateBrowserContextParams) WithProxyBypassList(proxyBypassList string) *CreateBrowserContextParams {
	p.ProxyBypassList = proxyBypassList
	return &p
}

// WithOriginsWithUniversalNetworkAccess an optional list of origins to grant
// unlimited cross-origin access to. Parts of the URL other than those
// constituting origin are ignored.
func (p CreateBrowserContextParams) WithOriginsWithUniversalNetworkAccess(originsWithUniversalNetworkAccess []string) *CreateBrowserContextParams {
	p.OriginsWithUniversalNetworkAccess = originsWithUniversalNetworkAccess
	return &p
}

// CreateBrowserContextReturns return values.
type CreateBrowserContextReturns struct {
	BrowserContextID cdp.BrowserContextID `json:"browserContextId,omitempty,omitzero"` // The id of the context created.
}

// Do executes Target.createBrowserContext against the provided context.
//
// returns:
//
//	browserContextID - The id of the context created.
func (p *CreateBrowserContextParams) Do(ctx context.Context) (browserContextID cdp.BrowserContextID, err error) {
	// execute
	var res CreateBrowserContextReturns
	err = cdp.Execute(ctx, CommandCreateBrowserContext, p, &res)
	if err != nil {
		return "", err
	}

	return res.BrowserContextID, nil
}

// GetBrowserContextsParams returns all browser contexts created with
// Target.createBrowserContext method.
type GetBrowserContextsParams struct{}

// GetBrowserContexts returns all browser contexts created with
// Target.createBrowserContext method.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-getBrowserContexts
func GetBrowserContexts() *GetBrowserContextsParams {
	return &GetBrowserContextsParams{}
}

// GetBrowserContextsReturns return values.
type GetBrowserContextsReturns struct {
	BrowserContextIDs []cdp.BrowserContextID `json:"browserContextIds,omitempty,omitzero"` // An array of browser context ids.
}

// Do executes Target.getBrowserContexts against the provided context.
//
// returns:
//
//	browserContextIDs - An array of browser context ids.
func (p *GetBrowserContextsParams) Do(ctx context.Context) (browserContextIDs []cdp.BrowserContextID, err error) {
	// execute
	var res GetBrowserContextsReturns
	err = cdp.Execute(ctx, CommandGetBrowserContexts, nil, &res)
	if err != nil {
		return nil, err
	}

	return res.BrowserContextIDs, nil
}

// CreateTargetParams creates a new page.
type CreateTargetParams struct {
	URL                     string               `json:"url"`                                 // The initial URL the page will be navigated to. An empty string indicates about:blank.
	Left                    int64                `json:"left,omitempty,omitzero"`             // Frame left origin in DIP (requires newWindow to be true or headless shell).
	Top                     int64                `json:"top,omitempty,omitzero"`              // Frame top origin in DIP (requires newWindow to be true or headless shell).
	Width                   int64                `json:"width,omitempty,omitzero"`            // Frame width in DIP (requires newWindow to be true or headless shell).
	Height                  int64                `json:"height,omitempty,omitzero"`           // Frame height in DIP (requires newWindow to be true or headless shell).
	WindowState             WindowState          `json:"windowState,omitempty,omitzero"`      // Frame window state (requires newWindow to be true or headless shell). Default is normal.
	BrowserContextID        cdp.BrowserContextID `json:"browserContextId,omitempty,omitzero"` // The browser context to create the page in.
	EnableBeginFrameControl bool                 `json:"enableBeginFrameControl"`             // Whether BeginFrames for this target will be controlled via DevTools (headless shell only, not supported on MacOS yet, false by default).
	NewWindow               bool                 `json:"newWindow"`                           // Whether to create a new Window or Tab (false by default, not supported by headless shell).
	Background              bool                 `json:"background"`                          // Whether to create the target in background or foreground (false by default, not supported by headless shell).
	ForTab                  bool                 `json:"forTab"`                              // Whether to create the target of type "tab".
	Hidden                  bool                 `json:"hidden"`                              // Whether to create a hidden target. The hidden target is observable via protocol, but not present in the tab UI strip. Cannot be created with forTab: true, newWindow: true or background: false. The life-time of the tab is limited to the life-time of the session.
}

// CreateTarget creates a new page.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-createTarget
//
// parameters:
//
//	url - The initial URL the page will be navigated to. An empty string indicates about:blank.
func CreateTarget(url string) *CreateTargetParams {
	return &CreateTargetParams{
		URL:                     url,
		EnableBeginFrameControl: false,
		NewWindow:               false,
		Background:              false,
		ForTab:                  false,
		Hidden:                  false,
	}
}

// WithLeft frame left origin in DIP (requires newWindow to be true or
// headless shell).
func (p CreateTargetParams) WithLeft(left int64) *CreateTargetParams {
	p.Left = left
	return &p
}

// WithTop frame top origin in DIP (requires newWindow to be true or headless
// shell).
func (p CreateTargetParams) WithTop(top int64) *CreateTargetParams {
	p.Top = top
	return &p
}

// WithWidth frame width in DIP (requires newWindow to be true or headless
// shell).
func (p CreateTargetParams) WithWidth(width int64) *CreateTargetParams {
	p.Width = width
	return &p
}

// WithHeight frame height in DIP (requires newWindow to be true or headless
// shell).
func (p CreateTargetParams) WithHeight(height int64) *CreateTargetParams {
	p.Height = height
	return &p
}

// WithWindowState frame window state (requires newWindow to be true or
// headless shell). Default is normal.
func (p CreateTargetParams) WithWindowState(windowState WindowState) *CreateTargetParams {
	p.WindowState = windowState
	return &p
}

// WithBrowserContextID the browser context to create the page in.
func (p CreateTargetParams) WithBrowserContextID(browserContextID cdp.BrowserContextID) *CreateTargetParams {
	p.BrowserContextID = browserContextID
	return &p
}

// WithEnableBeginFrameControl whether BeginFrames for this target will be
// controlled via DevTools (headless shell only, not supported on MacOS yet,
// false by default).
func (p CreateTargetParams) WithEnableBeginFrameControl(enableBeginFrameControl bool) *CreateTargetParams {
	p.EnableBeginFrameControl = enableBeginFrameControl
	return &p
}

// WithNewWindow whether to create a new Window or Tab (false by default, not
// supported by headless shell).
func (p CreateTargetParams) WithNewWindow(newWindow bool) *CreateTargetParams {
	p.NewWindow = newWindow
	return &p
}

// WithBackground whether to create the target in background or foreground
// (false by default, not supported by headless shell).
func (p CreateTargetParams) WithBackground(background bool) *CreateTargetParams {
	p.Background = background
	return &p
}

// WithForTab whether to create the target of type "tab".
func (p CreateTargetParams) WithForTab(forTab bool) *CreateTargetParams {
	p.ForTab = forTab
	return &p
}

// WithHidden whether to create a hidden target. The hidden target is
// observable via protocol, but not present in the tab UI strip. Cannot be
// created with forTab: true, newWindow: true or background: false. The
// life-time of the tab is limited to the life-time of the session.
func (p CreateTargetParams) WithHidden(hidden bool) *CreateTargetParams {
	p.Hidden = hidden
	return &p
}

// CreateTargetReturns return values.
type CreateTargetReturns struct {
	TargetID ID `json:"targetId,omitempty,omitzero"` // The id of the page opened.
}

// Do executes Target.createTarget against the provided context.
//
// returns:
//
//	targetID - The id of the page opened.
func (p *CreateTargetParams) Do(ctx context.Context) (targetID ID, err error) {
	// execute
	var res CreateTargetReturns
	err = cdp.Execute(ctx, CommandCreateTarget, p, &res)
	if err != nil {
		return "", err
	}

	return res.TargetID, nil
}

// DetachFromTargetParams detaches session with given id.
type DetachFromTargetParams struct {
	SessionID SessionID `json:"sessionId,omitempty,omitzero"` // Session to detach.
}

// DetachFromTarget detaches session with given id.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-detachFromTarget
//
// parameters:
func DetachFromTarget() *DetachFromTargetParams {
	return &DetachFromTargetParams{}
}

// WithSessionID session to detach.
func (p DetachFromTargetParams) WithSessionID(sessionID SessionID) *DetachFromTargetParams {
	p.SessionID = sessionID
	return &p
}

// Do executes Target.detachFromTarget against the provided context.
func (p *DetachFromTargetParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDetachFromTarget, p, nil)
}

// DisposeBrowserContextParams deletes a BrowserContext. All the belonging
// pages will be closed without calling their beforeunload hooks.
type DisposeBrowserContextParams struct {
	BrowserContextID cdp.BrowserContextID `json:"browserContextId"`
}

// DisposeBrowserContext deletes a BrowserContext. All the belonging pages
// will be closed without calling their beforeunload hooks.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-disposeBrowserContext
//
// parameters:
//
//	browserContextID
func DisposeBrowserContext(browserContextID cdp.BrowserContextID) *DisposeBrowserContextParams {
	return &DisposeBrowserContextParams{
		BrowserContextID: browserContextID,
	}
}

// Do executes Target.disposeBrowserContext against the provided context.
func (p *DisposeBrowserContextParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDisposeBrowserContext, p, nil)
}

// GetTargetInfoParams returns information about a target.
type GetTargetInfoParams struct {
	TargetID ID `json:"targetId,omitempty,omitzero"`
}

// GetTargetInfo returns information about a target.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-getTargetInfo
//
// parameters:
func GetTargetInfo() *GetTargetInfoParams {
	return &GetTargetInfoParams{}
}

// WithTargetID [no description].
func (p GetTargetInfoParams) WithTargetID(targetID ID) *GetTargetInfoParams {
	p.TargetID = targetID
	return &p
}

// GetTargetInfoReturns return values.
type GetTargetInfoReturns struct {
	TargetInfo *Info `json:"targetInfo,omitempty,omitzero"`
}

// Do executes Target.getTargetInfo against the provided context.
//
// returns:
//
//	targetInfo
func (p *GetTargetInfoParams) Do(ctx context.Context) (targetInfo *Info, err error) {
	// execute
	var res GetTargetInfoReturns
	err = cdp.Execute(ctx, CommandGetTargetInfo, p, &res)
	if err != nil {
		return nil, err
	}

	return res.TargetInfo, nil
}

// GetTargetsParams retrieves a list of available targets.
type GetTargetsParams struct {
	Filter Filter `json:"filter,omitempty,omitzero"` // Only targets matching filter will be reported. If filter is not specified and target discovery is currently enabled, a filter used for target discovery is used for consistency.
}

// GetTargets retrieves a list of available targets.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-getTargets
//
// parameters:
func GetTargets() *GetTargetsParams {
	return &GetTargetsParams{}
}

// WithFilter only targets matching filter will be reported. If filter is not
// specified and target discovery is currently enabled, a filter used for target
// discovery is used for consistency.
func (p GetTargetsParams) WithFilter(filter Filter) *GetTargetsParams {
	p.Filter = filter
	return &p
}

// GetTargetsReturns return values.
type GetTargetsReturns struct {
	TargetInfos []*Info `json:"targetInfos,omitempty,omitzero"` // The list of targets.
}

// Do executes Target.getTargets against the provided context.
//
// returns:
//
//	targetInfos - The list of targets.
func (p *GetTargetsParams) Do(ctx context.Context) (targetInfos []*Info, err error) {
	// execute
	var res GetTargetsReturns
	err = cdp.Execute(ctx, CommandGetTargets, p, &res)
	if err != nil {
		return nil, err
	}

	return res.TargetInfos, nil
}

// SetAutoAttachParams controls whether to automatically attach to new
// targets which are considered to be related to this one. When turned on,
// attaches to all existing related targets as well. When turned off,
// automatically detaches from all currently attached targets. This also clears
// all targets added by autoAttachRelated from the list of targets to watch for
// creation of related targets.
type SetAutoAttachParams struct {
	AutoAttach             bool   `json:"autoAttach"`                // Whether to auto-attach to related targets.
	WaitForDebuggerOnStart bool   `json:"waitForDebuggerOnStart"`    // Whether to pause new targets when attaching to them. Use Runtime.runIfWaitingForDebugger to run paused targets.
	Flatten                bool   `json:"flatten"`                   // Enables "flat" access to the session via specifying sessionId attribute in the commands. We plan to make this the default, deprecate non-flattened mode, and eventually retire it. See crbug.com/991325.
	Filter                 Filter `json:"filter,omitempty,omitzero"` // Only targets matching filter will be attached.
}

// SetAutoAttach controls whether to automatically attach to new targets
// which are considered to be related to this one. When turned on, attaches to
// all existing related targets as well. When turned off, automatically detaches
// from all currently attached targets. This also clears all targets added by
// autoAttachRelated from the list of targets to watch for creation of related
// targets.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-setAutoAttach
//
// parameters:
//
//	autoAttach - Whether to auto-attach to related targets.
//	waitForDebuggerOnStart - Whether to pause new targets when attaching to them. Use Runtime.runIfWaitingForDebugger to run paused targets.
func SetAutoAttach(autoAttach bool, waitForDebuggerOnStart bool) *SetAutoAttachParams {
	return &SetAutoAttachParams{
		AutoAttach:             autoAttach,
		WaitForDebuggerOnStart: waitForDebuggerOnStart,
		Flatten:                false,
	}
}

// WithFlatten enables "flat" access to the session via specifying sessionId
// attribute in the commands. We plan to make this the default, deprecate
// non-flattened mode, and eventually retire it. See crbug.com/991325.
func (p SetAutoAttachParams) WithFlatten(flatten bool) *SetAutoAttachParams {
	p.Flatten = flatten
	return &p
}

// WithFilter only targets matching filter will be attached.
func (p SetAutoAttachParams) WithFilter(filter Filter) *SetAutoAttachParams {
	p.Filter = filter
	return &p
}

// Do executes Target.setAutoAttach against the provided context.
func (p *SetAutoAttachParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetAutoAttach, p, nil)
}

// AutoAttachRelatedParams adds the specified target to the list of targets
// that will be monitored for any related target creation (such as child frames,
// child workers and new versions of service worker) and reported through
// attachedToTarget. The specified target is also auto-attached. This cancels
// the effect of any previous setAutoAttach and is also cancelled by subsequent
// setAutoAttach. Only available at the Browser target.
type AutoAttachRelatedParams struct {
	TargetID               ID     `json:"targetId"`
	WaitForDebuggerOnStart bool   `json:"waitForDebuggerOnStart"`    // Whether to pause new targets when attaching to them. Use Runtime.runIfWaitingForDebugger to run paused targets.
	Filter                 Filter `json:"filter,omitempty,omitzero"` // Only targets matching filter will be attached.
}

// AutoAttachRelated adds the specified target to the list of targets that
// will be monitored for any related target creation (such as child frames,
// child workers and new versions of service worker) and reported through
// attachedToTarget. The specified target is also auto-attached. This cancels
// the effect of any previous setAutoAttach and is also cancelled by subsequent
// setAutoAttach. Only available at the Browser target.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-autoAttachRelated
//
// parameters:
//
//	targetID
//	waitForDebuggerOnStart - Whether to pause new targets when attaching to them. Use Runtime.runIfWaitingForDebugger to run paused targets.
func AutoAttachRelated(targetID ID, waitForDebuggerOnStart bool) *AutoAttachRelatedParams {
	return &AutoAttachRelatedParams{
		TargetID:               targetID,
		WaitForDebuggerOnStart: waitForDebuggerOnStart,
	}
}

// WithFilter only targets matching filter will be attached.
func (p AutoAttachRelatedParams) WithFilter(filter Filter) *AutoAttachRelatedParams {
	p.Filter = filter
	return &p
}

// Do executes Target.autoAttachRelated against the provided context.
func (p *AutoAttachRelatedParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandAutoAttachRelated, p, nil)
}

// SetDiscoverTargetsParams controls whether to discover available targets
// and notify via targetCreated/targetInfoChanged/targetDestroyed events.
type SetDiscoverTargetsParams struct {
	Discover bool   `json:"discover"`                  // Whether to discover available targets.
	Filter   Filter `json:"filter,omitempty,omitzero"` // Only targets matching filter will be attached. If discover is false, filter must be omitted or empty.
}

// SetDiscoverTargets controls whether to discover available targets and
// notify via targetCreated/targetInfoChanged/targetDestroyed events.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-setDiscoverTargets
//
// parameters:
//
//	discover - Whether to discover available targets.
func SetDiscoverTargets(discover bool) *SetDiscoverTargetsParams {
	return &SetDiscoverTargetsParams{
		Discover: discover,
	}
}

// WithFilter only targets matching filter will be attached. If discover is
// false, filter must be omitted or empty.
func (p SetDiscoverTargetsParams) WithFilter(filter Filter) *SetDiscoverTargetsParams {
	p.Filter = filter
	return &p
}

// Do executes Target.setDiscoverTargets against the provided context.
func (p *SetDiscoverTargetsParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetDiscoverTargets, p, nil)
}

// SetRemoteLocationsParams enables target discovery for the specified
// locations, when setDiscoverTargets was set to true.
type SetRemoteLocationsParams struct {
	Locations []*RemoteLocation `json:"locations"` // List of remote locations.
}

// SetRemoteLocations enables target discovery for the specified locations,
// when setDiscoverTargets was set to true.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#method-setRemoteLocations
//
// parameters:
//
//	locations - List of remote locations.
func SetRemoteLocations(locations []*RemoteLocation) *SetRemoteLocationsParams {
	return &SetRemoteLocationsParams{
		Locations: locations,
	}
}

// Do executes Target.setRemoteLocations against the provided context.
func (p *SetRemoteLocationsParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetRemoteLocations, p, nil)
}

// Command names.
const (
	CommandActivateTarget         = "Target.activateTarget"
	CommandAttachToTarget         = "Target.attachToTarget"
	CommandAttachToBrowserTarget  = "Target.attachToBrowserTarget"
	CommandCloseTarget            = "Target.closeTarget"
	CommandExposeDevToolsProtocol = "Target.exposeDevToolsProtocol"
	CommandCreateBrowserContext   = "Target.createBrowserContext"
	CommandGetBrowserContexts     = "Target.getBrowserContexts"
	CommandCreateTarget           = "Target.createTarget"
	CommandDetachFromTarget       = "Target.detachFromTarget"
	CommandDisposeBrowserContext  = "Target.disposeBrowserContext"
	CommandGetTargetInfo          = "Target.getTargetInfo"
	CommandGetTargets             = "Target.getTargets"
	CommandSetAutoAttach          = "Target.setAutoAttach"
	CommandAutoAttachRelated      = "Target.autoAttachRelated"
	CommandSetDiscoverTargets     = "Target.setDiscoverTargets"
	CommandSetRemoteLocations     = "Target.setRemoteLocations"
)
