/*  fermat.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifdef HAVE_FERMAT

#ifndef FERMAT_H_
#define FERMAT_H_

#include <ginac/ginac.h>
#include <string>

namespace Reduze {

struct FermatPrivate;

/// wrapper to normalize rational functions with an external Fermat executable
/** the implementation is heavily inspired by a similar wrapper 'gateToFermat'
 ** written in C by Mikhail Tentyukov */
class Fermat {
public:
	static Fermat* instance();
	GiNaC::ex normalize(const GiNaC::ex& expr);
	//std::string determinant(const GiNaC::matrix& mat);
	void init(const GiNaC::lst& symbols, const std::string& exec,
			bool use_laurent_polynomials);
	void close();
	bool is_initialized() const;
	/// asks Fermat to solve some test and verifies the result is correct
	void verify_in_sync() const;
	const GiNaC::lst& get_symbols() const;
	void set_symbols(const GiNaC::lst& symbs);
	~Fermat();
	static bool is_proper_executable_path(const std::string& path, std::string& errmsg);
private:
	Fermat();
	void fork_fermat_executable();
	void fork_guard();
	void configure_fermat_executable(bool use_laurent_polynomials);
	FermatPrivate *d;
};

} // namespace Reduze


#endif /* FERMAT_H_ */

#endif // HAVE_FERMAT
