/*  job_generateseeds.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_GENERATESEEDS_H_
#define JOB_GENERATESEEDS_H_

#include "job.h"
#include "int.h" /* SeedGeneratorOptions */
#include "yamlconfigurable.h"

namespace Reduze {

class Sector;
class RSFiniteGenericSelection;

/// Job to generate integrals from a sector
class GenerateSeeds: public Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("generate_seeds");
		s.set_short_description("Generates integrals from a sector.");
		s.set_long_description(""//
					"Job to generate integrals from a sector.");
		s.add_option("sector", true, "sequence", "A sector");
		s.add_option("ranges", true, "sequence", "rs ranges.");
		s.add_option("options", true, "sequence",
				"Options for the seed generator.");
		s.add_option("output_file", true, "string", "Output file.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}

	GenerateSeeds() {
		add_auto_io("ranges", ranges_);
		add_auto_io("options", options_);
		add_auto_io("output_file", output_file_);
	}
	GenerateSeeds(const Sector& sector, const std::list<
			RSFiniteGenericSelection>& ranges,
			const SeedGeneratorOptions& options, const std::string& output_file) :
		ranges_(ranges), /**/
		options_(options), /**/
		output_file_(output_file) {
		sector_.push_back(sector);
		add_auto_options();
	}
	virtual ~GenerateSeeds() {
	}

	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;

protected:
	virtual void add_auto_options() {
		add_auto_io("ranges", ranges_);
		add_auto_io("options", options_);
		add_auto_io("output_file", output_file_);
	}
	virtual void print_manual_options(YAML::Emitter& os) const;
	virtual void read_manual_options(const YAML::Node&);

private:
	// one or zero sectors
	std::list<Sector> sector_;
	std::list<RSFiniteGenericSelection> ranges_;
	SeedGeneratorOptions options_;
	std::string output_file_;
};

}

#endif /* JOB_GENERATESEEDS_H_ */
