import { type RouterLinkComponent } from '../index';
/**
 * __useRouterLink()__
 *
 * Hook: Returns app-configured router link component.
 *
 * A generic can be passed to define advanced link configuration:
 * ```
 * type MyRouterLinkConfig = {
 *  to: string;
 *  replace?: boolean;
 * }
 *
 * const RouterLink = useRouterLink<MyRouterLinkConfig>();
 * ```
 */
declare const useRouterLink: <RouterLinkConfig extends Record<string, any> = never>() => RouterLinkComponent<RouterLinkConfig> | undefined;
export default useRouterLink;
