'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var hooks = require('@mantine/hooks');
var createScopedKeydownHandler = require('../../../core/utils/create-scoped-keydown-handler/create-scoped-keydown-handler.cjs');
var createEventHandler = require('../../../core/utils/create-event-handler/create-event-handler.cjs');
require('clsx');
var parseThemeColor = require('../../../core/MantineProvider/color-functions/parse-theme-color/parse-theme-color.cjs');
require('../../../core/MantineProvider/Mantine.context.cjs');
require('../../../core/MantineProvider/default-theme.cjs');
require('../../../core/MantineProvider/MantineProvider.cjs');
var MantineThemeProvider = require('../../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.cjs');
var useProps = require('../../../core/MantineProvider/use-props/use-props.cjs');
require('../../../core/MantineProvider/MantineCssVariables/MantineCssVariables.cjs');
require('../../../core/Box/Box.cjs');
var polymorphicFactory = require('../../../core/factory/polymorphic-factory.cjs');
var DirectionProvider = require('../../../core/DirectionProvider/DirectionProvider.cjs');
require('../../Accordion/Accordion.cjs');
var AccordionChevron = require('../../Accordion/AccordionChevron.cjs');
require('../../Accordion/AccordionItem/AccordionItem.cjs');
require('../../Accordion/AccordionPanel/AccordionPanel.cjs');
require('../../Accordion/AccordionControl/AccordionControl.cjs');
var UnstyledButton = require('../../UnstyledButton/UnstyledButton.cjs');
var Menu_context = require('../Menu.context.cjs');
var MenuSub_context = require('../MenuSub/MenuSub.context.cjs');
var Menu_module = require('../Menu.module.css.cjs');

const defaultProps = {};
const MenuSubItem = polymorphicFactory.polymorphicFactory((props, ref) => {
  const {
    classNames,
    className,
    style,
    styles,
    vars,
    color,
    leftSection,
    rightSection,
    children,
    disabled,
    "data-disabled": dataDisabled,
    closeMenuOnClick,
    ...others
  } = useProps.useProps("MenuSubItem", defaultProps, props);
  const ctx = Menu_context.useMenuContext();
  const subCtx = MenuSub_context.useSubMenuContext();
  const theme = MantineThemeProvider.useMantineTheme();
  const { dir } = DirectionProvider.useDirection();
  const itemRef = React.useRef(null);
  const _others = others;
  const colors = color ? theme.variantColorResolver({ color, theme, variant: "light" }) : void 0;
  const parsedThemeColor = color ? parseThemeColor.parseThemeColor({ color, theme }) : null;
  const handleKeydown = createEventHandler.createEventHandler(_others.onKeyDown, (event) => {
    if (event.key === "ArrowRight") {
      subCtx?.open();
      subCtx?.focusFirstItem();
    }
    if (event.key === "ArrowLeft" && subCtx?.parentContext) {
      subCtx.parentContext.close();
      subCtx.parentContext.focusParentItem();
    }
  });
  const handleClick = createEventHandler.createEventHandler(_others.onClick, () => {
    if (!dataDisabled && closeMenuOnClick) {
      ctx.closeDropdownImmediately();
    }
  });
  const handleMouseEnter = createEventHandler.createEventHandler(_others.onMouseEnter, subCtx?.open);
  const handleMouseLeave = createEventHandler.createEventHandler(_others.onMouseLeave, subCtx?.close);
  return /* @__PURE__ */ jsxRuntime.jsxs(
    UnstyledButton.UnstyledButton,
    {
      onMouseDown: (event) => event.preventDefault(),
      ...others,
      unstyled: ctx.unstyled,
      tabIndex: ctx.menuItemTabIndex,
      ...ctx.getStyles("item", { className, style, styles, classNames }),
      ref: hooks.useMergedRef(itemRef, ref),
      role: "menuitem",
      disabled,
      "data-menu-item": true,
      "data-sub-menu-item": true,
      "data-disabled": disabled || dataDisabled || void 0,
      "data-mantine-stop-propagation": true,
      onMouseEnter: handleMouseEnter,
      onMouseLeave: handleMouseLeave,
      onClick: handleClick,
      onKeyDown: createScopedKeydownHandler.createScopedKeydownHandler({
        siblingSelector: "[data-menu-item]:not([data-disabled])",
        parentSelector: "[data-menu-dropdown]",
        activateOnFocus: false,
        loop: ctx.loop,
        dir,
        orientation: "vertical",
        onKeyDown: handleKeydown
      }),
      __vars: {
        "--menu-item-color": parsedThemeColor?.isThemeColor && parsedThemeColor?.shade === void 0 ? `var(--mantine-color-${parsedThemeColor.color}-6)` : colors?.color,
        "--menu-item-hover": colors?.hover
      },
      children: [
        leftSection && /* @__PURE__ */ jsxRuntime.jsx("div", { ...ctx.getStyles("itemSection", { styles, classNames }), "data-position": "left", children: leftSection }),
        children && /* @__PURE__ */ jsxRuntime.jsx("div", { ...ctx.getStyles("itemLabel", { styles, classNames }), children }),
        /* @__PURE__ */ jsxRuntime.jsx("div", { ...ctx.getStyles("itemSection", { styles, classNames }), "data-position": "right", children: rightSection || /* @__PURE__ */ jsxRuntime.jsx(AccordionChevron.AccordionChevron, { ...ctx.getStyles("chevron"), size: 14 }) })
      ]
    }
  );
});
MenuSubItem.classes = Menu_module;
MenuSubItem.displayName = "@mantine/core/MenuSubItem";

exports.MenuSubItem = MenuSubItem;
//# sourceMappingURL=MenuSubItem.cjs.map
