// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package customerprofiles

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddProfileKey = "AddProfileKey"

// AddProfileKeyRequest generates a "aws/request.Request" representing the
// client's request for the AddProfileKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddProfileKey for more information on using the AddProfileKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddProfileKeyRequest method.
//	req, resp := client.AddProfileKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/AddProfileKey
func (c *CustomerProfiles) AddProfileKeyRequest(input *AddProfileKeyInput) (req *request.Request, output *AddProfileKeyOutput) {
	op := &request.Operation{
		Name:       opAddProfileKey,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/keys",
	}

	if input == nil {
		input = &AddProfileKeyInput{}
	}

	output = &AddProfileKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddProfileKey API operation for Amazon Connect Customer Profiles.
//
// Associates a new key value with a specific profile, such as a Contact Record
// ContactId.
//
// A profile object can have a single unique key and any number of additional
// keys that can be used to identify the profile that it belongs to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation AddProfileKey for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/AddProfileKey
func (c *CustomerProfiles) AddProfileKey(input *AddProfileKeyInput) (*AddProfileKeyOutput, error) {
	req, out := c.AddProfileKeyRequest(input)
	return out, req.Send()
}

// AddProfileKeyWithContext is the same as AddProfileKey with the addition of
// the ability to pass a context and additional request options.
//
// See AddProfileKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) AddProfileKeyWithContext(ctx aws.Context, input *AddProfileKeyInput, opts ...request.Option) (*AddProfileKeyOutput, error) {
	req, out := c.AddProfileKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCalculatedAttributeDefinition = "CreateCalculatedAttributeDefinition"

// CreateCalculatedAttributeDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateCalculatedAttributeDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCalculatedAttributeDefinition for more information on using the CreateCalculatedAttributeDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCalculatedAttributeDefinitionRequest method.
//	req, resp := client.CreateCalculatedAttributeDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateCalculatedAttributeDefinition
func (c *CustomerProfiles) CreateCalculatedAttributeDefinitionRequest(input *CreateCalculatedAttributeDefinitionInput) (req *request.Request, output *CreateCalculatedAttributeDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateCalculatedAttributeDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}",
	}

	if input == nil {
		input = &CreateCalculatedAttributeDefinitionInput{}
	}

	output = &CreateCalculatedAttributeDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCalculatedAttributeDefinition API operation for Amazon Connect Customer Profiles.
//
// Creates a new calculated attribute definition. After creation, new object
// data ingested into Customer Profiles will be included in the calculated attribute,
// which can be retrieved for a profile using the GetCalculatedAttributeForProfile
// (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetCalculatedAttributeForProfile.html)
// API. Defining a calculated attribute makes it available for all profiles
// within a domain. Each calculated attribute can only reference one ObjectType
// and at most, two fields from that ObjectType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation CreateCalculatedAttributeDefinition for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateCalculatedAttributeDefinition
func (c *CustomerProfiles) CreateCalculatedAttributeDefinition(input *CreateCalculatedAttributeDefinitionInput) (*CreateCalculatedAttributeDefinitionOutput, error) {
	req, out := c.CreateCalculatedAttributeDefinitionRequest(input)
	return out, req.Send()
}

// CreateCalculatedAttributeDefinitionWithContext is the same as CreateCalculatedAttributeDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCalculatedAttributeDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) CreateCalculatedAttributeDefinitionWithContext(ctx aws.Context, input *CreateCalculatedAttributeDefinitionInput, opts ...request.Option) (*CreateCalculatedAttributeDefinitionOutput, error) {
	req, out := c.CreateCalculatedAttributeDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDomainRequest method.
//	req, resp := client.CreateDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateDomain
func (c *CustomerProfiles) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon Connect Customer Profiles.
//
// Creates a domain, which is a container for all customer data, such as customer
// profile attributes, object types, profile keys, and encryption keys. You
// can create multiple domains, and each domain can have multiple third-party
// integrations.
//
// Each Amazon Connect instance can be associated with only one domain. Multiple
// Amazon Connect instances can be associated with one domain.
//
// Use this API or UpdateDomain (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html)
// to enable identity resolution (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html):
// set Matching to true.
//
// To prevent cross-service impersonation when you call this API, see Cross-service
// confused deputy prevention (https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html)
// for sample policies that you should apply.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateDomain
func (c *CustomerProfiles) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventStream = "CreateEventStream"

// CreateEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventStream for more information on using the CreateEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEventStreamRequest method.
//	req, resp := client.CreateEventStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateEventStream
func (c *CustomerProfiles) CreateEventStreamRequest(input *CreateEventStreamInput) (req *request.Request, output *CreateEventStreamOutput) {
	op := &request.Operation{
		Name:       opCreateEventStream,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/event-streams/{EventStreamName}",
	}

	if input == nil {
		input = &CreateEventStreamInput{}
	}

	output = &CreateEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventStream API operation for Amazon Connect Customer Profiles.
//
// Creates an event stream, which is a subscription to real-time events, such
// as when profiles are created and updated through Amazon Connect Customer
// Profiles.
//
// Each event stream can be associated with only one Kinesis Data Stream destination
// in the same region and Amazon Web Services account as the customer profiles
// domain
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation CreateEventStream for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateEventStream
func (c *CustomerProfiles) CreateEventStream(input *CreateEventStreamInput) (*CreateEventStreamOutput, error) {
	req, out := c.CreateEventStreamRequest(input)
	return out, req.Send()
}

// CreateEventStreamWithContext is the same as CreateEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) CreateEventStreamWithContext(ctx aws.Context, input *CreateEventStreamInput, opts ...request.Option) (*CreateEventStreamOutput, error) {
	req, out := c.CreateEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIntegrationWorkflow = "CreateIntegrationWorkflow"

// CreateIntegrationWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the CreateIntegrationWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIntegrationWorkflow for more information on using the CreateIntegrationWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIntegrationWorkflowRequest method.
//	req, resp := client.CreateIntegrationWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateIntegrationWorkflow
func (c *CustomerProfiles) CreateIntegrationWorkflowRequest(input *CreateIntegrationWorkflowInput) (req *request.Request, output *CreateIntegrationWorkflowOutput) {
	op := &request.Operation{
		Name:       opCreateIntegrationWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/workflows/integrations",
	}

	if input == nil {
		input = &CreateIntegrationWorkflowInput{}
	}

	output = &CreateIntegrationWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIntegrationWorkflow API operation for Amazon Connect Customer Profiles.
//
// Creates an integration workflow. An integration workflow is an async process
// which ingests historic data and sets up an integration for ongoing updates.
// The supported Amazon AppFlow sources are Salesforce, ServiceNow, and Marketo.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation CreateIntegrationWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateIntegrationWorkflow
func (c *CustomerProfiles) CreateIntegrationWorkflow(input *CreateIntegrationWorkflowInput) (*CreateIntegrationWorkflowOutput, error) {
	req, out := c.CreateIntegrationWorkflowRequest(input)
	return out, req.Send()
}

// CreateIntegrationWorkflowWithContext is the same as CreateIntegrationWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIntegrationWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) CreateIntegrationWorkflowWithContext(ctx aws.Context, input *CreateIntegrationWorkflowInput, opts ...request.Option) (*CreateIntegrationWorkflowOutput, error) {
	req, out := c.CreateIntegrationWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProfile = "CreateProfile"

// CreateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfile for more information on using the CreateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProfileRequest method.
//	req, resp := client.CreateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateProfile
func (c *CustomerProfiles) CreateProfileRequest(input *CreateProfileInput) (req *request.Request, output *CreateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles",
	}

	if input == nil {
		input = &CreateProfileInput{}
	}

	output = &CreateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfile API operation for Amazon Connect Customer Profiles.
//
// Creates a standard profile.
//
// A standard profile represents the following attributes for a customer profile
// in a domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation CreateProfile for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateProfile
func (c *CustomerProfiles) CreateProfile(input *CreateProfileInput) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	return out, req.Send()
}

// CreateProfileWithContext is the same as CreateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) CreateProfileWithContext(ctx aws.Context, input *CreateProfileInput, opts ...request.Option) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCalculatedAttributeDefinition = "DeleteCalculatedAttributeDefinition"

// DeleteCalculatedAttributeDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCalculatedAttributeDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCalculatedAttributeDefinition for more information on using the DeleteCalculatedAttributeDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCalculatedAttributeDefinitionRequest method.
//	req, resp := client.DeleteCalculatedAttributeDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteCalculatedAttributeDefinition
func (c *CustomerProfiles) DeleteCalculatedAttributeDefinitionRequest(input *DeleteCalculatedAttributeDefinitionInput) (req *request.Request, output *DeleteCalculatedAttributeDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteCalculatedAttributeDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}",
	}

	if input == nil {
		input = &DeleteCalculatedAttributeDefinitionInput{}
	}

	output = &DeleteCalculatedAttributeDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCalculatedAttributeDefinition API operation for Amazon Connect Customer Profiles.
//
// Deletes an existing calculated attribute definition. Note that deleting a
// default calculated attribute is possible, however once deleted, you will
// be unable to undo that action and will need to recreate it on your own using
// the CreateCalculatedAttributeDefinition API if you want it back.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteCalculatedAttributeDefinition for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteCalculatedAttributeDefinition
func (c *CustomerProfiles) DeleteCalculatedAttributeDefinition(input *DeleteCalculatedAttributeDefinitionInput) (*DeleteCalculatedAttributeDefinitionOutput, error) {
	req, out := c.DeleteCalculatedAttributeDefinitionRequest(input)
	return out, req.Send()
}

// DeleteCalculatedAttributeDefinitionWithContext is the same as DeleteCalculatedAttributeDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCalculatedAttributeDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteCalculatedAttributeDefinitionWithContext(ctx aws.Context, input *DeleteCalculatedAttributeDefinitionInput, opts ...request.Option) (*DeleteCalculatedAttributeDefinitionOutput, error) {
	req, out := c.DeleteCalculatedAttributeDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDomainRequest method.
//	req, resp := client.DeleteDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteDomain
func (c *CustomerProfiles) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domains/{DomainName}",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomain API operation for Amazon Connect Customer Profiles.
//
// Deletes a specific domain and all of its customer data, such as customer
// profile attributes and their related objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteDomain
func (c *CustomerProfiles) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventStream = "DeleteEventStream"

// DeleteEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventStream for more information on using the DeleteEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventStreamRequest method.
//	req, resp := client.DeleteEventStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteEventStream
func (c *CustomerProfiles) DeleteEventStreamRequest(input *DeleteEventStreamInput) (req *request.Request, output *DeleteEventStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteEventStream,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domains/{DomainName}/event-streams/{EventStreamName}",
	}

	if input == nil {
		input = &DeleteEventStreamInput{}
	}

	output = &DeleteEventStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventStream API operation for Amazon Connect Customer Profiles.
//
// Disables and deletes the specified event stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteEventStream for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteEventStream
func (c *CustomerProfiles) DeleteEventStream(input *DeleteEventStreamInput) (*DeleteEventStreamOutput, error) {
	req, out := c.DeleteEventStreamRequest(input)
	return out, req.Send()
}

// DeleteEventStreamWithContext is the same as DeleteEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteEventStreamWithContext(ctx aws.Context, input *DeleteEventStreamInput, opts ...request.Option) (*DeleteEventStreamOutput, error) {
	req, out := c.DeleteEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntegration = "DeleteIntegration"

// DeleteIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntegration for more information on using the DeleteIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIntegrationRequest method.
//	req, resp := client.DeleteIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteIntegration
func (c *CustomerProfiles) DeleteIntegrationRequest(input *DeleteIntegrationInput) (req *request.Request, output *DeleteIntegrationOutput) {
	op := &request.Operation{
		Name:       opDeleteIntegration,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/integrations/delete",
	}

	if input == nil {
		input = &DeleteIntegrationInput{}
	}

	output = &DeleteIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIntegration API operation for Amazon Connect Customer Profiles.
//
// Removes an integration from a specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteIntegration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteIntegration
func (c *CustomerProfiles) DeleteIntegration(input *DeleteIntegrationInput) (*DeleteIntegrationOutput, error) {
	req, out := c.DeleteIntegrationRequest(input)
	return out, req.Send()
}

// DeleteIntegrationWithContext is the same as DeleteIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteIntegrationWithContext(ctx aws.Context, input *DeleteIntegrationInput, opts ...request.Option) (*DeleteIntegrationOutput, error) {
	req, out := c.DeleteIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfile = "DeleteProfile"

// DeleteProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfile for more information on using the DeleteProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProfileRequest method.
//	req, resp := client.DeleteProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfile
func (c *CustomerProfiles) DeleteProfileRequest(input *DeleteProfileInput) (req *request.Request, output *DeleteProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/delete",
	}

	if input == nil {
		input = &DeleteProfileInput{}
	}

	output = &DeleteProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfile API operation for Amazon Connect Customer Profiles.
//
// Deletes the standard customer profile and all data pertaining to the profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteProfile for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfile
func (c *CustomerProfiles) DeleteProfile(input *DeleteProfileInput) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	return out, req.Send()
}

// DeleteProfileWithContext is the same as DeleteProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteProfileWithContext(ctx aws.Context, input *DeleteProfileInput, opts ...request.Option) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfileKey = "DeleteProfileKey"

// DeleteProfileKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfileKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfileKey for more information on using the DeleteProfileKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProfileKeyRequest method.
//	req, resp := client.DeleteProfileKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileKey
func (c *CustomerProfiles) DeleteProfileKeyRequest(input *DeleteProfileKeyInput) (req *request.Request, output *DeleteProfileKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteProfileKey,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/keys/delete",
	}

	if input == nil {
		input = &DeleteProfileKeyInput{}
	}

	output = &DeleteProfileKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfileKey API operation for Amazon Connect Customer Profiles.
//
// Removes a searchable key from a customer profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteProfileKey for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileKey
func (c *CustomerProfiles) DeleteProfileKey(input *DeleteProfileKeyInput) (*DeleteProfileKeyOutput, error) {
	req, out := c.DeleteProfileKeyRequest(input)
	return out, req.Send()
}

// DeleteProfileKeyWithContext is the same as DeleteProfileKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfileKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteProfileKeyWithContext(ctx aws.Context, input *DeleteProfileKeyInput, opts ...request.Option) (*DeleteProfileKeyOutput, error) {
	req, out := c.DeleteProfileKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfileObject = "DeleteProfileObject"

// DeleteProfileObjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfileObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfileObject for more information on using the DeleteProfileObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProfileObjectRequest method.
//	req, resp := client.DeleteProfileObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObject
func (c *CustomerProfiles) DeleteProfileObjectRequest(input *DeleteProfileObjectInput) (req *request.Request, output *DeleteProfileObjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProfileObject,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/objects/delete",
	}

	if input == nil {
		input = &DeleteProfileObjectInput{}
	}

	output = &DeleteProfileObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfileObject API operation for Amazon Connect Customer Profiles.
//
// Removes an object associated with a profile of a given ProfileObjectType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteProfileObject for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObject
func (c *CustomerProfiles) DeleteProfileObject(input *DeleteProfileObjectInput) (*DeleteProfileObjectOutput, error) {
	req, out := c.DeleteProfileObjectRequest(input)
	return out, req.Send()
}

// DeleteProfileObjectWithContext is the same as DeleteProfileObject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfileObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteProfileObjectWithContext(ctx aws.Context, input *DeleteProfileObjectInput, opts ...request.Option) (*DeleteProfileObjectOutput, error) {
	req, out := c.DeleteProfileObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfileObjectType = "DeleteProfileObjectType"

// DeleteProfileObjectTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfileObjectType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfileObjectType for more information on using the DeleteProfileObjectType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProfileObjectTypeRequest method.
//	req, resp := client.DeleteProfileObjectTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObjectType
func (c *CustomerProfiles) DeleteProfileObjectTypeRequest(input *DeleteProfileObjectTypeInput) (req *request.Request, output *DeleteProfileObjectTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteProfileObjectType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domains/{DomainName}/object-types/{ObjectTypeName}",
	}

	if input == nil {
		input = &DeleteProfileObjectTypeInput{}
	}

	output = &DeleteProfileObjectTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfileObjectType API operation for Amazon Connect Customer Profiles.
//
// Removes a ProfileObjectType from a specific domain as well as removes all
// the ProfileObjects of that type. It also disables integrations from this
// specific ProfileObjectType. In addition, it scrubs all of the fields of the
// standard profile that were populated from this ProfileObjectType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteProfileObjectType for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObjectType
func (c *CustomerProfiles) DeleteProfileObjectType(input *DeleteProfileObjectTypeInput) (*DeleteProfileObjectTypeOutput, error) {
	req, out := c.DeleteProfileObjectTypeRequest(input)
	return out, req.Send()
}

// DeleteProfileObjectTypeWithContext is the same as DeleteProfileObjectType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfileObjectType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteProfileObjectTypeWithContext(ctx aws.Context, input *DeleteProfileObjectTypeInput, opts ...request.Option) (*DeleteProfileObjectTypeOutput, error) {
	req, out := c.DeleteProfileObjectTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkflow = "DeleteWorkflow"

// DeleteWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkflow for more information on using the DeleteWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkflowRequest method.
//	req, resp := client.DeleteWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteWorkflow
func (c *CustomerProfiles) DeleteWorkflowRequest(input *DeleteWorkflowInput) (req *request.Request, output *DeleteWorkflowOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkflow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domains/{DomainName}/workflows/{WorkflowId}",
	}

	if input == nil {
		input = &DeleteWorkflowInput{}
	}

	output = &DeleteWorkflowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkflow API operation for Amazon Connect Customer Profiles.
//
// Deletes the specified workflow and all its corresponding resources. This
// is an async process.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteWorkflow
func (c *CustomerProfiles) DeleteWorkflow(input *DeleteWorkflowInput) (*DeleteWorkflowOutput, error) {
	req, out := c.DeleteWorkflowRequest(input)
	return out, req.Send()
}

// DeleteWorkflowWithContext is the same as DeleteWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteWorkflowWithContext(ctx aws.Context, input *DeleteWorkflowInput, opts ...request.Option) (*DeleteWorkflowOutput, error) {
	req, out := c.DeleteWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAutoMergingPreview = "GetAutoMergingPreview"

// GetAutoMergingPreviewRequest generates a "aws/request.Request" representing the
// client's request for the GetAutoMergingPreview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAutoMergingPreview for more information on using the GetAutoMergingPreview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAutoMergingPreviewRequest method.
//	req, resp := client.GetAutoMergingPreviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetAutoMergingPreview
func (c *CustomerProfiles) GetAutoMergingPreviewRequest(input *GetAutoMergingPreviewInput) (req *request.Request, output *GetAutoMergingPreviewOutput) {
	op := &request.Operation{
		Name:       opGetAutoMergingPreview,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/identity-resolution-jobs/auto-merging-preview",
	}

	if input == nil {
		input = &GetAutoMergingPreviewInput{}
	}

	output = &GetAutoMergingPreviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAutoMergingPreview API operation for Amazon Connect Customer Profiles.
//
// Tests the auto-merging settings of your Identity Resolution Job without merging
// your data. It randomly selects a sample of matching groups from the existing
// matching results, and applies the automerging settings that you provided.
// You can then view the number of profiles in the sample, the number of matches,
// and the number of profiles identified to be merged. This enables you to evaluate
// the accuracy of the attributes in your matching list.
//
// You can't view which profiles are matched and would be merged.
//
// We strongly recommend you use this API to do a dry run of the automerging
// process before running the Identity Resolution Job. Include at least two
// matching attributes. If your matching list includes too few attributes (such
// as only FirstName or only LastName), there may be a large number of matches.
// This increases the chances of erroneous merges.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetAutoMergingPreview for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetAutoMergingPreview
func (c *CustomerProfiles) GetAutoMergingPreview(input *GetAutoMergingPreviewInput) (*GetAutoMergingPreviewOutput, error) {
	req, out := c.GetAutoMergingPreviewRequest(input)
	return out, req.Send()
}

// GetAutoMergingPreviewWithContext is the same as GetAutoMergingPreview with the addition of
// the ability to pass a context and additional request options.
//
// See GetAutoMergingPreview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetAutoMergingPreviewWithContext(ctx aws.Context, input *GetAutoMergingPreviewInput, opts ...request.Option) (*GetAutoMergingPreviewOutput, error) {
	req, out := c.GetAutoMergingPreviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCalculatedAttributeDefinition = "GetCalculatedAttributeDefinition"

// GetCalculatedAttributeDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetCalculatedAttributeDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCalculatedAttributeDefinition for more information on using the GetCalculatedAttributeDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCalculatedAttributeDefinitionRequest method.
//	req, resp := client.GetCalculatedAttributeDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeDefinition
func (c *CustomerProfiles) GetCalculatedAttributeDefinitionRequest(input *GetCalculatedAttributeDefinitionInput) (req *request.Request, output *GetCalculatedAttributeDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetCalculatedAttributeDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}",
	}

	if input == nil {
		input = &GetCalculatedAttributeDefinitionInput{}
	}

	output = &GetCalculatedAttributeDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCalculatedAttributeDefinition API operation for Amazon Connect Customer Profiles.
//
// Provides more information on a calculated attribute definition for Customer
// Profiles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetCalculatedAttributeDefinition for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeDefinition
func (c *CustomerProfiles) GetCalculatedAttributeDefinition(input *GetCalculatedAttributeDefinitionInput) (*GetCalculatedAttributeDefinitionOutput, error) {
	req, out := c.GetCalculatedAttributeDefinitionRequest(input)
	return out, req.Send()
}

// GetCalculatedAttributeDefinitionWithContext is the same as GetCalculatedAttributeDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetCalculatedAttributeDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetCalculatedAttributeDefinitionWithContext(ctx aws.Context, input *GetCalculatedAttributeDefinitionInput, opts ...request.Option) (*GetCalculatedAttributeDefinitionOutput, error) {
	req, out := c.GetCalculatedAttributeDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCalculatedAttributeForProfile = "GetCalculatedAttributeForProfile"

// GetCalculatedAttributeForProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetCalculatedAttributeForProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCalculatedAttributeForProfile for more information on using the GetCalculatedAttributeForProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCalculatedAttributeForProfileRequest method.
//	req, resp := client.GetCalculatedAttributeForProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeForProfile
func (c *CustomerProfiles) GetCalculatedAttributeForProfileRequest(input *GetCalculatedAttributeForProfileInput) (req *request.Request, output *GetCalculatedAttributeForProfileOutput) {
	op := &request.Operation{
		Name:       opGetCalculatedAttributeForProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/profile/{ProfileId}/calculated-attributes/{CalculatedAttributeName}",
	}

	if input == nil {
		input = &GetCalculatedAttributeForProfileInput{}
	}

	output = &GetCalculatedAttributeForProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCalculatedAttributeForProfile API operation for Amazon Connect Customer Profiles.
//
// Retrieve a calculated attribute for a customer profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetCalculatedAttributeForProfile for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeForProfile
func (c *CustomerProfiles) GetCalculatedAttributeForProfile(input *GetCalculatedAttributeForProfileInput) (*GetCalculatedAttributeForProfileOutput, error) {
	req, out := c.GetCalculatedAttributeForProfileRequest(input)
	return out, req.Send()
}

// GetCalculatedAttributeForProfileWithContext is the same as GetCalculatedAttributeForProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetCalculatedAttributeForProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetCalculatedAttributeForProfileWithContext(ctx aws.Context, input *GetCalculatedAttributeForProfileInput, opts ...request.Option) (*GetCalculatedAttributeForProfileOutput, error) {
	req, out := c.GetCalculatedAttributeForProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomain = "GetDomain"

// GetDomainRequest generates a "aws/request.Request" representing the
// client's request for the GetDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomain for more information on using the GetDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDomainRequest method.
//	req, resp := client.GetDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetDomain
func (c *CustomerProfiles) GetDomainRequest(input *GetDomainInput) (req *request.Request, output *GetDomainOutput) {
	op := &request.Operation{
		Name:       opGetDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}",
	}

	if input == nil {
		input = &GetDomainInput{}
	}

	output = &GetDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomain API operation for Amazon Connect Customer Profiles.
//
// Returns information about a specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetDomain for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetDomain
func (c *CustomerProfiles) GetDomain(input *GetDomainInput) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	return out, req.Send()
}

// GetDomainWithContext is the same as GetDomain with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetDomainWithContext(ctx aws.Context, input *GetDomainInput, opts ...request.Option) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventStream = "GetEventStream"

// GetEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the GetEventStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventStream for more information on using the GetEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEventStreamRequest method.
//	req, resp := client.GetEventStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetEventStream
func (c *CustomerProfiles) GetEventStreamRequest(input *GetEventStreamInput) (req *request.Request, output *GetEventStreamOutput) {
	op := &request.Operation{
		Name:       opGetEventStream,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/event-streams/{EventStreamName}",
	}

	if input == nil {
		input = &GetEventStreamInput{}
	}

	output = &GetEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventStream API operation for Amazon Connect Customer Profiles.
//
// Returns information about the specified event stream in a specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetEventStream for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetEventStream
func (c *CustomerProfiles) GetEventStream(input *GetEventStreamInput) (*GetEventStreamOutput, error) {
	req, out := c.GetEventStreamRequest(input)
	return out, req.Send()
}

// GetEventStreamWithContext is the same as GetEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetEventStreamWithContext(ctx aws.Context, input *GetEventStreamInput, opts ...request.Option) (*GetEventStreamOutput, error) {
	req, out := c.GetEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityResolutionJob = "GetIdentityResolutionJob"

// GetIdentityResolutionJobRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityResolutionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityResolutionJob for more information on using the GetIdentityResolutionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdentityResolutionJobRequest method.
//	req, resp := client.GetIdentityResolutionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIdentityResolutionJob
func (c *CustomerProfiles) GetIdentityResolutionJobRequest(input *GetIdentityResolutionJobInput) (req *request.Request, output *GetIdentityResolutionJobOutput) {
	op := &request.Operation{
		Name:       opGetIdentityResolutionJob,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/identity-resolution-jobs/{JobId}",
	}

	if input == nil {
		input = &GetIdentityResolutionJobInput{}
	}

	output = &GetIdentityResolutionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityResolutionJob API operation for Amazon Connect Customer Profiles.
//
// Returns information about an Identity Resolution Job in a specific domain.
//
// Identity Resolution Jobs are set up using the Amazon Connect admin console.
// For more information, see Use Identity Resolution to consolidate similar
// profiles (https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetIdentityResolutionJob for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIdentityResolutionJob
func (c *CustomerProfiles) GetIdentityResolutionJob(input *GetIdentityResolutionJobInput) (*GetIdentityResolutionJobOutput, error) {
	req, out := c.GetIdentityResolutionJobRequest(input)
	return out, req.Send()
}

// GetIdentityResolutionJobWithContext is the same as GetIdentityResolutionJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityResolutionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetIdentityResolutionJobWithContext(ctx aws.Context, input *GetIdentityResolutionJobInput, opts ...request.Option) (*GetIdentityResolutionJobOutput, error) {
	req, out := c.GetIdentityResolutionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntegration = "GetIntegration"

// GetIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the GetIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntegration for more information on using the GetIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIntegrationRequest method.
//	req, resp := client.GetIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIntegration
func (c *CustomerProfiles) GetIntegrationRequest(input *GetIntegrationInput) (req *request.Request, output *GetIntegrationOutput) {
	op := &request.Operation{
		Name:       opGetIntegration,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/integrations",
	}

	if input == nil {
		input = &GetIntegrationInput{}
	}

	output = &GetIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntegration API operation for Amazon Connect Customer Profiles.
//
// Returns an integration for a domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetIntegration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIntegration
func (c *CustomerProfiles) GetIntegration(input *GetIntegrationInput) (*GetIntegrationOutput, error) {
	req, out := c.GetIntegrationRequest(input)
	return out, req.Send()
}

// GetIntegrationWithContext is the same as GetIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetIntegrationWithContext(ctx aws.Context, input *GetIntegrationInput, opts ...request.Option) (*GetIntegrationOutput, error) {
	req, out := c.GetIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMatches = "GetMatches"

// GetMatchesRequest generates a "aws/request.Request" representing the
// client's request for the GetMatches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMatches for more information on using the GetMatches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMatchesRequest method.
//	req, resp := client.GetMatchesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetMatches
func (c *CustomerProfiles) GetMatchesRequest(input *GetMatchesInput) (req *request.Request, output *GetMatchesOutput) {
	op := &request.Operation{
		Name:       opGetMatches,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/matches",
	}

	if input == nil {
		input = &GetMatchesInput{}
	}

	output = &GetMatchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMatches API operation for Amazon Connect Customer Profiles.
//
// Before calling this API, use CreateDomain (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html)
// or UpdateDomain (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html)
// to enable identity resolution: set Matching to true.
//
// GetMatches returns potentially matching profiles, based on the results of
// the latest run of a machine learning process.
//
// The process of matching duplicate profiles. If Matching = true, Amazon Connect
// Customer Profiles starts a weekly batch process called Identity Resolution
// Job. If you do not specify a date and time for Identity Resolution Job to
// run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles
// in your domains.
//
// After the Identity Resolution Job completes, use the GetMatches (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html)
// API to return and review the results. Or, if you have configured ExportingConfig
// in the MatchingRequest, you can download the results from S3.
//
// Amazon Connect uses the following profile attributes to identify matches:
//
//   - PhoneNumber
//
//   - HomePhoneNumber
//
//   - BusinessPhoneNumber
//
//   - MobilePhoneNumber
//
//   - EmailAddress
//
//   - PersonalEmailAddress
//
//   - BusinessEmailAddress
//
//   - FullName
//
// For example, two or more profiles—with spelling mistakes such as John Doe
// and Jhn Doe, or different casing email addresses such as JOHN_DOE@ANYCOMPANY.COM
// and johndoe@anycompany.com, or different phone number formats such as 555-010-0000
// and +1-555-010-0000—can be detected as belonging to the same customer John
// Doe and merged into a unified profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetMatches for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetMatches
func (c *CustomerProfiles) GetMatches(input *GetMatchesInput) (*GetMatchesOutput, error) {
	req, out := c.GetMatchesRequest(input)
	return out, req.Send()
}

// GetMatchesWithContext is the same as GetMatches with the addition of
// the ability to pass a context and additional request options.
//
// See GetMatches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetMatchesWithContext(ctx aws.Context, input *GetMatchesInput, opts ...request.Option) (*GetMatchesOutput, error) {
	req, out := c.GetMatchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfileObjectType = "GetProfileObjectType"

// GetProfileObjectTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetProfileObjectType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfileObjectType for more information on using the GetProfileObjectType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProfileObjectTypeRequest method.
//	req, resp := client.GetProfileObjectTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectType
func (c *CustomerProfiles) GetProfileObjectTypeRequest(input *GetProfileObjectTypeInput) (req *request.Request, output *GetProfileObjectTypeOutput) {
	op := &request.Operation{
		Name:       opGetProfileObjectType,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/object-types/{ObjectTypeName}",
	}

	if input == nil {
		input = &GetProfileObjectTypeInput{}
	}

	output = &GetProfileObjectTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfileObjectType API operation for Amazon Connect Customer Profiles.
//
// Returns the object types for a specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetProfileObjectType for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectType
func (c *CustomerProfiles) GetProfileObjectType(input *GetProfileObjectTypeInput) (*GetProfileObjectTypeOutput, error) {
	req, out := c.GetProfileObjectTypeRequest(input)
	return out, req.Send()
}

// GetProfileObjectTypeWithContext is the same as GetProfileObjectType with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfileObjectType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetProfileObjectTypeWithContext(ctx aws.Context, input *GetProfileObjectTypeInput, opts ...request.Option) (*GetProfileObjectTypeOutput, error) {
	req, out := c.GetProfileObjectTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfileObjectTypeTemplate = "GetProfileObjectTypeTemplate"

// GetProfileObjectTypeTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetProfileObjectTypeTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfileObjectTypeTemplate for more information on using the GetProfileObjectTypeTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProfileObjectTypeTemplateRequest method.
//	req, resp := client.GetProfileObjectTypeTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectTypeTemplate
func (c *CustomerProfiles) GetProfileObjectTypeTemplateRequest(input *GetProfileObjectTypeTemplateInput) (req *request.Request, output *GetProfileObjectTypeTemplateOutput) {
	op := &request.Operation{
		Name:       opGetProfileObjectTypeTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/templates/{TemplateId}",
	}

	if input == nil {
		input = &GetProfileObjectTypeTemplateInput{}
	}

	output = &GetProfileObjectTypeTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfileObjectTypeTemplate API operation for Amazon Connect Customer Profiles.
//
// Returns the template information for a specific object type.
//
// A template is a predefined ProfileObjectType, such as “Salesforce-Account”
// or “Salesforce-Contact.” When a user sends a ProfileObject, using the
// PutProfileObject API, with an ObjectTypeName that matches one of the TemplateIds,
// it uses the mappings from the template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetProfileObjectTypeTemplate for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectTypeTemplate
func (c *CustomerProfiles) GetProfileObjectTypeTemplate(input *GetProfileObjectTypeTemplateInput) (*GetProfileObjectTypeTemplateOutput, error) {
	req, out := c.GetProfileObjectTypeTemplateRequest(input)
	return out, req.Send()
}

// GetProfileObjectTypeTemplateWithContext is the same as GetProfileObjectTypeTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfileObjectTypeTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetProfileObjectTypeTemplateWithContext(ctx aws.Context, input *GetProfileObjectTypeTemplateInput, opts ...request.Option) (*GetProfileObjectTypeTemplateOutput, error) {
	req, out := c.GetProfileObjectTypeTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkflow = "GetWorkflow"

// GetWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflow for more information on using the GetWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkflowRequest method.
//	req, resp := client.GetWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflow
func (c *CustomerProfiles) GetWorkflowRequest(input *GetWorkflowInput) (req *request.Request, output *GetWorkflowOutput) {
	op := &request.Operation{
		Name:       opGetWorkflow,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/workflows/{WorkflowId}",
	}

	if input == nil {
		input = &GetWorkflowInput{}
	}

	output = &GetWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkflow API operation for Amazon Connect Customer Profiles.
//
// Get details of specified workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflow
func (c *CustomerProfiles) GetWorkflow(input *GetWorkflowInput) (*GetWorkflowOutput, error) {
	req, out := c.GetWorkflowRequest(input)
	return out, req.Send()
}

// GetWorkflowWithContext is the same as GetWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetWorkflowWithContext(ctx aws.Context, input *GetWorkflowInput, opts ...request.Option) (*GetWorkflowOutput, error) {
	req, out := c.GetWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkflowSteps = "GetWorkflowSteps"

// GetWorkflowStepsRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflowSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflowSteps for more information on using the GetWorkflowSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkflowStepsRequest method.
//	req, resp := client.GetWorkflowStepsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflowSteps
func (c *CustomerProfiles) GetWorkflowStepsRequest(input *GetWorkflowStepsInput) (req *request.Request, output *GetWorkflowStepsOutput) {
	op := &request.Operation{
		Name:       opGetWorkflowSteps,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/workflows/{WorkflowId}/steps",
	}

	if input == nil {
		input = &GetWorkflowStepsInput{}
	}

	output = &GetWorkflowStepsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkflowSteps API operation for Amazon Connect Customer Profiles.
//
// Get granular list of steps in workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetWorkflowSteps for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflowSteps
func (c *CustomerProfiles) GetWorkflowSteps(input *GetWorkflowStepsInput) (*GetWorkflowStepsOutput, error) {
	req, out := c.GetWorkflowStepsRequest(input)
	return out, req.Send()
}

// GetWorkflowStepsWithContext is the same as GetWorkflowSteps with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflowSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetWorkflowStepsWithContext(ctx aws.Context, input *GetWorkflowStepsInput, opts ...request.Option) (*GetWorkflowStepsOutput, error) {
	req, out := c.GetWorkflowStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccountIntegrations = "ListAccountIntegrations"

// ListAccountIntegrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountIntegrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountIntegrations for more information on using the ListAccountIntegrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountIntegrationsRequest method.
//	req, resp := client.ListAccountIntegrationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListAccountIntegrations
func (c *CustomerProfiles) ListAccountIntegrationsRequest(input *ListAccountIntegrationsInput) (req *request.Request, output *ListAccountIntegrationsOutput) {
	op := &request.Operation{
		Name:       opListAccountIntegrations,
		HTTPMethod: "POST",
		HTTPPath:   "/integrations",
	}

	if input == nil {
		input = &ListAccountIntegrationsInput{}
	}

	output = &ListAccountIntegrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountIntegrations API operation for Amazon Connect Customer Profiles.
//
// Lists all of the integrations associated to a specific URI in the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListAccountIntegrations for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListAccountIntegrations
func (c *CustomerProfiles) ListAccountIntegrations(input *ListAccountIntegrationsInput) (*ListAccountIntegrationsOutput, error) {
	req, out := c.ListAccountIntegrationsRequest(input)
	return out, req.Send()
}

// ListAccountIntegrationsWithContext is the same as ListAccountIntegrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountIntegrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListAccountIntegrationsWithContext(ctx aws.Context, input *ListAccountIntegrationsInput, opts ...request.Option) (*ListAccountIntegrationsOutput, error) {
	req, out := c.ListAccountIntegrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCalculatedAttributeDefinitions = "ListCalculatedAttributeDefinitions"

// ListCalculatedAttributeDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCalculatedAttributeDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCalculatedAttributeDefinitions for more information on using the ListCalculatedAttributeDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCalculatedAttributeDefinitionsRequest method.
//	req, resp := client.ListCalculatedAttributeDefinitionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributeDefinitions
func (c *CustomerProfiles) ListCalculatedAttributeDefinitionsRequest(input *ListCalculatedAttributeDefinitionsInput) (req *request.Request, output *ListCalculatedAttributeDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListCalculatedAttributeDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/calculated-attributes",
	}

	if input == nil {
		input = &ListCalculatedAttributeDefinitionsInput{}
	}

	output = &ListCalculatedAttributeDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCalculatedAttributeDefinitions API operation for Amazon Connect Customer Profiles.
//
// # Lists calculated attribute definitions for Customer Profiles
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListCalculatedAttributeDefinitions for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributeDefinitions
func (c *CustomerProfiles) ListCalculatedAttributeDefinitions(input *ListCalculatedAttributeDefinitionsInput) (*ListCalculatedAttributeDefinitionsOutput, error) {
	req, out := c.ListCalculatedAttributeDefinitionsRequest(input)
	return out, req.Send()
}

// ListCalculatedAttributeDefinitionsWithContext is the same as ListCalculatedAttributeDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListCalculatedAttributeDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListCalculatedAttributeDefinitionsWithContext(ctx aws.Context, input *ListCalculatedAttributeDefinitionsInput, opts ...request.Option) (*ListCalculatedAttributeDefinitionsOutput, error) {
	req, out := c.ListCalculatedAttributeDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCalculatedAttributesForProfile = "ListCalculatedAttributesForProfile"

// ListCalculatedAttributesForProfileRequest generates a "aws/request.Request" representing the
// client's request for the ListCalculatedAttributesForProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCalculatedAttributesForProfile for more information on using the ListCalculatedAttributesForProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCalculatedAttributesForProfileRequest method.
//	req, resp := client.ListCalculatedAttributesForProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributesForProfile
func (c *CustomerProfiles) ListCalculatedAttributesForProfileRequest(input *ListCalculatedAttributesForProfileInput) (req *request.Request, output *ListCalculatedAttributesForProfileOutput) {
	op := &request.Operation{
		Name:       opListCalculatedAttributesForProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/profile/{ProfileId}/calculated-attributes",
	}

	if input == nil {
		input = &ListCalculatedAttributesForProfileInput{}
	}

	output = &ListCalculatedAttributesForProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCalculatedAttributesForProfile API operation for Amazon Connect Customer Profiles.
//
// Retrieve a list of calculated attributes for a customer profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListCalculatedAttributesForProfile for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributesForProfile
func (c *CustomerProfiles) ListCalculatedAttributesForProfile(input *ListCalculatedAttributesForProfileInput) (*ListCalculatedAttributesForProfileOutput, error) {
	req, out := c.ListCalculatedAttributesForProfileRequest(input)
	return out, req.Send()
}

// ListCalculatedAttributesForProfileWithContext is the same as ListCalculatedAttributesForProfile with the addition of
// the ability to pass a context and additional request options.
//
// See ListCalculatedAttributesForProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListCalculatedAttributesForProfileWithContext(ctx aws.Context, input *ListCalculatedAttributesForProfileInput, opts ...request.Option) (*ListCalculatedAttributesForProfileOutput, error) {
	req, out := c.ListCalculatedAttributesForProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainsRequest method.
//	req, resp := client.ListDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomains
func (c *CustomerProfiles) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "GET",
		HTTPPath:   "/domains",
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for Amazon Connect Customer Profiles.
//
// Returns a list of all the domains for an AWS account that have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListDomains for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomains
func (c *CustomerProfiles) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEventStreams = "ListEventStreams"

// ListEventStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventStreams for more information on using the ListEventStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventStreamsRequest method.
//	req, resp := client.ListEventStreamsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventStreams
func (c *CustomerProfiles) ListEventStreamsRequest(input *ListEventStreamsInput) (req *request.Request, output *ListEventStreamsOutput) {
	op := &request.Operation{
		Name:       opListEventStreams,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/event-streams",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventStreamsInput{}
	}

	output = &ListEventStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventStreams API operation for Amazon Connect Customer Profiles.
//
// Returns a list of all the event streams in a specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListEventStreams for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventStreams
func (c *CustomerProfiles) ListEventStreams(input *ListEventStreamsInput) (*ListEventStreamsOutput, error) {
	req, out := c.ListEventStreamsRequest(input)
	return out, req.Send()
}

// ListEventStreamsWithContext is the same as ListEventStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListEventStreamsWithContext(ctx aws.Context, input *ListEventStreamsInput, opts ...request.Option) (*ListEventStreamsOutput, error) {
	req, out := c.ListEventStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventStreamsPages iterates over the pages of a ListEventStreams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventStreams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEventStreams operation.
//	pageNum := 0
//	err := client.ListEventStreamsPages(params,
//	    func(page *customerprofiles.ListEventStreamsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CustomerProfiles) ListEventStreamsPages(input *ListEventStreamsInput, fn func(*ListEventStreamsOutput, bool) bool) error {
	return c.ListEventStreamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventStreamsPagesWithContext same as ListEventStreamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListEventStreamsPagesWithContext(ctx aws.Context, input *ListEventStreamsInput, fn func(*ListEventStreamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventStreamsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventStreamsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventStreamsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdentityResolutionJobs = "ListIdentityResolutionJobs"

// ListIdentityResolutionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityResolutionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityResolutionJobs for more information on using the ListIdentityResolutionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdentityResolutionJobsRequest method.
//	req, resp := client.ListIdentityResolutionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIdentityResolutionJobs
func (c *CustomerProfiles) ListIdentityResolutionJobsRequest(input *ListIdentityResolutionJobsInput) (req *request.Request, output *ListIdentityResolutionJobsOutput) {
	op := &request.Operation{
		Name:       opListIdentityResolutionJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/identity-resolution-jobs",
	}

	if input == nil {
		input = &ListIdentityResolutionJobsInput{}
	}

	output = &ListIdentityResolutionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityResolutionJobs API operation for Amazon Connect Customer Profiles.
//
// Lists all of the Identity Resolution Jobs in your domain. The response sorts
// the list by JobStartTime.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListIdentityResolutionJobs for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIdentityResolutionJobs
func (c *CustomerProfiles) ListIdentityResolutionJobs(input *ListIdentityResolutionJobsInput) (*ListIdentityResolutionJobsOutput, error) {
	req, out := c.ListIdentityResolutionJobsRequest(input)
	return out, req.Send()
}

// ListIdentityResolutionJobsWithContext is the same as ListIdentityResolutionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityResolutionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListIdentityResolutionJobsWithContext(ctx aws.Context, input *ListIdentityResolutionJobsInput, opts ...request.Option) (*ListIdentityResolutionJobsOutput, error) {
	req, out := c.ListIdentityResolutionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIntegrations = "ListIntegrations"

// ListIntegrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListIntegrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIntegrations for more information on using the ListIntegrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIntegrationsRequest method.
//	req, resp := client.ListIntegrationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIntegrations
func (c *CustomerProfiles) ListIntegrationsRequest(input *ListIntegrationsInput) (req *request.Request, output *ListIntegrationsOutput) {
	op := &request.Operation{
		Name:       opListIntegrations,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/integrations",
	}

	if input == nil {
		input = &ListIntegrationsInput{}
	}

	output = &ListIntegrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIntegrations API operation for Amazon Connect Customer Profiles.
//
// Lists all of the integrations in your domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListIntegrations for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIntegrations
func (c *CustomerProfiles) ListIntegrations(input *ListIntegrationsInput) (*ListIntegrationsOutput, error) {
	req, out := c.ListIntegrationsRequest(input)
	return out, req.Send()
}

// ListIntegrationsWithContext is the same as ListIntegrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListIntegrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListIntegrationsWithContext(ctx aws.Context, input *ListIntegrationsInput, opts ...request.Option) (*ListIntegrationsOutput, error) {
	req, out := c.ListIntegrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProfileObjectTypeTemplates = "ListProfileObjectTypeTemplates"

// ListProfileObjectTypeTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileObjectTypeTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileObjectTypeTemplates for more information on using the ListProfileObjectTypeTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfileObjectTypeTemplatesRequest method.
//	req, resp := client.ListProfileObjectTypeTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypeTemplates
func (c *CustomerProfiles) ListProfileObjectTypeTemplatesRequest(input *ListProfileObjectTypeTemplatesInput) (req *request.Request, output *ListProfileObjectTypeTemplatesOutput) {
	op := &request.Operation{
		Name:       opListProfileObjectTypeTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/templates",
	}

	if input == nil {
		input = &ListProfileObjectTypeTemplatesInput{}
	}

	output = &ListProfileObjectTypeTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileObjectTypeTemplates API operation for Amazon Connect Customer Profiles.
//
// Lists all of the template information for object types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListProfileObjectTypeTemplates for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypeTemplates
func (c *CustomerProfiles) ListProfileObjectTypeTemplates(input *ListProfileObjectTypeTemplatesInput) (*ListProfileObjectTypeTemplatesOutput, error) {
	req, out := c.ListProfileObjectTypeTemplatesRequest(input)
	return out, req.Send()
}

// ListProfileObjectTypeTemplatesWithContext is the same as ListProfileObjectTypeTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileObjectTypeTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListProfileObjectTypeTemplatesWithContext(ctx aws.Context, input *ListProfileObjectTypeTemplatesInput, opts ...request.Option) (*ListProfileObjectTypeTemplatesOutput, error) {
	req, out := c.ListProfileObjectTypeTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProfileObjectTypes = "ListProfileObjectTypes"

// ListProfileObjectTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileObjectTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileObjectTypes for more information on using the ListProfileObjectTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfileObjectTypesRequest method.
//	req, resp := client.ListProfileObjectTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypes
func (c *CustomerProfiles) ListProfileObjectTypesRequest(input *ListProfileObjectTypesInput) (req *request.Request, output *ListProfileObjectTypesOutput) {
	op := &request.Operation{
		Name:       opListProfileObjectTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/object-types",
	}

	if input == nil {
		input = &ListProfileObjectTypesInput{}
	}

	output = &ListProfileObjectTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileObjectTypes API operation for Amazon Connect Customer Profiles.
//
// Lists all of the templates available within the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListProfileObjectTypes for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypes
func (c *CustomerProfiles) ListProfileObjectTypes(input *ListProfileObjectTypesInput) (*ListProfileObjectTypesOutput, error) {
	req, out := c.ListProfileObjectTypesRequest(input)
	return out, req.Send()
}

// ListProfileObjectTypesWithContext is the same as ListProfileObjectTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileObjectTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListProfileObjectTypesWithContext(ctx aws.Context, input *ListProfileObjectTypesInput, opts ...request.Option) (*ListProfileObjectTypesOutput, error) {
	req, out := c.ListProfileObjectTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProfileObjects = "ListProfileObjects"

// ListProfileObjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileObjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileObjects for more information on using the ListProfileObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfileObjectsRequest method.
//	req, resp := client.ListProfileObjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjects
func (c *CustomerProfiles) ListProfileObjectsRequest(input *ListProfileObjectsInput) (req *request.Request, output *ListProfileObjectsOutput) {
	op := &request.Operation{
		Name:       opListProfileObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/objects",
	}

	if input == nil {
		input = &ListProfileObjectsInput{}
	}

	output = &ListProfileObjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileObjects API operation for Amazon Connect Customer Profiles.
//
// Returns a list of objects associated with a profile of a given ProfileObjectType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListProfileObjects for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjects
func (c *CustomerProfiles) ListProfileObjects(input *ListProfileObjectsInput) (*ListProfileObjectsOutput, error) {
	req, out := c.ListProfileObjectsRequest(input)
	return out, req.Send()
}

// ListProfileObjectsWithContext is the same as ListProfileObjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListProfileObjectsWithContext(ctx aws.Context, input *ListProfileObjectsInput, opts ...request.Option) (*ListProfileObjectsOutput, error) {
	req, out := c.ListProfileObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListTagsForResource
func (c *CustomerProfiles) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Connect Customer Profiles.
//
// Displays the tags associated with an Amazon Connect Customer Profiles resource.
// In Connect Customer Profiles, domains, profile object types, and integrations
// can be tagged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal service error occurred.
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListTagsForResource
func (c *CustomerProfiles) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWorkflows = "ListWorkflows"

// ListWorkflowsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkflows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkflows for more information on using the ListWorkflows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkflowsRequest method.
//	req, resp := client.ListWorkflowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListWorkflows
func (c *CustomerProfiles) ListWorkflowsRequest(input *ListWorkflowsInput) (req *request.Request, output *ListWorkflowsOutput) {
	op := &request.Operation{
		Name:       opListWorkflows,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/workflows",
	}

	if input == nil {
		input = &ListWorkflowsInput{}
	}

	output = &ListWorkflowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkflows API operation for Amazon Connect Customer Profiles.
//
// Query to list all workflows.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListWorkflows for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListWorkflows
func (c *CustomerProfiles) ListWorkflows(input *ListWorkflowsInput) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	return out, req.Send()
}

// ListWorkflowsWithContext is the same as ListWorkflows with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkflows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListWorkflowsWithContext(ctx aws.Context, input *ListWorkflowsInput, opts ...request.Option) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMergeProfiles = "MergeProfiles"

// MergeProfilesRequest generates a "aws/request.Request" representing the
// client's request for the MergeProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MergeProfiles for more information on using the MergeProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the MergeProfilesRequest method.
//	req, resp := client.MergeProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/MergeProfiles
func (c *CustomerProfiles) MergeProfilesRequest(input *MergeProfilesInput) (req *request.Request, output *MergeProfilesOutput) {
	op := &request.Operation{
		Name:       opMergeProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/objects/merge",
	}

	if input == nil {
		input = &MergeProfilesInput{}
	}

	output = &MergeProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MergeProfiles API operation for Amazon Connect Customer Profiles.
//
// Runs an AWS Lambda job that does the following:
//
// All the profileKeys in the ProfileToBeMerged will be moved to the main profile.
//
// All the objects in the ProfileToBeMerged will be moved to the main profile.
//
// All the ProfileToBeMerged will be deleted at the end.
//
// All the profileKeys in the ProfileIdsToBeMerged will be moved to the main
// profile.
//
// Standard fields are merged as follows:
//
// Fields are always "union"-ed if there are no conflicts in standard fields
// or attributeKeys.
//
// When there are conflicting fields:
//
// If no SourceProfileIds entry is specified, the main Profile value is always
// taken.
//
// If a SourceProfileIds entry is specified, the specified profileId is always
// taken, even if it is a NULL value.
//
// You can use MergeProfiles together with GetMatches (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html),
// which returns potentially matching profiles, or use it with the results of
// another matching system. After profiles have been merged, they cannot be
// separated (unmerged).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation MergeProfiles for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/MergeProfiles
func (c *CustomerProfiles) MergeProfiles(input *MergeProfilesInput) (*MergeProfilesOutput, error) {
	req, out := c.MergeProfilesRequest(input)
	return out, req.Send()
}

// MergeProfilesWithContext is the same as MergeProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See MergeProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) MergeProfilesWithContext(ctx aws.Context, input *MergeProfilesInput, opts ...request.Option) (*MergeProfilesOutput, error) {
	req, out := c.MergeProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutIntegration = "PutIntegration"

// PutIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the PutIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutIntegration for more information on using the PutIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutIntegrationRequest method.
//	req, resp := client.PutIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutIntegration
func (c *CustomerProfiles) PutIntegrationRequest(input *PutIntegrationInput) (req *request.Request, output *PutIntegrationOutput) {
	op := &request.Operation{
		Name:       opPutIntegration,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}/integrations",
	}

	if input == nil {
		input = &PutIntegrationInput{}
	}

	output = &PutIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutIntegration API operation for Amazon Connect Customer Profiles.
//
// Adds an integration between the service and a third-party service, which
// includes Amazon AppFlow and Amazon Connect.
//
// An integration can belong to only one domain.
//
// To add or remove tags on an existing Integration, see TagResource (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html)/
// UntagResource (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation PutIntegration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutIntegration
func (c *CustomerProfiles) PutIntegration(input *PutIntegrationInput) (*PutIntegrationOutput, error) {
	req, out := c.PutIntegrationRequest(input)
	return out, req.Send()
}

// PutIntegrationWithContext is the same as PutIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See PutIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) PutIntegrationWithContext(ctx aws.Context, input *PutIntegrationInput, opts ...request.Option) (*PutIntegrationOutput, error) {
	req, out := c.PutIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutProfileObject = "PutProfileObject"

// PutProfileObjectRequest generates a "aws/request.Request" representing the
// client's request for the PutProfileObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutProfileObject for more information on using the PutProfileObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutProfileObjectRequest method.
//	req, resp := client.PutProfileObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObject
func (c *CustomerProfiles) PutProfileObjectRequest(input *PutProfileObjectInput) (req *request.Request, output *PutProfileObjectOutput) {
	op := &request.Operation{
		Name:       opPutProfileObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}/profiles/objects",
	}

	if input == nil {
		input = &PutProfileObjectInput{}
	}

	output = &PutProfileObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutProfileObject API operation for Amazon Connect Customer Profiles.
//
// Adds additional objects to customer profiles of a given ObjectType.
//
// When adding a specific profile object, like a Contact Record, an inferred
// profile can get created if it is not mapped to an existing profile. The resulting
// profile will only have a phone number populated in the standard ProfileObject.
// Any additional Contact Records with the same phone number will be mapped
// to the same inferred profile.
//
// When a ProfileObject is created and if a ProfileObjectType already exists
// for the ProfileObject, it will provide data to a standard profile depending
// on the ProfileObjectType definition.
//
// PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation PutProfileObject for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObject
func (c *CustomerProfiles) PutProfileObject(input *PutProfileObjectInput) (*PutProfileObjectOutput, error) {
	req, out := c.PutProfileObjectRequest(input)
	return out, req.Send()
}

// PutProfileObjectWithContext is the same as PutProfileObject with the addition of
// the ability to pass a context and additional request options.
//
// See PutProfileObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) PutProfileObjectWithContext(ctx aws.Context, input *PutProfileObjectInput, opts ...request.Option) (*PutProfileObjectOutput, error) {
	req, out := c.PutProfileObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutProfileObjectType = "PutProfileObjectType"

// PutProfileObjectTypeRequest generates a "aws/request.Request" representing the
// client's request for the PutProfileObjectType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutProfileObjectType for more information on using the PutProfileObjectType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutProfileObjectTypeRequest method.
//	req, resp := client.PutProfileObjectTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObjectType
func (c *CustomerProfiles) PutProfileObjectTypeRequest(input *PutProfileObjectTypeInput) (req *request.Request, output *PutProfileObjectTypeOutput) {
	op := &request.Operation{
		Name:       opPutProfileObjectType,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}/object-types/{ObjectTypeName}",
	}

	if input == nil {
		input = &PutProfileObjectTypeInput{}
	}

	output = &PutProfileObjectTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutProfileObjectType API operation for Amazon Connect Customer Profiles.
//
// Defines a ProfileObjectType.
//
// To add or remove tags on an existing ObjectType, see TagResource (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html)/UntagResource
// (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation PutProfileObjectType for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObjectType
func (c *CustomerProfiles) PutProfileObjectType(input *PutProfileObjectTypeInput) (*PutProfileObjectTypeOutput, error) {
	req, out := c.PutProfileObjectTypeRequest(input)
	return out, req.Send()
}

// PutProfileObjectTypeWithContext is the same as PutProfileObjectType with the addition of
// the ability to pass a context and additional request options.
//
// See PutProfileObjectType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) PutProfileObjectTypeWithContext(ctx aws.Context, input *PutProfileObjectTypeInput, opts ...request.Option) (*PutProfileObjectTypeOutput, error) {
	req, out := c.PutProfileObjectTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchProfiles = "SearchProfiles"

// SearchProfilesRequest generates a "aws/request.Request" representing the
// client's request for the SearchProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchProfiles for more information on using the SearchProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchProfilesRequest method.
//	req, resp := client.SearchProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/SearchProfiles
func (c *CustomerProfiles) SearchProfilesRequest(input *SearchProfilesInput) (req *request.Request, output *SearchProfilesOutput) {
	op := &request.Operation{
		Name:       opSearchProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/search",
	}

	if input == nil {
		input = &SearchProfilesInput{}
	}

	output = &SearchProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchProfiles API operation for Amazon Connect Customer Profiles.
//
// Searches for profiles within a specific domain using one or more predefined
// search keys (e.g., _fullName, _phone, _email, _account, etc.) and/or custom-defined
// search keys. A search key is a data type pair that consists of a KeyName
// and Values list.
//
// This operation supports searching for profiles with a minimum of 1 key-value(s)
// pair and up to 5 key-value(s) pairs using either AND or OR logic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation SearchProfiles for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/SearchProfiles
func (c *CustomerProfiles) SearchProfiles(input *SearchProfilesInput) (*SearchProfilesOutput, error) {
	req, out := c.SearchProfilesRequest(input)
	return out, req.Send()
}

// SearchProfilesWithContext is the same as SearchProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See SearchProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) SearchProfilesWithContext(ctx aws.Context, input *SearchProfilesInput, opts ...request.Option) (*SearchProfilesOutput, error) {
	req, out := c.SearchProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/TagResource
func (c *CustomerProfiles) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Connect Customer Profiles.
//
// Assigns one or more tags (key-value pairs) to the specified Amazon Connect
// Customer Profiles resource. Tags can help you organize and categorize your
// resources. You can also use them to scope user permissions by granting a
// user permission to access or change only resources with certain tag values.
// In Connect Customer Profiles, domains, profile object types, and integrations
// can be tagged.
//
// Tags don't have any semantic meaning to AWS and are interpreted strictly
// as strings of characters.
//
// You can use the TagResource action with a resource that already has tags.
// If you specify a new tag key, this tag is appended to the list of tags associated
// with the resource. If you specify a tag key that is already associated with
// the resource, the new tag value that you specify replaces the previous value
// for that tag.
//
// You can associate as many as 50 tags with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal service error occurred.
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/TagResource
func (c *CustomerProfiles) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UntagResource
func (c *CustomerProfiles) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Connect Customer Profiles.
//
// Removes one or more tags from the specified Amazon Connect Customer Profiles
// resource. In Connect Customer Profiles, domains, profile object types, and
// integrations can be tagged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal service error occurred.
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UntagResource
func (c *CustomerProfiles) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCalculatedAttributeDefinition = "UpdateCalculatedAttributeDefinition"

// UpdateCalculatedAttributeDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCalculatedAttributeDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCalculatedAttributeDefinition for more information on using the UpdateCalculatedAttributeDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCalculatedAttributeDefinitionRequest method.
//	req, resp := client.UpdateCalculatedAttributeDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateCalculatedAttributeDefinition
func (c *CustomerProfiles) UpdateCalculatedAttributeDefinitionRequest(input *UpdateCalculatedAttributeDefinitionInput) (req *request.Request, output *UpdateCalculatedAttributeDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateCalculatedAttributeDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}",
	}

	if input == nil {
		input = &UpdateCalculatedAttributeDefinitionInput{}
	}

	output = &UpdateCalculatedAttributeDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCalculatedAttributeDefinition API operation for Amazon Connect Customer Profiles.
//
// Updates an existing calculated attribute definition. When updating the Conditions,
// note that increasing the date range of a calculated attribute will not trigger
// inclusion of historical data greater than the current date range.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation UpdateCalculatedAttributeDefinition for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateCalculatedAttributeDefinition
func (c *CustomerProfiles) UpdateCalculatedAttributeDefinition(input *UpdateCalculatedAttributeDefinitionInput) (*UpdateCalculatedAttributeDefinitionOutput, error) {
	req, out := c.UpdateCalculatedAttributeDefinitionRequest(input)
	return out, req.Send()
}

// UpdateCalculatedAttributeDefinitionWithContext is the same as UpdateCalculatedAttributeDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCalculatedAttributeDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) UpdateCalculatedAttributeDefinitionWithContext(ctx aws.Context, input *UpdateCalculatedAttributeDefinitionInput, opts ...request.Option) (*UpdateCalculatedAttributeDefinitionOutput, error) {
	req, out := c.UpdateCalculatedAttributeDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomain = "UpdateDomain"

// UpdateDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomain for more information on using the UpdateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDomainRequest method.
//	req, resp := client.UpdateDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateDomain
func (c *CustomerProfiles) UpdateDomainRequest(input *UpdateDomainInput) (req *request.Request, output *UpdateDomainOutput) {
	op := &request.Operation{
		Name:       opUpdateDomain,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}",
	}

	if input == nil {
		input = &UpdateDomainInput{}
	}

	output = &UpdateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomain API operation for Amazon Connect Customer Profiles.
//
// Updates the properties of a domain, including creating or selecting a dead
// letter queue or an encryption key.
//
// After a domain is created, the name can’t be changed.
//
// Use this API or CreateDomain (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html)
// to enable identity resolution (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html):
// set Matching to true.
//
// To prevent cross-service impersonation when you call this API, see Cross-service
// confused deputy prevention (https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html)
// for sample policies that you should apply.
//
// To add or remove tags on an existing Domain, see TagResource (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html)/UntagResource
// (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation UpdateDomain for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateDomain
func (c *CustomerProfiles) UpdateDomain(input *UpdateDomainInput) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	return out, req.Send()
}

// UpdateDomainWithContext is the same as UpdateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) UpdateDomainWithContext(ctx aws.Context, input *UpdateDomainInput, opts ...request.Option) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProfile = "UpdateProfile"

// UpdateProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProfile for more information on using the UpdateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProfileRequest method.
//	req, resp := client.UpdateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateProfile
func (c *CustomerProfiles) UpdateProfileRequest(input *UpdateProfileInput) (req *request.Request, output *UpdateProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}/profiles",
	}

	if input == nil {
		input = &UpdateProfileInput{}
	}

	output = &UpdateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProfile API operation for Amazon Connect Customer Profiles.
//
// Updates the properties of a profile. The ProfileId is required for updating
// a customer profile.
//
// When calling the UpdateProfile API, specifying an empty string value means
// that any existing value will be removed. Not specifying a string value means
// that any value already there will be kept.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation UpdateProfile for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input you provided is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource does not exist, or access was denied.
//
//   - ThrottlingException
//     You exceeded the maximum number of requests.
//
//   - InternalServerException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateProfile
func (c *CustomerProfiles) UpdateProfile(input *UpdateProfileInput) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	return out, req.Send()
}

// UpdateProfileWithContext is the same as UpdateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) UpdateProfileWithContext(ctx aws.Context, input *UpdateProfileInput, opts ...request.Option) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddProfileKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// A searchable identifier of a customer profile. The predefined keys you can
	// use include: _account, _profileId, _assetId, _caseId, _orderId, _fullName,
	// _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId,
	// _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId,
	// _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId,
	// _shopifyOrderId.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// A list of key values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddProfileKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddProfileKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddProfileKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddProfileKeyInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *AddProfileKeyInput) SetDomainName(v string) *AddProfileKeyInput {
	s.DomainName = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AddProfileKeyInput) SetKeyName(v string) *AddProfileKeyInput {
	s.KeyName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *AddProfileKeyInput) SetProfileId(v string) *AddProfileKeyInput {
	s.ProfileId = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AddProfileKeyInput) SetValues(v []*string) *AddProfileKeyInput {
	s.Values = v
	return s
}

type AddProfileKeyOutput struct {
	_ struct{} `type:"structure"`

	// A searchable identifier of a customer profile.
	KeyName *string `min:"1" type:"string"`

	// A list of key values.
	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddProfileKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddProfileKeyOutput) GoString() string {
	return s.String()
}

// SetKeyName sets the KeyName field's value.
func (s *AddProfileKeyOutput) SetKeyName(v string) *AddProfileKeyOutput {
	s.KeyName = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AddProfileKeyOutput) SetValues(v []*string) *AddProfileKeyOutput {
	s.Values = v
	return s
}

// A data type pair that consists of a KeyName and Values list that is used
// in conjunction with the KeyName (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html#customerprofiles-SearchProfiles-request-KeyName)
// and Values (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html#customerprofiles-SearchProfiles-request-Values)
// parameters to search for profiles using the SearchProfiles (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html)
// API.
type AdditionalSearchKey struct {
	_ struct{} `type:"structure"`

	// A searchable identifier of a customer profile.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// A list of key values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalSearchKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalSearchKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdditionalSearchKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdditionalSearchKey"}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyName sets the KeyName field's value.
func (s *AdditionalSearchKey) SetKeyName(v string) *AdditionalSearchKey {
	s.KeyName = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AdditionalSearchKey) SetValues(v []*string) *AdditionalSearchKey {
	s.Values = v
	return s
}

// A generic address associated with the customer that is not mailing, shipping,
// or billing.
type Address struct {
	_ struct{} `type:"structure"`

	// The first line of a customer address.
	Address1 *string `min:"1" type:"string"`

	// The second line of a customer address.
	Address2 *string `min:"1" type:"string"`

	// The third line of a customer address.
	Address3 *string `min:"1" type:"string"`

	// The fourth line of a customer address.
	Address4 *string `min:"1" type:"string"`

	// The city in which a customer lives.
	City *string `min:"1" type:"string"`

	// The country in which a customer lives.
	Country *string `min:"1" type:"string"`

	// The county in which a customer lives.
	County *string `min:"1" type:"string"`

	// The postal code of a customer address.
	PostalCode *string `min:"1" type:"string"`

	// The province in which a customer lives.
	Province *string `min:"1" type:"string"`

	// The state in which a customer lives.
	State *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Address) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Address"}
	if s.Address1 != nil && len(*s.Address1) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address1", 1))
	}
	if s.Address2 != nil && len(*s.Address2) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address2", 1))
	}
	if s.Address3 != nil && len(*s.Address3) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address3", 1))
	}
	if s.Address4 != nil && len(*s.Address4) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address4", 1))
	}
	if s.City != nil && len(*s.City) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("City", 1))
	}
	if s.Country != nil && len(*s.Country) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Country", 1))
	}
	if s.County != nil && len(*s.County) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("County", 1))
	}
	if s.PostalCode != nil && len(*s.PostalCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PostalCode", 1))
	}
	if s.Province != nil && len(*s.Province) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Province", 1))
	}
	if s.State != nil && len(*s.State) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("State", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress1 sets the Address1 field's value.
func (s *Address) SetAddress1(v string) *Address {
	s.Address1 = &v
	return s
}

// SetAddress2 sets the Address2 field's value.
func (s *Address) SetAddress2(v string) *Address {
	s.Address2 = &v
	return s
}

// SetAddress3 sets the Address3 field's value.
func (s *Address) SetAddress3(v string) *Address {
	s.Address3 = &v
	return s
}

// SetAddress4 sets the Address4 field's value.
func (s *Address) SetAddress4(v string) *Address {
	s.Address4 = &v
	return s
}

// SetCity sets the City field's value.
func (s *Address) SetCity(v string) *Address {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *Address) SetCountry(v string) *Address {
	s.Country = &v
	return s
}

// SetCounty sets the County field's value.
func (s *Address) SetCounty(v string) *Address {
	s.County = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Address) SetPostalCode(v string) *Address {
	s.PostalCode = &v
	return s
}

// SetProvince sets the Province field's value.
func (s *Address) SetProvince(v string) *Address {
	s.Province = &v
	return s
}

// SetState sets the State field's value.
func (s *Address) SetState(v string) *Address {
	s.State = &v
	return s
}

// Details for workflow of type APPFLOW_INTEGRATION.
type AppflowIntegration struct {
	_ struct{} `type:"structure"`

	// Batches in workflow of type APPFLOW_INTEGRATION.
	Batches []*Batch `type:"list"`

	// The configurations that control how Customer Profiles retrieves data from
	// the source, Amazon AppFlow. Customer Profiles uses this information to create
	// an AppFlow flow on behalf of customers.
	//
	// FlowDefinition is a required field
	FlowDefinition *FlowDefinition `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppflowIntegration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppflowIntegration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppflowIntegration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppflowIntegration"}
	if s.FlowDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowDefinition"))
	}
	if s.Batches != nil {
		for i, v := range s.Batches {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Batches", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FlowDefinition != nil {
		if err := s.FlowDefinition.Validate(); err != nil {
			invalidParams.AddNested("FlowDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatches sets the Batches field's value.
func (s *AppflowIntegration) SetBatches(v []*Batch) *AppflowIntegration {
	s.Batches = v
	return s
}

// SetFlowDefinition sets the FlowDefinition field's value.
func (s *AppflowIntegration) SetFlowDefinition(v *FlowDefinition) *AppflowIntegration {
	s.FlowDefinition = v
	return s
}

// Structure holding all APPFLOW_INTEGRATION specific workflow attributes.
type AppflowIntegrationWorkflowAttributes struct {
	_ struct{} `type:"structure"`

	// The name of the AppFlow connector profile used for ingestion.
	//
	// ConnectorProfileName is a required field
	ConnectorProfileName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes
	// this role to create resources on your behalf as part of workflow execution.
	RoleArn *string `min:"1" type:"string"`

	// Specifies the source connector type, such as Salesforce, ServiceNow, and
	// Marketo. Indicates source of ingestion.
	//
	// SourceConnectorType is a required field
	SourceConnectorType *string `type:"string" required:"true" enum:"SourceConnectorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppflowIntegrationWorkflowAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppflowIntegrationWorkflowAttributes) GoString() string {
	return s.String()
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *AppflowIntegrationWorkflowAttributes) SetConnectorProfileName(v string) *AppflowIntegrationWorkflowAttributes {
	s.ConnectorProfileName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AppflowIntegrationWorkflowAttributes) SetRoleArn(v string) *AppflowIntegrationWorkflowAttributes {
	s.RoleArn = &v
	return s
}

// SetSourceConnectorType sets the SourceConnectorType field's value.
func (s *AppflowIntegrationWorkflowAttributes) SetSourceConnectorType(v string) *AppflowIntegrationWorkflowAttributes {
	s.SourceConnectorType = &v
	return s
}

// Workflow specific execution metrics for APPFLOW_INTEGRATION workflow.
type AppflowIntegrationWorkflowMetrics struct {
	_ struct{} `type:"structure"`

	// Number of records processed in APPFLOW_INTEGRATION workflow.
	//
	// RecordsProcessed is a required field
	RecordsProcessed *int64 `type:"long" required:"true"`

	// Total steps completed in APPFLOW_INTEGRATION workflow.
	//
	// StepsCompleted is a required field
	StepsCompleted *int64 `type:"long" required:"true"`

	// Total steps in APPFLOW_INTEGRATION workflow.
	//
	// TotalSteps is a required field
	TotalSteps *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppflowIntegrationWorkflowMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppflowIntegrationWorkflowMetrics) GoString() string {
	return s.String()
}

// SetRecordsProcessed sets the RecordsProcessed field's value.
func (s *AppflowIntegrationWorkflowMetrics) SetRecordsProcessed(v int64) *AppflowIntegrationWorkflowMetrics {
	s.RecordsProcessed = &v
	return s
}

// SetStepsCompleted sets the StepsCompleted field's value.
func (s *AppflowIntegrationWorkflowMetrics) SetStepsCompleted(v int64) *AppflowIntegrationWorkflowMetrics {
	s.StepsCompleted = &v
	return s
}

// SetTotalSteps sets the TotalSteps field's value.
func (s *AppflowIntegrationWorkflowMetrics) SetTotalSteps(v int64) *AppflowIntegrationWorkflowMetrics {
	s.TotalSteps = &v
	return s
}

// Workflow step details for APPFLOW_INTEGRATION workflow.
type AppflowIntegrationWorkflowStep struct {
	_ struct{} `type:"structure"`

	// End datetime of records pulled in batch during execution of workflow step
	// for APPFLOW_INTEGRATION workflow.
	//
	// BatchRecordsEndTime is a required field
	BatchRecordsEndTime *string `min:"1" type:"string" required:"true"`

	// Start datetime of records pulled in batch during execution of workflow step
	// for APPFLOW_INTEGRATION workflow.
	//
	// BatchRecordsStartTime is a required field
	BatchRecordsStartTime *string `min:"1" type:"string" required:"true"`

	// Creation timestamp of workflow step for APPFLOW_INTEGRATION workflow.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// Message indicating execution of workflow step for APPFLOW_INTEGRATION workflow.
	//
	// ExecutionMessage is a required field
	ExecutionMessage *string `min:"1" type:"string" required:"true"`

	// Name of the flow created during execution of workflow step. APPFLOW_INTEGRATION
	// workflow type creates an appflow flow during workflow step execution on the
	// customers behalf.
	//
	// FlowName is a required field
	FlowName *string `type:"string" required:"true"`

	// Last updated timestamp for workflow step for APPFLOW_INTEGRATION workflow.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// Total number of records processed during execution of workflow step for APPFLOW_INTEGRATION
	// workflow.
	//
	// RecordsProcessed is a required field
	RecordsProcessed *int64 `type:"long" required:"true"`

	// Workflow step status for APPFLOW_INTEGRATION workflow.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppflowIntegrationWorkflowStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppflowIntegrationWorkflowStep) GoString() string {
	return s.String()
}

// SetBatchRecordsEndTime sets the BatchRecordsEndTime field's value.
func (s *AppflowIntegrationWorkflowStep) SetBatchRecordsEndTime(v string) *AppflowIntegrationWorkflowStep {
	s.BatchRecordsEndTime = &v
	return s
}

// SetBatchRecordsStartTime sets the BatchRecordsStartTime field's value.
func (s *AppflowIntegrationWorkflowStep) SetBatchRecordsStartTime(v string) *AppflowIntegrationWorkflowStep {
	s.BatchRecordsStartTime = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AppflowIntegrationWorkflowStep) SetCreatedAt(v time.Time) *AppflowIntegrationWorkflowStep {
	s.CreatedAt = &v
	return s
}

// SetExecutionMessage sets the ExecutionMessage field's value.
func (s *AppflowIntegrationWorkflowStep) SetExecutionMessage(v string) *AppflowIntegrationWorkflowStep {
	s.ExecutionMessage = &v
	return s
}

// SetFlowName sets the FlowName field's value.
func (s *AppflowIntegrationWorkflowStep) SetFlowName(v string) *AppflowIntegrationWorkflowStep {
	s.FlowName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *AppflowIntegrationWorkflowStep) SetLastUpdatedAt(v time.Time) *AppflowIntegrationWorkflowStep {
	s.LastUpdatedAt = &v
	return s
}

// SetRecordsProcessed sets the RecordsProcessed field's value.
func (s *AppflowIntegrationWorkflowStep) SetRecordsProcessed(v int64) *AppflowIntegrationWorkflowStep {
	s.RecordsProcessed = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AppflowIntegrationWorkflowStep) SetStatus(v string) *AppflowIntegrationWorkflowStep {
	s.Status = &v
	return s
}

// Mathematical expression and a list of attribute items specified in that expression.
type AttributeDetails struct {
	_ struct{} `type:"structure"`

	// A list of attribute items specified in the mathematical expression.
	//
	// Attributes is a required field
	Attributes []*AttributeItem `min:"1" type:"list" required:"true"`

	// Mathematical expression that is performed on attribute items provided in
	// the attribute list. Each element in the expression should follow the structure
	// of \"{ObjectTypeName.AttributeName}\".
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeDetails"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attributes", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *AttributeDetails) SetAttributes(v []*AttributeItem) *AttributeDetails {
	s.Attributes = v
	return s
}

// SetExpression sets the Expression field's value.
func (s *AttributeDetails) SetExpression(v string) *AttributeDetails {
	s.Expression = &v
	return s
}

// The details of a single attribute item specified in the mathematical expression.
type AttributeItem struct {
	_ struct{} `type:"structure"`

	// The name of an attribute defined in a profile object type.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeItem"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AttributeItem) SetName(v string) *AttributeItem {
	s.Name = &v
	return s
}

// Configuration settings for how to perform the auto-merging of profiles.
type AutoMerging struct {
	_ struct{} `type:"structure"`

	// How the auto-merging process should resolve conflicts between different profiles.
	// For example, if Profile A and Profile B have the same FirstName and LastName
	// (and that is the matching criteria), which EmailAddress should be used?
	ConflictResolution *ConflictResolution `type:"structure"`

	// A list of matching attributes that represent matching criteria. If two profiles
	// meet at least one of the requirements in the matching attributes list, they
	// will be merged.
	Consolidation *Consolidation `type:"structure"`

	// The flag that enables the auto-merging of duplicate profiles.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A number between 0 and 1 that represents the minimum confidence score required
	// for profiles within a matching group to be merged during the auto-merge process.
	// A higher score means higher similarity required to merge profiles.
	MinAllowedConfidenceScoreForMerging *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoMerging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoMerging) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMerging) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMerging"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.ConflictResolution != nil {
		if err := s.ConflictResolution.Validate(); err != nil {
			invalidParams.AddNested("ConflictResolution", err.(request.ErrInvalidParams))
		}
	}
	if s.Consolidation != nil {
		if err := s.Consolidation.Validate(); err != nil {
			invalidParams.AddNested("Consolidation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConflictResolution sets the ConflictResolution field's value.
func (s *AutoMerging) SetConflictResolution(v *ConflictResolution) *AutoMerging {
	s.ConflictResolution = v
	return s
}

// SetConsolidation sets the Consolidation field's value.
func (s *AutoMerging) SetConsolidation(v *Consolidation) *AutoMerging {
	s.Consolidation = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AutoMerging) SetEnabled(v bool) *AutoMerging {
	s.Enabled = &v
	return s
}

// SetMinAllowedConfidenceScoreForMerging sets the MinAllowedConfidenceScoreForMerging field's value.
func (s *AutoMerging) SetMinAllowedConfidenceScoreForMerging(v float64) *AutoMerging {
	s.MinAllowedConfidenceScoreForMerging = &v
	return s
}

// The input you provided is invalid.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Batch defines the boundaries for ingestion for each step in APPFLOW_INTEGRATION
// workflow. APPFLOW_INTEGRATION workflow splits ingestion based on these boundaries.
type Batch struct {
	_ struct{} `type:"structure"`

	// End time of batch to split ingestion.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// Start time of batch to split ingestion.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Batch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Batch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Batch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Batch"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *Batch) SetEndTime(v time.Time) *Batch {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Batch) SetStartTime(v time.Time) *Batch {
	s.StartTime = &v
	return s
}

// The conditions including range, object count, and threshold for the calculated
// attribute.
type Conditions struct {
	_ struct{} `type:"structure"`

	// The number of profile objects used for the calculated attribute.
	ObjectCount *int64 `min:"1" type:"integer"`

	// The relative time period over which data is included in the aggregation.
	Range *Range `type:"structure"`

	// The threshold for the calculated attribute.
	Threshold *Threshold `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Conditions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Conditions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Conditions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Conditions"}
	if s.ObjectCount != nil && *s.ObjectCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ObjectCount", 1))
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(request.ErrInvalidParams))
		}
	}
	if s.Threshold != nil {
		if err := s.Threshold.Validate(); err != nil {
			invalidParams.AddNested("Threshold", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectCount sets the ObjectCount field's value.
func (s *Conditions) SetObjectCount(v int64) *Conditions {
	s.ObjectCount = &v
	return s
}

// SetRange sets the Range field's value.
func (s *Conditions) SetRange(v *Range) *Conditions {
	s.Range = v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *Conditions) SetThreshold(v *Threshold) *Conditions {
	s.Threshold = v
	return s
}

// How the auto-merging process should resolve conflicts between different profiles.
type ConflictResolution struct {
	_ struct{} `type:"structure"`

	// How the auto-merging process should resolve conflicts between different profiles.
	//
	//    * RECENCY: Uses the data that was most recently updated.
	//
	//    * SOURCE: Uses the data from a specific source. For example, if a company
	//    has been aquired or two departments have merged, data from the specified
	//    source is used. If two duplicate profiles are from the same source, then
	//    RECENCY is used again.
	//
	// ConflictResolvingModel is a required field
	ConflictResolvingModel *string `type:"string" required:"true" enum:"ConflictResolvingModel"`

	// The ObjectType name that is used to resolve profile merging conflicts when
	// choosing SOURCE as the ConflictResolvingModel.
	SourceName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictResolution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictResolution) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConflictResolution) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConflictResolution"}
	if s.ConflictResolvingModel == nil {
		invalidParams.Add(request.NewErrParamRequired("ConflictResolvingModel"))
	}
	if s.SourceName != nil && len(*s.SourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConflictResolvingModel sets the ConflictResolvingModel field's value.
func (s *ConflictResolution) SetConflictResolvingModel(v string) *ConflictResolution {
	s.ConflictResolvingModel = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *ConflictResolution) SetSourceName(v string) *ConflictResolution {
	s.SourceName = &v
	return s
}

// The operation to be performed on the provided source fields.
type ConnectorOperator struct {
	_ struct{} `type:"structure"`

	// The operation to be performed on the provided Marketo source fields.
	Marketo *string `type:"string" enum:"MarketoConnectorOperator"`

	// The operation to be performed on the provided Amazon S3 source fields.
	S3 *string `type:"string" enum:"S3ConnectorOperator"`

	// The operation to be performed on the provided Salesforce source fields.
	Salesforce *string `type:"string" enum:"SalesforceConnectorOperator"`

	// The operation to be performed on the provided ServiceNow source fields.
	ServiceNow *string `type:"string" enum:"ServiceNowConnectorOperator"`

	// The operation to be performed on the provided Zendesk source fields.
	Zendesk *string `type:"string" enum:"ZendeskConnectorOperator"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorOperator) GoString() string {
	return s.String()
}

// SetMarketo sets the Marketo field's value.
func (s *ConnectorOperator) SetMarketo(v string) *ConnectorOperator {
	s.Marketo = &v
	return s
}

// SetS3 sets the S3 field's value.
func (s *ConnectorOperator) SetS3(v string) *ConnectorOperator {
	s.S3 = &v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *ConnectorOperator) SetSalesforce(v string) *ConnectorOperator {
	s.Salesforce = &v
	return s
}

// SetServiceNow sets the ServiceNow field's value.
func (s *ConnectorOperator) SetServiceNow(v string) *ConnectorOperator {
	s.ServiceNow = &v
	return s
}

// SetZendesk sets the Zendesk field's value.
func (s *ConnectorOperator) SetZendesk(v string) *ConnectorOperator {
	s.Zendesk = &v
	return s
}

// The matching criteria to be used during the auto-merging process.
type Consolidation struct {
	_ struct{} `type:"structure"`

	// A list of matching criteria.
	//
	// MatchingAttributesList is a required field
	MatchingAttributesList [][]*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Consolidation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Consolidation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Consolidation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Consolidation"}
	if s.MatchingAttributesList == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchingAttributesList"))
	}
	if s.MatchingAttributesList != nil && len(s.MatchingAttributesList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MatchingAttributesList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMatchingAttributesList sets the MatchingAttributesList field's value.
func (s *Consolidation) SetMatchingAttributesList(v [][]*string) *Consolidation {
	s.MatchingAttributesList = v
	return s
}

type CreateCalculatedAttributeDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Mathematical expression and a list of attribute items specified in that expression.
	//
	// AttributeDetails is a required field
	AttributeDetails *AttributeDetails `type:"structure" required:"true"`

	// The unique name of the calculated attribute.
	//
	// CalculatedAttributeName is a required field
	CalculatedAttributeName *string `location:"uri" locationName:"CalculatedAttributeName" min:"1" type:"string" required:"true"`

	// The conditions including range, object count, and threshold for the calculated
	// attribute.
	Conditions *Conditions `type:"structure"`

	// The description of the calculated attribute.
	Description *string `min:"1" type:"string"`

	// The display name of the calculated attribute.
	DisplayName *string `min:"1" type:"string"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The aggregation operation to perform for the calculated attribute.
	//
	// Statistic is a required field
	Statistic *string `type:"string" required:"true" enum:"Statistic"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCalculatedAttributeDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCalculatedAttributeDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCalculatedAttributeDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCalculatedAttributeDefinitionInput"}
	if s.AttributeDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeDetails"))
	}
	if s.CalculatedAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatedAttributeName"))
	}
	if s.CalculatedAttributeName != nil && len(*s.CalculatedAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatedAttributeName", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.AttributeDetails != nil {
		if err := s.AttributeDetails.Validate(); err != nil {
			invalidParams.AddNested("AttributeDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.Conditions != nil {
		if err := s.Conditions.Validate(); err != nil {
			invalidParams.AddNested("Conditions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeDetails sets the AttributeDetails field's value.
func (s *CreateCalculatedAttributeDefinitionInput) SetAttributeDetails(v *AttributeDetails) *CreateCalculatedAttributeDefinitionInput {
	s.AttributeDetails = v
	return s
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *CreateCalculatedAttributeDefinitionInput) SetCalculatedAttributeName(v string) *CreateCalculatedAttributeDefinitionInput {
	s.CalculatedAttributeName = &v
	return s
}

// SetConditions sets the Conditions field's value.
func (s *CreateCalculatedAttributeDefinitionInput) SetConditions(v *Conditions) *CreateCalculatedAttributeDefinitionInput {
	s.Conditions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCalculatedAttributeDefinitionInput) SetDescription(v string) *CreateCalculatedAttributeDefinitionInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateCalculatedAttributeDefinitionInput) SetDisplayName(v string) *CreateCalculatedAttributeDefinitionInput {
	s.DisplayName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateCalculatedAttributeDefinitionInput) SetDomainName(v string) *CreateCalculatedAttributeDefinitionInput {
	s.DomainName = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CreateCalculatedAttributeDefinitionInput) SetStatistic(v string) *CreateCalculatedAttributeDefinitionInput {
	s.Statistic = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCalculatedAttributeDefinitionInput) SetTags(v map[string]*string) *CreateCalculatedAttributeDefinitionInput {
	s.Tags = v
	return s
}

type CreateCalculatedAttributeDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Mathematical expression and a list of attribute items specified in that expression.
	AttributeDetails *AttributeDetails `type:"structure"`

	// The unique name of the calculated attribute.
	CalculatedAttributeName *string `min:"1" type:"string"`

	// The conditions including range, object count, and threshold for the calculated
	// attribute.
	Conditions *Conditions `type:"structure"`

	// The timestamp of when the calculated attribute definition was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the calculated attribute.
	Description *string `min:"1" type:"string"`

	// The display name of the calculated attribute.
	DisplayName *string `min:"1" type:"string"`

	// The timestamp of when the calculated attribute definition was most recently
	// edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The aggregation operation to perform for the calculated attribute.
	Statistic *string `type:"string" enum:"Statistic"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCalculatedAttributeDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCalculatedAttributeDefinitionOutput) GoString() string {
	return s.String()
}

// SetAttributeDetails sets the AttributeDetails field's value.
func (s *CreateCalculatedAttributeDefinitionOutput) SetAttributeDetails(v *AttributeDetails) *CreateCalculatedAttributeDefinitionOutput {
	s.AttributeDetails = v
	return s
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *CreateCalculatedAttributeDefinitionOutput) SetCalculatedAttributeName(v string) *CreateCalculatedAttributeDefinitionOutput {
	s.CalculatedAttributeName = &v
	return s
}

// SetConditions sets the Conditions field's value.
func (s *CreateCalculatedAttributeDefinitionOutput) SetConditions(v *Conditions) *CreateCalculatedAttributeDefinitionOutput {
	s.Conditions = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateCalculatedAttributeDefinitionOutput) SetCreatedAt(v time.Time) *CreateCalculatedAttributeDefinitionOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCalculatedAttributeDefinitionOutput) SetDescription(v string) *CreateCalculatedAttributeDefinitionOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateCalculatedAttributeDefinitionOutput) SetDisplayName(v string) *CreateCalculatedAttributeDefinitionOutput {
	s.DisplayName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *CreateCalculatedAttributeDefinitionOutput) SetLastUpdatedAt(v time.Time) *CreateCalculatedAttributeDefinitionOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CreateCalculatedAttributeDefinitionOutput) SetStatistic(v string) *CreateCalculatedAttributeDefinitionOutput {
	s.Statistic = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCalculatedAttributeDefinitionOutput) SetTags(v map[string]*string) *CreateCalculatedAttributeDefinitionOutput {
	s.Tags = v
	return s
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The URL of the SQS dead letter queue, which is used for reporting errors
	// associated with ingesting data from third party applications. You must set
	// up a policy on the DeadLetterQueue for the SendMessage operation to enable
	// Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.
	DeadLetterQueueUrl *string `type:"string"`

	// The default encryption key, which is an AWS managed key, is used when no
	// specific type of encryption key is specified. It is used to encrypt all data
	// before it is placed in permanent or semi-permanent storage.
	DefaultEncryptionKey *string `type:"string"`

	// The default number of days until the data within the domain expires.
	//
	// DefaultExpirationDays is a required field
	DefaultExpirationDays *int64 `min:"1" type:"integer" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The process of matching duplicate profiles. If Matching = true, Amazon Connect
	// Customer Profiles starts a weekly batch process called Identity Resolution
	// Job. If you do not specify a date and time for Identity Resolution Job to
	// run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles
	// in your domains.
	//
	// After the Identity Resolution Job completes, use the GetMatches (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html)
	// API to return and review the results. Or, if you have configured ExportingConfig
	// in the MatchingRequest, you can download the results from S3.
	Matching *MatchingRequest `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.DefaultExpirationDays == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultExpirationDays"))
	}
	if s.DefaultExpirationDays != nil && *s.DefaultExpirationDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DefaultExpirationDays", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Matching != nil {
		if err := s.Matching.Validate(); err != nil {
			invalidParams.AddNested("Matching", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeadLetterQueueUrl sets the DeadLetterQueueUrl field's value.
func (s *CreateDomainInput) SetDeadLetterQueueUrl(v string) *CreateDomainInput {
	s.DeadLetterQueueUrl = &v
	return s
}

// SetDefaultEncryptionKey sets the DefaultEncryptionKey field's value.
func (s *CreateDomainInput) SetDefaultEncryptionKey(v string) *CreateDomainInput {
	s.DefaultEncryptionKey = &v
	return s
}

// SetDefaultExpirationDays sets the DefaultExpirationDays field's value.
func (s *CreateDomainInput) SetDefaultExpirationDays(v int64) *CreateDomainInput {
	s.DefaultExpirationDays = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainInput) SetDomainName(v string) *CreateDomainInput {
	s.DomainName = &v
	return s
}

// SetMatching sets the Matching field's value.
func (s *CreateDomainInput) SetMatching(v *MatchingRequest) *CreateDomainInput {
	s.Matching = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainInput) SetTags(v map[string]*string) *CreateDomainInput {
	s.Tags = v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The URL of the SQS dead letter queue, which is used for reporting errors
	// associated with ingesting data from third party applications.
	DeadLetterQueueUrl *string `type:"string"`

	// The default encryption key, which is an AWS managed key, is used when no
	// specific type of encryption key is specified. It is used to encrypt all data
	// before it is placed in permanent or semi-permanent storage.
	DefaultEncryptionKey *string `type:"string"`

	// The default number of days until the data within the domain expires.
	//
	// DefaultExpirationDays is a required field
	DefaultExpirationDays *int64 `min:"1" type:"integer" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The process of matching duplicate profiles. If Matching = true, Amazon Connect
	// Customer Profiles starts a weekly batch process called Identity Resolution
	// Job. If you do not specify a date and time for Identity Resolution Job to
	// run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles
	// in your domains.
	//
	// After the Identity Resolution Job completes, use the GetMatches (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html)
	// API to return and review the results. Or, if you have configured ExportingConfig
	// in the MatchingRequest, you can download the results from S3.
	Matching *MatchingResponse `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateDomainOutput) SetCreatedAt(v time.Time) *CreateDomainOutput {
	s.CreatedAt = &v
	return s
}

// SetDeadLetterQueueUrl sets the DeadLetterQueueUrl field's value.
func (s *CreateDomainOutput) SetDeadLetterQueueUrl(v string) *CreateDomainOutput {
	s.DeadLetterQueueUrl = &v
	return s
}

// SetDefaultEncryptionKey sets the DefaultEncryptionKey field's value.
func (s *CreateDomainOutput) SetDefaultEncryptionKey(v string) *CreateDomainOutput {
	s.DefaultEncryptionKey = &v
	return s
}

// SetDefaultExpirationDays sets the DefaultExpirationDays field's value.
func (s *CreateDomainOutput) SetDefaultExpirationDays(v int64) *CreateDomainOutput {
	s.DefaultExpirationDays = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainOutput) SetDomainName(v string) *CreateDomainOutput {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *CreateDomainOutput) SetLastUpdatedAt(v time.Time) *CreateDomainOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetMatching sets the Matching field's value.
func (s *CreateDomainOutput) SetMatching(v *MatchingResponse) *CreateDomainOutput {
	s.Matching = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainOutput) SetTags(v map[string]*string) *CreateDomainOutput {
	s.Tags = v
	return s
}

type CreateEventStreamInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The name of the event stream.
	//
	// EventStreamName is a required field
	EventStreamName *string `location:"uri" locationName:"EventStreamName" min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// The StreamARN of the destination to deliver profile events to. For example,
	// arn:aws:kinesis:region:account-id:stream/stream-name
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventStreamInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.EventStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventStreamName"))
	}
	if s.EventStreamName != nil && len(*s.EventStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventStreamName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CreateEventStreamInput) SetDomainName(v string) *CreateEventStreamInput {
	s.DomainName = &v
	return s
}

// SetEventStreamName sets the EventStreamName field's value.
func (s *CreateEventStreamInput) SetEventStreamName(v string) *CreateEventStreamInput {
	s.EventStreamName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventStreamInput) SetTags(v map[string]*string) *CreateEventStreamInput {
	s.Tags = v
	return s
}

// SetUri sets the Uri field's value.
func (s *CreateEventStreamInput) SetUri(v string) *CreateEventStreamInput {
	s.Uri = &v
	return s
}

type CreateEventStreamOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the event stream.
	//
	// EventStreamArn is a required field
	EventStreamArn *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventStreamOutput) GoString() string {
	return s.String()
}

// SetEventStreamArn sets the EventStreamArn field's value.
func (s *CreateEventStreamOutput) SetEventStreamArn(v string) *CreateEventStreamOutput {
	s.EventStreamArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventStreamOutput) SetTags(v map[string]*string) *CreateEventStreamOutput {
	s.Tags = v
	return s
}

type CreateIntegrationWorkflowInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// Configuration data for integration workflow.
	//
	// IntegrationConfig is a required field
	IntegrationConfig *IntegrationConfig `type:"structure" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// The type of workflow. The only supported value is APPFLOW_INTEGRATION.
	//
	// WorkflowType is a required field
	WorkflowType *string `type:"string" required:"true" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntegrationWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntegrationWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIntegrationWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIntegrationWorkflowInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.IntegrationConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationConfig"))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.WorkflowType == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowType"))
	}
	if s.IntegrationConfig != nil {
		if err := s.IntegrationConfig.Validate(); err != nil {
			invalidParams.AddNested("IntegrationConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CreateIntegrationWorkflowInput) SetDomainName(v string) *CreateIntegrationWorkflowInput {
	s.DomainName = &v
	return s
}

// SetIntegrationConfig sets the IntegrationConfig field's value.
func (s *CreateIntegrationWorkflowInput) SetIntegrationConfig(v *IntegrationConfig) *CreateIntegrationWorkflowInput {
	s.IntegrationConfig = v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *CreateIntegrationWorkflowInput) SetObjectTypeName(v string) *CreateIntegrationWorkflowInput {
	s.ObjectTypeName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateIntegrationWorkflowInput) SetRoleArn(v string) *CreateIntegrationWorkflowInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIntegrationWorkflowInput) SetTags(v map[string]*string) *CreateIntegrationWorkflowInput {
	s.Tags = v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *CreateIntegrationWorkflowInput) SetWorkflowType(v string) *CreateIntegrationWorkflowInput {
	s.WorkflowType = &v
	return s
}

type CreateIntegrationWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A message indicating create request was received.
	//
	// Message is a required field
	Message *string `min:"1" type:"string" required:"true"`

	// Unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntegrationWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntegrationWorkflowOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *CreateIntegrationWorkflowOutput) SetMessage(v string) *CreateIntegrationWorkflowOutput {
	s.Message = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *CreateIntegrationWorkflowOutput) SetWorkflowId(v string) *CreateIntegrationWorkflowOutput {
	s.WorkflowId = &v
	return s
}

type CreateProfileInput struct {
	_ struct{} `type:"structure"`

	// A unique account number that you have given to the customer.
	AccountNumber *string `min:"1" type:"string"`

	// Any additional information relevant to the customer’s profile.
	AdditionalInformation *string `min:"1" type:"string"`

	// A generic address associated with the customer that is not mailing, shipping,
	// or billing.
	Address *Address `type:"structure"`

	// A key value pair of attributes of a customer profile.
	Attributes map[string]*string `type:"map"`

	// The customer’s billing address.
	BillingAddress *Address `type:"structure"`

	// The customer’s birth date.
	BirthDate *string `min:"1" type:"string"`

	// The customer’s business email address.
	BusinessEmailAddress *string `min:"1" type:"string"`

	// The name of the customer’s business.
	BusinessName *string `min:"1" type:"string"`

	// The customer’s business phone number.
	BusinessPhoneNumber *string `min:"1" type:"string"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The customer’s email address, which has not been specified as a personal
	// or business address.
	EmailAddress *string `min:"1" type:"string"`

	// The customer’s first name.
	FirstName *string `min:"1" type:"string"`

	// The gender with which the customer identifies.
	Gender *string `deprecated:"true" type:"string" enum:"Gender"`

	// An alternative to Gender which accepts any string as input.
	GenderString *string `min:"1" type:"string"`

	// The customer’s home phone number.
	HomePhoneNumber *string `min:"1" type:"string"`

	// The customer’s last name.
	LastName *string `min:"1" type:"string"`

	// The customer’s mailing address.
	MailingAddress *Address `type:"structure"`

	// The customer’s middle name.
	MiddleName *string `min:"1" type:"string"`

	// The customer’s mobile phone number.
	MobilePhoneNumber *string `min:"1" type:"string"`

	// The type of profile used to describe the customer.
	PartyType *string `deprecated:"true" type:"string" enum:"PartyType"`

	// An alternative to PartyType which accepts any string as input.
	PartyTypeString *string `min:"1" type:"string"`

	// The customer’s personal email address.
	PersonalEmailAddress *string `min:"1" type:"string"`

	// The customer’s phone number, which has not been specified as a mobile,
	// home, or business number.
	PhoneNumber *string `min:"1" type:"string"`

	// The customer’s shipping address.
	ShippingAddress *Address `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfileInput"}
	if s.AccountNumber != nil && len(*s.AccountNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountNumber", 1))
	}
	if s.AdditionalInformation != nil && len(*s.AdditionalInformation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalInformation", 1))
	}
	if s.BirthDate != nil && len(*s.BirthDate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BirthDate", 1))
	}
	if s.BusinessEmailAddress != nil && len(*s.BusinessEmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BusinessEmailAddress", 1))
	}
	if s.BusinessName != nil && len(*s.BusinessName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BusinessName", 1))
	}
	if s.BusinessPhoneNumber != nil && len(*s.BusinessPhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BusinessPhoneNumber", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 1))
	}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstName", 1))
	}
	if s.GenderString != nil && len(*s.GenderString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GenderString", 1))
	}
	if s.HomePhoneNumber != nil && len(*s.HomePhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HomePhoneNumber", 1))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastName", 1))
	}
	if s.MiddleName != nil && len(*s.MiddleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MiddleName", 1))
	}
	if s.MobilePhoneNumber != nil && len(*s.MobilePhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MobilePhoneNumber", 1))
	}
	if s.PartyTypeString != nil && len(*s.PartyTypeString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartyTypeString", 1))
	}
	if s.PersonalEmailAddress != nil && len(*s.PersonalEmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PersonalEmailAddress", 1))
	}
	if s.PhoneNumber != nil && len(*s.PhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumber", 1))
	}
	if s.Address != nil {
		if err := s.Address.Validate(); err != nil {
			invalidParams.AddNested("Address", err.(request.ErrInvalidParams))
		}
	}
	if s.BillingAddress != nil {
		if err := s.BillingAddress.Validate(); err != nil {
			invalidParams.AddNested("BillingAddress", err.(request.ErrInvalidParams))
		}
	}
	if s.MailingAddress != nil {
		if err := s.MailingAddress.Validate(); err != nil {
			invalidParams.AddNested("MailingAddress", err.(request.ErrInvalidParams))
		}
	}
	if s.ShippingAddress != nil {
		if err := s.ShippingAddress.Validate(); err != nil {
			invalidParams.AddNested("ShippingAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountNumber sets the AccountNumber field's value.
func (s *CreateProfileInput) SetAccountNumber(v string) *CreateProfileInput {
	s.AccountNumber = &v
	return s
}

// SetAdditionalInformation sets the AdditionalInformation field's value.
func (s *CreateProfileInput) SetAdditionalInformation(v string) *CreateProfileInput {
	s.AdditionalInformation = &v
	return s
}

// SetAddress sets the Address field's value.
func (s *CreateProfileInput) SetAddress(v *Address) *CreateProfileInput {
	s.Address = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *CreateProfileInput) SetAttributes(v map[string]*string) *CreateProfileInput {
	s.Attributes = v
	return s
}

// SetBillingAddress sets the BillingAddress field's value.
func (s *CreateProfileInput) SetBillingAddress(v *Address) *CreateProfileInput {
	s.BillingAddress = v
	return s
}

// SetBirthDate sets the BirthDate field's value.
func (s *CreateProfileInput) SetBirthDate(v string) *CreateProfileInput {
	s.BirthDate = &v
	return s
}

// SetBusinessEmailAddress sets the BusinessEmailAddress field's value.
func (s *CreateProfileInput) SetBusinessEmailAddress(v string) *CreateProfileInput {
	s.BusinessEmailAddress = &v
	return s
}

// SetBusinessName sets the BusinessName field's value.
func (s *CreateProfileInput) SetBusinessName(v string) *CreateProfileInput {
	s.BusinessName = &v
	return s
}

// SetBusinessPhoneNumber sets the BusinessPhoneNumber field's value.
func (s *CreateProfileInput) SetBusinessPhoneNumber(v string) *CreateProfileInput {
	s.BusinessPhoneNumber = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateProfileInput) SetDomainName(v string) *CreateProfileInput {
	s.DomainName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *CreateProfileInput) SetEmailAddress(v string) *CreateProfileInput {
	s.EmailAddress = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *CreateProfileInput) SetFirstName(v string) *CreateProfileInput {
	s.FirstName = &v
	return s
}

// SetGender sets the Gender field's value.
func (s *CreateProfileInput) SetGender(v string) *CreateProfileInput {
	s.Gender = &v
	return s
}

// SetGenderString sets the GenderString field's value.
func (s *CreateProfileInput) SetGenderString(v string) *CreateProfileInput {
	s.GenderString = &v
	return s
}

// SetHomePhoneNumber sets the HomePhoneNumber field's value.
func (s *CreateProfileInput) SetHomePhoneNumber(v string) *CreateProfileInput {
	s.HomePhoneNumber = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *CreateProfileInput) SetLastName(v string) *CreateProfileInput {
	s.LastName = &v
	return s
}

// SetMailingAddress sets the MailingAddress field's value.
func (s *CreateProfileInput) SetMailingAddress(v *Address) *CreateProfileInput {
	s.MailingAddress = v
	return s
}

// SetMiddleName sets the MiddleName field's value.
func (s *CreateProfileInput) SetMiddleName(v string) *CreateProfileInput {
	s.MiddleName = &v
	return s
}

// SetMobilePhoneNumber sets the MobilePhoneNumber field's value.
func (s *CreateProfileInput) SetMobilePhoneNumber(v string) *CreateProfileInput {
	s.MobilePhoneNumber = &v
	return s
}

// SetPartyType sets the PartyType field's value.
func (s *CreateProfileInput) SetPartyType(v string) *CreateProfileInput {
	s.PartyType = &v
	return s
}

// SetPartyTypeString sets the PartyTypeString field's value.
func (s *CreateProfileInput) SetPartyTypeString(v string) *CreateProfileInput {
	s.PartyTypeString = &v
	return s
}

// SetPersonalEmailAddress sets the PersonalEmailAddress field's value.
func (s *CreateProfileInput) SetPersonalEmailAddress(v string) *CreateProfileInput {
	s.PersonalEmailAddress = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *CreateProfileInput) SetPhoneNumber(v string) *CreateProfileInput {
	s.PhoneNumber = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *CreateProfileInput) SetShippingAddress(v *Address) *CreateProfileInput {
	s.ShippingAddress = v
	return s
}

type CreateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) GoString() string {
	return s.String()
}

// SetProfileId sets the ProfileId field's value.
func (s *CreateProfileOutput) SetProfileId(v string) *CreateProfileOutput {
	s.ProfileId = &v
	return s
}

type DeleteCalculatedAttributeDefinitionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the calculated attribute.
	//
	// CalculatedAttributeName is a required field
	CalculatedAttributeName *string `location:"uri" locationName:"CalculatedAttributeName" min:"1" type:"string" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCalculatedAttributeDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCalculatedAttributeDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCalculatedAttributeDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCalculatedAttributeDefinitionInput"}
	if s.CalculatedAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatedAttributeName"))
	}
	if s.CalculatedAttributeName != nil && len(*s.CalculatedAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatedAttributeName", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *DeleteCalculatedAttributeDefinitionInput) SetCalculatedAttributeName(v string) *DeleteCalculatedAttributeDefinitionInput {
	s.CalculatedAttributeName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteCalculatedAttributeDefinitionInput) SetDomainName(v string) *DeleteCalculatedAttributeDefinitionInput {
	s.DomainName = &v
	return s
}

type DeleteCalculatedAttributeDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCalculatedAttributeDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCalculatedAttributeDefinitionOutput) GoString() string {
	return s.String()
}

type DeleteDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainInput) SetDomainName(v string) *DeleteDomainInput {
	s.DomainName = &v
	return s
}

type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteDomainOutput) SetMessage(v string) *DeleteDomainOutput {
	s.Message = &v
	return s
}

type DeleteEventStreamInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The name of the event stream
	//
	// EventStreamName is a required field
	EventStreamName *string `location:"uri" locationName:"EventStreamName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventStreamInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.EventStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventStreamName"))
	}
	if s.EventStreamName != nil && len(*s.EventStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteEventStreamInput) SetDomainName(v string) *DeleteEventStreamInput {
	s.DomainName = &v
	return s
}

// SetEventStreamName sets the EventStreamName field's value.
func (s *DeleteEventStreamInput) SetEventStreamName(v string) *DeleteEventStreamInput {
	s.EventStreamName = &v
	return s
}

type DeleteEventStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventStreamOutput) GoString() string {
	return s.String()
}

type DeleteIntegrationInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIntegrationInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteIntegrationInput) SetDomainName(v string) *DeleteIntegrationInput {
	s.DomainName = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *DeleteIntegrationInput) SetUri(v string) *DeleteIntegrationInput {
	s.Uri = &v
	return s
}

type DeleteIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteIntegrationOutput) SetMessage(v string) *DeleteIntegrationOutput {
	s.Message = &v
	return s
}

type DeleteProfileInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteProfileInput) SetDomainName(v string) *DeleteProfileInput {
	s.DomainName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *DeleteProfileInput) SetProfileId(v string) *DeleteProfileInput {
	s.ProfileId = &v
	return s
}

type DeleteProfileKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// A searchable identifier of a customer profile.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// A list of key values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileKeyInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteProfileKeyInput) SetDomainName(v string) *DeleteProfileKeyInput {
	s.DomainName = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *DeleteProfileKeyInput) SetKeyName(v string) *DeleteProfileKeyInput {
	s.KeyName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *DeleteProfileKeyInput) SetProfileId(v string) *DeleteProfileKeyInput {
	s.ProfileId = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DeleteProfileKeyInput) SetValues(v []*string) *DeleteProfileKeyInput {
	s.Values = v
	return s
}

type DeleteProfileKeyOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileKeyOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteProfileKeyOutput) SetMessage(v string) *DeleteProfileKeyOutput {
	s.Message = &v
	return s
}

type DeleteProfileObjectInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// The unique identifier of the profile object generated by the service.
	//
	// ProfileObjectUniqueKey is a required field
	ProfileObjectUniqueKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileObjectInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileObjectUniqueKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileObjectUniqueKey"))
	}
	if s.ProfileObjectUniqueKey != nil && len(*s.ProfileObjectUniqueKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileObjectUniqueKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteProfileObjectInput) SetDomainName(v string) *DeleteProfileObjectInput {
	s.DomainName = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *DeleteProfileObjectInput) SetObjectTypeName(v string) *DeleteProfileObjectInput {
	s.ObjectTypeName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *DeleteProfileObjectInput) SetProfileId(v string) *DeleteProfileObjectInput {
	s.ProfileId = &v
	return s
}

// SetProfileObjectUniqueKey sets the ProfileObjectUniqueKey field's value.
func (s *DeleteProfileObjectInput) SetProfileObjectUniqueKey(v string) *DeleteProfileObjectInput {
	s.ProfileObjectUniqueKey = &v
	return s
}

type DeleteProfileObjectOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileObjectOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteProfileObjectOutput) SetMessage(v string) *DeleteProfileObjectOutput {
	s.Message = &v
	return s
}

type DeleteProfileObjectTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `location:"uri" locationName:"ObjectTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileObjectTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileObjectTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileObjectTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileObjectTypeInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteProfileObjectTypeInput) SetDomainName(v string) *DeleteProfileObjectTypeInput {
	s.DomainName = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *DeleteProfileObjectTypeInput) SetObjectTypeName(v string) *DeleteProfileObjectTypeInput {
	s.ObjectTypeName = &v
	return s
}

type DeleteProfileObjectTypeOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileObjectTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileObjectTypeOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteProfileObjectTypeOutput) SetMessage(v string) *DeleteProfileObjectTypeOutput {
	s.Message = &v
	return s
}

type DeleteProfileOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteProfileOutput) SetMessage(v string) *DeleteProfileOutput {
	s.Message = &v
	return s
}

type DeleteWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// Unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"uri" locationName:"WorkflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkflowInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteWorkflowInput) SetDomainName(v string) *DeleteWorkflowInput {
	s.DomainName = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *DeleteWorkflowInput) SetWorkflowId(v string) *DeleteWorkflowInput {
	s.WorkflowId = &v
	return s
}

type DeleteWorkflowOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowOutput) GoString() string {
	return s.String()
}

// Summary information about the Kinesis data stream
type DestinationSummary struct {
	_ struct{} `type:"structure"`

	// The status of enabling the Kinesis stream as a destination for export.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"EventStreamDestinationStatus"`

	// The timestamp when the status last changed to UNHEALHY.
	UnhealthySince *time.Time `type:"timestamp"`

	// The StreamARN of the destination to deliver profile events to. For example,
	// arn:aws:kinesis:region:account-id:stream/stream-name.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationSummary) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DestinationSummary) SetStatus(v string) *DestinationSummary {
	s.Status = &v
	return s
}

// SetUnhealthySince sets the UnhealthySince field's value.
func (s *DestinationSummary) SetUnhealthySince(v time.Time) *DestinationSummary {
	s.UnhealthySince = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *DestinationSummary) SetUri(v string) *DestinationSummary {
	s.Uri = &v
	return s
}

// Usage-specific statistics about the domain.
type DomainStats struct {
	_ struct{} `type:"structure"`

	// The number of profiles that you are currently paying for in the domain. If
	// you have more than 100 objects associated with a single profile, that profile
	// counts as two profiles. If you have more than 200 objects, that profile counts
	// as three, and so on.
	MeteringProfileCount *int64 `type:"long"`

	// The total number of objects in domain.
	ObjectCount *int64 `type:"long"`

	// The total number of profiles currently in the domain.
	ProfileCount *int64 `type:"long"`

	// The total size, in bytes, of all objects in the domain.
	TotalSize *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainStats) GoString() string {
	return s.String()
}

// SetMeteringProfileCount sets the MeteringProfileCount field's value.
func (s *DomainStats) SetMeteringProfileCount(v int64) *DomainStats {
	s.MeteringProfileCount = &v
	return s
}

// SetObjectCount sets the ObjectCount field's value.
func (s *DomainStats) SetObjectCount(v int64) *DomainStats {
	s.ObjectCount = &v
	return s
}

// SetProfileCount sets the ProfileCount field's value.
func (s *DomainStats) SetProfileCount(v int64) *DomainStats {
	s.ProfileCount = &v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *DomainStats) SetTotalSize(v int64) *DomainStats {
	s.TotalSize = &v
	return s
}

// Details of the destination being used for the EventStream.
type EventStreamDestinationDetails struct {
	_ struct{} `type:"structure"`

	// The human-readable string that corresponds to the error or success while
	// enabling the streaming destination.
	Message *string `min:"1" type:"string"`

	// The status of enabling the Kinesis stream as a destination for export.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"EventStreamDestinationStatus"`

	// The timestamp when the status last changed to UNHEALHY.
	UnhealthySince *time.Time `type:"timestamp"`

	// The StreamARN of the destination to deliver profile events to. For example,
	// arn:aws:kinesis:region:account-id:stream/stream-name.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventStreamDestinationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventStreamDestinationDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *EventStreamDestinationDetails) SetMessage(v string) *EventStreamDestinationDetails {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventStreamDestinationDetails) SetStatus(v string) *EventStreamDestinationDetails {
	s.Status = &v
	return s
}

// SetUnhealthySince sets the UnhealthySince field's value.
func (s *EventStreamDestinationDetails) SetUnhealthySince(v time.Time) *EventStreamDestinationDetails {
	s.UnhealthySince = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *EventStreamDestinationDetails) SetUri(v string) *EventStreamDestinationDetails {
	s.Uri = &v
	return s
}

// An instance of EventStream in a list of EventStreams.
type EventStreamSummary struct {
	_ struct{} `type:"structure"`

	// Summary information about the Kinesis data stream.
	DestinationSummary *DestinationSummary `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for the event stream.
	//
	// EventStreamArn is a required field
	EventStreamArn *string `min:"1" type:"string" required:"true"`

	// The name of the event stream.
	//
	// EventStreamName is a required field
	EventStreamName *string `min:"1" type:"string" required:"true"`

	// The operational state of destination stream for export.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"EventStreamState"`

	// The timestamp when the State changed to STOPPED.
	StoppedSince *time.Time `type:"timestamp"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventStreamSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventStreamSummary) GoString() string {
	return s.String()
}

// SetDestinationSummary sets the DestinationSummary field's value.
func (s *EventStreamSummary) SetDestinationSummary(v *DestinationSummary) *EventStreamSummary {
	s.DestinationSummary = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *EventStreamSummary) SetDomainName(v string) *EventStreamSummary {
	s.DomainName = &v
	return s
}

// SetEventStreamArn sets the EventStreamArn field's value.
func (s *EventStreamSummary) SetEventStreamArn(v string) *EventStreamSummary {
	s.EventStreamArn = &v
	return s
}

// SetEventStreamName sets the EventStreamName field's value.
func (s *EventStreamSummary) SetEventStreamName(v string) *EventStreamSummary {
	s.EventStreamName = &v
	return s
}

// SetState sets the State field's value.
func (s *EventStreamSummary) SetState(v string) *EventStreamSummary {
	s.State = &v
	return s
}

// SetStoppedSince sets the StoppedSince field's value.
func (s *EventStreamSummary) SetStoppedSince(v time.Time) *EventStreamSummary {
	s.StoppedSince = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EventStreamSummary) SetTags(v map[string]*string) *EventStreamSummary {
	s.Tags = v
	return s
}

// Configuration information about the S3 bucket where Identity Resolution Jobs
// writes result files.
//
// You need to give Customer Profiles service principal write permission to
// your S3 bucket. Otherwise, you'll get an exception in the API response. For
// an example policy, see Amazon Connect Customer Profiles cross-service confused
// deputy prevention (https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html#customer-profiles-cross-service).
type ExportingConfig struct {
	_ struct{} `type:"structure"`

	// The S3 location where Identity Resolution Jobs write result files.
	S3Exporting *S3ExportingConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportingConfig"}
	if s.S3Exporting != nil {
		if err := s.S3Exporting.Validate(); err != nil {
			invalidParams.AddNested("S3Exporting", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Exporting sets the S3Exporting field's value.
func (s *ExportingConfig) SetS3Exporting(v *S3ExportingConfig) *ExportingConfig {
	s.S3Exporting = v
	return s
}

// The S3 location where Identity Resolution Jobs write result files.
type ExportingLocation struct {
	_ struct{} `type:"structure"`

	// Information about the S3 location where Identity Resolution Jobs write result
	// files.
	S3Exporting *S3ExportingLocation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportingLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportingLocation) GoString() string {
	return s.String()
}

// SetS3Exporting sets the S3Exporting field's value.
func (s *ExportingLocation) SetS3Exporting(v *S3ExportingLocation) *ExportingLocation {
	s.S3Exporting = v
	return s
}

// A duplicate customer profile that is to be merged into a main profile.
type FieldSourceProfileIds struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the account number field to be merged.
	AccountNumber *string `type:"string"`

	// A unique identifier for the additional information field to be merged.
	AdditionalInformation *string `type:"string"`

	// A unique identifier for the party type field to be merged.
	Address *string `type:"string"`

	// A unique identifier for the attributes field to be merged.
	Attributes map[string]*string `type:"map"`

	// A unique identifier for the billing type field to be merged.
	BillingAddress *string `type:"string"`

	// A unique identifier for the birthdate field to be merged.
	BirthDate *string `type:"string"`

	// A unique identifier for the party type field to be merged.
	BusinessEmailAddress *string `type:"string"`

	// A unique identifier for the business name field to be merged.
	BusinessName *string `type:"string"`

	// A unique identifier for the business phone number field to be merged.
	BusinessPhoneNumber *string `type:"string"`

	// A unique identifier for the email address field to be merged.
	EmailAddress *string `type:"string"`

	// A unique identifier for the first name field to be merged.
	FirstName *string `type:"string"`

	// A unique identifier for the gender field to be merged.
	Gender *string `type:"string"`

	// A unique identifier for the home phone number field to be merged.
	HomePhoneNumber *string `type:"string"`

	// A unique identifier for the last name field to be merged.
	LastName *string `type:"string"`

	// A unique identifier for the mailing address field to be merged.
	MailingAddress *string `type:"string"`

	// A unique identifier for the middle name field to be merged.
	MiddleName *string `type:"string"`

	// A unique identifier for the mobile phone number field to be merged.
	MobilePhoneNumber *string `type:"string"`

	// A unique identifier for the party type field to be merged.
	PartyType *string `type:"string"`

	// A unique identifier for the personal email address field to be merged.
	PersonalEmailAddress *string `type:"string"`

	// A unique identifier for the phone number field to be merged.
	PhoneNumber *string `type:"string"`

	// A unique identifier for the shipping address field to be merged.
	ShippingAddress *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldSourceProfileIds) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldSourceProfileIds) GoString() string {
	return s.String()
}

// SetAccountNumber sets the AccountNumber field's value.
func (s *FieldSourceProfileIds) SetAccountNumber(v string) *FieldSourceProfileIds {
	s.AccountNumber = &v
	return s
}

// SetAdditionalInformation sets the AdditionalInformation field's value.
func (s *FieldSourceProfileIds) SetAdditionalInformation(v string) *FieldSourceProfileIds {
	s.AdditionalInformation = &v
	return s
}

// SetAddress sets the Address field's value.
func (s *FieldSourceProfileIds) SetAddress(v string) *FieldSourceProfileIds {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *FieldSourceProfileIds) SetAttributes(v map[string]*string) *FieldSourceProfileIds {
	s.Attributes = v
	return s
}

// SetBillingAddress sets the BillingAddress field's value.
func (s *FieldSourceProfileIds) SetBillingAddress(v string) *FieldSourceProfileIds {
	s.BillingAddress = &v
	return s
}

// SetBirthDate sets the BirthDate field's value.
func (s *FieldSourceProfileIds) SetBirthDate(v string) *FieldSourceProfileIds {
	s.BirthDate = &v
	return s
}

// SetBusinessEmailAddress sets the BusinessEmailAddress field's value.
func (s *FieldSourceProfileIds) SetBusinessEmailAddress(v string) *FieldSourceProfileIds {
	s.BusinessEmailAddress = &v
	return s
}

// SetBusinessName sets the BusinessName field's value.
func (s *FieldSourceProfileIds) SetBusinessName(v string) *FieldSourceProfileIds {
	s.BusinessName = &v
	return s
}

// SetBusinessPhoneNumber sets the BusinessPhoneNumber field's value.
func (s *FieldSourceProfileIds) SetBusinessPhoneNumber(v string) *FieldSourceProfileIds {
	s.BusinessPhoneNumber = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *FieldSourceProfileIds) SetEmailAddress(v string) *FieldSourceProfileIds {
	s.EmailAddress = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *FieldSourceProfileIds) SetFirstName(v string) *FieldSourceProfileIds {
	s.FirstName = &v
	return s
}

// SetGender sets the Gender field's value.
func (s *FieldSourceProfileIds) SetGender(v string) *FieldSourceProfileIds {
	s.Gender = &v
	return s
}

// SetHomePhoneNumber sets the HomePhoneNumber field's value.
func (s *FieldSourceProfileIds) SetHomePhoneNumber(v string) *FieldSourceProfileIds {
	s.HomePhoneNumber = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *FieldSourceProfileIds) SetLastName(v string) *FieldSourceProfileIds {
	s.LastName = &v
	return s
}

// SetMailingAddress sets the MailingAddress field's value.
func (s *FieldSourceProfileIds) SetMailingAddress(v string) *FieldSourceProfileIds {
	s.MailingAddress = &v
	return s
}

// SetMiddleName sets the MiddleName field's value.
func (s *FieldSourceProfileIds) SetMiddleName(v string) *FieldSourceProfileIds {
	s.MiddleName = &v
	return s
}

// SetMobilePhoneNumber sets the MobilePhoneNumber field's value.
func (s *FieldSourceProfileIds) SetMobilePhoneNumber(v string) *FieldSourceProfileIds {
	s.MobilePhoneNumber = &v
	return s
}

// SetPartyType sets the PartyType field's value.
func (s *FieldSourceProfileIds) SetPartyType(v string) *FieldSourceProfileIds {
	s.PartyType = &v
	return s
}

// SetPersonalEmailAddress sets the PersonalEmailAddress field's value.
func (s *FieldSourceProfileIds) SetPersonalEmailAddress(v string) *FieldSourceProfileIds {
	s.PersonalEmailAddress = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *FieldSourceProfileIds) SetPhoneNumber(v string) *FieldSourceProfileIds {
	s.PhoneNumber = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *FieldSourceProfileIds) SetShippingAddress(v string) *FieldSourceProfileIds {
	s.ShippingAddress = &v
	return s
}

// The configurations that control how Customer Profiles retrieves data from
// the source, Amazon AppFlow. Customer Profiles uses this information to create
// an AppFlow flow on behalf of customers.
type FlowDefinition struct {
	_ struct{} `type:"structure"`

	// A description of the flow you want to create.
	Description *string `type:"string"`

	// The specified name of the flow. Use underscores (_) or hyphens (-) only.
	// Spaces are not allowed.
	//
	// FlowName is a required field
	FlowName *string `type:"string" required:"true"`

	// The Amazon Resource Name of the AWS Key Management Service (KMS) key you
	// provide for encryption.
	//
	// KmsArn is a required field
	KmsArn *string `min:"20" type:"string" required:"true"`

	// The configuration that controls how Customer Profiles retrieves data from
	// the source.
	//
	// SourceFlowConfig is a required field
	SourceFlowConfig *SourceFlowConfig `type:"structure" required:"true"`

	// A list of tasks that Customer Profiles performs while transferring the data
	// in the flow run.
	//
	// Tasks is a required field
	Tasks []*Task `type:"list" required:"true"`

	// The trigger settings that determine how and when the flow runs.
	//
	// TriggerConfig is a required field
	TriggerConfig *TriggerConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowDefinition"}
	if s.FlowName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowName"))
	}
	if s.KmsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsArn"))
	}
	if s.KmsArn != nil && len(*s.KmsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsArn", 20))
	}
	if s.SourceFlowConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFlowConfig"))
	}
	if s.Tasks == nil {
		invalidParams.Add(request.NewErrParamRequired("Tasks"))
	}
	if s.TriggerConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerConfig"))
	}
	if s.SourceFlowConfig != nil {
		if err := s.SourceFlowConfig.Validate(); err != nil {
			invalidParams.AddNested("SourceFlowConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tasks != nil {
		for i, v := range s.Tasks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tasks", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TriggerConfig != nil {
		if err := s.TriggerConfig.Validate(); err != nil {
			invalidParams.AddNested("TriggerConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *FlowDefinition) SetDescription(v string) *FlowDefinition {
	s.Description = &v
	return s
}

// SetFlowName sets the FlowName field's value.
func (s *FlowDefinition) SetFlowName(v string) *FlowDefinition {
	s.FlowName = &v
	return s
}

// SetKmsArn sets the KmsArn field's value.
func (s *FlowDefinition) SetKmsArn(v string) *FlowDefinition {
	s.KmsArn = &v
	return s
}

// SetSourceFlowConfig sets the SourceFlowConfig field's value.
func (s *FlowDefinition) SetSourceFlowConfig(v *SourceFlowConfig) *FlowDefinition {
	s.SourceFlowConfig = v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *FlowDefinition) SetTasks(v []*Task) *FlowDefinition {
	s.Tasks = v
	return s
}

// SetTriggerConfig sets the TriggerConfig field's value.
func (s *FlowDefinition) SetTriggerConfig(v *TriggerConfig) *FlowDefinition {
	s.TriggerConfig = v
	return s
}

// A data type pair that consists of a KeyName and Values list that were used
// to find a profile returned in response to a SearchProfiles (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html)
// request.
type FoundByKeyValue struct {
	_ struct{} `type:"structure"`

	// A searchable identifier of a customer profile.
	KeyName *string `min:"1" type:"string"`

	// A list of key values.
	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundByKeyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundByKeyValue) GoString() string {
	return s.String()
}

// SetKeyName sets the KeyName field's value.
func (s *FoundByKeyValue) SetKeyName(v string) *FoundByKeyValue {
	s.KeyName = &v
	return s
}

// SetValues sets the Values field's value.
func (s *FoundByKeyValue) SetValues(v []*string) *FoundByKeyValue {
	s.Values = v
	return s
}

type GetAutoMergingPreviewInput struct {
	_ struct{} `type:"structure"`

	// How the auto-merging process should resolve conflicts between different profiles.
	//
	// ConflictResolution is a required field
	ConflictResolution *ConflictResolution `type:"structure" required:"true"`

	// A list of matching attributes that represent matching criteria.
	//
	// Consolidation is a required field
	Consolidation *Consolidation `type:"structure" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// Minimum confidence score required for profiles within a matching group to
	// be merged during the auto-merge process.
	MinAllowedConfidenceScoreForMerging *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAutoMergingPreviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAutoMergingPreviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAutoMergingPreviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAutoMergingPreviewInput"}
	if s.ConflictResolution == nil {
		invalidParams.Add(request.NewErrParamRequired("ConflictResolution"))
	}
	if s.Consolidation == nil {
		invalidParams.Add(request.NewErrParamRequired("Consolidation"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ConflictResolution != nil {
		if err := s.ConflictResolution.Validate(); err != nil {
			invalidParams.AddNested("ConflictResolution", err.(request.ErrInvalidParams))
		}
	}
	if s.Consolidation != nil {
		if err := s.Consolidation.Validate(); err != nil {
			invalidParams.AddNested("Consolidation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConflictResolution sets the ConflictResolution field's value.
func (s *GetAutoMergingPreviewInput) SetConflictResolution(v *ConflictResolution) *GetAutoMergingPreviewInput {
	s.ConflictResolution = v
	return s
}

// SetConsolidation sets the Consolidation field's value.
func (s *GetAutoMergingPreviewInput) SetConsolidation(v *Consolidation) *GetAutoMergingPreviewInput {
	s.Consolidation = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetAutoMergingPreviewInput) SetDomainName(v string) *GetAutoMergingPreviewInput {
	s.DomainName = &v
	return s
}

// SetMinAllowedConfidenceScoreForMerging sets the MinAllowedConfidenceScoreForMerging field's value.
func (s *GetAutoMergingPreviewInput) SetMinAllowedConfidenceScoreForMerging(v float64) *GetAutoMergingPreviewInput {
	s.MinAllowedConfidenceScoreForMerging = &v
	return s
}

type GetAutoMergingPreviewOutput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The number of match groups in the domain that have been reviewed in this
	// preview dry run.
	NumberOfMatchesInSample *int64 `type:"long"`

	// The number of profiles found in this preview dry run.
	NumberOfProfilesInSample *int64 `type:"long"`

	// The number of profiles that would be merged if this wasn't a preview dry
	// run.
	NumberOfProfilesWillBeMerged *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAutoMergingPreviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAutoMergingPreviewOutput) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *GetAutoMergingPreviewOutput) SetDomainName(v string) *GetAutoMergingPreviewOutput {
	s.DomainName = &v
	return s
}

// SetNumberOfMatchesInSample sets the NumberOfMatchesInSample field's value.
func (s *GetAutoMergingPreviewOutput) SetNumberOfMatchesInSample(v int64) *GetAutoMergingPreviewOutput {
	s.NumberOfMatchesInSample = &v
	return s
}

// SetNumberOfProfilesInSample sets the NumberOfProfilesInSample field's value.
func (s *GetAutoMergingPreviewOutput) SetNumberOfProfilesInSample(v int64) *GetAutoMergingPreviewOutput {
	s.NumberOfProfilesInSample = &v
	return s
}

// SetNumberOfProfilesWillBeMerged sets the NumberOfProfilesWillBeMerged field's value.
func (s *GetAutoMergingPreviewOutput) SetNumberOfProfilesWillBeMerged(v int64) *GetAutoMergingPreviewOutput {
	s.NumberOfProfilesWillBeMerged = &v
	return s
}

type GetCalculatedAttributeDefinitionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the calculated attribute.
	//
	// CalculatedAttributeName is a required field
	CalculatedAttributeName *string `location:"uri" locationName:"CalculatedAttributeName" min:"1" type:"string" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCalculatedAttributeDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCalculatedAttributeDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCalculatedAttributeDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCalculatedAttributeDefinitionInput"}
	if s.CalculatedAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatedAttributeName"))
	}
	if s.CalculatedAttributeName != nil && len(*s.CalculatedAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatedAttributeName", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *GetCalculatedAttributeDefinitionInput) SetCalculatedAttributeName(v string) *GetCalculatedAttributeDefinitionInput {
	s.CalculatedAttributeName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetCalculatedAttributeDefinitionInput) SetDomainName(v string) *GetCalculatedAttributeDefinitionInput {
	s.DomainName = &v
	return s
}

type GetCalculatedAttributeDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Mathematical expression and a list of attribute items specified in that expression.
	AttributeDetails *AttributeDetails `type:"structure"`

	// The unique name of the calculated attribute.
	CalculatedAttributeName *string `min:"1" type:"string"`

	// The conditions including range, object count, and threshold for the calculated
	// attribute.
	Conditions *Conditions `type:"structure"`

	// The timestamp of when the calculated attribute definition was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the calculated attribute.
	Description *string `min:"1" type:"string"`

	// The display name of the calculated attribute.
	DisplayName *string `min:"1" type:"string"`

	// The timestamp of when the calculated attribute definition was most recently
	// edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The aggregation operation to perform for the calculated attribute.
	Statistic *string `type:"string" enum:"Statistic"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCalculatedAttributeDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCalculatedAttributeDefinitionOutput) GoString() string {
	return s.String()
}

// SetAttributeDetails sets the AttributeDetails field's value.
func (s *GetCalculatedAttributeDefinitionOutput) SetAttributeDetails(v *AttributeDetails) *GetCalculatedAttributeDefinitionOutput {
	s.AttributeDetails = v
	return s
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *GetCalculatedAttributeDefinitionOutput) SetCalculatedAttributeName(v string) *GetCalculatedAttributeDefinitionOutput {
	s.CalculatedAttributeName = &v
	return s
}

// SetConditions sets the Conditions field's value.
func (s *GetCalculatedAttributeDefinitionOutput) SetConditions(v *Conditions) *GetCalculatedAttributeDefinitionOutput {
	s.Conditions = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetCalculatedAttributeDefinitionOutput) SetCreatedAt(v time.Time) *GetCalculatedAttributeDefinitionOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetCalculatedAttributeDefinitionOutput) SetDescription(v string) *GetCalculatedAttributeDefinitionOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetCalculatedAttributeDefinitionOutput) SetDisplayName(v string) *GetCalculatedAttributeDefinitionOutput {
	s.DisplayName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetCalculatedAttributeDefinitionOutput) SetLastUpdatedAt(v time.Time) *GetCalculatedAttributeDefinitionOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *GetCalculatedAttributeDefinitionOutput) SetStatistic(v string) *GetCalculatedAttributeDefinitionOutput {
	s.Statistic = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetCalculatedAttributeDefinitionOutput) SetTags(v map[string]*string) *GetCalculatedAttributeDefinitionOutput {
	s.Tags = v
	return s
}

type GetCalculatedAttributeForProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the calculated attribute.
	//
	// CalculatedAttributeName is a required field
	CalculatedAttributeName *string `location:"uri" locationName:"CalculatedAttributeName" min:"1" type:"string" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"ProfileId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCalculatedAttributeForProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCalculatedAttributeForProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCalculatedAttributeForProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCalculatedAttributeForProfileInput"}
	if s.CalculatedAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatedAttributeName"))
	}
	if s.CalculatedAttributeName != nil && len(*s.CalculatedAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatedAttributeName", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *GetCalculatedAttributeForProfileInput) SetCalculatedAttributeName(v string) *GetCalculatedAttributeForProfileInput {
	s.CalculatedAttributeName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetCalculatedAttributeForProfileInput) SetDomainName(v string) *GetCalculatedAttributeForProfileInput {
	s.DomainName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *GetCalculatedAttributeForProfileInput) SetProfileId(v string) *GetCalculatedAttributeForProfileInput {
	s.ProfileId = &v
	return s
}

type GetCalculatedAttributeForProfileOutput struct {
	_ struct{} `type:"structure"`

	// The unique name of the calculated attribute.
	CalculatedAttributeName *string `min:"1" type:"string"`

	// The display name of the calculated attribute.
	DisplayName *string `min:"1" type:"string"`

	// Indicates whether the calculated attribute’s value is based on partial
	// data. If data is partial, it is set to true.
	IsDataPartial *string `min:"1" type:"string"`

	// The value of the calculated attribute.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCalculatedAttributeForProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCalculatedAttributeForProfileOutput) GoString() string {
	return s.String()
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *GetCalculatedAttributeForProfileOutput) SetCalculatedAttributeName(v string) *GetCalculatedAttributeForProfileOutput {
	s.CalculatedAttributeName = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetCalculatedAttributeForProfileOutput) SetDisplayName(v string) *GetCalculatedAttributeForProfileOutput {
	s.DisplayName = &v
	return s
}

// SetIsDataPartial sets the IsDataPartial field's value.
func (s *GetCalculatedAttributeForProfileOutput) SetIsDataPartial(v string) *GetCalculatedAttributeForProfileOutput {
	s.IsDataPartial = &v
	return s
}

// SetValue sets the Value field's value.
func (s *GetCalculatedAttributeForProfileOutput) SetValue(v string) *GetCalculatedAttributeForProfileOutput {
	s.Value = &v
	return s
}

type GetDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainInput) SetDomainName(v string) *GetDomainInput {
	s.DomainName = &v
	return s
}

type GetDomainOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The URL of the SQS dead letter queue, which is used for reporting errors
	// associated with ingesting data from third party applications.
	DeadLetterQueueUrl *string `type:"string"`

	// The default encryption key, which is an AWS managed key, is used when no
	// specific type of encryption key is specified. It is used to encrypt all data
	// before it is placed in permanent or semi-permanent storage.
	DefaultEncryptionKey *string `type:"string"`

	// The default number of days until the data within the domain expires.
	DefaultExpirationDays *int64 `min:"1" type:"integer"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The process of matching duplicate profiles. If Matching = true, Amazon Connect
	// Customer Profiles starts a weekly batch process called Identity Resolution
	// Job. If you do not specify a date and time for Identity Resolution Job to
	// run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles
	// in your domains.
	//
	// After the Identity Resolution Job completes, use the GetMatches (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html)
	// API to return and review the results. Or, if you have configured ExportingConfig
	// in the MatchingRequest, you can download the results from S3.
	Matching *MatchingResponse `type:"structure"`

	// Usage-specific statistics about the domain.
	Stats *DomainStats `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDomainOutput) SetCreatedAt(v time.Time) *GetDomainOutput {
	s.CreatedAt = &v
	return s
}

// SetDeadLetterQueueUrl sets the DeadLetterQueueUrl field's value.
func (s *GetDomainOutput) SetDeadLetterQueueUrl(v string) *GetDomainOutput {
	s.DeadLetterQueueUrl = &v
	return s
}

// SetDefaultEncryptionKey sets the DefaultEncryptionKey field's value.
func (s *GetDomainOutput) SetDefaultEncryptionKey(v string) *GetDomainOutput {
	s.DefaultEncryptionKey = &v
	return s
}

// SetDefaultExpirationDays sets the DefaultExpirationDays field's value.
func (s *GetDomainOutput) SetDefaultExpirationDays(v int64) *GetDomainOutput {
	s.DefaultExpirationDays = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainOutput) SetDomainName(v string) *GetDomainOutput {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetDomainOutput) SetLastUpdatedAt(v time.Time) *GetDomainOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetMatching sets the Matching field's value.
func (s *GetDomainOutput) SetMatching(v *MatchingResponse) *GetDomainOutput {
	s.Matching = v
	return s
}

// SetStats sets the Stats field's value.
func (s *GetDomainOutput) SetStats(v *DomainStats) *GetDomainOutput {
	s.Stats = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDomainOutput) SetTags(v map[string]*string) *GetDomainOutput {
	s.Tags = v
	return s
}

type GetEventStreamInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The name of the event stream provided during create operations.
	//
	// EventStreamName is a required field
	EventStreamName *string `location:"uri" locationName:"EventStreamName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventStreamInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.EventStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventStreamName"))
	}
	if s.EventStreamName != nil && len(*s.EventStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetEventStreamInput) SetDomainName(v string) *GetEventStreamInput {
	s.DomainName = &v
	return s
}

// SetEventStreamName sets the EventStreamName field's value.
func (s *GetEventStreamInput) SetEventStreamName(v string) *GetEventStreamInput {
	s.EventStreamName = &v
	return s
}

type GetEventStreamOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the export was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// Details regarding the Kinesis stream.
	//
	// DestinationDetails is a required field
	DestinationDetails *EventStreamDestinationDetails `type:"structure" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for the event stream.
	//
	// EventStreamArn is a required field
	EventStreamArn *string `min:"1" type:"string" required:"true"`

	// The operational state of destination stream for export.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"EventStreamState"`

	// The timestamp when the State changed to STOPPED.
	StoppedSince *time.Time `type:"timestamp"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventStreamOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetEventStreamOutput) SetCreatedAt(v time.Time) *GetEventStreamOutput {
	s.CreatedAt = &v
	return s
}

// SetDestinationDetails sets the DestinationDetails field's value.
func (s *GetEventStreamOutput) SetDestinationDetails(v *EventStreamDestinationDetails) *GetEventStreamOutput {
	s.DestinationDetails = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetEventStreamOutput) SetDomainName(v string) *GetEventStreamOutput {
	s.DomainName = &v
	return s
}

// SetEventStreamArn sets the EventStreamArn field's value.
func (s *GetEventStreamOutput) SetEventStreamArn(v string) *GetEventStreamOutput {
	s.EventStreamArn = &v
	return s
}

// SetState sets the State field's value.
func (s *GetEventStreamOutput) SetState(v string) *GetEventStreamOutput {
	s.State = &v
	return s
}

// SetStoppedSince sets the StoppedSince field's value.
func (s *GetEventStreamOutput) SetStoppedSince(v time.Time) *GetEventStreamOutput {
	s.StoppedSince = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetEventStreamOutput) SetTags(v map[string]*string) *GetEventStreamOutput {
	s.Tags = v
	return s
}

type GetIdentityResolutionJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The unique identifier of the Identity Resolution Job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"JobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityResolutionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityResolutionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityResolutionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityResolutionJobInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetIdentityResolutionJobInput) SetDomainName(v string) *GetIdentityResolutionJobInput {
	s.DomainName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetIdentityResolutionJobInput) SetJobId(v string) *GetIdentityResolutionJobInput {
	s.JobId = &v
	return s
}

type GetIdentityResolutionJobOutput struct {
	_ struct{} `type:"structure"`

	// Configuration settings for how to perform the auto-merging of profiles.
	AutoMerging *AutoMerging `type:"structure"`

	// The unique name of the domain.
	DomainName *string `min:"1" type:"string"`

	// The S3 location where the Identity Resolution Job writes result files.
	ExportingLocation *ExportingLocation `type:"structure"`

	// The timestamp of when the Identity Resolution Job was completed.
	JobEndTime *time.Time `type:"timestamp"`

	// The timestamp of when the Identity Resolution Job will expire.
	JobExpirationTime *time.Time `type:"timestamp"`

	// The unique identifier of the Identity Resolution Job.
	JobId *string `type:"string"`

	// The timestamp of when the Identity Resolution Job was started or will be
	// started.
	JobStartTime *time.Time `type:"timestamp"`

	// Statistics about the Identity Resolution Job.
	JobStats *JobStats `type:"structure"`

	// The timestamp of when the Identity Resolution Job was most recently edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The error messages that are generated when the Identity Resolution Job runs.
	Message *string `type:"string"`

	// The status of the Identity Resolution Job.
	//
	//    * PENDING: The Identity Resolution Job is scheduled but has not started
	//    yet. If you turn off the Identity Resolution feature in your domain, jobs
	//    in the PENDING state are deleted.
	//
	//    * PREPROCESSING: The Identity Resolution Job is loading your data.
	//
	//    * FIND_MATCHING: The Identity Resolution Job is using the machine learning
	//    model to identify profiles that belong to the same matching group.
	//
	//    * MERGING: The Identity Resolution Job is merging duplicate profiles.
	//
	//    * COMPLETED: The Identity Resolution Job completed successfully.
	//
	//    * PARTIAL_SUCCESS: There's a system error and not all of the data is merged.
	//    The Identity Resolution Job writes a message indicating the source of
	//    the problem.
	//
	//    * FAILED: The Identity Resolution Job did not merge any data. It writes
	//    a message indicating the source of the problem.
	Status *string `type:"string" enum:"IdentityResolutionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityResolutionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityResolutionJobOutput) GoString() string {
	return s.String()
}

// SetAutoMerging sets the AutoMerging field's value.
func (s *GetIdentityResolutionJobOutput) SetAutoMerging(v *AutoMerging) *GetIdentityResolutionJobOutput {
	s.AutoMerging = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetIdentityResolutionJobOutput) SetDomainName(v string) *GetIdentityResolutionJobOutput {
	s.DomainName = &v
	return s
}

// SetExportingLocation sets the ExportingLocation field's value.
func (s *GetIdentityResolutionJobOutput) SetExportingLocation(v *ExportingLocation) *GetIdentityResolutionJobOutput {
	s.ExportingLocation = v
	return s
}

// SetJobEndTime sets the JobEndTime field's value.
func (s *GetIdentityResolutionJobOutput) SetJobEndTime(v time.Time) *GetIdentityResolutionJobOutput {
	s.JobEndTime = &v
	return s
}

// SetJobExpirationTime sets the JobExpirationTime field's value.
func (s *GetIdentityResolutionJobOutput) SetJobExpirationTime(v time.Time) *GetIdentityResolutionJobOutput {
	s.JobExpirationTime = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetIdentityResolutionJobOutput) SetJobId(v string) *GetIdentityResolutionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStartTime sets the JobStartTime field's value.
func (s *GetIdentityResolutionJobOutput) SetJobStartTime(v time.Time) *GetIdentityResolutionJobOutput {
	s.JobStartTime = &v
	return s
}

// SetJobStats sets the JobStats field's value.
func (s *GetIdentityResolutionJobOutput) SetJobStats(v *JobStats) *GetIdentityResolutionJobOutput {
	s.JobStats = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetIdentityResolutionJobOutput) SetLastUpdatedAt(v time.Time) *GetIdentityResolutionJobOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetIdentityResolutionJobOutput) SetMessage(v string) *GetIdentityResolutionJobOutput {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetIdentityResolutionJobOutput) SetStatus(v string) *GetIdentityResolutionJobOutput {
	s.Status = &v
	return s
}

type GetIntegrationInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntegrationInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetIntegrationInput) SetDomainName(v string) *GetIntegrationInput {
	s.DomainName = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *GetIntegrationInput) SetUri(v string) *GetIntegrationInput {
	s.Uri = &v
	return s
}

type GetIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// Boolean that shows if the Flow that's associated with the Integration is
	// created in Amazon Appflow, or with ObjectTypeName equals _unstructured via
	// API/CLI in flowDefinition.
	IsUnstructured *bool `type:"boolean"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The name of the profile object type.
	ObjectTypeName *string `min:"1" type:"string"`

	// A map in which each key is an event type from an external application such
	// as Segment or Shopify, and each value is an ObjectTypeName (template) used
	// to ingest the event. It supports the following event types: SegmentIdentify,
	// ShopifyCreateCustomers, ShopifyUpdateCustomers, ShopifyCreateDraftOrders,
	// ShopifyUpdateDraftOrders, ShopifyCreateOrders, and ShopifyUpdatedOrders.
	ObjectTypeNames map[string]*string `type:"map"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`

	// Unique identifier for the workflow.
	WorkflowId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIntegrationOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetIntegrationOutput) SetCreatedAt(v time.Time) *GetIntegrationOutput {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetIntegrationOutput) SetDomainName(v string) *GetIntegrationOutput {
	s.DomainName = &v
	return s
}

// SetIsUnstructured sets the IsUnstructured field's value.
func (s *GetIntegrationOutput) SetIsUnstructured(v bool) *GetIntegrationOutput {
	s.IsUnstructured = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetIntegrationOutput) SetLastUpdatedAt(v time.Time) *GetIntegrationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *GetIntegrationOutput) SetObjectTypeName(v string) *GetIntegrationOutput {
	s.ObjectTypeName = &v
	return s
}

// SetObjectTypeNames sets the ObjectTypeNames field's value.
func (s *GetIntegrationOutput) SetObjectTypeNames(v map[string]*string) *GetIntegrationOutput {
	s.ObjectTypeNames = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetIntegrationOutput) SetTags(v map[string]*string) *GetIntegrationOutput {
	s.Tags = v
	return s
}

// SetUri sets the Uri field's value.
func (s *GetIntegrationOutput) SetUri(v string) *GetIntegrationOutput {
	s.Uri = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *GetIntegrationOutput) SetWorkflowId(v string) *GetIntegrationOutput {
	s.WorkflowId = &v
	return s
}

type GetMatchesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMatchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMatchesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetMatchesInput) SetDomainName(v string) *GetMatchesInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetMatchesInput) SetMaxResults(v int64) *GetMatchesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMatchesInput) SetNextToken(v string) *GetMatchesInput {
	s.NextToken = &v
	return s
}

type GetMatchesOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp this version of Match Result generated.
	MatchGenerationDate *time.Time `type:"timestamp"`

	// The list of matched profiles for this instance.
	Matches []*MatchItem `type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of potential matches found.
	PotentialMatches *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchesOutput) GoString() string {
	return s.String()
}

// SetMatchGenerationDate sets the MatchGenerationDate field's value.
func (s *GetMatchesOutput) SetMatchGenerationDate(v time.Time) *GetMatchesOutput {
	s.MatchGenerationDate = &v
	return s
}

// SetMatches sets the Matches field's value.
func (s *GetMatchesOutput) SetMatches(v []*MatchItem) *GetMatchesOutput {
	s.Matches = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMatchesOutput) SetNextToken(v string) *GetMatchesOutput {
	s.NextToken = &v
	return s
}

// SetPotentialMatches sets the PotentialMatches field's value.
func (s *GetMatchesOutput) SetPotentialMatches(v int64) *GetMatchesOutput {
	s.PotentialMatches = &v
	return s
}

type GetProfileObjectTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `location:"uri" locationName:"ObjectTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileObjectTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileObjectTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileObjectTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileObjectTypeInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetProfileObjectTypeInput) SetDomainName(v string) *GetProfileObjectTypeInput {
	s.DomainName = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *GetProfileObjectTypeInput) SetObjectTypeName(v string) *GetProfileObjectTypeInput {
	s.ObjectTypeName = &v
	return s
}

type GetProfileObjectTypeOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether a profile should be created when data is received if one
	// doesn’t exist for an object of this type. The default is FALSE. If the
	// AllowProfileCreation flag is set to FALSE, then the service tries to fetch
	// a standard profile and associate this object with the profile. If it is set
	// to TRUE, and if no match is found, then the service creates a new standard
	// profile.
	AllowProfileCreation *bool `type:"boolean"`

	// The timestamp of when the domain was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the profile object type.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The customer-provided key to encrypt the profile object that will be created
	// in this profile object type.
	EncryptionKey *string `type:"string"`

	// The number of days until the data in the object expires.
	ExpirationDays *int64 `min:"1" type:"integer"`

	// A map of the name and ObjectType field.
	Fields map[string]*ObjectTypeField `type:"map"`

	// A list of unique keys that can be used to map data to the profile.
	Keys map[string][]*ObjectTypeKey `type:"map"`

	// The timestamp of when the domain was most recently edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The format of your sourceLastUpdatedTimestamp that was previously set up.
	SourceLastUpdatedTimestampFormat *string `min:"1" type:"string"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// A unique identifier for the object template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileObjectTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileObjectTypeOutput) GoString() string {
	return s.String()
}

// SetAllowProfileCreation sets the AllowProfileCreation field's value.
func (s *GetProfileObjectTypeOutput) SetAllowProfileCreation(v bool) *GetProfileObjectTypeOutput {
	s.AllowProfileCreation = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetProfileObjectTypeOutput) SetCreatedAt(v time.Time) *GetProfileObjectTypeOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetProfileObjectTypeOutput) SetDescription(v string) *GetProfileObjectTypeOutput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *GetProfileObjectTypeOutput) SetEncryptionKey(v string) *GetProfileObjectTypeOutput {
	s.EncryptionKey = &v
	return s
}

// SetExpirationDays sets the ExpirationDays field's value.
func (s *GetProfileObjectTypeOutput) SetExpirationDays(v int64) *GetProfileObjectTypeOutput {
	s.ExpirationDays = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *GetProfileObjectTypeOutput) SetFields(v map[string]*ObjectTypeField) *GetProfileObjectTypeOutput {
	s.Fields = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *GetProfileObjectTypeOutput) SetKeys(v map[string][]*ObjectTypeKey) *GetProfileObjectTypeOutput {
	s.Keys = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetProfileObjectTypeOutput) SetLastUpdatedAt(v time.Time) *GetProfileObjectTypeOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *GetProfileObjectTypeOutput) SetObjectTypeName(v string) *GetProfileObjectTypeOutput {
	s.ObjectTypeName = &v
	return s
}

// SetSourceLastUpdatedTimestampFormat sets the SourceLastUpdatedTimestampFormat field's value.
func (s *GetProfileObjectTypeOutput) SetSourceLastUpdatedTimestampFormat(v string) *GetProfileObjectTypeOutput {
	s.SourceLastUpdatedTimestampFormat = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetProfileObjectTypeOutput) SetTags(v map[string]*string) *GetProfileObjectTypeOutput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetProfileObjectTypeOutput) SetTemplateId(v string) *GetProfileObjectTypeOutput {
	s.TemplateId = &v
	return s
}

type GetProfileObjectTypeTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the object template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileObjectTypeTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileObjectTypeTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileObjectTypeTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileObjectTypeTemplateInput"}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetProfileObjectTypeTemplateInput) SetTemplateId(v string) *GetProfileObjectTypeTemplateInput {
	s.TemplateId = &v
	return s
}

type GetProfileObjectTypeTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether a profile should be created when data is received if one
	// doesn’t exist for an object of this type. The default is FALSE. If the
	// AllowProfileCreation flag is set to FALSE, then the service tries to fetch
	// a standard profile and associate this object with the profile. If it is set
	// to TRUE, and if no match is found, then the service creates a new standard
	// profile.
	AllowProfileCreation *bool `type:"boolean"`

	// A map of the name and ObjectType field.
	Fields map[string]*ObjectTypeField `type:"map"`

	// A list of unique keys that can be used to map data to the profile.
	Keys map[string][]*ObjectTypeKey `type:"map"`

	// The format of your sourceLastUpdatedTimestamp that was previously set up.
	SourceLastUpdatedTimestampFormat *string `min:"1" type:"string"`

	// The name of the source of the object template.
	SourceName *string `min:"1" type:"string"`

	// The source of the object template.
	SourceObject *string `min:"1" type:"string"`

	// A unique identifier for the object template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileObjectTypeTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileObjectTypeTemplateOutput) GoString() string {
	return s.String()
}

// SetAllowProfileCreation sets the AllowProfileCreation field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetAllowProfileCreation(v bool) *GetProfileObjectTypeTemplateOutput {
	s.AllowProfileCreation = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetFields(v map[string]*ObjectTypeField) *GetProfileObjectTypeTemplateOutput {
	s.Fields = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetKeys(v map[string][]*ObjectTypeKey) *GetProfileObjectTypeTemplateOutput {
	s.Keys = v
	return s
}

// SetSourceLastUpdatedTimestampFormat sets the SourceLastUpdatedTimestampFormat field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetSourceLastUpdatedTimestampFormat(v string) *GetProfileObjectTypeTemplateOutput {
	s.SourceLastUpdatedTimestampFormat = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetSourceName(v string) *GetProfileObjectTypeTemplateOutput {
	s.SourceName = &v
	return s
}

// SetSourceObject sets the SourceObject field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetSourceObject(v string) *GetProfileObjectTypeTemplateOutput {
	s.SourceObject = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetTemplateId(v string) *GetProfileObjectTypeTemplateOutput {
	s.TemplateId = &v
	return s
}

type GetWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// Unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"uri" locationName:"WorkflowId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkflowInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetWorkflowInput) SetDomainName(v string) *GetWorkflowInput {
	s.DomainName = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *GetWorkflowInput) SetWorkflowId(v string) *GetWorkflowInput {
	s.WorkflowId = &v
	return s
}

type GetWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// Attributes provided for workflow execution.
	Attributes *WorkflowAttributes `type:"structure"`

	// Workflow error messages during execution (if any).
	ErrorDescription *string `min:"1" type:"string"`

	// The timestamp that represents when workflow execution last updated.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// Workflow specific execution metrics.
	Metrics *WorkflowMetrics `type:"structure"`

	// The timestamp that represents when workflow execution started.
	StartDate *time.Time `type:"timestamp"`

	// Status of workflow execution.
	Status *string `type:"string" enum:"Status"`

	// Unique identifier for the workflow.
	WorkflowId *string `type:"string"`

	// The type of workflow. The only supported value is APPFLOW_INTEGRATION.
	WorkflowType *string `type:"string" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *GetWorkflowOutput) SetAttributes(v *WorkflowAttributes) *GetWorkflowOutput {
	s.Attributes = v
	return s
}

// SetErrorDescription sets the ErrorDescription field's value.
func (s *GetWorkflowOutput) SetErrorDescription(v string) *GetWorkflowOutput {
	s.ErrorDescription = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetWorkflowOutput) SetLastUpdatedAt(v time.Time) *GetWorkflowOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetWorkflowOutput) SetMetrics(v *WorkflowMetrics) *GetWorkflowOutput {
	s.Metrics = v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *GetWorkflowOutput) SetStartDate(v time.Time) *GetWorkflowOutput {
	s.StartDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetWorkflowOutput) SetStatus(v string) *GetWorkflowOutput {
	s.Status = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *GetWorkflowOutput) SetWorkflowId(v string) *GetWorkflowOutput {
	s.WorkflowId = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *GetWorkflowOutput) SetWorkflowType(v string) *GetWorkflowOutput {
	s.WorkflowType = &v
	return s
}

type GetWorkflowStepsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// Unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"uri" locationName:"WorkflowId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkflowStepsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkflowStepsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetWorkflowStepsInput) SetDomainName(v string) *GetWorkflowStepsInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetWorkflowStepsInput) SetMaxResults(v int64) *GetWorkflowStepsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetWorkflowStepsInput) SetNextToken(v string) *GetWorkflowStepsInput {
	s.NextToken = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *GetWorkflowStepsInput) SetWorkflowId(v string) *GetWorkflowStepsInput {
	s.WorkflowId = &v
	return s
}

type GetWorkflowStepsOutput struct {
	_ struct{} `type:"structure"`

	// List containing workflow step details.
	Items []*WorkflowStepItem `type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`

	// Unique identifier for the workflow.
	WorkflowId *string `type:"string"`

	// The type of workflow. The only supported value is APPFLOW_INTEGRATION.
	WorkflowType *string `type:"string" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetWorkflowStepsOutput) SetItems(v []*WorkflowStepItem) *GetWorkflowStepsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetWorkflowStepsOutput) SetNextToken(v string) *GetWorkflowStepsOutput {
	s.NextToken = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *GetWorkflowStepsOutput) SetWorkflowId(v string) *GetWorkflowStepsOutput {
	s.WorkflowId = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *GetWorkflowStepsOutput) SetWorkflowType(v string) *GetWorkflowStepsOutput {
	s.WorkflowType = &v
	return s
}

// Information about the Identity Resolution Job.
type IdentityResolutionJob struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	DomainName *string `min:"1" type:"string"`

	// The S3 location where the Identity Resolution Job writes result files.
	ExportingLocation *ExportingLocation `type:"structure"`

	// The timestamp of when the job was completed.
	JobEndTime *time.Time `type:"timestamp"`

	// The unique identifier of the Identity Resolution Job.
	JobId *string `type:"string"`

	// The timestamp of when the job was started or will be started.
	JobStartTime *time.Time `type:"timestamp"`

	// Statistics about an Identity Resolution Job.
	JobStats *JobStats `type:"structure"`

	// The error messages that are generated when the Identity Resolution Job runs.
	Message *string `type:"string"`

	// The status of the Identity Resolution Job.
	//
	//    * PENDING: The Identity Resolution Job is scheduled but has not started
	//    yet. If you turn off the Identity Resolution feature in your domain, jobs
	//    in the PENDING state are deleted.
	//
	//    * PREPROCESSING: The Identity Resolution Job is loading your data.
	//
	//    * FIND_MATCHING: The Identity Resolution Job is using the machine learning
	//    model to identify profiles that belong to the same matching group.
	//
	//    * MERGING: The Identity Resolution Job is merging duplicate profiles.
	//
	//    * COMPLETED: The Identity Resolution Job completed successfully.
	//
	//    * PARTIAL_SUCCESS: There's a system error and not all of the data is merged.
	//    The Identity Resolution Job writes a message indicating the source of
	//    the problem.
	//
	//    * FAILED: The Identity Resolution Job did not merge any data. It writes
	//    a message indicating the source of the problem.
	Status *string `type:"string" enum:"IdentityResolutionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityResolutionJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityResolutionJob) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *IdentityResolutionJob) SetDomainName(v string) *IdentityResolutionJob {
	s.DomainName = &v
	return s
}

// SetExportingLocation sets the ExportingLocation field's value.
func (s *IdentityResolutionJob) SetExportingLocation(v *ExportingLocation) *IdentityResolutionJob {
	s.ExportingLocation = v
	return s
}

// SetJobEndTime sets the JobEndTime field's value.
func (s *IdentityResolutionJob) SetJobEndTime(v time.Time) *IdentityResolutionJob {
	s.JobEndTime = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *IdentityResolutionJob) SetJobId(v string) *IdentityResolutionJob {
	s.JobId = &v
	return s
}

// SetJobStartTime sets the JobStartTime field's value.
func (s *IdentityResolutionJob) SetJobStartTime(v time.Time) *IdentityResolutionJob {
	s.JobStartTime = &v
	return s
}

// SetJobStats sets the JobStats field's value.
func (s *IdentityResolutionJob) SetJobStats(v *JobStats) *IdentityResolutionJob {
	s.JobStats = v
	return s
}

// SetMessage sets the Message field's value.
func (s *IdentityResolutionJob) SetMessage(v string) *IdentityResolutionJob {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IdentityResolutionJob) SetStatus(v string) *IdentityResolutionJob {
	s.Status = &v
	return s
}

// Specifies the configuration used when importing incremental records from
// the source.
type IncrementalPullConfig struct {
	_ struct{} `type:"structure"`

	// A field that specifies the date time or timestamp field as the criteria to
	// use when importing incremental records from the source.
	DatetimeTypeFieldName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncrementalPullConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncrementalPullConfig) GoString() string {
	return s.String()
}

// SetDatetimeTypeFieldName sets the DatetimeTypeFieldName field's value.
func (s *IncrementalPullConfig) SetDatetimeTypeFieldName(v string) *IncrementalPullConfig {
	s.DatetimeTypeFieldName = &v
	return s
}

// Configuration data for integration workflow.
type IntegrationConfig struct {
	_ struct{} `type:"structure"`

	// Configuration data for APPFLOW_INTEGRATION workflow type.
	AppflowIntegration *AppflowIntegration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntegrationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegrationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntegrationConfig"}
	if s.AppflowIntegration != nil {
		if err := s.AppflowIntegration.Validate(); err != nil {
			invalidParams.AddNested("AppflowIntegration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppflowIntegration sets the AppflowIntegration field's value.
func (s *IntegrationConfig) SetAppflowIntegration(v *AppflowIntegration) *IntegrationConfig {
	s.AppflowIntegration = v
	return s
}

// An internal service error occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The day and time when do you want to start the Identity Resolution Job every
// week.
type JobSchedule struct {
	_ struct{} `type:"structure"`

	// The day when the Identity Resolution Job should run every week.
	//
	// DayOfTheWeek is a required field
	DayOfTheWeek *string `type:"string" required:"true" enum:"JobScheduleDayOfTheWeek"`

	// The time when the Identity Resolution Job should run every week.
	//
	// Time is a required field
	Time *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobSchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobSchedule"}
	if s.DayOfTheWeek == nil {
		invalidParams.Add(request.NewErrParamRequired("DayOfTheWeek"))
	}
	if s.Time == nil {
		invalidParams.Add(request.NewErrParamRequired("Time"))
	}
	if s.Time != nil && len(*s.Time) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Time", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDayOfTheWeek sets the DayOfTheWeek field's value.
func (s *JobSchedule) SetDayOfTheWeek(v string) *JobSchedule {
	s.DayOfTheWeek = &v
	return s
}

// SetTime sets the Time field's value.
func (s *JobSchedule) SetTime(v string) *JobSchedule {
	s.Time = &v
	return s
}

// Statistics about the Identity Resolution Job.
type JobStats struct {
	_ struct{} `type:"structure"`

	// The number of matches found.
	NumberOfMatchesFound *int64 `type:"long"`

	// The number of merges completed.
	NumberOfMergesDone *int64 `type:"long"`

	// The number of profiles reviewed.
	NumberOfProfilesReviewed *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobStats) GoString() string {
	return s.String()
}

// SetNumberOfMatchesFound sets the NumberOfMatchesFound field's value.
func (s *JobStats) SetNumberOfMatchesFound(v int64) *JobStats {
	s.NumberOfMatchesFound = &v
	return s
}

// SetNumberOfMergesDone sets the NumberOfMergesDone field's value.
func (s *JobStats) SetNumberOfMergesDone(v int64) *JobStats {
	s.NumberOfMergesDone = &v
	return s
}

// SetNumberOfProfilesReviewed sets the NumberOfProfilesReviewed field's value.
func (s *JobStats) SetNumberOfProfilesReviewed(v int64) *JobStats {
	s.NumberOfProfilesReviewed = &v
	return s
}

type ListAccountIntegrationsInput struct {
	_ struct{} `type:"structure"`

	// Boolean to indicate if hidden integration should be returned. Defaults to
	// False.
	IncludeHidden *bool `location:"querystring" locationName:"include-hidden" type:"boolean"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous ListAccountIntegrations API call.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountIntegrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountIntegrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountIntegrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountIntegrationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeHidden sets the IncludeHidden field's value.
func (s *ListAccountIntegrationsInput) SetIncludeHidden(v bool) *ListAccountIntegrationsInput {
	s.IncludeHidden = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountIntegrationsInput) SetMaxResults(v int64) *ListAccountIntegrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountIntegrationsInput) SetNextToken(v string) *ListAccountIntegrationsInput {
	s.NextToken = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *ListAccountIntegrationsInput) SetUri(v string) *ListAccountIntegrationsInput {
	s.Uri = &v
	return s
}

type ListAccountIntegrationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListAccountIntegration instances.
	Items []*ListIntegrationItem `type:"list"`

	// The pagination token from the previous ListAccountIntegrations API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountIntegrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountIntegrationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListAccountIntegrationsOutput) SetItems(v []*ListIntegrationItem) *ListAccountIntegrationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountIntegrationsOutput) SetNextToken(v string) *ListAccountIntegrationsOutput {
	s.NextToken = &v
	return s
}

// The details of a single calculated attribute definition.
type ListCalculatedAttributeDefinitionItem struct {
	_ struct{} `type:"structure"`

	// The unique name of the calculated attribute.
	CalculatedAttributeName *string `min:"1" type:"string"`

	// The threshold for the calculated attribute.
	CreatedAt *time.Time `type:"timestamp"`

	// The threshold for the calculated attribute.
	Description *string `min:"1" type:"string"`

	// The display name of the calculated attribute.
	DisplayName *string `min:"1" type:"string"`

	// The timestamp of when the calculated attribute definition was most recently
	// edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributeDefinitionItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributeDefinitionItem) GoString() string {
	return s.String()
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *ListCalculatedAttributeDefinitionItem) SetCalculatedAttributeName(v string) *ListCalculatedAttributeDefinitionItem {
	s.CalculatedAttributeName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListCalculatedAttributeDefinitionItem) SetCreatedAt(v time.Time) *ListCalculatedAttributeDefinitionItem {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListCalculatedAttributeDefinitionItem) SetDescription(v string) *ListCalculatedAttributeDefinitionItem {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ListCalculatedAttributeDefinitionItem) SetDisplayName(v string) *ListCalculatedAttributeDefinitionItem {
	s.DisplayName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ListCalculatedAttributeDefinitionItem) SetLastUpdatedAt(v time.Time) *ListCalculatedAttributeDefinitionItem {
	s.LastUpdatedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListCalculatedAttributeDefinitionItem) SetTags(v map[string]*string) *ListCalculatedAttributeDefinitionItem {
	s.Tags = v
	return s
}

type ListCalculatedAttributeDefinitionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of calculated attribute definitions returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous call to ListCalculatedAttributeDefinitions.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributeDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributeDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCalculatedAttributeDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCalculatedAttributeDefinitionsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListCalculatedAttributeDefinitionsInput) SetDomainName(v string) *ListCalculatedAttributeDefinitionsInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCalculatedAttributeDefinitionsInput) SetMaxResults(v int64) *ListCalculatedAttributeDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCalculatedAttributeDefinitionsInput) SetNextToken(v string) *ListCalculatedAttributeDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListCalculatedAttributeDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of calculated attribute definitions.
	Items []*ListCalculatedAttributeDefinitionItem `type:"list"`

	// The pagination token from the previous call to ListCalculatedAttributeDefinitions.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributeDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributeDefinitionsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListCalculatedAttributeDefinitionsOutput) SetItems(v []*ListCalculatedAttributeDefinitionItem) *ListCalculatedAttributeDefinitionsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCalculatedAttributeDefinitionsOutput) SetNextToken(v string) *ListCalculatedAttributeDefinitionsOutput {
	s.NextToken = &v
	return s
}

// The details of a single calculated attribute for a profile.
type ListCalculatedAttributeForProfileItem struct {
	_ struct{} `type:"structure"`

	// The unique name of the calculated attribute.
	CalculatedAttributeName *string `min:"1" type:"string"`

	// The display name of the calculated attribute.
	DisplayName *string `min:"1" type:"string"`

	// Indicates whether the calculated attribute’s value is based on partial
	// data. If data is partial, it is set to true.
	IsDataPartial *string `min:"1" type:"string"`

	// The value of the calculated attribute.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributeForProfileItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributeForProfileItem) GoString() string {
	return s.String()
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *ListCalculatedAttributeForProfileItem) SetCalculatedAttributeName(v string) *ListCalculatedAttributeForProfileItem {
	s.CalculatedAttributeName = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ListCalculatedAttributeForProfileItem) SetDisplayName(v string) *ListCalculatedAttributeForProfileItem {
	s.DisplayName = &v
	return s
}

// SetIsDataPartial sets the IsDataPartial field's value.
func (s *ListCalculatedAttributeForProfileItem) SetIsDataPartial(v string) *ListCalculatedAttributeForProfileItem {
	s.IsDataPartial = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ListCalculatedAttributeForProfileItem) SetValue(v string) *ListCalculatedAttributeForProfileItem {
	s.Value = &v
	return s
}

type ListCalculatedAttributesForProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of calculated attributes returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous call to ListCalculatedAttributesForProfile.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"ProfileId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributesForProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributesForProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCalculatedAttributesForProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCalculatedAttributesForProfileInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListCalculatedAttributesForProfileInput) SetDomainName(v string) *ListCalculatedAttributesForProfileInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCalculatedAttributesForProfileInput) SetMaxResults(v int64) *ListCalculatedAttributesForProfileInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCalculatedAttributesForProfileInput) SetNextToken(v string) *ListCalculatedAttributesForProfileInput {
	s.NextToken = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ListCalculatedAttributesForProfileInput) SetProfileId(v string) *ListCalculatedAttributesForProfileInput {
	s.ProfileId = &v
	return s
}

type ListCalculatedAttributesForProfileOutput struct {
	_ struct{} `type:"structure"`

	// The list of calculated attributes.
	Items []*ListCalculatedAttributeForProfileItem `type:"list"`

	// The pagination token from the previous call to ListCalculatedAttributesForProfile.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributesForProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCalculatedAttributesForProfileOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListCalculatedAttributesForProfileOutput) SetItems(v []*ListCalculatedAttributeForProfileItem) *ListCalculatedAttributesForProfileOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCalculatedAttributesForProfileOutput) SetNextToken(v string) *ListCalculatedAttributesForProfileOutput {
	s.NextToken = &v
	return s
}

// An object in a list that represents a domain.
type ListDomainItem struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainItem) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListDomainItem) SetCreatedAt(v time.Time) *ListDomainItem {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ListDomainItem) SetDomainName(v string) *ListDomainItem {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ListDomainItem) SetLastUpdatedAt(v time.Time) *ListDomainItem {
	s.LastUpdatedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListDomainItem) SetTags(v map[string]*string) *ListDomainItem {
	s.Tags = v
	return s
}

type ListDomainsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous ListDomain API call.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainsInput) SetMaxResults(v int64) *ListDomainsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsInput) SetNextToken(v string) *ListDomainsInput {
	s.NextToken = &v
	return s
}

type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListDomains instances.
	Items []*ListDomainItem `type:"list"`

	// The pagination token from the previous ListDomains API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListDomainsOutput) SetItems(v []*ListDomainItem) *ListDomainsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsOutput) SetNextToken(v string) *ListDomainsOutput {
	s.NextToken = &v
	return s
}

type ListEventStreamsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventStreamsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListEventStreamsInput) SetDomainName(v string) *ListEventStreamsInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventStreamsInput) SetMaxResults(v int64) *ListEventStreamsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventStreamsInput) SetNextToken(v string) *ListEventStreamsInput {
	s.NextToken = &v
	return s
}

type ListEventStreamsOutput struct {
	_ struct{} `type:"structure"`

	// Contains summary information about an EventStream.
	Items []*EventStreamSummary `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventStreamsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListEventStreamsOutput) SetItems(v []*EventStreamSummary) *ListEventStreamsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventStreamsOutput) SetNextToken(v string) *ListEventStreamsOutput {
	s.NextToken = &v
	return s
}

type ListIdentityResolutionJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityResolutionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityResolutionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityResolutionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentityResolutionJobsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListIdentityResolutionJobsInput) SetDomainName(v string) *ListIdentityResolutionJobsInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentityResolutionJobsInput) SetMaxResults(v int64) *ListIdentityResolutionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityResolutionJobsInput) SetNextToken(v string) *ListIdentityResolutionJobsInput {
	s.NextToken = &v
	return s
}

type ListIdentityResolutionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Identity Resolution Jobs.
	IdentityResolutionJobsList []*IdentityResolutionJob `type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityResolutionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityResolutionJobsOutput) GoString() string {
	return s.String()
}

// SetIdentityResolutionJobsList sets the IdentityResolutionJobsList field's value.
func (s *ListIdentityResolutionJobsOutput) SetIdentityResolutionJobsList(v []*IdentityResolutionJob) *ListIdentityResolutionJobsOutput {
	s.IdentityResolutionJobsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityResolutionJobsOutput) SetNextToken(v string) *ListIdentityResolutionJobsOutput {
	s.NextToken = &v
	return s
}

// An integration in list of integrations.
type ListIntegrationItem struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// Boolean that shows if the Flow that's associated with the Integration is
	// created in Amazon Appflow, or with ObjectTypeName equals _unstructured via
	// API/CLI in flowDefinition.
	IsUnstructured *bool `type:"boolean"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The name of the profile object type.
	ObjectTypeName *string `min:"1" type:"string"`

	// A map in which each key is an event type from an external application such
	// as Segment or Shopify, and each value is an ObjectTypeName (template) used
	// to ingest the event. It supports the following event types: SegmentIdentify,
	// ShopifyCreateCustomers, ShopifyUpdateCustomers, ShopifyCreateDraftOrders,
	// ShopifyUpdateDraftOrders, ShopifyCreateOrders, and ShopifyUpdatedOrders.
	ObjectTypeNames map[string]*string `type:"map"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`

	// Unique identifier for the workflow.
	WorkflowId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIntegrationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIntegrationItem) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListIntegrationItem) SetCreatedAt(v time.Time) *ListIntegrationItem {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ListIntegrationItem) SetDomainName(v string) *ListIntegrationItem {
	s.DomainName = &v
	return s
}

// SetIsUnstructured sets the IsUnstructured field's value.
func (s *ListIntegrationItem) SetIsUnstructured(v bool) *ListIntegrationItem {
	s.IsUnstructured = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ListIntegrationItem) SetLastUpdatedAt(v time.Time) *ListIntegrationItem {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *ListIntegrationItem) SetObjectTypeName(v string) *ListIntegrationItem {
	s.ObjectTypeName = &v
	return s
}

// SetObjectTypeNames sets the ObjectTypeNames field's value.
func (s *ListIntegrationItem) SetObjectTypeNames(v map[string]*string) *ListIntegrationItem {
	s.ObjectTypeNames = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListIntegrationItem) SetTags(v map[string]*string) *ListIntegrationItem {
	s.Tags = v
	return s
}

// SetUri sets the Uri field's value.
func (s *ListIntegrationItem) SetUri(v string) *ListIntegrationItem {
	s.Uri = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *ListIntegrationItem) SetWorkflowId(v string) *ListIntegrationItem {
	s.WorkflowId = &v
	return s
}

type ListIntegrationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// Boolean to indicate if hidden integration should be returned. Defaults to
	// False.
	IncludeHidden *bool `location:"querystring" locationName:"include-hidden" type:"boolean"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous ListIntegrations API call.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIntegrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIntegrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIntegrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIntegrationsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListIntegrationsInput) SetDomainName(v string) *ListIntegrationsInput {
	s.DomainName = &v
	return s
}

// SetIncludeHidden sets the IncludeHidden field's value.
func (s *ListIntegrationsInput) SetIncludeHidden(v bool) *ListIntegrationsInput {
	s.IncludeHidden = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIntegrationsInput) SetMaxResults(v int64) *ListIntegrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIntegrationsInput) SetNextToken(v string) *ListIntegrationsInput {
	s.NextToken = &v
	return s
}

type ListIntegrationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListIntegrations instances.
	Items []*ListIntegrationItem `type:"list"`

	// The pagination token from the previous ListIntegrations API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIntegrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIntegrationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListIntegrationsOutput) SetItems(v []*ListIntegrationItem) *ListIntegrationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIntegrationsOutput) SetNextToken(v string) *ListIntegrationsOutput {
	s.NextToken = &v
	return s
}

// A ProfileObjectType instance.
type ListProfileObjectTypeItem struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Description of the profile object type.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypeItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypeItem) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListProfileObjectTypeItem) SetCreatedAt(v time.Time) *ListProfileObjectTypeItem {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListProfileObjectTypeItem) SetDescription(v string) *ListProfileObjectTypeItem {
	s.Description = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ListProfileObjectTypeItem) SetLastUpdatedAt(v time.Time) *ListProfileObjectTypeItem {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *ListProfileObjectTypeItem) SetObjectTypeName(v string) *ListProfileObjectTypeItem {
	s.ObjectTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListProfileObjectTypeItem) SetTags(v map[string]*string) *ListProfileObjectTypeItem {
	s.Tags = v
	return s
}

// A ProfileObjectTypeTemplate in a list of ProfileObjectTypeTemplates.
type ListProfileObjectTypeTemplateItem struct {
	_ struct{} `type:"structure"`

	// The name of the source of the object template.
	SourceName *string `min:"1" type:"string"`

	// The source of the object template.
	SourceObject *string `min:"1" type:"string"`

	// A unique identifier for the object template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypeTemplateItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypeTemplateItem) GoString() string {
	return s.String()
}

// SetSourceName sets the SourceName field's value.
func (s *ListProfileObjectTypeTemplateItem) SetSourceName(v string) *ListProfileObjectTypeTemplateItem {
	s.SourceName = &v
	return s
}

// SetSourceObject sets the SourceObject field's value.
func (s *ListProfileObjectTypeTemplateItem) SetSourceObject(v string) *ListProfileObjectTypeTemplateItem {
	s.SourceObject = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *ListProfileObjectTypeTemplateItem) SetTemplateId(v string) *ListProfileObjectTypeTemplateItem {
	s.TemplateId = &v
	return s
}

type ListProfileObjectTypeTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous ListObjectTypeTemplates API call.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypeTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypeTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileObjectTypeTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileObjectTypeTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileObjectTypeTemplatesInput) SetMaxResults(v int64) *ListProfileObjectTypeTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectTypeTemplatesInput) SetNextToken(v string) *ListProfileObjectTypeTemplatesInput {
	s.NextToken = &v
	return s
}

type ListProfileObjectTypeTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListProfileObjectType template instances.
	Items []*ListProfileObjectTypeTemplateItem `type:"list"`

	// The pagination token from the previous ListObjectTypeTemplates API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypeTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypeTemplatesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListProfileObjectTypeTemplatesOutput) SetItems(v []*ListProfileObjectTypeTemplateItem) *ListProfileObjectTypeTemplatesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectTypeTemplatesOutput) SetNextToken(v string) *ListProfileObjectTypeTemplatesOutput {
	s.NextToken = &v
	return s
}

type ListProfileObjectTypesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileObjectTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileObjectTypesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListProfileObjectTypesInput) SetDomainName(v string) *ListProfileObjectTypesInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileObjectTypesInput) SetMaxResults(v int64) *ListProfileObjectTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectTypesInput) SetNextToken(v string) *ListProfileObjectTypesInput {
	s.NextToken = &v
	return s
}

type ListProfileObjectTypesOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListProfileObjectTypes instances.
	Items []*ListProfileObjectTypeItem `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectTypesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListProfileObjectTypesOutput) SetItems(v []*ListProfileObjectTypeItem) *ListProfileObjectTypesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectTypesOutput) SetNextToken(v string) *ListProfileObjectTypesOutput {
	s.NextToken = &v
	return s
}

type ListProfileObjectsInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous call to ListProfileObjects.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// Applies a filter to the response to include profile objects with the specified
	// index values.
	ObjectFilter *ObjectFilter `type:"structure"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileObjectsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ObjectFilter != nil {
		if err := s.ObjectFilter.Validate(); err != nil {
			invalidParams.AddNested("ObjectFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListProfileObjectsInput) SetDomainName(v string) *ListProfileObjectsInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileObjectsInput) SetMaxResults(v int64) *ListProfileObjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectsInput) SetNextToken(v string) *ListProfileObjectsInput {
	s.NextToken = &v
	return s
}

// SetObjectFilter sets the ObjectFilter field's value.
func (s *ListProfileObjectsInput) SetObjectFilter(v *ObjectFilter) *ListProfileObjectsInput {
	s.ObjectFilter = v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *ListProfileObjectsInput) SetObjectTypeName(v string) *ListProfileObjectsInput {
	s.ObjectTypeName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ListProfileObjectsInput) SetProfileId(v string) *ListProfileObjectsInput {
	s.ProfileId = &v
	return s
}

// A ProfileObject in a list of ProfileObjects.
type ListProfileObjectsItem struct {
	_ struct{} `type:"structure"`

	// A JSON representation of a ProfileObject that belongs to a profile.
	Object *string `min:"1" type:"string"`

	// Specifies the kind of object being added to a profile, such as "Salesforce-Account."
	ObjectTypeName *string `min:"1" type:"string"`

	// The unique identifier of the ProfileObject generated by the service.
	ProfileObjectUniqueKey *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectsItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectsItem) GoString() string {
	return s.String()
}

// SetObject sets the Object field's value.
func (s *ListProfileObjectsItem) SetObject(v string) *ListProfileObjectsItem {
	s.Object = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *ListProfileObjectsItem) SetObjectTypeName(v string) *ListProfileObjectsItem {
	s.ObjectTypeName = &v
	return s
}

// SetProfileObjectUniqueKey sets the ProfileObjectUniqueKey field's value.
func (s *ListProfileObjectsItem) SetProfileObjectUniqueKey(v string) *ListProfileObjectsItem {
	s.ProfileObjectUniqueKey = &v
	return s
}

type ListProfileObjectsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListProfileObject instances.
	Items []*ListProfileObjectsItem `type:"list"`

	// The pagination token from the previous call to ListProfileObjects.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileObjectsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListProfileObjectsOutput) SetItems(v []*ListProfileObjectsItem) *ListProfileObjectsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectsOutput) SetNextToken(v string) *ListProfileObjectsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource for which you want to view tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListWorkflowsInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// Retrieve workflows ended after timestamp.
	QueryEndDate *time.Time `type:"timestamp"`

	// Retrieve workflows started after timestamp.
	QueryStartDate *time.Time `type:"timestamp"`

	// Status of workflow execution.
	Status *string `type:"string" enum:"Status"`

	// The type of workflow. The only supported value is APPFLOW_INTEGRATION.
	WorkflowType *string `type:"string" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkflowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkflowsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListWorkflowsInput) SetDomainName(v string) *ListWorkflowsInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkflowsInput) SetMaxResults(v int64) *ListWorkflowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowsInput) SetNextToken(v string) *ListWorkflowsInput {
	s.NextToken = &v
	return s
}

// SetQueryEndDate sets the QueryEndDate field's value.
func (s *ListWorkflowsInput) SetQueryEndDate(v time.Time) *ListWorkflowsInput {
	s.QueryEndDate = &v
	return s
}

// SetQueryStartDate sets the QueryStartDate field's value.
func (s *ListWorkflowsInput) SetQueryStartDate(v time.Time) *ListWorkflowsInput {
	s.QueryStartDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListWorkflowsInput) SetStatus(v string) *ListWorkflowsInput {
	s.Status = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *ListWorkflowsInput) SetWorkflowType(v string) *ListWorkflowsInput {
	s.WorkflowType = &v
	return s
}

// A workflow in list of workflows.
type ListWorkflowsItem struct {
	_ struct{} `type:"structure"`

	// Creation timestamp for workflow.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// Last updated timestamp for workflow.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// Status of workflow execution.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"Status"`

	// Description for workflow execution status.
	//
	// StatusDescription is a required field
	StatusDescription *string `min:"1" type:"string" required:"true"`

	// Unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `min:"1" type:"string" required:"true"`

	// The type of workflow. The only supported value is APPFLOW_INTEGRATION.
	//
	// WorkflowType is a required field
	WorkflowType *string `type:"string" required:"true" enum:"WorkflowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsItem) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListWorkflowsItem) SetCreatedAt(v time.Time) *ListWorkflowsItem {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ListWorkflowsItem) SetLastUpdatedAt(v time.Time) *ListWorkflowsItem {
	s.LastUpdatedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListWorkflowsItem) SetStatus(v string) *ListWorkflowsItem {
	s.Status = &v
	return s
}

// SetStatusDescription sets the StatusDescription field's value.
func (s *ListWorkflowsItem) SetStatusDescription(v string) *ListWorkflowsItem {
	s.StatusDescription = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *ListWorkflowsItem) SetWorkflowId(v string) *ListWorkflowsItem {
	s.WorkflowId = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *ListWorkflowsItem) SetWorkflowType(v string) *ListWorkflowsItem {
	s.WorkflowType = &v
	return s
}

type ListWorkflowsOutput struct {
	_ struct{} `type:"structure"`

	// List containing workflow details.
	Items []*ListWorkflowsItem `type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListWorkflowsOutput) SetItems(v []*ListWorkflowsItem) *ListWorkflowsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowsOutput) SetNextToken(v string) *ListWorkflowsOutput {
	s.NextToken = &v
	return s
}

// The properties that are applied when Marketo is being used as a source.
type MarketoSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Marketo flow source.
	//
	// Object is a required field
	Object *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MarketoSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MarketoSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MarketoSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MarketoSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *MarketoSourceProperties) SetObject(v string) *MarketoSourceProperties {
	s.Object = &v
	return s
}

// The Match group object.
type MatchItem struct {
	_ struct{} `type:"structure"`

	// A number between 0 and 1, where a higher score means higher similarity. Examining
	// match confidence scores lets you distinguish between groups of similar records
	// in which the system is highly confident (which you may decide to merge),
	// groups of similar records about which the system is uncertain (which you
	// may decide to have reviewed by a human), and groups of similar records that
	// the system deems to be unlikely (which you may decide to reject). Given confidence
	// scores vary as per the data input, it should not be used an absolute measure
	// of matching quality.
	ConfidenceScore *float64 `type:"double"`

	// The unique identifiers for this group of profiles that match.
	MatchId *string `min:"1" type:"string"`

	// A list of identifiers for profiles that match.
	ProfileIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchItem) GoString() string {
	return s.String()
}

// SetConfidenceScore sets the ConfidenceScore field's value.
func (s *MatchItem) SetConfidenceScore(v float64) *MatchItem {
	s.ConfidenceScore = &v
	return s
}

// SetMatchId sets the MatchId field's value.
func (s *MatchItem) SetMatchId(v string) *MatchItem {
	s.MatchId = &v
	return s
}

// SetProfileIds sets the ProfileIds field's value.
func (s *MatchItem) SetProfileIds(v []*string) *MatchItem {
	s.ProfileIds = v
	return s
}

// The flag that enables the matching process of duplicate profiles.
type MatchingRequest struct {
	_ struct{} `type:"structure"`

	// Configuration information about the auto-merging process.
	AutoMerging *AutoMerging `type:"structure"`

	// The flag that enables the matching process of duplicate profiles.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Configuration information for exporting Identity Resolution results, for
	// example, to an S3 bucket.
	ExportingConfig *ExportingConfig `type:"structure"`

	// The day and time when do you want to start the Identity Resolution Job every
	// week.
	JobSchedule *JobSchedule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchingRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchingRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MatchingRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MatchingRequest"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.AutoMerging != nil {
		if err := s.AutoMerging.Validate(); err != nil {
			invalidParams.AddNested("AutoMerging", err.(request.ErrInvalidParams))
		}
	}
	if s.ExportingConfig != nil {
		if err := s.ExportingConfig.Validate(); err != nil {
			invalidParams.AddNested("ExportingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.JobSchedule != nil {
		if err := s.JobSchedule.Validate(); err != nil {
			invalidParams.AddNested("JobSchedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoMerging sets the AutoMerging field's value.
func (s *MatchingRequest) SetAutoMerging(v *AutoMerging) *MatchingRequest {
	s.AutoMerging = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *MatchingRequest) SetEnabled(v bool) *MatchingRequest {
	s.Enabled = &v
	return s
}

// SetExportingConfig sets the ExportingConfig field's value.
func (s *MatchingRequest) SetExportingConfig(v *ExportingConfig) *MatchingRequest {
	s.ExportingConfig = v
	return s
}

// SetJobSchedule sets the JobSchedule field's value.
func (s *MatchingRequest) SetJobSchedule(v *JobSchedule) *MatchingRequest {
	s.JobSchedule = v
	return s
}

// The flag that enables the matching process of duplicate profiles.
type MatchingResponse struct {
	_ struct{} `type:"structure"`

	// Configuration information about the auto-merging process.
	AutoMerging *AutoMerging `type:"structure"`

	// The flag that enables the matching process of duplicate profiles.
	Enabled *bool `type:"boolean"`

	// Configuration information for exporting Identity Resolution results, for
	// example, to an S3 bucket.
	ExportingConfig *ExportingConfig `type:"structure"`

	// The day and time when do you want to start the Identity Resolution Job every
	// week.
	JobSchedule *JobSchedule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchingResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchingResponse) GoString() string {
	return s.String()
}

// SetAutoMerging sets the AutoMerging field's value.
func (s *MatchingResponse) SetAutoMerging(v *AutoMerging) *MatchingResponse {
	s.AutoMerging = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *MatchingResponse) SetEnabled(v bool) *MatchingResponse {
	s.Enabled = &v
	return s
}

// SetExportingConfig sets the ExportingConfig field's value.
func (s *MatchingResponse) SetExportingConfig(v *ExportingConfig) *MatchingResponse {
	s.ExportingConfig = v
	return s
}

// SetJobSchedule sets the JobSchedule field's value.
func (s *MatchingResponse) SetJobSchedule(v *JobSchedule) *MatchingResponse {
	s.JobSchedule = v
	return s
}

type MergeProfilesInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The identifiers of the fields in the profile that has the information you
	// want to apply to the merge. For example, say you want to merge EmailAddress
	// from Profile1 into MainProfile. This would be the identifier of the EmailAddress
	// field in Profile1.
	FieldSourceProfileIds *FieldSourceProfileIds `type:"structure"`

	// The identifier of the profile to be taken.
	//
	// MainProfileId is a required field
	MainProfileId *string `type:"string" required:"true"`

	// The identifier of the profile to be merged into MainProfileId.
	//
	// ProfileIdsToBeMerged is a required field
	ProfileIdsToBeMerged []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MergeProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MergeProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MergeProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MergeProfilesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MainProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("MainProfileId"))
	}
	if s.ProfileIdsToBeMerged == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileIdsToBeMerged"))
	}
	if s.ProfileIdsToBeMerged != nil && len(s.ProfileIdsToBeMerged) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileIdsToBeMerged", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *MergeProfilesInput) SetDomainName(v string) *MergeProfilesInput {
	s.DomainName = &v
	return s
}

// SetFieldSourceProfileIds sets the FieldSourceProfileIds field's value.
func (s *MergeProfilesInput) SetFieldSourceProfileIds(v *FieldSourceProfileIds) *MergeProfilesInput {
	s.FieldSourceProfileIds = v
	return s
}

// SetMainProfileId sets the MainProfileId field's value.
func (s *MergeProfilesInput) SetMainProfileId(v string) *MergeProfilesInput {
	s.MainProfileId = &v
	return s
}

// SetProfileIdsToBeMerged sets the ProfileIdsToBeMerged field's value.
func (s *MergeProfilesInput) SetProfileIdsToBeMerged(v []*string) *MergeProfilesInput {
	s.ProfileIdsToBeMerged = v
	return s
}

type MergeProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the merge request is complete.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MergeProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MergeProfilesOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *MergeProfilesOutput) SetMessage(v string) *MergeProfilesOutput {
	s.Message = &v
	return s
}

// The filter applied to ListProfileObjects response to include profile objects
// with the specified index values.
type ObjectFilter struct {
	_ struct{} `type:"structure"`

	// A searchable identifier of a profile object. The predefined keys you can
	// use to search for _asset include: _assetId, _assetName, and _serialNumber.
	// The predefined keys you can use to search for _case include: _caseId. The
	// predefined keys you can use to search for _order include: _orderId.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// A list of key values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectFilter"}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyName sets the KeyName field's value.
func (s *ObjectFilter) SetKeyName(v string) *ObjectFilter {
	s.KeyName = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ObjectFilter) SetValues(v []*string) *ObjectFilter {
	s.Values = v
	return s
}

// Represents a field in a ProfileObjectType.
type ObjectTypeField struct {
	_ struct{} `type:"structure"`

	// The content type of the field. Used for determining equality when searching.
	ContentType *string `type:"string" enum:"FieldContentType"`

	// A field of a ProfileObject. For example: _source.FirstName, where “_source”
	// is a ProfileObjectType of a Zendesk user and “FirstName” is a field in
	// that ObjectType.
	Source *string `min:"1" type:"string"`

	// The location of the data in the standard ProfileObject model. For example:
	// _profile.Address.PostalCode.
	Target *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectTypeField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectTypeField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectTypeField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectTypeField"}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *ObjectTypeField) SetContentType(v string) *ObjectTypeField {
	s.ContentType = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ObjectTypeField) SetSource(v string) *ObjectTypeField {
	s.Source = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ObjectTypeField) SetTarget(v string) *ObjectTypeField {
	s.Target = &v
	return s
}

// An object that defines the Key element of a ProfileObject. A Key is a special
// element that can be used to search for a customer profile.
type ObjectTypeKey struct {
	_ struct{} `type:"structure"`

	// The reference for the key name of the fields map.
	FieldNames []*string `type:"list"`

	// The types of keys that a ProfileObject can have. Each ProfileObject can have
	// only 1 UNIQUE key but multiple PROFILE keys. PROFILE, ASSET, CASE, or ORDER
	// means that this key can be used to tie an object to a PROFILE, ASSET, CASE,
	// or ORDER respectively. UNIQUE means that it can be used to uniquely identify
	// an object. If a key a is marked as SECONDARY, it will be used to search for
	// profiles after all other PROFILE keys have been searched. A LOOKUP_ONLY key
	// is only used to match a profile but is not persisted to be used for searching
	// of the profile. A NEW_ONLY key is only used if the profile does not already
	// exist before the object is ingested, otherwise it is only used for matching
	// objects to profiles.
	StandardIdentifiers []*string `type:"list" enum:"StandardIdentifier"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectTypeKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectTypeKey) GoString() string {
	return s.String()
}

// SetFieldNames sets the FieldNames field's value.
func (s *ObjectTypeKey) SetFieldNames(v []*string) *ObjectTypeKey {
	s.FieldNames = v
	return s
}

// SetStandardIdentifiers sets the StandardIdentifiers field's value.
func (s *ObjectTypeKey) SetStandardIdentifiers(v []*string) *ObjectTypeKey {
	s.StandardIdentifiers = v
	return s
}

// The standard profile of a customer.
type Profile struct {
	_ struct{} `type:"structure"`

	// A unique account number that you have given to the customer.
	AccountNumber *string `min:"1" type:"string"`

	// Any additional information relevant to the customer’s profile.
	AdditionalInformation *string `min:"1" type:"string"`

	// A generic address associated with the customer that is not mailing, shipping,
	// or billing.
	Address *Address `type:"structure"`

	// A key value pair of attributes of a customer profile.
	Attributes map[string]*string `type:"map"`

	// The customer’s billing address.
	BillingAddress *Address `type:"structure"`

	// The customer’s birth date.
	BirthDate *string `min:"1" type:"string"`

	// The customer’s business email address.
	BusinessEmailAddress *string `min:"1" type:"string"`

	// The name of the customer’s business.
	BusinessName *string `min:"1" type:"string"`

	// The customer’s home phone number.
	BusinessPhoneNumber *string `min:"1" type:"string"`

	// The customer’s email address, which has not been specified as a personal
	// or business address.
	EmailAddress *string `min:"1" type:"string"`

	// The customer’s first name.
	FirstName *string `min:"1" type:"string"`

	// A list of items used to find a profile returned in a SearchProfiles (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html)
	// response. An item is a key-value(s) pair that matches an attribute in the
	// profile.
	//
	// If the optional AdditionalSearchKeys parameter was included in the SearchProfiles
	// (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html)
	// request, the FoundByItems list should be interpreted based on the LogicalOperator
	// used in the request:
	//
	//    * AND - The profile included in the response matched all of the search
	//    keys specified in the request. The FoundByItems will include all of the
	//    key-value(s) pairs that were specified in the request (as this is a requirement
	//    of AND search logic).
	//
	//    * OR - The profile included in the response matched at least one of the
	//    search keys specified in the request. The FoundByItems will include each
	//    of the key-value(s) pairs that the profile was found by.
	//
	// The OR relationship is the default behavior if the LogicalOperator parameter
	// is not included in the SearchProfiles (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html)
	// request.
	FoundByItems []*FoundByKeyValue `min:"1" type:"list"`

	// The gender with which the customer identifies.
	Gender *string `deprecated:"true" type:"string" enum:"Gender"`

	// An alternative to Gender which accepts any string as input.
	GenderString *string `min:"1" type:"string"`

	// The customer’s home phone number.
	HomePhoneNumber *string `min:"1" type:"string"`

	// The customer’s last name.
	LastName *string `min:"1" type:"string"`

	// The customer’s mailing address.
	MailingAddress *Address `type:"structure"`

	// The customer’s middle name.
	MiddleName *string `min:"1" type:"string"`

	// The customer’s mobile phone number.
	MobilePhoneNumber *string `min:"1" type:"string"`

	// The type of profile used to describe the customer.
	PartyType *string `deprecated:"true" type:"string" enum:"PartyType"`

	// An alternative to PartyType which accepts any string as input.
	PartyTypeString *string `min:"1" type:"string"`

	// The customer’s personal email address.
	PersonalEmailAddress *string `min:"1" type:"string"`

	// The customer's phone number, which has not been specified as a mobile, home,
	// or business number.
	PhoneNumber *string `min:"1" type:"string"`

	// The unique identifier of a customer profile.
	ProfileId *string `type:"string"`

	// The customer’s shipping address.
	ShippingAddress *Address `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Profile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Profile) GoString() string {
	return s.String()
}

// SetAccountNumber sets the AccountNumber field's value.
func (s *Profile) SetAccountNumber(v string) *Profile {
	s.AccountNumber = &v
	return s
}

// SetAdditionalInformation sets the AdditionalInformation field's value.
func (s *Profile) SetAdditionalInformation(v string) *Profile {
	s.AdditionalInformation = &v
	return s
}

// SetAddress sets the Address field's value.
func (s *Profile) SetAddress(v *Address) *Profile {
	s.Address = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Profile) SetAttributes(v map[string]*string) *Profile {
	s.Attributes = v
	return s
}

// SetBillingAddress sets the BillingAddress field's value.
func (s *Profile) SetBillingAddress(v *Address) *Profile {
	s.BillingAddress = v
	return s
}

// SetBirthDate sets the BirthDate field's value.
func (s *Profile) SetBirthDate(v string) *Profile {
	s.BirthDate = &v
	return s
}

// SetBusinessEmailAddress sets the BusinessEmailAddress field's value.
func (s *Profile) SetBusinessEmailAddress(v string) *Profile {
	s.BusinessEmailAddress = &v
	return s
}

// SetBusinessName sets the BusinessName field's value.
func (s *Profile) SetBusinessName(v string) *Profile {
	s.BusinessName = &v
	return s
}

// SetBusinessPhoneNumber sets the BusinessPhoneNumber field's value.
func (s *Profile) SetBusinessPhoneNumber(v string) *Profile {
	s.BusinessPhoneNumber = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Profile) SetEmailAddress(v string) *Profile {
	s.EmailAddress = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *Profile) SetFirstName(v string) *Profile {
	s.FirstName = &v
	return s
}

// SetFoundByItems sets the FoundByItems field's value.
func (s *Profile) SetFoundByItems(v []*FoundByKeyValue) *Profile {
	s.FoundByItems = v
	return s
}

// SetGender sets the Gender field's value.
func (s *Profile) SetGender(v string) *Profile {
	s.Gender = &v
	return s
}

// SetGenderString sets the GenderString field's value.
func (s *Profile) SetGenderString(v string) *Profile {
	s.GenderString = &v
	return s
}

// SetHomePhoneNumber sets the HomePhoneNumber field's value.
func (s *Profile) SetHomePhoneNumber(v string) *Profile {
	s.HomePhoneNumber = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *Profile) SetLastName(v string) *Profile {
	s.LastName = &v
	return s
}

// SetMailingAddress sets the MailingAddress field's value.
func (s *Profile) SetMailingAddress(v *Address) *Profile {
	s.MailingAddress = v
	return s
}

// SetMiddleName sets the MiddleName field's value.
func (s *Profile) SetMiddleName(v string) *Profile {
	s.MiddleName = &v
	return s
}

// SetMobilePhoneNumber sets the MobilePhoneNumber field's value.
func (s *Profile) SetMobilePhoneNumber(v string) *Profile {
	s.MobilePhoneNumber = &v
	return s
}

// SetPartyType sets the PartyType field's value.
func (s *Profile) SetPartyType(v string) *Profile {
	s.PartyType = &v
	return s
}

// SetPartyTypeString sets the PartyTypeString field's value.
func (s *Profile) SetPartyTypeString(v string) *Profile {
	s.PartyTypeString = &v
	return s
}

// SetPersonalEmailAddress sets the PersonalEmailAddress field's value.
func (s *Profile) SetPersonalEmailAddress(v string) *Profile {
	s.PersonalEmailAddress = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *Profile) SetPhoneNumber(v string) *Profile {
	s.PhoneNumber = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *Profile) SetProfileId(v string) *Profile {
	s.ProfileId = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *Profile) SetShippingAddress(v *Address) *Profile {
	s.ShippingAddress = v
	return s
}

type PutIntegrationInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The configuration that controls how Customer Profiles retrieves data from
	// the source.
	FlowDefinition *FlowDefinition `type:"structure"`

	// The name of the profile object type.
	ObjectTypeName *string `min:"1" type:"string"`

	// A map in which each key is an event type from an external application such
	// as Segment or Shopify, and each value is an ObjectTypeName (template) used
	// to ingest the event. It supports the following event types: SegmentIdentify,
	// ShopifyCreateCustomers, ShopifyUpdateCustomers, ShopifyCreateDraftOrders,
	// ShopifyUpdateDraftOrders, ShopifyCreateOrders, and ShopifyUpdatedOrders.
	ObjectTypeNames map[string]*string `type:"map"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// The URI of the S3 bucket or any other type of data source.
	Uri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutIntegrationInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}
	if s.FlowDefinition != nil {
		if err := s.FlowDefinition.Validate(); err != nil {
			invalidParams.AddNested("FlowDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *PutIntegrationInput) SetDomainName(v string) *PutIntegrationInput {
	s.DomainName = &v
	return s
}

// SetFlowDefinition sets the FlowDefinition field's value.
func (s *PutIntegrationInput) SetFlowDefinition(v *FlowDefinition) *PutIntegrationInput {
	s.FlowDefinition = v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *PutIntegrationInput) SetObjectTypeName(v string) *PutIntegrationInput {
	s.ObjectTypeName = &v
	return s
}

// SetObjectTypeNames sets the ObjectTypeNames field's value.
func (s *PutIntegrationInput) SetObjectTypeNames(v map[string]*string) *PutIntegrationInput {
	s.ObjectTypeNames = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutIntegrationInput) SetTags(v map[string]*string) *PutIntegrationInput {
	s.Tags = v
	return s
}

// SetUri sets the Uri field's value.
func (s *PutIntegrationInput) SetUri(v string) *PutIntegrationInput {
	s.Uri = &v
	return s
}

type PutIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// Boolean that shows if the Flow that's associated with the Integration is
	// created in Amazon Appflow, or with ObjectTypeName equals _unstructured via
	// API/CLI in flowDefinition.
	IsUnstructured *bool `type:"boolean"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The name of the profile object type.
	ObjectTypeName *string `min:"1" type:"string"`

	// A map in which each key is an event type from an external application such
	// as Segment or Shopify, and each value is an ObjectTypeName (template) used
	// to ingest the event. It supports the following event types: SegmentIdentify,
	// ShopifyCreateCustomers, ShopifyUpdateCustomers, ShopifyCreateDraftOrders,
	// ShopifyUpdateDraftOrders, ShopifyCreateOrders, and ShopifyUpdatedOrders.
	ObjectTypeNames map[string]*string `type:"map"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`

	// Unique identifier for the workflow.
	WorkflowId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIntegrationOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PutIntegrationOutput) SetCreatedAt(v time.Time) *PutIntegrationOutput {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *PutIntegrationOutput) SetDomainName(v string) *PutIntegrationOutput {
	s.DomainName = &v
	return s
}

// SetIsUnstructured sets the IsUnstructured field's value.
func (s *PutIntegrationOutput) SetIsUnstructured(v bool) *PutIntegrationOutput {
	s.IsUnstructured = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *PutIntegrationOutput) SetLastUpdatedAt(v time.Time) *PutIntegrationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *PutIntegrationOutput) SetObjectTypeName(v string) *PutIntegrationOutput {
	s.ObjectTypeName = &v
	return s
}

// SetObjectTypeNames sets the ObjectTypeNames field's value.
func (s *PutIntegrationOutput) SetObjectTypeNames(v map[string]*string) *PutIntegrationOutput {
	s.ObjectTypeNames = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutIntegrationOutput) SetTags(v map[string]*string) *PutIntegrationOutput {
	s.Tags = v
	return s
}

// SetUri sets the Uri field's value.
func (s *PutIntegrationOutput) SetUri(v string) *PutIntegrationOutput {
	s.Uri = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *PutIntegrationOutput) SetWorkflowId(v string) *PutIntegrationOutput {
	s.WorkflowId = &v
	return s
}

type PutProfileObjectInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// A string that is serialized from a JSON object.
	//
	// Object is a required field
	Object *string `min:"1" type:"string" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProfileObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProfileObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutProfileObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutProfileObjectInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}
	if s.Object != nil && len(*s.Object) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Object", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *PutProfileObjectInput) SetDomainName(v string) *PutProfileObjectInput {
	s.DomainName = &v
	return s
}

// SetObject sets the Object field's value.
func (s *PutProfileObjectInput) SetObject(v string) *PutProfileObjectInput {
	s.Object = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *PutProfileObjectInput) SetObjectTypeName(v string) *PutProfileObjectInput {
	s.ObjectTypeName = &v
	return s
}

type PutProfileObjectOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the profile object generated by the service.
	ProfileObjectUniqueKey *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProfileObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProfileObjectOutput) GoString() string {
	return s.String()
}

// SetProfileObjectUniqueKey sets the ProfileObjectUniqueKey field's value.
func (s *PutProfileObjectOutput) SetProfileObjectUniqueKey(v string) *PutProfileObjectOutput {
	s.ProfileObjectUniqueKey = &v
	return s
}

type PutProfileObjectTypeInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether a profile should be created when data is received if one
	// doesn’t exist for an object of this type. The default is FALSE. If the
	// AllowProfileCreation flag is set to FALSE, then the service tries to fetch
	// a standard profile and associate this object with the profile. If it is set
	// to TRUE, and if no match is found, then the service creates a new standard
	// profile.
	AllowProfileCreation *bool `type:"boolean"`

	// Description of the profile object type.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The customer-provided key to encrypt the profile object that will be created
	// in this profile object type.
	EncryptionKey *string `type:"string"`

	// The number of days until the data in the object expires.
	ExpirationDays *int64 `min:"1" type:"integer"`

	// A map of the name and ObjectType field.
	Fields map[string]*ObjectTypeField `type:"map"`

	// A list of unique keys that can be used to map data to the profile.
	Keys map[string][]*ObjectTypeKey `type:"map"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `location:"uri" locationName:"ObjectTypeName" min:"1" type:"string" required:"true"`

	// The format of your sourceLastUpdatedTimestamp that was previously set up.
	SourceLastUpdatedTimestampFormat *string `min:"1" type:"string"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// A unique identifier for the object template. For some attributes in the request,
	// the service will use the default value from the object template when TemplateId
	// is present. If these attributes are present in the request, the service may
	// return a BadRequestException. These attributes include: AllowProfileCreation,
	// SourceLastUpdatedTimestampFormat, Fields, and Keys. For example, if AllowProfileCreation
	// is set to true when TemplateId is set, the service may return a BadRequestException.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProfileObjectTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProfileObjectTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutProfileObjectTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutProfileObjectTypeInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ExpirationDays != nil && *s.ExpirationDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExpirationDays", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}
	if s.SourceLastUpdatedTimestampFormat != nil && len(*s.SourceLastUpdatedTimestampFormat) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLastUpdatedTimestampFormat", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowProfileCreation sets the AllowProfileCreation field's value.
func (s *PutProfileObjectTypeInput) SetAllowProfileCreation(v bool) *PutProfileObjectTypeInput {
	s.AllowProfileCreation = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutProfileObjectTypeInput) SetDescription(v string) *PutProfileObjectTypeInput {
	s.Description = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *PutProfileObjectTypeInput) SetDomainName(v string) *PutProfileObjectTypeInput {
	s.DomainName = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *PutProfileObjectTypeInput) SetEncryptionKey(v string) *PutProfileObjectTypeInput {
	s.EncryptionKey = &v
	return s
}

// SetExpirationDays sets the ExpirationDays field's value.
func (s *PutProfileObjectTypeInput) SetExpirationDays(v int64) *PutProfileObjectTypeInput {
	s.ExpirationDays = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *PutProfileObjectTypeInput) SetFields(v map[string]*ObjectTypeField) *PutProfileObjectTypeInput {
	s.Fields = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *PutProfileObjectTypeInput) SetKeys(v map[string][]*ObjectTypeKey) *PutProfileObjectTypeInput {
	s.Keys = v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *PutProfileObjectTypeInput) SetObjectTypeName(v string) *PutProfileObjectTypeInput {
	s.ObjectTypeName = &v
	return s
}

// SetSourceLastUpdatedTimestampFormat sets the SourceLastUpdatedTimestampFormat field's value.
func (s *PutProfileObjectTypeInput) SetSourceLastUpdatedTimestampFormat(v string) *PutProfileObjectTypeInput {
	s.SourceLastUpdatedTimestampFormat = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutProfileObjectTypeInput) SetTags(v map[string]*string) *PutProfileObjectTypeInput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *PutProfileObjectTypeInput) SetTemplateId(v string) *PutProfileObjectTypeInput {
	s.TemplateId = &v
	return s
}

type PutProfileObjectTypeOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether a profile should be created when data is received if one
	// doesn’t exist for an object of this type. The default is FALSE. If the
	// AllowProfileCreation flag is set to FALSE, then the service tries to fetch
	// a standard profile and associate this object with the profile. If it is set
	// to TRUE, and if no match is found, then the service creates a new standard
	// profile.
	AllowProfileCreation *bool `type:"boolean"`

	// The timestamp of when the domain was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Description of the profile object type.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The customer-provided key to encrypt the profile object that will be created
	// in this profile object type.
	EncryptionKey *string `type:"string"`

	// The number of days until the data in the object expires.
	ExpirationDays *int64 `min:"1" type:"integer"`

	// A map of the name and ObjectType field.
	Fields map[string]*ObjectTypeField `type:"map"`

	// A list of unique keys that can be used to map data to the profile.
	Keys map[string][]*ObjectTypeKey `type:"map"`

	// The timestamp of when the domain was most recently edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The format of your sourceLastUpdatedTimestamp that was previously set up
	// in fields that were parsed using SimpleDateFormat (https://docs.oracle.com/javase/10/docs/api/java/text/SimpleDateFormat.html).
	// If you have sourceLastUpdatedTimestamp in your field, you must set up sourceLastUpdatedTimestampFormat.
	SourceLastUpdatedTimestampFormat *string `min:"1" type:"string"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// A unique identifier for the object template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProfileObjectTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProfileObjectTypeOutput) GoString() string {
	return s.String()
}

// SetAllowProfileCreation sets the AllowProfileCreation field's value.
func (s *PutProfileObjectTypeOutput) SetAllowProfileCreation(v bool) *PutProfileObjectTypeOutput {
	s.AllowProfileCreation = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PutProfileObjectTypeOutput) SetCreatedAt(v time.Time) *PutProfileObjectTypeOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutProfileObjectTypeOutput) SetDescription(v string) *PutProfileObjectTypeOutput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *PutProfileObjectTypeOutput) SetEncryptionKey(v string) *PutProfileObjectTypeOutput {
	s.EncryptionKey = &v
	return s
}

// SetExpirationDays sets the ExpirationDays field's value.
func (s *PutProfileObjectTypeOutput) SetExpirationDays(v int64) *PutProfileObjectTypeOutput {
	s.ExpirationDays = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *PutProfileObjectTypeOutput) SetFields(v map[string]*ObjectTypeField) *PutProfileObjectTypeOutput {
	s.Fields = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *PutProfileObjectTypeOutput) SetKeys(v map[string][]*ObjectTypeKey) *PutProfileObjectTypeOutput {
	s.Keys = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *PutProfileObjectTypeOutput) SetLastUpdatedAt(v time.Time) *PutProfileObjectTypeOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *PutProfileObjectTypeOutput) SetObjectTypeName(v string) *PutProfileObjectTypeOutput {
	s.ObjectTypeName = &v
	return s
}

// SetSourceLastUpdatedTimestampFormat sets the SourceLastUpdatedTimestampFormat field's value.
func (s *PutProfileObjectTypeOutput) SetSourceLastUpdatedTimestampFormat(v string) *PutProfileObjectTypeOutput {
	s.SourceLastUpdatedTimestampFormat = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutProfileObjectTypeOutput) SetTags(v map[string]*string) *PutProfileObjectTypeOutput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *PutProfileObjectTypeOutput) SetTemplateId(v string) *PutProfileObjectTypeOutput {
	s.TemplateId = &v
	return s
}

// The relative time period over which data is included in the aggregation.
type Range struct {
	_ struct{} `type:"structure"`

	// The unit of time.
	//
	// Unit is a required field
	Unit *string `type:"string" required:"true" enum:"Unit"`

	// The amount of time of the specified unit.
	//
	// Value is a required field
	Value *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Range) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Range) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Range) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Range"}
	if s.Unit == nil {
		invalidParams.Add(request.NewErrParamRequired("Unit"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && *s.Value < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnit sets the Unit field's value.
func (s *Range) SetUnit(v string) *Range {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Range) SetValue(v int64) *Range {
	s.Value = &v
	return s
}

// The requested resource does not exist, or access was denied.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Configuration information about the S3 bucket where Identity Resolution Jobs
// write result files.
type S3ExportingConfig struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket where Identity Resolution Jobs write result files.
	//
	// S3BucketName is a required field
	S3BucketName *string `min:"3" type:"string" required:"true"`

	// The S3 key name of the location where Identity Resolution Jobs write result
	// files.
	S3KeyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ExportingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ExportingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ExportingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ExportingConfig"}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}
	if s.S3KeyName != nil && len(*s.S3KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3KeyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *S3ExportingConfig) SetS3BucketName(v string) *S3ExportingConfig {
	s.S3BucketName = &v
	return s
}

// SetS3KeyName sets the S3KeyName field's value.
func (s *S3ExportingConfig) SetS3KeyName(v string) *S3ExportingConfig {
	s.S3KeyName = &v
	return s
}

// The S3 location where Identity Resolution Jobs write result files.
type S3ExportingLocation struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket name where Identity Resolution Jobs write result
	// files.
	S3BucketName *string `min:"3" type:"string"`

	// The S3 key name of the location where Identity Resolution Jobs write result
	// files.
	S3KeyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ExportingLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ExportingLocation) GoString() string {
	return s.String()
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *S3ExportingLocation) SetS3BucketName(v string) *S3ExportingLocation {
	s.S3BucketName = &v
	return s
}

// SetS3KeyName sets the S3KeyName field's value.
func (s *S3ExportingLocation) SetS3KeyName(v string) *S3ExportingLocation {
	s.S3KeyName = &v
	return s
}

// The properties that are applied when Amazon S3 is being used as the flow
// source.
type S3SourceProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket name where the source files are stored.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	// The object key for the Amazon S3 bucket in which the source files are stored.
	BucketPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3SourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3SourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SourceProperties"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3SourceProperties) SetBucketName(v string) *S3SourceProperties {
	s.BucketName = &v
	return s
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *S3SourceProperties) SetBucketPrefix(v string) *S3SourceProperties {
	s.BucketPrefix = &v
	return s
}

// The properties that are applied when Salesforce is being used as a source.
type SalesforceSourceProperties struct {
	_ struct{} `type:"structure"`

	// The flag that enables dynamic fetching of new (recently added) fields in
	// the Salesforce objects while running a flow.
	EnableDynamicFieldUpdate *bool `type:"boolean"`

	// Indicates whether Amazon AppFlow includes deleted files in the flow run.
	IncludeDeletedRecords *bool `type:"boolean"`

	// The object specified in the Salesforce flow source.
	//
	// Object is a required field
	Object *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableDynamicFieldUpdate sets the EnableDynamicFieldUpdate field's value.
func (s *SalesforceSourceProperties) SetEnableDynamicFieldUpdate(v bool) *SalesforceSourceProperties {
	s.EnableDynamicFieldUpdate = &v
	return s
}

// SetIncludeDeletedRecords sets the IncludeDeletedRecords field's value.
func (s *SalesforceSourceProperties) SetIncludeDeletedRecords(v bool) *SalesforceSourceProperties {
	s.IncludeDeletedRecords = &v
	return s
}

// SetObject sets the Object field's value.
func (s *SalesforceSourceProperties) SetObject(v string) *SalesforceSourceProperties {
	s.Object = &v
	return s
}

// Specifies the configuration details of a scheduled-trigger flow that you
// define. Currently, these settings only apply to the scheduled-trigger type.
type ScheduledTriggerProperties struct {
	_ struct{} `type:"structure"`

	// Specifies whether a scheduled flow has an incremental data transfer or a
	// complete data transfer for each flow run.
	DataPullMode *string `type:"string" enum:"DataPullMode"`

	// Specifies the date range for the records to import from the connector in
	// the first flow run.
	FirstExecutionFrom *time.Time `type:"timestamp"`

	// Specifies the scheduled end time for a scheduled-trigger flow.
	ScheduleEndTime *time.Time `type:"timestamp"`

	// The scheduling expression that determines the rate at which the schedule
	// will run, for example rate (5 minutes).
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `type:"string" required:"true"`

	// Specifies the optional offset that is added to the time interval for a schedule-triggered
	// flow.
	ScheduleOffset *int64 `type:"long"`

	// Specifies the scheduled start time for a scheduled-trigger flow.
	ScheduleStartTime *time.Time `type:"timestamp"`

	// Specifies the time zone used when referring to the date and time of a scheduled-triggered
	// flow, such as America/New_York.
	Timezone *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledTriggerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledTriggerProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledTriggerProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduledTriggerProperties"}
	if s.ScheduleExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataPullMode sets the DataPullMode field's value.
func (s *ScheduledTriggerProperties) SetDataPullMode(v string) *ScheduledTriggerProperties {
	s.DataPullMode = &v
	return s
}

// SetFirstExecutionFrom sets the FirstExecutionFrom field's value.
func (s *ScheduledTriggerProperties) SetFirstExecutionFrom(v time.Time) *ScheduledTriggerProperties {
	s.FirstExecutionFrom = &v
	return s
}

// SetScheduleEndTime sets the ScheduleEndTime field's value.
func (s *ScheduledTriggerProperties) SetScheduleEndTime(v time.Time) *ScheduledTriggerProperties {
	s.ScheduleEndTime = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *ScheduledTriggerProperties) SetScheduleExpression(v string) *ScheduledTriggerProperties {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleOffset sets the ScheduleOffset field's value.
func (s *ScheduledTriggerProperties) SetScheduleOffset(v int64) *ScheduledTriggerProperties {
	s.ScheduleOffset = &v
	return s
}

// SetScheduleStartTime sets the ScheduleStartTime field's value.
func (s *ScheduledTriggerProperties) SetScheduleStartTime(v time.Time) *ScheduledTriggerProperties {
	s.ScheduleStartTime = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *ScheduledTriggerProperties) SetTimezone(v string) *ScheduledTriggerProperties {
	s.Timezone = &v
	return s
}

type SearchProfilesInput struct {
	_ struct{} `type:"structure"`

	// A list of AdditionalSearchKey objects that are each searchable identifiers
	// of a profile. Each AdditionalSearchKey object contains a KeyName and a list
	// of Values associated with that specific key (i.e., a key-value(s) pair).
	// These additional search keys will be used in conjunction with the LogicalOperator
	// and the required KeyName and Values parameters to search for profiles that
	// satisfy the search criteria.
	AdditionalSearchKeys []*AdditionalSearchKey `min:"1" type:"list"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// A searchable identifier of a customer profile. The predefined keys you can
	// use to search include: _account, _profileId, _assetId, _caseId, _orderId,
	// _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId,
	// _salesforceContactId, _salesforceAssetId, _zendeskUserId, _zendeskExternalId,
	// _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId,
	// _shopifyCustomerId, _shopifyOrderId.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// Relationship between all specified search keys that will be used to search
	// for profiles. This includes the required KeyName and Values parameters as
	// well as any key-value(s) pairs specified in the AdditionalSearchKeys list.
	//
	// This parameter influences which profiles will be returned in the response
	// in the following manner:
	//
	//    * AND - The response only includes profiles that match all of the search
	//    keys.
	//
	//    * OR - The response includes profiles that match at least one of the search
	//    keys.
	//
	// The OR relationship is the default behavior if this parameter is not included
	// in the request.
	LogicalOperator *string `type:"string" enum:"LogicalOperator"`

	// The maximum number of objects returned per page.
	//
	// The default is 20 if this parameter is not included in the request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous SearchProfiles API call.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// A list of key values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchProfilesInput"}
	if s.AdditionalSearchKeys != nil && len(s.AdditionalSearchKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalSearchKeys", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.AdditionalSearchKeys != nil {
		for i, v := range s.AdditionalSearchKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AdditionalSearchKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalSearchKeys sets the AdditionalSearchKeys field's value.
func (s *SearchProfilesInput) SetAdditionalSearchKeys(v []*AdditionalSearchKey) *SearchProfilesInput {
	s.AdditionalSearchKeys = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *SearchProfilesInput) SetDomainName(v string) *SearchProfilesInput {
	s.DomainName = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *SearchProfilesInput) SetKeyName(v string) *SearchProfilesInput {
	s.KeyName = &v
	return s
}

// SetLogicalOperator sets the LogicalOperator field's value.
func (s *SearchProfilesInput) SetLogicalOperator(v string) *SearchProfilesInput {
	s.LogicalOperator = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchProfilesInput) SetMaxResults(v int64) *SearchProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchProfilesInput) SetNextToken(v string) *SearchProfilesInput {
	s.NextToken = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SearchProfilesInput) SetValues(v []*string) *SearchProfilesInput {
	s.Values = v
	return s
}

type SearchProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The list of Profiles matching the search criteria.
	Items []*Profile `type:"list"`

	// The pagination token from the previous SearchProfiles API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchProfilesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *SearchProfilesOutput) SetItems(v []*Profile) *SearchProfilesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchProfilesOutput) SetNextToken(v string) *SearchProfilesOutput {
	s.NextToken = &v
	return s
}

// The properties that are applied when ServiceNow is being used as a source.
type ServiceNowSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the ServiceNow flow source.
	//
	// Object is a required field
	Object *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNowSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNowSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceNowSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *ServiceNowSourceProperties) SetObject(v string) *ServiceNowSourceProperties {
	s.Object = &v
	return s
}

// Specifies the information that is required to query a particular Amazon AppFlow
// connector. Customer Profiles supports Salesforce, Zendesk, Marketo, ServiceNow
// and Amazon S3.
type SourceConnectorProperties struct {
	_ struct{} `type:"structure"`

	// The properties that are applied when Marketo is being used as a source.
	Marketo *MarketoSourceProperties `type:"structure"`

	// The properties that are applied when Amazon S3 is being used as the flow
	// source.
	S3 *S3SourceProperties `type:"structure"`

	// The properties that are applied when Salesforce is being used as a source.
	Salesforce *SalesforceSourceProperties `type:"structure"`

	// The properties that are applied when ServiceNow is being used as a source.
	ServiceNow *ServiceNowSourceProperties `type:"structure"`

	// The properties that are applied when using Zendesk as a flow source.
	Zendesk *ZendeskSourceProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceConnectorProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceConnectorProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConnectorProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceConnectorProperties"}
	if s.Marketo != nil {
		if err := s.Marketo.Validate(); err != nil {
			invalidParams.AddNested("Marketo", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}
	if s.Salesforce != nil {
		if err := s.Salesforce.Validate(); err != nil {
			invalidParams.AddNested("Salesforce", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceNow != nil {
		if err := s.ServiceNow.Validate(); err != nil {
			invalidParams.AddNested("ServiceNow", err.(request.ErrInvalidParams))
		}
	}
	if s.Zendesk != nil {
		if err := s.Zendesk.Validate(); err != nil {
			invalidParams.AddNested("Zendesk", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarketo sets the Marketo field's value.
func (s *SourceConnectorProperties) SetMarketo(v *MarketoSourceProperties) *SourceConnectorProperties {
	s.Marketo = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *SourceConnectorProperties) SetS3(v *S3SourceProperties) *SourceConnectorProperties {
	s.S3 = v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *SourceConnectorProperties) SetSalesforce(v *SalesforceSourceProperties) *SourceConnectorProperties {
	s.Salesforce = v
	return s
}

// SetServiceNow sets the ServiceNow field's value.
func (s *SourceConnectorProperties) SetServiceNow(v *ServiceNowSourceProperties) *SourceConnectorProperties {
	s.ServiceNow = v
	return s
}

// SetZendesk sets the Zendesk field's value.
func (s *SourceConnectorProperties) SetZendesk(v *ZendeskSourceProperties) *SourceConnectorProperties {
	s.Zendesk = v
	return s
}

// Contains information about the configuration of the source connector used
// in the flow.
type SourceFlowConfig struct {
	_ struct{} `type:"structure"`

	// The name of the AppFlow connector profile. This name must be unique for each
	// connector profile in the AWS account.
	ConnectorProfileName *string `type:"string"`

	// The type of connector, such as Salesforce, Marketo, and so on.
	//
	// ConnectorType is a required field
	ConnectorType *string `type:"string" required:"true" enum:"SourceConnectorType"`

	// Defines the configuration for a scheduled incremental data pull. If a valid
	// configuration is provided, the fields specified in the configuration are
	// used when querying for the incremental data pull.
	IncrementalPullConfig *IncrementalPullConfig `type:"structure"`

	// Specifies the information that is required to query a particular source connector.
	//
	// SourceConnectorProperties is a required field
	SourceConnectorProperties *SourceConnectorProperties `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceFlowConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceFlowConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceFlowConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceFlowConfig"}
	if s.ConnectorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorType"))
	}
	if s.SourceConnectorProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceConnectorProperties"))
	}
	if s.SourceConnectorProperties != nil {
		if err := s.SourceConnectorProperties.Validate(); err != nil {
			invalidParams.AddNested("SourceConnectorProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *SourceFlowConfig) SetConnectorProfileName(v string) *SourceFlowConfig {
	s.ConnectorProfileName = &v
	return s
}

// SetConnectorType sets the ConnectorType field's value.
func (s *SourceFlowConfig) SetConnectorType(v string) *SourceFlowConfig {
	s.ConnectorType = &v
	return s
}

// SetIncrementalPullConfig sets the IncrementalPullConfig field's value.
func (s *SourceFlowConfig) SetIncrementalPullConfig(v *IncrementalPullConfig) *SourceFlowConfig {
	s.IncrementalPullConfig = v
	return s
}

// SetSourceConnectorProperties sets the SourceConnectorProperties field's value.
func (s *SourceFlowConfig) SetSourceConnectorProperties(v *SourceConnectorProperties) *SourceFlowConfig {
	s.SourceConnectorProperties = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource that you're adding tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A class for modeling different type of tasks. Task implementation varies
// based on the TaskType.
type Task struct {
	_ struct{} `type:"structure"`

	// The operation to be performed on the provided source fields.
	ConnectorOperator *ConnectorOperator `type:"structure"`

	// A field in a destination connector, or a field value against which Amazon
	// AppFlow validates a source field.
	DestinationField *string `type:"string"`

	// The source fields to which a particular task is applied.
	//
	// SourceFields is a required field
	SourceFields []*string `type:"list" required:"true"`

	// A map used to store task-related information. The service looks for particular
	// information based on the TaskType.
	TaskProperties map[string]*string `type:"map"`

	// Specifies the particular task implementation that Amazon AppFlow performs.
	//
	// TaskType is a required field
	TaskType *string `type:"string" required:"true" enum:"TaskType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Task) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Task) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Task) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Task"}
	if s.SourceFields == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFields"))
	}
	if s.TaskType == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorOperator sets the ConnectorOperator field's value.
func (s *Task) SetConnectorOperator(v *ConnectorOperator) *Task {
	s.ConnectorOperator = v
	return s
}

// SetDestinationField sets the DestinationField field's value.
func (s *Task) SetDestinationField(v string) *Task {
	s.DestinationField = &v
	return s
}

// SetSourceFields sets the SourceFields field's value.
func (s *Task) SetSourceFields(v []*string) *Task {
	s.SourceFields = v
	return s
}

// SetTaskProperties sets the TaskProperties field's value.
func (s *Task) SetTaskProperties(v map[string]*string) *Task {
	s.TaskProperties = v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *Task) SetTaskType(v string) *Task {
	s.TaskType = &v
	return s
}

// The threshold for the calculated attribute.
type Threshold struct {
	_ struct{} `type:"structure"`

	// The operator of the threshold.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"Operator"`

	// The value of the threshold.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Threshold) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Threshold) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Threshold) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Threshold"}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperator sets the Operator field's value.
func (s *Threshold) SetOperator(v string) *Threshold {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Threshold) SetValue(v string) *Threshold {
	s.Value = &v
	return s
}

// You exceeded the maximum number of requests.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The trigger settings that determine how and when Amazon AppFlow runs the
// specified flow.
type TriggerConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the configuration details of a schedule-triggered flow that you
	// define. Currently, these settings only apply to the Scheduled trigger type.
	TriggerProperties *TriggerProperties `type:"structure"`

	// Specifies the type of flow trigger. It can be OnDemand, Scheduled, or Event.
	//
	// TriggerType is a required field
	TriggerType *string `type:"string" required:"true" enum:"TriggerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TriggerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TriggerConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggerConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TriggerConfig"}
	if s.TriggerType == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerType"))
	}
	if s.TriggerProperties != nil {
		if err := s.TriggerProperties.Validate(); err != nil {
			invalidParams.AddNested("TriggerProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTriggerProperties sets the TriggerProperties field's value.
func (s *TriggerConfig) SetTriggerProperties(v *TriggerProperties) *TriggerConfig {
	s.TriggerProperties = v
	return s
}

// SetTriggerType sets the TriggerType field's value.
func (s *TriggerConfig) SetTriggerType(v string) *TriggerConfig {
	s.TriggerType = &v
	return s
}

// Specifies the configuration details that control the trigger for a flow.
// Currently, these settings only apply to the Scheduled trigger type.
type TriggerProperties struct {
	_ struct{} `type:"structure"`

	// Specifies the configuration details of a schedule-triggered flow that you
	// define.
	Scheduled *ScheduledTriggerProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TriggerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TriggerProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggerProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TriggerProperties"}
	if s.Scheduled != nil {
		if err := s.Scheduled.Validate(); err != nil {
			invalidParams.AddNested("Scheduled", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduled sets the Scheduled field's value.
func (s *TriggerProperties) SetScheduled(v *ScheduledTriggerProperties) *TriggerProperties {
	s.Scheduled = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource from which you are removing tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Updates associated with the address properties of a customer profile.
type UpdateAddress struct {
	_ struct{} `type:"structure"`

	// The first line of a customer address.
	Address1 *string `type:"string"`

	// The second line of a customer address.
	Address2 *string `type:"string"`

	// The third line of a customer address.
	Address3 *string `type:"string"`

	// The fourth line of a customer address.
	Address4 *string `type:"string"`

	// The city in which a customer lives.
	City *string `type:"string"`

	// The country in which a customer lives.
	Country *string `type:"string"`

	// The county in which a customer lives.
	County *string `type:"string"`

	// The postal code of a customer address.
	PostalCode *string `type:"string"`

	// The province in which a customer lives.
	Province *string `type:"string"`

	// The state in which a customer lives.
	State *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddress) GoString() string {
	return s.String()
}

// SetAddress1 sets the Address1 field's value.
func (s *UpdateAddress) SetAddress1(v string) *UpdateAddress {
	s.Address1 = &v
	return s
}

// SetAddress2 sets the Address2 field's value.
func (s *UpdateAddress) SetAddress2(v string) *UpdateAddress {
	s.Address2 = &v
	return s
}

// SetAddress3 sets the Address3 field's value.
func (s *UpdateAddress) SetAddress3(v string) *UpdateAddress {
	s.Address3 = &v
	return s
}

// SetAddress4 sets the Address4 field's value.
func (s *UpdateAddress) SetAddress4(v string) *UpdateAddress {
	s.Address4 = &v
	return s
}

// SetCity sets the City field's value.
func (s *UpdateAddress) SetCity(v string) *UpdateAddress {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *UpdateAddress) SetCountry(v string) *UpdateAddress {
	s.Country = &v
	return s
}

// SetCounty sets the County field's value.
func (s *UpdateAddress) SetCounty(v string) *UpdateAddress {
	s.County = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *UpdateAddress) SetPostalCode(v string) *UpdateAddress {
	s.PostalCode = &v
	return s
}

// SetProvince sets the Province field's value.
func (s *UpdateAddress) SetProvince(v string) *UpdateAddress {
	s.Province = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateAddress) SetState(v string) *UpdateAddress {
	s.State = &v
	return s
}

type UpdateCalculatedAttributeDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the calculated attribute.
	//
	// CalculatedAttributeName is a required field
	CalculatedAttributeName *string `location:"uri" locationName:"CalculatedAttributeName" min:"1" type:"string" required:"true"`

	// The conditions including range, object count, and threshold for the calculated
	// attribute.
	Conditions *Conditions `type:"structure"`

	// The description of the calculated attribute.
	Description *string `min:"1" type:"string"`

	// The display name of the calculated attribute.
	DisplayName *string `min:"1" type:"string"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCalculatedAttributeDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCalculatedAttributeDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCalculatedAttributeDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCalculatedAttributeDefinitionInput"}
	if s.CalculatedAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatedAttributeName"))
	}
	if s.CalculatedAttributeName != nil && len(*s.CalculatedAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatedAttributeName", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Conditions != nil {
		if err := s.Conditions.Validate(); err != nil {
			invalidParams.AddNested("Conditions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *UpdateCalculatedAttributeDefinitionInput) SetCalculatedAttributeName(v string) *UpdateCalculatedAttributeDefinitionInput {
	s.CalculatedAttributeName = &v
	return s
}

// SetConditions sets the Conditions field's value.
func (s *UpdateCalculatedAttributeDefinitionInput) SetConditions(v *Conditions) *UpdateCalculatedAttributeDefinitionInput {
	s.Conditions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateCalculatedAttributeDefinitionInput) SetDescription(v string) *UpdateCalculatedAttributeDefinitionInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateCalculatedAttributeDefinitionInput) SetDisplayName(v string) *UpdateCalculatedAttributeDefinitionInput {
	s.DisplayName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateCalculatedAttributeDefinitionInput) SetDomainName(v string) *UpdateCalculatedAttributeDefinitionInput {
	s.DomainName = &v
	return s
}

type UpdateCalculatedAttributeDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The mathematical expression and a list of attribute items specified in that
	// expression.
	AttributeDetails *AttributeDetails `type:"structure"`

	// The unique name of the calculated attribute.
	CalculatedAttributeName *string `min:"1" type:"string"`

	// The conditions including range, object count, and threshold for the calculated
	// attribute.
	Conditions *Conditions `type:"structure"`

	// The timestamp of when the calculated attribute definition was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the calculated attribute.
	Description *string `min:"1" type:"string"`

	// The display name of the calculated attribute.
	DisplayName *string `min:"1" type:"string"`

	// The timestamp of when the calculated attribute definition was most recently
	// edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The aggregation operation to perform for the calculated attribute.
	Statistic *string `type:"string" enum:"Statistic"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCalculatedAttributeDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCalculatedAttributeDefinitionOutput) GoString() string {
	return s.String()
}

// SetAttributeDetails sets the AttributeDetails field's value.
func (s *UpdateCalculatedAttributeDefinitionOutput) SetAttributeDetails(v *AttributeDetails) *UpdateCalculatedAttributeDefinitionOutput {
	s.AttributeDetails = v
	return s
}

// SetCalculatedAttributeName sets the CalculatedAttributeName field's value.
func (s *UpdateCalculatedAttributeDefinitionOutput) SetCalculatedAttributeName(v string) *UpdateCalculatedAttributeDefinitionOutput {
	s.CalculatedAttributeName = &v
	return s
}

// SetConditions sets the Conditions field's value.
func (s *UpdateCalculatedAttributeDefinitionOutput) SetConditions(v *Conditions) *UpdateCalculatedAttributeDefinitionOutput {
	s.Conditions = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateCalculatedAttributeDefinitionOutput) SetCreatedAt(v time.Time) *UpdateCalculatedAttributeDefinitionOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateCalculatedAttributeDefinitionOutput) SetDescription(v string) *UpdateCalculatedAttributeDefinitionOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateCalculatedAttributeDefinitionOutput) SetDisplayName(v string) *UpdateCalculatedAttributeDefinitionOutput {
	s.DisplayName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *UpdateCalculatedAttributeDefinitionOutput) SetLastUpdatedAt(v time.Time) *UpdateCalculatedAttributeDefinitionOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *UpdateCalculatedAttributeDefinitionOutput) SetStatistic(v string) *UpdateCalculatedAttributeDefinitionOutput {
	s.Statistic = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateCalculatedAttributeDefinitionOutput) SetTags(v map[string]*string) *UpdateCalculatedAttributeDefinitionOutput {
	s.Tags = v
	return s
}

type UpdateDomainInput struct {
	_ struct{} `type:"structure"`

	// The URL of the SQS dead letter queue, which is used for reporting errors
	// associated with ingesting data from third party applications. If specified
	// as an empty string, it will clear any existing value. You must set up a policy
	// on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect
	// Customer Profiles to send messages to the DeadLetterQueue.
	DeadLetterQueueUrl *string `type:"string"`

	// The default encryption key, which is an AWS managed key, is used when no
	// specific type of encryption key is specified. It is used to encrypt all data
	// before it is placed in permanent or semi-permanent storage. If specified
	// as an empty string, it will clear any existing value.
	DefaultEncryptionKey *string `type:"string"`

	// The default number of days until the data within the domain expires.
	DefaultExpirationDays *int64 `min:"1" type:"integer"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The process of matching duplicate profiles. If Matching = true, Amazon Connect
	// Customer Profiles starts a weekly batch process called Identity Resolution
	// Job. If you do not specify a date and time for Identity Resolution Job to
	// run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles
	// in your domains.
	//
	// After the Identity Resolution Job completes, use the GetMatches (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html)
	// API to return and review the results. Or, if you have configured ExportingConfig
	// in the MatchingRequest, you can download the results from S3.
	Matching *MatchingRequest `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainInput"}
	if s.DefaultExpirationDays != nil && *s.DefaultExpirationDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DefaultExpirationDays", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Matching != nil {
		if err := s.Matching.Validate(); err != nil {
			invalidParams.AddNested("Matching", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeadLetterQueueUrl sets the DeadLetterQueueUrl field's value.
func (s *UpdateDomainInput) SetDeadLetterQueueUrl(v string) *UpdateDomainInput {
	s.DeadLetterQueueUrl = &v
	return s
}

// SetDefaultEncryptionKey sets the DefaultEncryptionKey field's value.
func (s *UpdateDomainInput) SetDefaultEncryptionKey(v string) *UpdateDomainInput {
	s.DefaultEncryptionKey = &v
	return s
}

// SetDefaultExpirationDays sets the DefaultExpirationDays field's value.
func (s *UpdateDomainInput) SetDefaultExpirationDays(v int64) *UpdateDomainInput {
	s.DefaultExpirationDays = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainInput) SetDomainName(v string) *UpdateDomainInput {
	s.DomainName = &v
	return s
}

// SetMatching sets the Matching field's value.
func (s *UpdateDomainInput) SetMatching(v *MatchingRequest) *UpdateDomainInput {
	s.Matching = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateDomainInput) SetTags(v map[string]*string) *UpdateDomainInput {
	s.Tags = v
	return s
}

type UpdateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The URL of the SQS dead letter queue, which is used for reporting errors
	// associated with ingesting data from third party applications.
	DeadLetterQueueUrl *string `type:"string"`

	// The default encryption key, which is an AWS managed key, is used when no
	// specific type of encryption key is specified. It is used to encrypt all data
	// before it is placed in permanent or semi-permanent storage.
	DefaultEncryptionKey *string `type:"string"`

	// The default number of days until the data within the domain expires.
	DefaultExpirationDays *int64 `min:"1" type:"integer"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The process of matching duplicate profiles. If Matching = true, Amazon Connect
	// Customer Profiles starts a weekly batch process called Identity Resolution
	// Job. If you do not specify a date and time for Identity Resolution Job to
	// run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles
	// in your domains.
	//
	// After the Identity Resolution Job completes, use the GetMatches (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html)
	// API to return and review the results. Or, if you have configured ExportingConfig
	// in the MatchingRequest, you can download the results from S3.
	Matching *MatchingResponse `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateDomainOutput) SetCreatedAt(v time.Time) *UpdateDomainOutput {
	s.CreatedAt = &v
	return s
}

// SetDeadLetterQueueUrl sets the DeadLetterQueueUrl field's value.
func (s *UpdateDomainOutput) SetDeadLetterQueueUrl(v string) *UpdateDomainOutput {
	s.DeadLetterQueueUrl = &v
	return s
}

// SetDefaultEncryptionKey sets the DefaultEncryptionKey field's value.
func (s *UpdateDomainOutput) SetDefaultEncryptionKey(v string) *UpdateDomainOutput {
	s.DefaultEncryptionKey = &v
	return s
}

// SetDefaultExpirationDays sets the DefaultExpirationDays field's value.
func (s *UpdateDomainOutput) SetDefaultExpirationDays(v int64) *UpdateDomainOutput {
	s.DefaultExpirationDays = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainOutput) SetDomainName(v string) *UpdateDomainOutput {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *UpdateDomainOutput) SetLastUpdatedAt(v time.Time) *UpdateDomainOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetMatching sets the Matching field's value.
func (s *UpdateDomainOutput) SetMatching(v *MatchingResponse) *UpdateDomainOutput {
	s.Matching = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateDomainOutput) SetTags(v map[string]*string) *UpdateDomainOutput {
	s.Tags = v
	return s
}

type UpdateProfileInput struct {
	_ struct{} `type:"structure"`

	// A unique account number that you have given to the customer.
	AccountNumber *string `type:"string"`

	// Any additional information relevant to the customer’s profile.
	AdditionalInformation *string `type:"string"`

	// A generic address associated with the customer that is not mailing, shipping,
	// or billing.
	Address *UpdateAddress `type:"structure"`

	// A key value pair of attributes of a customer profile.
	Attributes map[string]*string `type:"map"`

	// The customer’s billing address.
	BillingAddress *UpdateAddress `type:"structure"`

	// The customer’s birth date.
	BirthDate *string `type:"string"`

	// The customer’s business email address.
	BusinessEmailAddress *string `type:"string"`

	// The name of the customer’s business.
	BusinessName *string `type:"string"`

	// The customer’s business phone number.
	BusinessPhoneNumber *string `type:"string"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The customer’s email address, which has not been specified as a personal
	// or business address.
	EmailAddress *string `type:"string"`

	// The customer’s first name.
	FirstName *string `type:"string"`

	// The gender with which the customer identifies.
	Gender *string `deprecated:"true" type:"string" enum:"Gender"`

	// An alternative to Gender which accepts any string as input.
	GenderString *string `type:"string"`

	// The customer’s home phone number.
	HomePhoneNumber *string `type:"string"`

	// The customer’s last name.
	LastName *string `type:"string"`

	// The customer’s mailing address.
	MailingAddress *UpdateAddress `type:"structure"`

	// The customer’s middle name.
	MiddleName *string `type:"string"`

	// The customer’s mobile phone number.
	MobilePhoneNumber *string `type:"string"`

	// The type of profile used to describe the customer.
	PartyType *string `deprecated:"true" type:"string" enum:"PartyType"`

	// An alternative to PartyType which accepts any string as input.
	PartyTypeString *string `type:"string"`

	// The customer’s personal email address.
	PersonalEmailAddress *string `type:"string"`

	// The customer’s phone number, which has not been specified as a mobile,
	// home, or business number.
	PhoneNumber *string `type:"string"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// The customer’s shipping address.
	ShippingAddress *UpdateAddress `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProfileInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountNumber sets the AccountNumber field's value.
func (s *UpdateProfileInput) SetAccountNumber(v string) *UpdateProfileInput {
	s.AccountNumber = &v
	return s
}

// SetAdditionalInformation sets the AdditionalInformation field's value.
func (s *UpdateProfileInput) SetAdditionalInformation(v string) *UpdateProfileInput {
	s.AdditionalInformation = &v
	return s
}

// SetAddress sets the Address field's value.
func (s *UpdateProfileInput) SetAddress(v *UpdateAddress) *UpdateProfileInput {
	s.Address = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateProfileInput) SetAttributes(v map[string]*string) *UpdateProfileInput {
	s.Attributes = v
	return s
}

// SetBillingAddress sets the BillingAddress field's value.
func (s *UpdateProfileInput) SetBillingAddress(v *UpdateAddress) *UpdateProfileInput {
	s.BillingAddress = v
	return s
}

// SetBirthDate sets the BirthDate field's value.
func (s *UpdateProfileInput) SetBirthDate(v string) *UpdateProfileInput {
	s.BirthDate = &v
	return s
}

// SetBusinessEmailAddress sets the BusinessEmailAddress field's value.
func (s *UpdateProfileInput) SetBusinessEmailAddress(v string) *UpdateProfileInput {
	s.BusinessEmailAddress = &v
	return s
}

// SetBusinessName sets the BusinessName field's value.
func (s *UpdateProfileInput) SetBusinessName(v string) *UpdateProfileInput {
	s.BusinessName = &v
	return s
}

// SetBusinessPhoneNumber sets the BusinessPhoneNumber field's value.
func (s *UpdateProfileInput) SetBusinessPhoneNumber(v string) *UpdateProfileInput {
	s.BusinessPhoneNumber = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateProfileInput) SetDomainName(v string) *UpdateProfileInput {
	s.DomainName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *UpdateProfileInput) SetEmailAddress(v string) *UpdateProfileInput {
	s.EmailAddress = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *UpdateProfileInput) SetFirstName(v string) *UpdateProfileInput {
	s.FirstName = &v
	return s
}

// SetGender sets the Gender field's value.
func (s *UpdateProfileInput) SetGender(v string) *UpdateProfileInput {
	s.Gender = &v
	return s
}

// SetGenderString sets the GenderString field's value.
func (s *UpdateProfileInput) SetGenderString(v string) *UpdateProfileInput {
	s.GenderString = &v
	return s
}

// SetHomePhoneNumber sets the HomePhoneNumber field's value.
func (s *UpdateProfileInput) SetHomePhoneNumber(v string) *UpdateProfileInput {
	s.HomePhoneNumber = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *UpdateProfileInput) SetLastName(v string) *UpdateProfileInput {
	s.LastName = &v
	return s
}

// SetMailingAddress sets the MailingAddress field's value.
func (s *UpdateProfileInput) SetMailingAddress(v *UpdateAddress) *UpdateProfileInput {
	s.MailingAddress = v
	return s
}

// SetMiddleName sets the MiddleName field's value.
func (s *UpdateProfileInput) SetMiddleName(v string) *UpdateProfileInput {
	s.MiddleName = &v
	return s
}

// SetMobilePhoneNumber sets the MobilePhoneNumber field's value.
func (s *UpdateProfileInput) SetMobilePhoneNumber(v string) *UpdateProfileInput {
	s.MobilePhoneNumber = &v
	return s
}

// SetPartyType sets the PartyType field's value.
func (s *UpdateProfileInput) SetPartyType(v string) *UpdateProfileInput {
	s.PartyType = &v
	return s
}

// SetPartyTypeString sets the PartyTypeString field's value.
func (s *UpdateProfileInput) SetPartyTypeString(v string) *UpdateProfileInput {
	s.PartyTypeString = &v
	return s
}

// SetPersonalEmailAddress sets the PersonalEmailAddress field's value.
func (s *UpdateProfileInput) SetPersonalEmailAddress(v string) *UpdateProfileInput {
	s.PersonalEmailAddress = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *UpdateProfileInput) SetPhoneNumber(v string) *UpdateProfileInput {
	s.PhoneNumber = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *UpdateProfileInput) SetProfileId(v string) *UpdateProfileInput {
	s.ProfileId = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *UpdateProfileInput) SetShippingAddress(v *UpdateAddress) *UpdateProfileInput {
	s.ShippingAddress = v
	return s
}

type UpdateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileOutput) GoString() string {
	return s.String()
}

// SetProfileId sets the ProfileId field's value.
func (s *UpdateProfileOutput) SetProfileId(v string) *UpdateProfileOutput {
	s.ProfileId = &v
	return s
}

// Structure to hold workflow attributes.
type WorkflowAttributes struct {
	_ struct{} `type:"structure"`

	// Workflow attributes specific to APPFLOW_INTEGRATION workflow.
	AppflowIntegration *AppflowIntegrationWorkflowAttributes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowAttributes) GoString() string {
	return s.String()
}

// SetAppflowIntegration sets the AppflowIntegration field's value.
func (s *WorkflowAttributes) SetAppflowIntegration(v *AppflowIntegrationWorkflowAttributes) *WorkflowAttributes {
	s.AppflowIntegration = v
	return s
}

// Generic object containing workflow execution metrics.
type WorkflowMetrics struct {
	_ struct{} `type:"structure"`

	// Workflow execution metrics for APPFLOW_INTEGRATION workflow.
	AppflowIntegration *AppflowIntegrationWorkflowMetrics `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowMetrics) GoString() string {
	return s.String()
}

// SetAppflowIntegration sets the AppflowIntegration field's value.
func (s *WorkflowMetrics) SetAppflowIntegration(v *AppflowIntegrationWorkflowMetrics) *WorkflowMetrics {
	s.AppflowIntegration = v
	return s
}

// List containing steps in workflow.
type WorkflowStepItem struct {
	_ struct{} `type:"structure"`

	// Workflow step information specific to APPFLOW_INTEGRATION workflow.
	AppflowIntegration *AppflowIntegrationWorkflowStep `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepItem) GoString() string {
	return s.String()
}

// SetAppflowIntegration sets the AppflowIntegration field's value.
func (s *WorkflowStepItem) SetAppflowIntegration(v *AppflowIntegrationWorkflowStep) *WorkflowStepItem {
	s.AppflowIntegration = v
	return s
}

// The properties that are applied when using Zendesk as a flow source.
type ZendeskSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Zendesk flow source.
	//
	// Object is a required field
	Object *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZendeskSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZendeskSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZendeskSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZendeskSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *ZendeskSourceProperties) SetObject(v string) *ZendeskSourceProperties {
	s.Object = &v
	return s
}

const (
	// ConflictResolvingModelRecency is a ConflictResolvingModel enum value
	ConflictResolvingModelRecency = "RECENCY"

	// ConflictResolvingModelSource is a ConflictResolvingModel enum value
	ConflictResolvingModelSource = "SOURCE"
)

// ConflictResolvingModel_Values returns all elements of the ConflictResolvingModel enum
func ConflictResolvingModel_Values() []string {
	return []string{
		ConflictResolvingModelRecency,
		ConflictResolvingModelSource,
	}
}

const (
	// DataPullModeIncremental is a DataPullMode enum value
	DataPullModeIncremental = "Incremental"

	// DataPullModeComplete is a DataPullMode enum value
	DataPullModeComplete = "Complete"
)

// DataPullMode_Values returns all elements of the DataPullMode enum
func DataPullMode_Values() []string {
	return []string{
		DataPullModeIncremental,
		DataPullModeComplete,
	}
}

const (
	// EventStreamDestinationStatusHealthy is a EventStreamDestinationStatus enum value
	EventStreamDestinationStatusHealthy = "HEALTHY"

	// EventStreamDestinationStatusUnhealthy is a EventStreamDestinationStatus enum value
	EventStreamDestinationStatusUnhealthy = "UNHEALTHY"
)

// EventStreamDestinationStatus_Values returns all elements of the EventStreamDestinationStatus enum
func EventStreamDestinationStatus_Values() []string {
	return []string{
		EventStreamDestinationStatusHealthy,
		EventStreamDestinationStatusUnhealthy,
	}
}

const (
	// EventStreamStateRunning is a EventStreamState enum value
	EventStreamStateRunning = "RUNNING"

	// EventStreamStateStopped is a EventStreamState enum value
	EventStreamStateStopped = "STOPPED"
)

// EventStreamState_Values returns all elements of the EventStreamState enum
func EventStreamState_Values() []string {
	return []string{
		EventStreamStateRunning,
		EventStreamStateStopped,
	}
}

const (
	// FieldContentTypeString is a FieldContentType enum value
	FieldContentTypeString = "STRING"

	// FieldContentTypeNumber is a FieldContentType enum value
	FieldContentTypeNumber = "NUMBER"

	// FieldContentTypePhoneNumber is a FieldContentType enum value
	FieldContentTypePhoneNumber = "PHONE_NUMBER"

	// FieldContentTypeEmailAddress is a FieldContentType enum value
	FieldContentTypeEmailAddress = "EMAIL_ADDRESS"

	// FieldContentTypeName is a FieldContentType enum value
	FieldContentTypeName = "NAME"
)

// FieldContentType_Values returns all elements of the FieldContentType enum
func FieldContentType_Values() []string {
	return []string{
		FieldContentTypeString,
		FieldContentTypeNumber,
		FieldContentTypePhoneNumber,
		FieldContentTypeEmailAddress,
		FieldContentTypeName,
	}
}

const (
	// GenderMale is a Gender enum value
	GenderMale = "MALE"

	// GenderFemale is a Gender enum value
	GenderFemale = "FEMALE"

	// GenderUnspecified is a Gender enum value
	GenderUnspecified = "UNSPECIFIED"
)

// Gender_Values returns all elements of the Gender enum
func Gender_Values() []string {
	return []string{
		GenderMale,
		GenderFemale,
		GenderUnspecified,
	}
}

const (
	// IdentityResolutionJobStatusPending is a IdentityResolutionJobStatus enum value
	IdentityResolutionJobStatusPending = "PENDING"

	// IdentityResolutionJobStatusPreprocessing is a IdentityResolutionJobStatus enum value
	IdentityResolutionJobStatusPreprocessing = "PREPROCESSING"

	// IdentityResolutionJobStatusFindMatching is a IdentityResolutionJobStatus enum value
	IdentityResolutionJobStatusFindMatching = "FIND_MATCHING"

	// IdentityResolutionJobStatusMerging is a IdentityResolutionJobStatus enum value
	IdentityResolutionJobStatusMerging = "MERGING"

	// IdentityResolutionJobStatusCompleted is a IdentityResolutionJobStatus enum value
	IdentityResolutionJobStatusCompleted = "COMPLETED"

	// IdentityResolutionJobStatusPartialSuccess is a IdentityResolutionJobStatus enum value
	IdentityResolutionJobStatusPartialSuccess = "PARTIAL_SUCCESS"

	// IdentityResolutionJobStatusFailed is a IdentityResolutionJobStatus enum value
	IdentityResolutionJobStatusFailed = "FAILED"
)

// IdentityResolutionJobStatus_Values returns all elements of the IdentityResolutionJobStatus enum
func IdentityResolutionJobStatus_Values() []string {
	return []string{
		IdentityResolutionJobStatusPending,
		IdentityResolutionJobStatusPreprocessing,
		IdentityResolutionJobStatusFindMatching,
		IdentityResolutionJobStatusMerging,
		IdentityResolutionJobStatusCompleted,
		IdentityResolutionJobStatusPartialSuccess,
		IdentityResolutionJobStatusFailed,
	}
}

const (
	// JobScheduleDayOfTheWeekSunday is a JobScheduleDayOfTheWeek enum value
	JobScheduleDayOfTheWeekSunday = "SUNDAY"

	// JobScheduleDayOfTheWeekMonday is a JobScheduleDayOfTheWeek enum value
	JobScheduleDayOfTheWeekMonday = "MONDAY"

	// JobScheduleDayOfTheWeekTuesday is a JobScheduleDayOfTheWeek enum value
	JobScheduleDayOfTheWeekTuesday = "TUESDAY"

	// JobScheduleDayOfTheWeekWednesday is a JobScheduleDayOfTheWeek enum value
	JobScheduleDayOfTheWeekWednesday = "WEDNESDAY"

	// JobScheduleDayOfTheWeekThursday is a JobScheduleDayOfTheWeek enum value
	JobScheduleDayOfTheWeekThursday = "THURSDAY"

	// JobScheduleDayOfTheWeekFriday is a JobScheduleDayOfTheWeek enum value
	JobScheduleDayOfTheWeekFriday = "FRIDAY"

	// JobScheduleDayOfTheWeekSaturday is a JobScheduleDayOfTheWeek enum value
	JobScheduleDayOfTheWeekSaturday = "SATURDAY"
)

// JobScheduleDayOfTheWeek_Values returns all elements of the JobScheduleDayOfTheWeek enum
func JobScheduleDayOfTheWeek_Values() []string {
	return []string{
		JobScheduleDayOfTheWeekSunday,
		JobScheduleDayOfTheWeekMonday,
		JobScheduleDayOfTheWeekTuesday,
		JobScheduleDayOfTheWeekWednesday,
		JobScheduleDayOfTheWeekThursday,
		JobScheduleDayOfTheWeekFriday,
		JobScheduleDayOfTheWeekSaturday,
	}
}

const (
	// LogicalOperatorAnd is a LogicalOperator enum value
	LogicalOperatorAnd = "AND"

	// LogicalOperatorOr is a LogicalOperator enum value
	LogicalOperatorOr = "OR"
)

// LogicalOperator_Values returns all elements of the LogicalOperator enum
func LogicalOperator_Values() []string {
	return []string{
		LogicalOperatorAnd,
		LogicalOperatorOr,
	}
}

const (
	// MarketoConnectorOperatorProjection is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorProjection = "PROJECTION"

	// MarketoConnectorOperatorLessThan is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorLessThan = "LESS_THAN"

	// MarketoConnectorOperatorGreaterThan is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorGreaterThan = "GREATER_THAN"

	// MarketoConnectorOperatorBetween is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorBetween = "BETWEEN"

	// MarketoConnectorOperatorAddition is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorAddition = "ADDITION"

	// MarketoConnectorOperatorMultiplication is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMultiplication = "MULTIPLICATION"

	// MarketoConnectorOperatorDivision is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorDivision = "DIVISION"

	// MarketoConnectorOperatorSubtraction is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorSubtraction = "SUBTRACTION"

	// MarketoConnectorOperatorMaskAll is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMaskAll = "MASK_ALL"

	// MarketoConnectorOperatorMaskFirstN is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// MarketoConnectorOperatorMaskLastN is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMaskLastN = "MASK_LAST_N"

	// MarketoConnectorOperatorValidateNonNull is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// MarketoConnectorOperatorValidateNonZero is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// MarketoConnectorOperatorValidateNonNegative is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// MarketoConnectorOperatorValidateNumeric is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// MarketoConnectorOperatorNoOp is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorNoOp = "NO_OP"
)

// MarketoConnectorOperator_Values returns all elements of the MarketoConnectorOperator enum
func MarketoConnectorOperator_Values() []string {
	return []string{
		MarketoConnectorOperatorProjection,
		MarketoConnectorOperatorLessThan,
		MarketoConnectorOperatorGreaterThan,
		MarketoConnectorOperatorBetween,
		MarketoConnectorOperatorAddition,
		MarketoConnectorOperatorMultiplication,
		MarketoConnectorOperatorDivision,
		MarketoConnectorOperatorSubtraction,
		MarketoConnectorOperatorMaskAll,
		MarketoConnectorOperatorMaskFirstN,
		MarketoConnectorOperatorMaskLastN,
		MarketoConnectorOperatorValidateNonNull,
		MarketoConnectorOperatorValidateNonZero,
		MarketoConnectorOperatorValidateNonNegative,
		MarketoConnectorOperatorValidateNumeric,
		MarketoConnectorOperatorNoOp,
	}
}

const (
	// OperatorEqualTo is a Operator enum value
	OperatorEqualTo = "EQUAL_TO"

	// OperatorGreaterThan is a Operator enum value
	OperatorGreaterThan = "GREATER_THAN"

	// OperatorLessThan is a Operator enum value
	OperatorLessThan = "LESS_THAN"

	// OperatorNotEqualTo is a Operator enum value
	OperatorNotEqualTo = "NOT_EQUAL_TO"
)

// Operator_Values returns all elements of the Operator enum
func Operator_Values() []string {
	return []string{
		OperatorEqualTo,
		OperatorGreaterThan,
		OperatorLessThan,
		OperatorNotEqualTo,
	}
}

const (
	// OperatorPropertiesKeysValue is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysValue = "VALUE"

	// OperatorPropertiesKeysValues is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysValues = "VALUES"

	// OperatorPropertiesKeysDataType is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysDataType = "DATA_TYPE"

	// OperatorPropertiesKeysUpperBound is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysUpperBound = "UPPER_BOUND"

	// OperatorPropertiesKeysLowerBound is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysLowerBound = "LOWER_BOUND"

	// OperatorPropertiesKeysSourceDataType is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysSourceDataType = "SOURCE_DATA_TYPE"

	// OperatorPropertiesKeysDestinationDataType is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysDestinationDataType = "DESTINATION_DATA_TYPE"

	// OperatorPropertiesKeysValidationAction is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysValidationAction = "VALIDATION_ACTION"

	// OperatorPropertiesKeysMaskValue is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysMaskValue = "MASK_VALUE"

	// OperatorPropertiesKeysMaskLength is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysMaskLength = "MASK_LENGTH"

	// OperatorPropertiesKeysTruncateLength is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysTruncateLength = "TRUNCATE_LENGTH"

	// OperatorPropertiesKeysMathOperationFieldsOrder is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysMathOperationFieldsOrder = "MATH_OPERATION_FIELDS_ORDER"

	// OperatorPropertiesKeysConcatFormat is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysConcatFormat = "CONCAT_FORMAT"

	// OperatorPropertiesKeysSubfieldCategoryMap is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysSubfieldCategoryMap = "SUBFIELD_CATEGORY_MAP"
)

// OperatorPropertiesKeys_Values returns all elements of the OperatorPropertiesKeys enum
func OperatorPropertiesKeys_Values() []string {
	return []string{
		OperatorPropertiesKeysValue,
		OperatorPropertiesKeysValues,
		OperatorPropertiesKeysDataType,
		OperatorPropertiesKeysUpperBound,
		OperatorPropertiesKeysLowerBound,
		OperatorPropertiesKeysSourceDataType,
		OperatorPropertiesKeysDestinationDataType,
		OperatorPropertiesKeysValidationAction,
		OperatorPropertiesKeysMaskValue,
		OperatorPropertiesKeysMaskLength,
		OperatorPropertiesKeysTruncateLength,
		OperatorPropertiesKeysMathOperationFieldsOrder,
		OperatorPropertiesKeysConcatFormat,
		OperatorPropertiesKeysSubfieldCategoryMap,
	}
}

const (
	// PartyTypeIndividual is a PartyType enum value
	PartyTypeIndividual = "INDIVIDUAL"

	// PartyTypeBusiness is a PartyType enum value
	PartyTypeBusiness = "BUSINESS"

	// PartyTypeOther is a PartyType enum value
	PartyTypeOther = "OTHER"
)

// PartyType_Values returns all elements of the PartyType enum
func PartyType_Values() []string {
	return []string{
		PartyTypeIndividual,
		PartyTypeBusiness,
		PartyTypeOther,
	}
}

const (
	// S3ConnectorOperatorProjection is a S3ConnectorOperator enum value
	S3ConnectorOperatorProjection = "PROJECTION"

	// S3ConnectorOperatorLessThan is a S3ConnectorOperator enum value
	S3ConnectorOperatorLessThan = "LESS_THAN"

	// S3ConnectorOperatorGreaterThan is a S3ConnectorOperator enum value
	S3ConnectorOperatorGreaterThan = "GREATER_THAN"

	// S3ConnectorOperatorBetween is a S3ConnectorOperator enum value
	S3ConnectorOperatorBetween = "BETWEEN"

	// S3ConnectorOperatorLessThanOrEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// S3ConnectorOperatorGreaterThanOrEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// S3ConnectorOperatorEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorEqualTo = "EQUAL_TO"

	// S3ConnectorOperatorNotEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorNotEqualTo = "NOT_EQUAL_TO"

	// S3ConnectorOperatorAddition is a S3ConnectorOperator enum value
	S3ConnectorOperatorAddition = "ADDITION"

	// S3ConnectorOperatorMultiplication is a S3ConnectorOperator enum value
	S3ConnectorOperatorMultiplication = "MULTIPLICATION"

	// S3ConnectorOperatorDivision is a S3ConnectorOperator enum value
	S3ConnectorOperatorDivision = "DIVISION"

	// S3ConnectorOperatorSubtraction is a S3ConnectorOperator enum value
	S3ConnectorOperatorSubtraction = "SUBTRACTION"

	// S3ConnectorOperatorMaskAll is a S3ConnectorOperator enum value
	S3ConnectorOperatorMaskAll = "MASK_ALL"

	// S3ConnectorOperatorMaskFirstN is a S3ConnectorOperator enum value
	S3ConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// S3ConnectorOperatorMaskLastN is a S3ConnectorOperator enum value
	S3ConnectorOperatorMaskLastN = "MASK_LAST_N"

	// S3ConnectorOperatorValidateNonNull is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// S3ConnectorOperatorValidateNonZero is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// S3ConnectorOperatorValidateNonNegative is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// S3ConnectorOperatorValidateNumeric is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// S3ConnectorOperatorNoOp is a S3ConnectorOperator enum value
	S3ConnectorOperatorNoOp = "NO_OP"
)

// S3ConnectorOperator_Values returns all elements of the S3ConnectorOperator enum
func S3ConnectorOperator_Values() []string {
	return []string{
		S3ConnectorOperatorProjection,
		S3ConnectorOperatorLessThan,
		S3ConnectorOperatorGreaterThan,
		S3ConnectorOperatorBetween,
		S3ConnectorOperatorLessThanOrEqualTo,
		S3ConnectorOperatorGreaterThanOrEqualTo,
		S3ConnectorOperatorEqualTo,
		S3ConnectorOperatorNotEqualTo,
		S3ConnectorOperatorAddition,
		S3ConnectorOperatorMultiplication,
		S3ConnectorOperatorDivision,
		S3ConnectorOperatorSubtraction,
		S3ConnectorOperatorMaskAll,
		S3ConnectorOperatorMaskFirstN,
		S3ConnectorOperatorMaskLastN,
		S3ConnectorOperatorValidateNonNull,
		S3ConnectorOperatorValidateNonZero,
		S3ConnectorOperatorValidateNonNegative,
		S3ConnectorOperatorValidateNumeric,
		S3ConnectorOperatorNoOp,
	}
}

const (
	// SalesforceConnectorOperatorProjection is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorProjection = "PROJECTION"

	// SalesforceConnectorOperatorLessThan is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorLessThan = "LESS_THAN"

	// SalesforceConnectorOperatorContains is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorContains = "CONTAINS"

	// SalesforceConnectorOperatorGreaterThan is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorGreaterThan = "GREATER_THAN"

	// SalesforceConnectorOperatorBetween is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorBetween = "BETWEEN"

	// SalesforceConnectorOperatorLessThanOrEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// SalesforceConnectorOperatorGreaterThanOrEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// SalesforceConnectorOperatorEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorEqualTo = "EQUAL_TO"

	// SalesforceConnectorOperatorNotEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorNotEqualTo = "NOT_EQUAL_TO"

	// SalesforceConnectorOperatorAddition is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorAddition = "ADDITION"

	// SalesforceConnectorOperatorMultiplication is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMultiplication = "MULTIPLICATION"

	// SalesforceConnectorOperatorDivision is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorDivision = "DIVISION"

	// SalesforceConnectorOperatorSubtraction is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorSubtraction = "SUBTRACTION"

	// SalesforceConnectorOperatorMaskAll is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMaskAll = "MASK_ALL"

	// SalesforceConnectorOperatorMaskFirstN is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// SalesforceConnectorOperatorMaskLastN is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMaskLastN = "MASK_LAST_N"

	// SalesforceConnectorOperatorValidateNonNull is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// SalesforceConnectorOperatorValidateNonZero is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// SalesforceConnectorOperatorValidateNonNegative is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// SalesforceConnectorOperatorValidateNumeric is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// SalesforceConnectorOperatorNoOp is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorNoOp = "NO_OP"
)

// SalesforceConnectorOperator_Values returns all elements of the SalesforceConnectorOperator enum
func SalesforceConnectorOperator_Values() []string {
	return []string{
		SalesforceConnectorOperatorProjection,
		SalesforceConnectorOperatorLessThan,
		SalesforceConnectorOperatorContains,
		SalesforceConnectorOperatorGreaterThan,
		SalesforceConnectorOperatorBetween,
		SalesforceConnectorOperatorLessThanOrEqualTo,
		SalesforceConnectorOperatorGreaterThanOrEqualTo,
		SalesforceConnectorOperatorEqualTo,
		SalesforceConnectorOperatorNotEqualTo,
		SalesforceConnectorOperatorAddition,
		SalesforceConnectorOperatorMultiplication,
		SalesforceConnectorOperatorDivision,
		SalesforceConnectorOperatorSubtraction,
		SalesforceConnectorOperatorMaskAll,
		SalesforceConnectorOperatorMaskFirstN,
		SalesforceConnectorOperatorMaskLastN,
		SalesforceConnectorOperatorValidateNonNull,
		SalesforceConnectorOperatorValidateNonZero,
		SalesforceConnectorOperatorValidateNonNegative,
		SalesforceConnectorOperatorValidateNumeric,
		SalesforceConnectorOperatorNoOp,
	}
}

const (
	// ServiceNowConnectorOperatorProjection is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorProjection = "PROJECTION"

	// ServiceNowConnectorOperatorContains is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorContains = "CONTAINS"

	// ServiceNowConnectorOperatorLessThan is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorLessThan = "LESS_THAN"

	// ServiceNowConnectorOperatorGreaterThan is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorGreaterThan = "GREATER_THAN"

	// ServiceNowConnectorOperatorBetween is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorBetween = "BETWEEN"

	// ServiceNowConnectorOperatorLessThanOrEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// ServiceNowConnectorOperatorGreaterThanOrEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// ServiceNowConnectorOperatorEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorEqualTo = "EQUAL_TO"

	// ServiceNowConnectorOperatorNotEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorNotEqualTo = "NOT_EQUAL_TO"

	// ServiceNowConnectorOperatorAddition is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorAddition = "ADDITION"

	// ServiceNowConnectorOperatorMultiplication is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMultiplication = "MULTIPLICATION"

	// ServiceNowConnectorOperatorDivision is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorDivision = "DIVISION"

	// ServiceNowConnectorOperatorSubtraction is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorSubtraction = "SUBTRACTION"

	// ServiceNowConnectorOperatorMaskAll is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMaskAll = "MASK_ALL"

	// ServiceNowConnectorOperatorMaskFirstN is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// ServiceNowConnectorOperatorMaskLastN is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMaskLastN = "MASK_LAST_N"

	// ServiceNowConnectorOperatorValidateNonNull is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// ServiceNowConnectorOperatorValidateNonZero is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// ServiceNowConnectorOperatorValidateNonNegative is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// ServiceNowConnectorOperatorValidateNumeric is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// ServiceNowConnectorOperatorNoOp is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorNoOp = "NO_OP"
)

// ServiceNowConnectorOperator_Values returns all elements of the ServiceNowConnectorOperator enum
func ServiceNowConnectorOperator_Values() []string {
	return []string{
		ServiceNowConnectorOperatorProjection,
		ServiceNowConnectorOperatorContains,
		ServiceNowConnectorOperatorLessThan,
		ServiceNowConnectorOperatorGreaterThan,
		ServiceNowConnectorOperatorBetween,
		ServiceNowConnectorOperatorLessThanOrEqualTo,
		ServiceNowConnectorOperatorGreaterThanOrEqualTo,
		ServiceNowConnectorOperatorEqualTo,
		ServiceNowConnectorOperatorNotEqualTo,
		ServiceNowConnectorOperatorAddition,
		ServiceNowConnectorOperatorMultiplication,
		ServiceNowConnectorOperatorDivision,
		ServiceNowConnectorOperatorSubtraction,
		ServiceNowConnectorOperatorMaskAll,
		ServiceNowConnectorOperatorMaskFirstN,
		ServiceNowConnectorOperatorMaskLastN,
		ServiceNowConnectorOperatorValidateNonNull,
		ServiceNowConnectorOperatorValidateNonZero,
		ServiceNowConnectorOperatorValidateNonNegative,
		ServiceNowConnectorOperatorValidateNumeric,
		ServiceNowConnectorOperatorNoOp,
	}
}

const (
	// SourceConnectorTypeSalesforce is a SourceConnectorType enum value
	SourceConnectorTypeSalesforce = "Salesforce"

	// SourceConnectorTypeMarketo is a SourceConnectorType enum value
	SourceConnectorTypeMarketo = "Marketo"

	// SourceConnectorTypeZendesk is a SourceConnectorType enum value
	SourceConnectorTypeZendesk = "Zendesk"

	// SourceConnectorTypeServicenow is a SourceConnectorType enum value
	SourceConnectorTypeServicenow = "Servicenow"

	// SourceConnectorTypeS3 is a SourceConnectorType enum value
	SourceConnectorTypeS3 = "S3"
)

// SourceConnectorType_Values returns all elements of the SourceConnectorType enum
func SourceConnectorType_Values() []string {
	return []string{
		SourceConnectorTypeSalesforce,
		SourceConnectorTypeMarketo,
		SourceConnectorTypeZendesk,
		SourceConnectorTypeServicenow,
		SourceConnectorTypeS3,
	}
}

const (
	// StandardIdentifierProfile is a StandardIdentifier enum value
	StandardIdentifierProfile = "PROFILE"

	// StandardIdentifierAsset is a StandardIdentifier enum value
	StandardIdentifierAsset = "ASSET"

	// StandardIdentifierCase is a StandardIdentifier enum value
	StandardIdentifierCase = "CASE"

	// StandardIdentifierUnique is a StandardIdentifier enum value
	StandardIdentifierUnique = "UNIQUE"

	// StandardIdentifierSecondary is a StandardIdentifier enum value
	StandardIdentifierSecondary = "SECONDARY"

	// StandardIdentifierLookupOnly is a StandardIdentifier enum value
	StandardIdentifierLookupOnly = "LOOKUP_ONLY"

	// StandardIdentifierNewOnly is a StandardIdentifier enum value
	StandardIdentifierNewOnly = "NEW_ONLY"

	// StandardIdentifierOrder is a StandardIdentifier enum value
	StandardIdentifierOrder = "ORDER"
)

// StandardIdentifier_Values returns all elements of the StandardIdentifier enum
func StandardIdentifier_Values() []string {
	return []string{
		StandardIdentifierProfile,
		StandardIdentifierAsset,
		StandardIdentifierCase,
		StandardIdentifierUnique,
		StandardIdentifierSecondary,
		StandardIdentifierLookupOnly,
		StandardIdentifierNewOnly,
		StandardIdentifierOrder,
	}
}

const (
	// StatisticFirstOccurrence is a Statistic enum value
	StatisticFirstOccurrence = "FIRST_OCCURRENCE"

	// StatisticLastOccurrence is a Statistic enum value
	StatisticLastOccurrence = "LAST_OCCURRENCE"

	// StatisticCount is a Statistic enum value
	StatisticCount = "COUNT"

	// StatisticSum is a Statistic enum value
	StatisticSum = "SUM"

	// StatisticMinimum is a Statistic enum value
	StatisticMinimum = "MINIMUM"

	// StatisticMaximum is a Statistic enum value
	StatisticMaximum = "MAXIMUM"

	// StatisticAverage is a Statistic enum value
	StatisticAverage = "AVERAGE"

	// StatisticMaxOccurrence is a Statistic enum value
	StatisticMaxOccurrence = "MAX_OCCURRENCE"
)

// Statistic_Values returns all elements of the Statistic enum
func Statistic_Values() []string {
	return []string{
		StatisticFirstOccurrence,
		StatisticLastOccurrence,
		StatisticCount,
		StatisticSum,
		StatisticMinimum,
		StatisticMaximum,
		StatisticAverage,
		StatisticMaxOccurrence,
	}
}

const (
	// StatusNotStarted is a Status enum value
	StatusNotStarted = "NOT_STARTED"

	// StatusInProgress is a Status enum value
	StatusInProgress = "IN_PROGRESS"

	// StatusComplete is a Status enum value
	StatusComplete = "COMPLETE"

	// StatusFailed is a Status enum value
	StatusFailed = "FAILED"

	// StatusSplit is a Status enum value
	StatusSplit = "SPLIT"

	// StatusRetry is a Status enum value
	StatusRetry = "RETRY"

	// StatusCancelled is a Status enum value
	StatusCancelled = "CANCELLED"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusNotStarted,
		StatusInProgress,
		StatusComplete,
		StatusFailed,
		StatusSplit,
		StatusRetry,
		StatusCancelled,
	}
}

const (
	// TaskTypeArithmetic is a TaskType enum value
	TaskTypeArithmetic = "Arithmetic"

	// TaskTypeFilter is a TaskType enum value
	TaskTypeFilter = "Filter"

	// TaskTypeMap is a TaskType enum value
	TaskTypeMap = "Map"

	// TaskTypeMask is a TaskType enum value
	TaskTypeMask = "Mask"

	// TaskTypeMerge is a TaskType enum value
	TaskTypeMerge = "Merge"

	// TaskTypeTruncate is a TaskType enum value
	TaskTypeTruncate = "Truncate"

	// TaskTypeValidate is a TaskType enum value
	TaskTypeValidate = "Validate"
)

// TaskType_Values returns all elements of the TaskType enum
func TaskType_Values() []string {
	return []string{
		TaskTypeArithmetic,
		TaskTypeFilter,
		TaskTypeMap,
		TaskTypeMask,
		TaskTypeMerge,
		TaskTypeTruncate,
		TaskTypeValidate,
	}
}

const (
	// TriggerTypeScheduled is a TriggerType enum value
	TriggerTypeScheduled = "Scheduled"

	// TriggerTypeEvent is a TriggerType enum value
	TriggerTypeEvent = "Event"

	// TriggerTypeOnDemand is a TriggerType enum value
	TriggerTypeOnDemand = "OnDemand"
)

// TriggerType_Values returns all elements of the TriggerType enum
func TriggerType_Values() []string {
	return []string{
		TriggerTypeScheduled,
		TriggerTypeEvent,
		TriggerTypeOnDemand,
	}
}

const (
	// UnitDays is a Unit enum value
	UnitDays = "DAYS"
)

// Unit_Values returns all elements of the Unit enum
func Unit_Values() []string {
	return []string{
		UnitDays,
	}
}

const (
	// WorkflowTypeAppflowIntegration is a WorkflowType enum value
	WorkflowTypeAppflowIntegration = "APPFLOW_INTEGRATION"
)

// WorkflowType_Values returns all elements of the WorkflowType enum
func WorkflowType_Values() []string {
	return []string{
		WorkflowTypeAppflowIntegration,
	}
}

const (
	// ZendeskConnectorOperatorProjection is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorProjection = "PROJECTION"

	// ZendeskConnectorOperatorGreaterThan is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorGreaterThan = "GREATER_THAN"

	// ZendeskConnectorOperatorAddition is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorAddition = "ADDITION"

	// ZendeskConnectorOperatorMultiplication is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMultiplication = "MULTIPLICATION"

	// ZendeskConnectorOperatorDivision is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorDivision = "DIVISION"

	// ZendeskConnectorOperatorSubtraction is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorSubtraction = "SUBTRACTION"

	// ZendeskConnectorOperatorMaskAll is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMaskAll = "MASK_ALL"

	// ZendeskConnectorOperatorMaskFirstN is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// ZendeskConnectorOperatorMaskLastN is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMaskLastN = "MASK_LAST_N"

	// ZendeskConnectorOperatorValidateNonNull is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// ZendeskConnectorOperatorValidateNonZero is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// ZendeskConnectorOperatorValidateNonNegative is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// ZendeskConnectorOperatorValidateNumeric is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// ZendeskConnectorOperatorNoOp is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorNoOp = "NO_OP"
)

// ZendeskConnectorOperator_Values returns all elements of the ZendeskConnectorOperator enum
func ZendeskConnectorOperator_Values() []string {
	return []string{
		ZendeskConnectorOperatorProjection,
		ZendeskConnectorOperatorGreaterThan,
		ZendeskConnectorOperatorAddition,
		ZendeskConnectorOperatorMultiplication,
		ZendeskConnectorOperatorDivision,
		ZendeskConnectorOperatorSubtraction,
		ZendeskConnectorOperatorMaskAll,
		ZendeskConnectorOperatorMaskFirstN,
		ZendeskConnectorOperatorMaskLastN,
		ZendeskConnectorOperatorValidateNonNull,
		ZendeskConnectorOperatorValidateNonZero,
		ZendeskConnectorOperatorValidateNonNegative,
		ZendeskConnectorOperatorValidateNumeric,
		ZendeskConnectorOperatorNoOp,
	}
}
