/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.transformers;

import java.util.Map;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlExpression;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.tools.transfer.IDataTransferAttributeTransformer;

public class DataTransferTransformerExpression
implements IDataTransferAttributeTransformer {
    private JexlExpression jexlExpression;

    @Override
    public Object transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding[] dataAttributes, @NotNull Object[] dataRow, @NotNull DBDAttributeBinding attribute, Object attrValue, @NotNull Map<String, Object> options) throws DBException {
        JexlExpression jexlExpression = this.getJexlExpression(options);
        VariablesContext context = new VariablesContext(session, dataAttributes, dataRow);
        return jexlExpression.evaluate((JexlContext)context);
    }

    public JexlExpression getJexlExpression(Map<String, Object> options) throws DBCException {
        if (this.jexlExpression == null) {
            String expr = JSONUtils.getString(options, (String)"expression");
            if (expr == null) {
                throw new DBCException("Expression property not specified");
            }
            this.jexlExpression = DBVUtils.parseExpression((String)expr);
        }
        return this.jexlExpression;
    }

    private static class VariablesContext
    implements JexlContext {
        private final DBCSession session;
        private final DBDAttributeBinding[] dataAttributes;
        private final Object[] dataRow;

        public VariablesContext(DBCSession session, DBDAttributeBinding[] dataAttributes, Object[] dataRow) {
            this.session = session;
            this.dataAttributes = dataAttributes;
            this.dataRow = dataRow;
        }

        public Object get(String s) {
            DBDAttributeBinding[] dBDAttributeBindingArray = this.dataAttributes;
            int n = this.dataAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attribute = dBDAttributeBindingArray[n2];
                if (attribute.getName().equals(s)) {
                    return DBUtils.getAttributeValue((DBDAttributeBinding)attribute, (DBDAttributeBinding[])this.dataAttributes, (Object[])this.dataRow);
                }
                ++n2;
            }
            return null;
        }

        public void set(String s, Object o) {
        }

        public boolean has(String s) {
            DBDAttributeBinding[] dBDAttributeBindingArray = this.dataAttributes;
            int n = this.dataAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attribute = dBDAttributeBindingArray[n2];
                if (attribute.getName().equals(s)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

