/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.rm.RMResource;
import org.jkiss.utils.ArrayUtils;

public abstract class RMObject
implements DBPNamedObject {
    @Nullable
    private RMResource[] children;
    private String name;

    public RMObject() {
    }

    public RMObject(@NotNull String name) {
        this.name = name;
    }

    public abstract boolean isFolder();

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Nullable
    public RMResource[] getChildren() {
        return this.children;
    }

    public void setChildren(@NotNull RMResource[] resources) {
        this.children = resources;
    }

    @Nullable
    public RMResource getChild(@NotNull String name) {
        if (this.children != null) {
            RMResource[] rMResourceArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                RMResource child = rMResourceArray[n2];
                if (child.getName().equals(name)) {
                    return child;
                }
                ++n2;
            }
        }
        return null;
    }

    public void updateChild(@NotNull String name, @NotNull RMResource resource) {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                RMResource child = this.children[i];
                if (child.getName().equals(name)) {
                    this.children[i] = resource;
                    break;
                }
                ++i;
            }
        }
    }

    public void addChild(@NotNull RMResource child) {
        this.children = this.children == null ? new RMResource[]{child} : (RMResource[])ArrayUtils.add(RMResource.class, (Object[])this.children, (Object)child);
    }

    public void removeChild(@NotNull RMResource child) {
        this.children = this.children == null || this.children.length == 1 && this.children[0] == child ? null : (RMResource[])ArrayUtils.remove(RMResource.class, (Object[])this.children, (Object)child);
    }

    public String toString() {
        return this.getName();
    }
}

