/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.subsonic.booter.agent;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.subsonic.booter.agent.SubsonicAgent;
import net.sourceforge.subsonic.booter.agent.SubsonicListener;
import net.sourceforge.subsonic.booter.deployer.DeploymentStatus;

public class StatusPanel
extends JPanel
implements SubsonicListener {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final SubsonicAgent subsonicAgent;
    private JTextField statusTextField;
    private JTextField startedTextField;
    private JTextField memoryTextField;
    private JTextArea errorTextField;
    private JButton startButton;
    private JButton stopButton;
    private JButton urlButton;

    public StatusPanel(SubsonicAgent subsonicAgent) {
        this.subsonicAgent = subsonicAgent;
        this.createComponents();
        this.configureComponents();
        this.layoutComponents();
        this.addBehaviour();
        subsonicAgent.addListener(this);
    }

    private void createComponents() {
        this.statusTextField = new JTextField();
        this.startedTextField = new JTextField();
        this.memoryTextField = new JTextField();
        this.errorTextField = new JTextArea(3, 24);
        this.startButton = new JButton("Start");
        this.stopButton = new JButton("Stop");
        this.urlButton = new JButton();
    }

    private void configureComponents() {
        this.statusTextField.setEditable(false);
        this.startedTextField.setEditable(false);
        this.memoryTextField.setEditable(false);
        this.errorTextField.setEditable(false);
        this.errorTextField.setLineWrap(true);
        this.errorTextField.setBorder(this.startedTextField.getBorder());
        this.urlButton.setBorderPainted(false);
        this.urlButton.setContentAreaFilled(false);
        this.urlButton.setForeground(Color.BLUE.darker());
        this.urlButton.setHorizontalAlignment(2);
    }

    private void layoutComponents() {
        JPanel buttons = ButtonBarFactory.buildRightAlignedBar(this.startButton, this.stopButton);
        FormLayout layout = new FormLayout("right:d, 6dlu, max(d;30dlu):grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, this);
        builder.append("Service status", (Component)this.statusTextField);
        builder.append("", (Component)buttons);
        builder.appendParagraphGapRow();
        builder.nextRow();
        builder.append("Started on", (Component)this.startedTextField);
        builder.append("Memory used", (Component)this.memoryTextField);
        builder.append("Error message", (Component)this.errorTextField);
        builder.append("Server address", (Component)this.urlButton);
        this.setBorder(Borders.DIALOG_BORDER);
    }

    private void addBehaviour() {
        this.urlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.subsonicAgent.openBrowser();
            }
        });
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.subsonicAgent.checkElevation("-start");
                StatusPanel.this.subsonicAgent.startOrStopService(true);
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.subsonicAgent.checkElevation("-stop");
                StatusPanel.this.subsonicAgent.startOrStopService(false);
            }
        });
    }

    @Override
    public void notifyDeploymentStatus(DeploymentStatus status) {
        this.startedTextField.setText(status == null ? null : DATE_FORMAT.format(status.getStartTime()));
        this.memoryTextField.setText(status == null ? null : status.getMemoryUsed() + " MB");
        this.errorTextField.setText(status == null ? null : status.getErrorMessage());
        this.urlButton.setText(status == null ? null : status.getURL());
    }

    @Override
    public void notifyServiceStatus(String serviceStatus) {
        this.statusTextField.setText(serviceStatus);
    }
}

