/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MessageSourceSupport {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean alwaysUseMessageFormat = false;
    private final Map cachedMessageFormats = new HashMap();

    public void setAlwaysUseMessageFormat(boolean alwaysUseMessageFormat) {
        this.alwaysUseMessageFormat = alwaysUseMessageFormat;
    }

    protected boolean isAlwaysUseMessageFormat() {
        return this.alwaysUseMessageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatMessage(String msg, Object[] args, Locale locale) {
        if (msg == null || !this.alwaysUseMessageFormat && (args == null || args.length == 0)) {
            return msg;
        }
        MessageFormat messageFormat = null;
        Object object = this.cachedMessageFormats;
        synchronized (object) {
            messageFormat = (MessageFormat)this.cachedMessageFormats.get(msg);
            if (messageFormat == null) {
                messageFormat = this.createMessageFormat(msg, locale);
                this.cachedMessageFormats.put(msg, messageFormat);
            }
        }
        object = messageFormat;
        synchronized (object) {
            return messageFormat.format(this.resolveArguments(args, locale));
        }
    }

    protected MessageFormat createMessageFormat(String msg, Locale locale) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating MessageFormat for pattern [" + msg + "] and locale '" + locale + "'");
        }
        return new MessageFormat(msg != null ? msg : "", locale);
    }

    protected Object[] resolveArguments(Object[] args, Locale locale) {
        return args;
    }

    protected String renderDefaultMessage(String defaultMessage, Object[] args, Locale locale) {
        return this.formatMessage(defaultMessage, args, locale);
    }
}

