// Code generated by smithy-go-codegen DO NOT EDIT.

package codecommit

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codecommit/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about the differences in a valid commit specifier (such as
// a branch, tag, HEAD, commit ID, or other fully qualified reference). Results can
// be limited to a specified path.
func (c *Client) GetDifferences(ctx context.Context, params *GetDifferencesInput, optFns ...func(*Options)) (*GetDifferencesOutput, error) {
	if params == nil {
		params = &GetDifferencesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDifferences", params, optFns, c.addOperationGetDifferencesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDifferencesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDifferencesInput struct {

	// The branch, tag, HEAD, or other fully qualified reference used to identify a
	// commit.
	//
	// This member is required.
	AfterCommitSpecifier *string

	// The name of the repository where you want to get differences.
	//
	// This member is required.
	RepositoryName *string

	// The file path in which to check differences. Limits the results to this path.
	// Can also be used to specify the changed name of a directory or folder, if it has
	// changed. If not specified, differences are shown for all paths.
	AfterPath *string

	// The branch, tag, HEAD, or other fully qualified reference used to identify a
	// commit (for example, the full commit ID). Optional. If not specified, all
	// changes before the afterCommitSpecifier value are shown. If you do not use
	// beforeCommitSpecifier in your request, consider limiting the results with
	// maxResults .
	BeforeCommitSpecifier *string

	// The file path in which to check for differences. Limits the results to this
	// path. Can also be used to specify the previous name of a directory or folder. If
	// beforePath and afterPath are not specified, differences are shown for all paths.
	BeforePath *string

	// A non-zero, non-negative integer used to limit the number of returned results.
	MaxResults *int32

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetDifferencesOutput struct {

	// A data type object that contains information about the differences, including
	// whether the difference is added, modified, or deleted (A, D, M).
	Differences []types.Difference

	// An enumeration token that can be used in a request to return the next batch of
	// the results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDifferencesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetDifferences{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetDifferences{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDifferences"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetDifferencesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDifferences(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetDifferencesPaginatorOptions is the paginator options for GetDifferences
type GetDifferencesPaginatorOptions struct {
	// A non-zero, non-negative integer used to limit the number of returned results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetDifferencesPaginator is a paginator for GetDifferences
type GetDifferencesPaginator struct {
	options   GetDifferencesPaginatorOptions
	client    GetDifferencesAPIClient
	params    *GetDifferencesInput
	nextToken *string
	firstPage bool
}

// NewGetDifferencesPaginator returns a new GetDifferencesPaginator
func NewGetDifferencesPaginator(client GetDifferencesAPIClient, params *GetDifferencesInput, optFns ...func(*GetDifferencesPaginatorOptions)) *GetDifferencesPaginator {
	if params == nil {
		params = &GetDifferencesInput{}
	}

	options := GetDifferencesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetDifferencesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetDifferencesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetDifferences page.
func (p *GetDifferencesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetDifferencesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetDifferences(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetDifferencesAPIClient is a client that implements the GetDifferences
// operation.
type GetDifferencesAPIClient interface {
	GetDifferences(context.Context, *GetDifferencesInput, ...func(*Options)) (*GetDifferencesOutput, error)
}

var _ GetDifferencesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetDifferences(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDifferences",
	}
}
