/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.plugin.meta;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PluginDependency {
    private final String id;
    private final @Nullable String version;
    private final boolean optional;

    public PluginDependency(String id, @Nullable String version, boolean optional) {
        this.id = Preconditions.checkNotNull(id, "id");
        Preconditions.checkArgument(!id.isEmpty(), "id cannot be empty");
        this.version = Strings.emptyToNull(version);
        this.optional = optional;
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginDependency that = (PluginDependency)o;
        return this.optional == that.optional && Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.optional);
    }

    public String toString() {
        return "PluginDependency{id='" + this.id + '\'' + ", version='" + this.version + '\'' + ", optional=" + this.optional + '}';
    }
}

