/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.RawCommand;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.proxy.command.CommandNodeFactory;
import com.velocitypowered.proxy.command.VelocityCommandMeta;
import com.velocitypowered.proxy.plugin.VelocityEventManager;
import com.velocitypowered.proxy.util.BrigadierUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class VelocityCommandManager
implements CommandManager {
    private final CommandDispatcher<CommandSource> dispatcher;
    private final VelocityEventManager eventManager;

    public VelocityCommandManager(VelocityEventManager eventManager) {
        this.eventManager = Preconditions.checkNotNull(eventManager);
        this.dispatcher = new CommandDispatcher();
    }

    @Override
    public CommandMeta.Builder metaBuilder(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        return new VelocityCommandMeta.Builder(alias);
    }

    @Override
    public CommandMeta.Builder metaBuilder(BrigadierCommand command) {
        Preconditions.checkNotNull(command, "command");
        return new VelocityCommandMeta.Builder(command.getNode().getName());
    }

    @Override
    public void register(Command command, String ... aliases) {
        Preconditions.checkArgument(aliases.length > 0, "no aliases provided");
        this.register(aliases[0], command, Arrays.copyOfRange(aliases, 1, aliases.length));
    }

    @Override
    public void register(String alias, Command command, String ... otherAliases) {
        Preconditions.checkNotNull(alias, "alias");
        Preconditions.checkNotNull(command, "command");
        Preconditions.checkNotNull(otherAliases, "otherAliases");
        this.register(this.metaBuilder(alias).aliases(otherAliases).build(), command);
    }

    @Override
    public void register(BrigadierCommand command) {
        Preconditions.checkNotNull(command, "command");
        this.register(this.metaBuilder(command).build(), command);
    }

    @Override
    public void register(CommandMeta meta, Command command) {
        Preconditions.checkNotNull(meta, "meta");
        Preconditions.checkNotNull(command, "command");
        Iterator<String> aliasIterator = meta.getAliases().iterator();
        String primaryAlias = aliasIterator.next();
        LiteralCommandNode<CommandSource> node = null;
        if (command instanceof BrigadierCommand) {
            node = ((BrigadierCommand)command).getNode();
        } else if (command instanceof SimpleCommand) {
            node = CommandNodeFactory.SIMPLE.create(primaryAlias, (SimpleCommand)command);
        } else if (command instanceof RawCommand) {
            RawCommand asRaw = (RawCommand)command;
            try {
                asRaw.suggest(null, new String[0]);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                node = CommandNodeFactory.RAW.create(primaryAlias, asRaw);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (node == null) {
            node = CommandNodeFactory.FALLBACK.create(primaryAlias, command);
        }
        if (!(command instanceof BrigadierCommand)) {
            for (CommandNode commandNode : meta.getHints()) {
                node.addChild(BrigadierUtils.wrapForHinting(commandNode, node.getCommand()));
            }
        }
        this.dispatcher.getRoot().addChild(node);
        while (aliasIterator.hasNext()) {
            String currentAlias = aliasIterator.next();
            CommandNode commandNode = this.dispatcher.getRoot().getChild(currentAlias.toLowerCase(Locale.ENGLISH));
            if (commandNode != null) {
                this.dispatcher.getRoot().getChildren().remove(commandNode);
            }
            this.dispatcher.getRoot().addChild(BrigadierUtils.buildRedirect(currentAlias, node));
        }
    }

    @Override
    public void unregister(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        this.dispatcher.getRoot().removeChildByName(alias.toLowerCase(Locale.ENGLISH));
    }

    public CompletableFuture<CommandExecuteEvent> callCommandEvent(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        return this.eventManager.fire(new CommandExecuteEvent(source, cmdLine));
    }

    @Override
    public boolean execute(CommandSource source, String cmdLine) {
        return this.executeAsync(source, cmdLine).join();
    }

    @Override
    public boolean executeImmediately(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        ParseResults<CommandSource> results = this.parse(cmdLine, source, true);
        try {
            return this.dispatcher.execute(results) != -165120983;
        }
        catch (CommandSyntaxException e) {
            boolean isSyntaxError;
            boolean bl = isSyntaxError = !e.getType().equals(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand());
            if (isSyntaxError) {
                source.sendMessage(Identity.nil(), (Component)Component.text(e.getMessage(), (TextColor)NamedTextColor.RED));
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to invoke command " + cmdLine + " for " + source, e);
        }
    }

    @Override
    public CompletableFuture<Boolean> executeAsync(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        return this.callCommandEvent(source, cmdLine).thenApply(event -> {
            CommandExecuteEvent.CommandResult commandResult = event.getResult();
            if (commandResult.isForwardToServer() || !commandResult.isAllowed()) {
                return false;
            }
            return this.executeImmediately(source, commandResult.getCommand().orElse(event.getCommand()));
        });
    }

    @Override
    public CompletableFuture<Boolean> executeImmediatelyAsync(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        return CompletableFuture.supplyAsync(() -> this.executeImmediately(source, cmdLine), this.eventManager.getService());
    }

    public CompletableFuture<List<String>> offerSuggestions(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        ParseResults<CommandSource> parse = this.parse(cmdLine, source, false);
        return this.dispatcher.getCompletionSuggestions(parse).thenApply(suggestions -> Lists.transform(suggestions.getList(), Suggestion::getText));
    }

    private ParseResults<CommandSource> parse(String cmdLine, CommandSource source, boolean trim) {
        String normalized = BrigadierUtils.normalizeInput(cmdLine, trim);
        return this.dispatcher.parse(normalized, source);
    }

    @Override
    public boolean hasCommand(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        return this.dispatcher.getRoot().getChild(alias.toLowerCase(Locale.ENGLISH)) != null;
    }

    public CommandDispatcher<CommandSource> getDispatcher() {
        return this.dispatcher;
    }
}

