/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.google.common.base.Preconditions;
import com.google.common.net.UrlEscapers;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.permission.PermissionsSetupEvent;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.permission.PermissionFunction;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.api.util.UuidUtils;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.VelocityConstants;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.client.InitialConnectSessionHandler;
import com.velocitypowered.proxy.connection.client.InitialInboundConnection;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.Disconnect;
import com.velocitypowered.proxy.protocol.packet.EncryptionRequest;
import com.velocitypowered.proxy.protocol.packet.EncryptionResponse;
import com.velocitypowered.proxy.protocol.packet.ServerLogin;
import com.velocitypowered.proxy.protocol.packet.ServerLoginSuccess;
import com.velocitypowered.proxy.protocol.packet.SetCompression;
import com.velocitypowered.proxy.util.EncryptionUtils;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class LoginSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(LoginSessionHandler.class);
    private static final String MOJANG_HASJOINED_URL = "https://sessionserver.mojang.com/session/minecraft/hasJoined?username=%s&serverId=%s";
    private final VelocityServer server;
    private final MinecraftConnection mcConnection;
    private final InitialInboundConnection inbound;
    private @MonotonicNonNull ServerLogin login;
    private byte[] verify = VelocityConstants.EMPTY_BYTE_ARRAY;
    private @MonotonicNonNull ConnectedPlayer connectedPlayer;

    LoginSessionHandler(VelocityServer server, MinecraftConnection mcConnection, InitialInboundConnection inbound) {
        this.server = Preconditions.checkNotNull(server, "server");
        this.mcConnection = Preconditions.checkNotNull(mcConnection, "mcConnection");
        this.inbound = Preconditions.checkNotNull(inbound, "inbound");
    }

    @Override
    public boolean handle(ServerLogin packet) {
        this.login = packet;
        this.beginPreLogin();
        return true;
    }

    @Override
    public boolean handle(EncryptionResponse packet) {
        ServerLogin login = this.login;
        if (login == null) {
            throw new IllegalStateException("No ServerLogin packet received yet.");
        }
        if (this.verify.length == 0) {
            throw new IllegalStateException("No EncryptionRequest packet sent yet.");
        }
        try {
            KeyPair serverKeyPair = this.server.getServerKeyPair();
            byte[] decryptedVerifyToken = EncryptionUtils.decryptRsa(serverKeyPair, packet.getVerifyToken());
            if (!MessageDigest.isEqual(this.verify, decryptedVerifyToken)) {
                throw new IllegalStateException("Unable to successfully decrypt the verification token.");
            }
            byte[] decryptedSharedSecret = EncryptionUtils.decryptRsa(serverKeyPair, packet.getSharedSecret());
            String serverId = EncryptionUtils.generateServerId(decryptedSharedSecret, serverKeyPair.getPublic());
            String playerIp = ((InetSocketAddress)this.mcConnection.getRemoteAddress()).getHostString();
            String url = String.format(MOJANG_HASJOINED_URL, UrlEscapers.urlFormParameterEscaper().escape(login.getUsername()), serverId);
            if (this.server.getConfiguration().shouldPreventClientProxyConnections()) {
                url = url + "&ip=" + UrlEscapers.urlFormParameterEscaper().escape(playerIp);
            }
            ListenableFuture<Response> hasJoinedResponse = this.server.getAsyncHttpClient().prepareGet(url).execute();
            hasJoinedResponse.addListener(() -> {
                if (this.mcConnection.isClosed()) {
                    return;
                }
                try {
                    this.mcConnection.enableEncryption(decryptedSharedSecret);
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
                try {
                    Response profileResponse = (Response)hasJoinedResponse.get();
                    if (profileResponse.getStatusCode() == 200) {
                        this.initializePlayer(VelocityServer.GENERAL_GSON.fromJson(profileResponse.getResponseBody(), GameProfile.class), true);
                    } else if (profileResponse.getStatusCode() == 204) {
                        this.inbound.disconnect(this.server.getConfiguration().getMessages().getOnlineModeOnly());
                    } else {
                        logger.error("Got an unexpected error code {} whilst contacting Mojang to log in {} ({})", (Object)profileResponse.getStatusCode(), (Object)login.getUsername(), (Object)playerIp);
                        this.mcConnection.close(true);
                    }
                }
                catch (ExecutionException e) {
                    logger.error("Unable to authenticate with Mojang", (Throwable)e);
                    this.mcConnection.close(true);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }, this.mcConnection.eventLoop());
        }
        catch (GeneralSecurityException e) {
            logger.error("Unable to enable encryption", (Throwable)e);
            this.mcConnection.close(true);
        }
        return true;
    }

    private void beginPreLogin() {
        ServerLogin login = this.login;
        if (login == null) {
            throw new IllegalStateException("No ServerLogin packet received yet.");
        }
        PreLoginEvent event = new PreLoginEvent(this.inbound, login.getUsername());
        ((CompletableFuture)this.server.getEventManager().fire(event).thenRunAsync(() -> {
            if (this.mcConnection.isClosed()) {
                return;
            }
            PreLoginEvent.PreLoginComponentResult result = event.getResult();
            Optional<Component> disconnectReason = result.getReasonComponent();
            if (disconnectReason.isPresent()) {
                this.mcConnection.closeWith(Disconnect.create(disconnectReason.get(), this.inbound.getProtocolVersion()));
                return;
            }
            if (!result.isForceOfflineMode() && (this.server.getConfiguration().isOnlineMode() || result.isOnlineModeAllowed())) {
                EncryptionRequest request = this.generateEncryptionRequest();
                this.verify = Arrays.copyOf(request.getVerifyToken(), 4);
                this.mcConnection.write(request);
            } else {
                this.initializePlayer(GameProfile.forOfflinePlayer(login.getUsername()), false);
            }
        }, this.mcConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception in pre-login stage", (Throwable)ex);
            return null;
        });
    }

    private EncryptionRequest generateEncryptionRequest() {
        byte[] verify = new byte[4];
        ThreadLocalRandom.current().nextBytes(verify);
        EncryptionRequest request = new EncryptionRequest();
        request.setPublicKey(this.server.getServerKeyPair().getPublic().getEncoded());
        request.setVerifyToken(verify);
        return request;
    }

    private void initializePlayer(GameProfile profile, boolean onlineMode) {
        profile = this.mcConnection.getType().addGameProfileTokensIfRequired(profile, this.server.getConfiguration().getPlayerInfoForwardingMode());
        GameProfileRequestEvent profileRequestEvent = new GameProfileRequestEvent(this.inbound, profile, onlineMode);
        GameProfile finalProfile = profile;
        ((CompletableFuture)this.server.getEventManager().fire(profileRequestEvent).thenComposeAsync(profileEvent -> {
            ConnectedPlayer player;
            if (this.mcConnection.isClosed()) {
                return CompletableFuture.completedFuture(null);
            }
            this.connectedPlayer = player = new ConnectedPlayer(this.server, profileEvent.getGameProfile(), this.mcConnection, this.inbound.getVirtualHost().orElse(null), onlineMode);
            if (!this.server.canRegisterConnection(player)) {
                player.disconnect0(this.server.getConfiguration().getMessages().getAlreadyConnected(), true);
                return CompletableFuture.completedFuture(null);
            }
            logger.info("{} has connected", (Object)player);
            return this.server.getEventManager().fire(new PermissionsSetupEvent(player, ConnectedPlayer.DEFAULT_PERMISSIONS)).thenAcceptAsync(event -> {
                if (!this.mcConnection.isClosed()) {
                    PermissionFunction function = event.createFunction(player);
                    if (function == null) {
                        logger.error("A plugin permission provider {} provided an invalid permission function for player {}. This is a bug in the plugin, not in Velocity. Falling back to the default permission function.", (Object)event.getProvider().getClass().getName(), (Object)player.getUsername());
                    } else {
                        player.setPermissionFunction(function);
                    }
                    this.completeLoginProtocolPhaseAndInitialize(player);
                }
            }, (Executor)this.mcConnection.eventLoop());
        }, (Executor)this.mcConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception during connection of {}", (Object)finalProfile, ex);
            return null;
        });
    }

    private void completeLoginProtocolPhaseAndInitialize(ConnectedPlayer player) {
        int threshold = this.server.getConfiguration().getCompressionThreshold();
        if (threshold >= 0 && this.mcConnection.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            this.mcConnection.write(new SetCompression(threshold));
            this.mcConnection.setCompressionThreshold(threshold);
        }
        VelocityConfiguration configuration = this.server.getConfiguration();
        UUID playerUniqueId = player.getUniqueId();
        if (configuration.getPlayerInfoForwardingMode() == PlayerInfoForwarding.NONE) {
            playerUniqueId = UuidUtils.generateOfflinePlayerUuid(player.getUsername());
        }
        ServerLoginSuccess success = new ServerLoginSuccess();
        success.setUsername(player.getUsername());
        success.setUuid(playerUniqueId);
        this.mcConnection.write(success);
        this.mcConnection.setAssociation(player);
        this.mcConnection.setState(StateRegistry.PLAY);
        ((CompletableFuture)this.server.getEventManager().fire(new LoginEvent(player)).thenAcceptAsync(event -> {
            if (this.mcConnection.isClosed()) {
                this.server.getEventManager().fireAndForget(new DisconnectEvent((Player)player, DisconnectEvent.LoginStatus.CANCELLED_BY_USER_BEFORE_COMPLETE));
                return;
            }
            Optional<Component> reason = event.getResult().getReasonComponent();
            if (reason.isPresent()) {
                player.disconnect0(reason.get(), true);
            } else {
                if (!this.server.registerConnection(player)) {
                    player.disconnect0(this.server.getConfiguration().getMessages().getAlreadyConnected(), true);
                    return;
                }
                this.mcConnection.setSessionHandler(new InitialConnectSessionHandler(player));
                ((CompletableFuture)this.server.getEventManager().fire(new PostLoginEvent(player)).thenCompose(ignored -> this.connectToInitialServer(player))).exceptionally(ex -> {
                    logger.error("Exception while connecting {} to initial server", (Object)player, ex);
                    return null;
                });
            }
        }, (Executor)this.mcConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while completing login initialisation phase for {}", (Object)player, ex);
            return null;
        });
    }

    private CompletableFuture<Void> connectToInitialServer(ConnectedPlayer player) {
        Optional<RegisteredServer> initialFromConfig = player.getNextServerToTry();
        PlayerChooseInitialServerEvent event = new PlayerChooseInitialServerEvent(player, initialFromConfig.orElse(null));
        return this.server.getEventManager().fire(event).thenRunAsync(() -> {
            Optional<RegisteredServer> toTry = event.getInitialServer();
            if (!toTry.isPresent()) {
                player.disconnect0(this.server.getConfiguration().getMessages().getNoAvailableServers(), true);
                return;
            }
            player.createConnectionRequest(toTry.get()).fireAndForget();
        }, this.mcConnection.eventLoop());
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        this.mcConnection.close(true);
    }

    @Override
    public void disconnected() {
        if (this.connectedPlayer != null) {
            this.connectedPlayer.teardown();
        }
    }
}

