/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.title;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.title.GenericTitlePacket;
import io.netty.buffer.ByteBuf;

public class TitleClearPacket
extends GenericTitlePacket {
    public TitleClearPacket() {
        this.setAction(GenericTitlePacket.ActionType.HIDE);
    }

    @Override
    public void setAction(GenericTitlePacket.ActionType action) {
        if (action != GenericTitlePacket.ActionType.HIDE && action != GenericTitlePacket.ActionType.RESET) {
            throw new IllegalArgumentException("TitleClearPacket only accepts CLEAR and RESET actions");
        }
        super.setAction(action);
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        buf.writeBoolean(this.getAction() == GenericTitlePacket.ActionType.RESET);
    }

    public String toString() {
        return "TitleClearPacket{, resetTimes=" + (this.getAction() == GenericTitlePacket.ActionType.RESET) + '}';
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

