/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.jul.AbstractLoggerAdapter;
import org.apache.logging.log4j.jul.NoOpLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public class LogManager
extends java.util.logging.LogManager {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AbstractLoggerAdapter loggerAdapter;
    private final ThreadLocal<Set<String>> recursive = ThreadLocal.withInitial(HashSet::new);

    public LogManager() {
        AbstractLoggerAdapter adapter = null;
        String overrideAdaptorClassName = PropertiesUtil.getProperties().getStringProperty("log4j.jul.LoggerAdapter");
        if (overrideAdaptorClassName != null) {
            try {
                LOGGER.info("Trying to use LoggerAdaptor [{}] specified by Log4j property.", (Object)overrideAdaptorClassName);
                adapter = LoaderUtil.newCheckedInstanceOf(overrideAdaptorClassName, AbstractLoggerAdapter.class);
            }
            catch (Exception e) {
                LOGGER.error("Specified LoggerAdapter [{}] is incompatible.", (Object)overrideAdaptorClassName, (Object)e);
            }
        }
        if (adapter == null) {
            String adapterClassName;
            try {
                LoaderUtil.loadClass("org.apache.logging.log4j.core.Logger");
                adapterClassName = "org.apache.logging.log4j.jul.CoreLoggerAdapter";
            }
            catch (ClassNotFoundException ignored) {
                adapterClassName = "org.apache.logging.log4j.jul.ApiLoggerAdapter";
            }
            LOGGER.debug("Attempting to use {}", (Object)adapterClassName);
            try {
                adapter = LoaderUtil.newCheckedInstanceOf(adapterClassName, AbstractLoggerAdapter.class);
            }
            catch (Exception e) {
                throw LOGGER.throwing(new LoggingException(e));
            }
        }
        this.loggerAdapter = adapter;
        LOGGER.info("Registered Log4j as the java.util.logging.LogManager.");
    }

    @Override
    public boolean addLogger(java.util.logging.Logger logger) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.util.logging.Logger getLogger(String name) {
        LOGGER.trace("Call to LogManager.getLogger({})", (Object)name);
        Set<String> activeRequests = this.recursive.get();
        if (activeRequests.add(name)) {
            try {
                java.util.logging.Logger logger = (java.util.logging.Logger)this.loggerAdapter.getLogger(name);
                return logger;
            }
            finally {
                activeRequests.remove(name);
            }
        }
        LOGGER.warn("Recursive call to getLogger for {} ignored.", (Object)name);
        return new NoOpLogger(name);
    }

    @Override
    public Enumeration<String> getLoggerNames() {
        return Collections.enumeration(this.loggerAdapter.getLoggersInContext(this.loggerAdapter.getContext()).keySet());
    }
}

