/* !! AUTOGENERATED FILE - DO NOT MODIFY !! 

WebGLRenderingContextBase implementation for QJS
*/


static JSValue wgl_getContextAttributes(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_isContextLost(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getSupportedExtensions(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getExtension(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_activeTexture(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_attachShader(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint program = 0;
	GLuint shader = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	WGL_GET_GLID(shader, argv[1], WebGLShader_class_id);
	glAttachShader(program, shader);
	return ret_val_js;
}

static JSValue wgl_bindAttribLocation(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint program = 0;
	u32 index = 0;
	const char * name = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	WGL_GET_U32(index, argv[1]);
	WGL_GET_STRING(name, argv[2]);
	glBindAttribLocation(program, index, name);
	JS_FreeCString(ctx, name);
	return ret_val_js;
}

static JSValue wgl_bindBuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	GLuint buffer = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_GLID(buffer, argv[1], WebGLBuffer_class_id);
	glBindBuffer(target, buffer);
	return ret_val_js;
}

JSValue wgl_bindFramebuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_bindRenderbuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	GLuint renderbuffer = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_GLID(renderbuffer, argv[1], WebGLRenderbuffer_class_id);
	glBindRenderbuffer(target, renderbuffer);
	return ret_val_js;
}

static JSValue wgl_bindTexture(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_blendColor(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	Float red = 0;
	Float green = 0;
	Float blue = 0;
	Float alpha = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_FLOAT_CLAMP(red, argv[0]);
	WGL_GET_FLOAT_CLAMP(green, argv[1]);
	WGL_GET_FLOAT_CLAMP(blue, argv[2]);
	WGL_GET_FLOAT_CLAMP(alpha, argv[3]);
	glBlendColor(red, green, blue, alpha);
	return ret_val_js;
}

static JSValue wgl_blendEquation(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 mode = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(mode, argv[0]);
	glBlendEquation(mode);
	return ret_val_js;
}

static JSValue wgl_blendEquationSeparate(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 modeRGB = 0;
	u32 modeAlpha = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(modeRGB, argv[0]);
	WGL_GET_U32(modeAlpha, argv[1]);
	glBlendEquationSeparate(modeRGB, modeAlpha);
	return ret_val_js;
}

static JSValue wgl_blendFunc(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 sfactor = 0;
	u32 dfactor = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(sfactor, argv[0]);
	WGL_GET_U32(dfactor, argv[1]);
	glBlendFunc(sfactor, dfactor);
	return ret_val_js;
}

static JSValue wgl_blendFuncSeparate(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 srcRGB = 0;
	u32 dstRGB = 0;
	u32 srcAlpha = 0;
	u32 dstAlpha = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(srcRGB, argv[0]);
	WGL_GET_U32(dstRGB, argv[1]);
	WGL_GET_U32(srcAlpha, argv[2]);
	WGL_GET_U32(dstAlpha, argv[3]);
	glBlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
	return ret_val_js;
}

static JSValue wgl_bufferData(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	u8 * data = NULL;
	u32 data_size = 0;
	u32 usage = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	if(!JS_IsObject(argv[1])) {
		WGL_GET_U32(data_size, argv[1]);
	} else {
		data = wgl_GetArrayBuffer(ctx, &data_size, argv[1]);
	}
	WGL_GET_U32(usage, argv[2]);
	glBufferData(target, data_size, data, usage);
	return ret_val_js;
}

static JSValue wgl_bufferSubData(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	u64 offset = 0;
	u8 * data = NULL;
	u32 data_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_U64(offset, argv[1]);
	if(!JS_IsObject(argv[2])) {
		WGL_GET_U32(data_size, argv[2]);
	} else {
		data = wgl_GetArrayBuffer(ctx, &data_size, argv[2]);
	}
	glBufferSubData(target, (size_t) offset, data_size, data);
	return ret_val_js;
}

static JSValue wgl_checkFramebufferStatus(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	u32 target = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	u32 ret_val = 0;
	ret_val = glCheckFramebufferStatus(target);
	return JS_NewInt32(ctx, ret_val);
}

static JSValue wgl_clear(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 mask = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(mask, argv[0]);
	glClear(mask);
	return ret_val_js;
}

static JSValue wgl_clearColor(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	Float red = 0;
	Float green = 0;
	Float blue = 0;
	Float alpha = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_FLOAT_CLAMP(red, argv[0]);
	WGL_GET_FLOAT_CLAMP(green, argv[1]);
	WGL_GET_FLOAT_CLAMP(blue, argv[2]);
	WGL_GET_FLOAT_CLAMP(alpha, argv[3]);
	glClearColor(red, green, blue, alpha);
	return ret_val_js;
}

static JSValue wgl_clearDepth(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	Float depth = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_FLOAT_CLAMP(depth, argv[0]);
#if defined(GPAC_USE_GLES2)
	glClearDepthf(
#else
	glClearDepth(
#endif
		depth);
	return ret_val_js;
}

static JSValue wgl_clearStencil(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	s32 s = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_S32(s, argv[0]);
	glClearStencil(s);
	return ret_val_js;
}

static JSValue wgl_colorMask(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	Bool red = 0;
	Bool green = 0;
	Bool blue = 0;
	Bool alpha = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_BOOL(red, argv[0]);
	WGL_GET_BOOL(green, argv[1]);
	WGL_GET_BOOL(blue, argv[2]);
	WGL_GET_BOOL(alpha, argv[3]);
	glColorMask(red, green, blue, alpha);
	return ret_val_js;
}

static JSValue wgl_compileShader(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint shader = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(shader, argv[0], WebGLShader_class_id);
	glCompileShader(shader);
	return ret_val_js;
}

static JSValue wgl_compressedTexImage2D(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	s32 level = 0;
	u32 internalformat = 0;
	u32 width = 0;
	u32 height = 0;
	s32 border = 0;
	u8 * data = NULL;
	u32 data_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<7) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_S32(level, argv[1]);
	WGL_GET_U32(internalformat, argv[2]);
	WGL_GET_U32(width, argv[3]);
	WGL_GET_U32(height, argv[4]);
	WGL_GET_S32(border, argv[5]);
	if(!JS_IsArray(ctx, argv[6])) return js_throw_err(ctx, WGL_INVALID_VALUE);
	data = wgl_GetArrayBuffer(ctx, &data_size, argv[6]);
	glCompressedTexImage2D(target, level, internalformat, width, height, border, data_size, data);
	return ret_val_js;
}

static JSValue wgl_compressedTexSubImage2D(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	s32 level = 0;
	s32 xoffset = 0;
	s32 yoffset = 0;
	u32 width = 0;
	u32 height = 0;
	u32 format = 0;
	u8 * data = NULL;
	u32 data_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<8) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_S32(level, argv[1]);
	WGL_GET_S32(xoffset, argv[2]);
	WGL_GET_S32(yoffset, argv[3]);
	WGL_GET_U32(width, argv[4]);
	WGL_GET_U32(height, argv[5]);
	WGL_GET_U32(format, argv[6]);
	if(!JS_IsArray(ctx, argv[7])) return js_throw_err(ctx, WGL_INVALID_VALUE);
	data = wgl_GetArrayBuffer(ctx, &data_size, argv[7]);
	glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, data_size, data);
	return ret_val_js;
}

static JSValue wgl_copyTexImage2D(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	s32 level = 0;
	u32 internalformat = 0;
	s32 x = 0;
	s32 y = 0;
	u32 width = 0;
	u32 height = 0;
	s32 border = 0;
	WGL_CHECK_CONTEXT
	if (argc<8) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_S32(level, argv[1]);
	WGL_GET_U32(internalformat, argv[2]);
	WGL_GET_S32(x, argv[3]);
	WGL_GET_S32(y, argv[4]);
	WGL_GET_U32(width, argv[5]);
	WGL_GET_U32(height, argv[6]);
	WGL_GET_S32(border, argv[7]);
	glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
	return ret_val_js;
}

static JSValue wgl_copyTexSubImage2D(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	s32 level = 0;
	s32 xoffset = 0;
	s32 yoffset = 0;
	s32 x = 0;
	s32 y = 0;
	u32 width = 0;
	u32 height = 0;
	WGL_CHECK_CONTEXT
	if (argc<8) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_S32(level, argv[1]);
	WGL_GET_S32(xoffset, argv[2]);
	WGL_GET_S32(yoffset, argv[3]);
	WGL_GET_S32(x, argv[4]);
	WGL_GET_S32(y, argv[5]);
	WGL_GET_U32(width, argv[6]);
	WGL_GET_U32(height, argv[7]);
	glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
	return ret_val_js;
}

static JSValue wgl_createBuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js;
	WGL_CHECK_CONTEXT
	GF_WebGLObject *wglo;
	GF_SAFEALLOC(wglo, GF_WebGLObject);
	if (!wglo) return js_throw_err(ctx, WGL_OUT_OF_MEMORY);
	wglo->par_ctx = JS_GetOpaque(this_val, WebGLRenderingContextBase_class_id);
	glGenBuffers(1, &wglo->gl_id);
	ret_val_js = JS_NewObjectClass(ctx, WebGLBuffer_class_id);
	JS_SetOpaque(ret_val_js, wglo);
	wglo->obj = JS_DupValue(ctx, ret_val_js);
	wglo->class_id = WebGLBuffer_class_id;
	gf_list_add(wglo->par_ctx->all_objects, wglo);
	return ret_val_js;
}

static JSValue wgl_createFramebuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js;
	WGL_CHECK_CONTEXT
	GF_WebGLObject *wglo;
	GF_SAFEALLOC(wglo, GF_WebGLObject);
	if (!wglo) return js_throw_err(ctx, WGL_OUT_OF_MEMORY);
	wglo->par_ctx = JS_GetOpaque(this_val, WebGLRenderingContextBase_class_id);
	glGenFramebuffers(1, &wglo->gl_id);
	ret_val_js = JS_NewObjectClass(ctx, WebGLFramebuffer_class_id);
	JS_SetOpaque(ret_val_js, wglo);
	wglo->obj = JS_DupValue(ctx, ret_val_js);
	wglo->class_id = WebGLFramebuffer_class_id;
	gf_list_add(wglo->par_ctx->all_objects, wglo);
	return ret_val_js;
}

static JSValue wgl_createProgram(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js;
	WGL_CHECK_CONTEXT
	GF_WebGLObject *wglo;
	GF_SAFEALLOC(wglo, GF_WebGLObject);
	if (!wglo) return js_throw_err(ctx, WGL_OUT_OF_MEMORY);
	wglo->par_ctx = JS_GetOpaque(this_val, WebGLRenderingContextBase_class_id);
	wglo->gl_id = glCreateProgram();
	ret_val_js = JS_NewObjectClass(ctx, WebGLProgram_class_id);
	JS_SetOpaque(ret_val_js, wglo);
	wglo->obj = JS_DupValue(ctx, ret_val_js);
	wglo->class_id = WebGLProgram_class_id;
	gf_list_add(wglo->par_ctx->all_objects, wglo);
	return ret_val_js;
}

static JSValue wgl_createRenderbuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js;
	WGL_CHECK_CONTEXT
	GF_WebGLObject *wglo;
	GF_SAFEALLOC(wglo, GF_WebGLObject);
	if (!wglo) return js_throw_err(ctx, WGL_OUT_OF_MEMORY);
	wglo->par_ctx = JS_GetOpaque(this_val, WebGLRenderingContextBase_class_id);
	glGenRenderbuffers(1, &wglo->gl_id);
	ret_val_js = JS_NewObjectClass(ctx, WebGLRenderbuffer_class_id);
	JS_SetOpaque(ret_val_js, wglo);
	wglo->obj = JS_DupValue(ctx, ret_val_js);
	wglo->class_id = WebGLRenderbuffer_class_id;
	gf_list_add(wglo->par_ctx->all_objects, wglo);
	return ret_val_js;
}

static JSValue wgl_createShader(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js;
	u32 type = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(type, argv[0]);
	GF_WebGLObject *wglo;
	GF_SAFEALLOC(wglo, GF_WebGLObject);
	if (!wglo) return js_throw_err(ctx, WGL_OUT_OF_MEMORY);
	wglo->par_ctx = JS_GetOpaque(this_val, WebGLRenderingContextBase_class_id);
	wglo->gl_id = glCreateShader(type);
	ret_val_js = JS_NewObjectClass(ctx, WebGLShader_class_id);
	JS_SetOpaque(ret_val_js, wglo);
	wglo->obj = JS_DupValue(ctx, ret_val_js);
	wglo->class_id = WebGLShader_class_id;
	gf_list_add(wglo->par_ctx->all_objects, wglo);
	return ret_val_js;
}

static JSValue wgl_createTexture(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_cullFace(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 mode = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(mode, argv[0]);
	glCullFace(mode);
	return ret_val_js;
}

static JSValue wgl_deleteBuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint buffer = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(buffer, argv[0], WebGLBuffer_class_id);
	glDeleteBuffers(1, &buffer);
	{
	GF_WebGLObject *glo = JS_GetOpaque(argv[0], WebGLBuffer_class_id);
	if (glo) {
	glo->gl_id=0;
	JS_FreeValue(ctx, glo->obj);
	glo->obj = JS_UNDEFINED;
	gf_list_del_item(glo->par_ctx->all_objects, glo);
	}
	}
	return ret_val_js;
}

static JSValue wgl_deleteFramebuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint framebuffer = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(framebuffer, argv[0], WebGLFramebuffer_class_id);
	glDeleteFramebuffers(1, &framebuffer);
	{
	GF_WebGLObject *glo = JS_GetOpaque(argv[0], WebGLFramebuffer_class_id);
	if (glo) {
	glo->gl_id=0;
	JS_FreeValue(ctx, glo->obj);
	glo->obj = JS_UNDEFINED;
	gf_list_del_item(glo->par_ctx->all_objects, glo);
	}
	}
	return ret_val_js;
}

static JSValue wgl_deleteProgram(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint program = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	glDeleteProgram(program);
	{
	GF_WebGLObject *glo = JS_GetOpaque(argv[0], WebGLProgram_class_id);
	if (glo) {
	glo->gl_id=0;
	JS_FreeValue(ctx, glo->obj);
	glo->obj = JS_UNDEFINED;
	gf_list_del_item(glo->par_ctx->all_objects, glo);
	}
	}
	return ret_val_js;
}

static JSValue wgl_deleteRenderbuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint renderbuffer = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(renderbuffer, argv[0], WebGLRenderbuffer_class_id);
	glDeleteRenderbuffers(1, &renderbuffer);
	{
	GF_WebGLObject *glo = JS_GetOpaque(argv[0], WebGLRenderbuffer_class_id);
	if (glo) {
	glo->gl_id=0;
	JS_FreeValue(ctx, glo->obj);
	glo->obj = JS_UNDEFINED;
	gf_list_del_item(glo->par_ctx->all_objects, glo);
	}
	}
	return ret_val_js;
}

static JSValue wgl_deleteShader(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint shader = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(shader, argv[0], WebGLShader_class_id);
	glDeleteShader(shader);
	{
	GF_WebGLObject *glo = JS_GetOpaque(argv[0], WebGLShader_class_id);
	if (glo) {
	glo->gl_id=0;
	JS_FreeValue(ctx, glo->obj);
	glo->obj = JS_UNDEFINED;
	gf_list_del_item(glo->par_ctx->all_objects, glo);
	}
	}
	return ret_val_js;
}

static JSValue wgl_deleteTexture(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint texture = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(texture, argv[0], WebGLTexture_class_id);
	glDeleteTextures(1, &texture);
	{
	GF_WebGLObject *glo = JS_GetOpaque(argv[0], WebGLTexture_class_id);
	if (glo) {
	glo->gl_id=0;
	JS_FreeValue(ctx, glo->obj);
	glo->obj = JS_UNDEFINED;
	gf_list_del_item(glo->par_ctx->all_objects, glo);
	}
	}
	return ret_val_js;
}

static JSValue wgl_depthFunc(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 func = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(func, argv[0]);
	glDepthFunc(func);
	return ret_val_js;
}

static JSValue wgl_depthMask(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	Bool flag = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_BOOL(flag, argv[0]);
	glDepthMask(flag);
	return ret_val_js;
}

static JSValue wgl_depthRange(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	Float zNear = 0;
	Float zFar = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_FLOAT_CLAMP(zNear, argv[0]);
	WGL_GET_FLOAT_CLAMP(zFar, argv[1]);
#if defined(GPAC_USE_GLES2)
	glDepthRangef(
#else
	glDepthRange(
#endif
		zNear, zFar);
	return ret_val_js;
}

static JSValue wgl_detachShader(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint program = 0;
	GLuint shader = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	WGL_GET_GLID(shader, argv[1], WebGLShader_class_id);
	glDetachShader(program, shader);
	return ret_val_js;
}

static JSValue wgl_disable(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 cap = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(cap, argv[0]);
	glDisable(cap);
	return ret_val_js;
}

static JSValue wgl_disableVertexAttribArray(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 index = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(index, argv[0]);
	glDisableVertexAttribArray(index);
	return ret_val_js;
}

static JSValue wgl_drawArrays(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 mode = 0;
	s32 first = 0;
	u32 count = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(mode, argv[0]);
	WGL_GET_S32(first, argv[1]);
	WGL_GET_U32(count, argv[2]);
	glDrawArrays(mode, first, count);
	return ret_val_js;
}

static JSValue wgl_drawElements(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 mode = 0;
	u32 count = 0;
	u32 type = 0;
	u64 offset = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(mode, argv[0]);
	WGL_GET_U32(count, argv[1]);
	WGL_GET_U32(type, argv[2]);
	WGL_GET_U64(offset, argv[3]);
#ifdef GPAC_64_BITS
	glDrawElements(mode, count, type, (void *)offset);
#else
	glDrawElements(mode, count, type, (void *) (u32) offset);
#endif
	return ret_val_js;
}

static JSValue wgl_enable(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 cap = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(cap, argv[0]);
	glEnable(cap);
	return ret_val_js;
}

static JSValue wgl_enableVertexAttribArray(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 index = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(index, argv[0]);
	glEnableVertexAttribArray(index);
	return ret_val_js;
}

static JSValue wgl_finish(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	WGL_CHECK_CONTEXT
	glFinish();
	return ret_val_js;
}

static JSValue wgl_flush(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	WGL_CHECK_CONTEXT
	glFlush();
	return ret_val_js;
}

static JSValue wgl_framebufferRenderbuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	u32 attachment = 0;
	u32 renderbuffertarget = 0;
	GLuint renderbuffer = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_U32(attachment, argv[1]);
	WGL_GET_U32(renderbuffertarget, argv[2]);
	WGL_GET_GLID(renderbuffer, argv[3], WebGLRenderbuffer_class_id);
	glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
	return ret_val_js;
}

static JSValue wgl_framebufferTexture2D(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	u32 attachment = 0;
	u32 textarget = 0;
	GLuint texture = 0;
	s32 level = 0;
	WGL_CHECK_CONTEXT
	if (argc<5) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_U32(attachment, argv[1]);
	WGL_GET_U32(textarget, argv[2]);
	WGL_GET_GLID(texture, argv[3], WebGLTexture_class_id);
	WGL_GET_S32(level, argv[4]);
	glFramebufferTexture2D(target, attachment, textarget, texture, level);
	return ret_val_js;
}

static JSValue wgl_frontFace(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 mode = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(mode, argv[0]);
	glFrontFace(mode);
	return ret_val_js;
}

static JSValue wgl_generateMipmap(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	glGenerateMipmap(target);
	return ret_val_js;
}

static JSValue wgl_getActiveAttrib(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	GLuint program = 0;
	u32 index = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	WGL_GET_U32(index, argv[1]);
	return webgl_getActiveAttrib(ctx, program, index);
}

static JSValue wgl_getActiveUniform(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	GLuint program = 0;
	u32 index = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	WGL_GET_U32(index, argv[1]);
	return webgl_getActiveUniform(ctx, program, index);
}

static JSValue wgl_getAttachedShaders(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	GLuint program = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	return webgl_getAttachedShaders(ctx, JS_GetOpaque(this_val, WebGLRenderingContextBase_class_id), program);
}

static JSValue wgl_getAttribLocation(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	GLuint program = 0;
	const char * name = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	WGL_GET_STRING(name, argv[1]);
	s32 ret_val = 0;
	ret_val = glGetAttribLocation(program, name);
	JS_FreeCString(ctx, name);
	return JS_NewInt32(ctx, ret_val);
}

static JSValue wgl_getBufferParameter(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getParameter(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getError(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js;
	WGL_CHECK_CONTEXT
	u32 ret_val = 0;
	ret_val = glGetError();
	ret_val_js = JS_NewInt32(ctx, ret_val);
	return ret_val_js;
}

static JSValue wgl_getFramebufferAttachmentParameter(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getProgramParameter(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getProgramInfoLog(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getRenderbufferParameter(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getShaderParameter(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getShaderPrecisionFormat(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getShaderInfoLog(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getShaderSource(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getTexParameter(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getUniform(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getUniformLocation(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getVertexAttrib(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_getVertexAttribOffset(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_hint(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	u32 mode = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_U32(mode, argv[1]);
	glHint(target, mode);
	return ret_val_js;
}

static JSValue wgl_isBuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	GLuint buffer = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(buffer, argv[0], WebGLBuffer_class_id);
	Bool ret_val = 0;
	ret_val = glIsBuffer(buffer);
	return JS_NewBool(ctx, ret_val);
}

static JSValue wgl_isEnabled(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	u32 cap = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(cap, argv[0]);
	Bool ret_val = 0;
	ret_val = glIsEnabled(cap);
	return JS_NewBool(ctx, ret_val);
}

static JSValue wgl_isFramebuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	GLuint framebuffer = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(framebuffer, argv[0], WebGLFramebuffer_class_id);
	Bool ret_val = 0;
	ret_val = glIsFramebuffer(framebuffer);
	return JS_NewBool(ctx, ret_val);
}

static JSValue wgl_isProgram(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	GLuint program = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	Bool ret_val = 0;
	ret_val = glIsProgram(program);
	return JS_NewBool(ctx, ret_val);
}

static JSValue wgl_isRenderbuffer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	GLuint renderbuffer = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(renderbuffer, argv[0], WebGLRenderbuffer_class_id);
	Bool ret_val = 0;
	ret_val = glIsRenderbuffer(renderbuffer);
	return JS_NewBool(ctx, ret_val);
}

static JSValue wgl_isShader(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	GLuint shader = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(shader, argv[0], WebGLShader_class_id);
	Bool ret_val = 0;
	ret_val = glIsShader(shader);
	return JS_NewBool(ctx, ret_val);
}

static JSValue wgl_isTexture(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	GLuint texture = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(texture, argv[0], WebGLTexture_class_id);
	Bool ret_val = 0;
	ret_val = glIsTexture(texture);
	return JS_NewBool(ctx, ret_val);
}

static JSValue wgl_lineWidth(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	Float width = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_FLOAT(width, argv[0]);
	glLineWidth(width);
	return ret_val_js;
}

static JSValue wgl_linkProgram(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint program = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	glLinkProgram(program);
	return ret_val_js;
}

JSValue wgl_pixelStorei(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_polygonOffset(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	Float factor = 0;
	Float units = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_FLOAT(factor, argv[0]);
	WGL_GET_FLOAT(units, argv[1]);
	glPolygonOffset(factor, units);
	return ret_val_js;
}

static JSValue wgl_readPixels(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_renderbufferStorage(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	u32 internalformat = 0;
	u32 width = 0;
	u32 height = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_U32(internalformat, argv[1]);
	WGL_GET_U32(width, argv[2]);
	WGL_GET_U32(height, argv[3]);
	glRenderbufferStorage(target, internalformat, width, height);
	return ret_val_js;
}

static JSValue wgl_sampleCoverage(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	Float value = 0;
	Bool invert = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_FLOAT_CLAMP(value, argv[0]);
	WGL_GET_BOOL(invert, argv[1]);
	glSampleCoverage(value, invert);
	return ret_val_js;
}

static JSValue wgl_scissor(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	s32 x = 0;
	s32 y = 0;
	u32 width = 0;
	u32 height = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_S32(x, argv[0]);
	WGL_GET_S32(y, argv[1]);
	WGL_GET_U32(width, argv[2]);
	WGL_GET_U32(height, argv[3]);
	glScissor(x, y, width, height);
	return ret_val_js;
}

static JSValue wgl_shaderSource(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_stencilFunc(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 func = 0;
	s32 ref = 0;
	u32 mask = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(func, argv[0]);
	WGL_GET_S32(ref, argv[1]);
	WGL_GET_U32(mask, argv[2]);
	glStencilFunc(func, ref, mask);
	return ret_val_js;
}

static JSValue wgl_stencilFuncSeparate(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 face = 0;
	u32 func = 0;
	s32 ref = 0;
	u32 mask = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(face, argv[0]);
	WGL_GET_U32(func, argv[1]);
	WGL_GET_S32(ref, argv[2]);
	WGL_GET_U32(mask, argv[3]);
	glStencilFuncSeparate(face, func, ref, mask);
	return ret_val_js;
}

static JSValue wgl_stencilMask(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 mask = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(mask, argv[0]);
	glStencilMask(mask);
	return ret_val_js;
}

static JSValue wgl_stencilMaskSeparate(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 face = 0;
	u32 mask = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(face, argv[0]);
	WGL_GET_U32(mask, argv[1]);
	glStencilMaskSeparate(face, mask);
	return ret_val_js;
}

static JSValue wgl_stencilOp(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 fail = 0;
	u32 zfail = 0;
	u32 zpass = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(fail, argv[0]);
	WGL_GET_U32(zfail, argv[1]);
	WGL_GET_U32(zpass, argv[2]);
	glStencilOp(fail, zfail, zpass);
	return ret_val_js;
}

static JSValue wgl_stencilOpSeparate(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 face = 0;
	u32 fail = 0;
	u32 zfail = 0;
	u32 zpass = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(face, argv[0]);
	WGL_GET_U32(fail, argv[1]);
	WGL_GET_U32(zfail, argv[2]);
	WGL_GET_U32(zpass, argv[3]);
	glStencilOpSeparate(face, fail, zfail, zpass);
	return ret_val_js;
}

static JSValue wgl_texImage2D(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_texParameterf(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	u32 pname = 0;
	Float param = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_U32(pname, argv[1]);
	WGL_GET_FLOAT(param, argv[2]);
	glTexParameterf(target, pname, param);
	return ret_val_js;
}

static JSValue wgl_texParameteri(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 target = 0;
	u32 pname = 0;
	s32 param = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(target, argv[0]);
	WGL_GET_U32(pname, argv[1]);
	WGL_GET_S32(param, argv[2]);
	glTexParameteri(target, pname, param);
	return ret_val_js;
}

static JSValue wgl_texSubImage2D(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_uniform1f(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Float x = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_FLOAT(x, argv[1]);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform1f(location, x);
	return ret_val_js;
}

static JSValue wgl_uniform1fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Float * v = NULL;
	u32 v_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[1], (Float **) &v, &v_size, 1, 0)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform1fv(location, v_size, v);
	if (v) gf_free(v);
	return ret_val_js;
}

static JSValue wgl_uniform1i(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	s32 x = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_S32(x, argv[1]);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform1i(location, x);
	return ret_val_js;
}

static JSValue wgl_uniform1iv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	s32 * v = NULL;
	u32 v_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	if (!WGL_LOAD_INT32_VEC(ctx, argv[1], (s32 **) &v, &v_size, 1)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform1iv(location, v_size, v);
	if (v) gf_free(v);
	return ret_val_js;
}

static JSValue wgl_uniform2f(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Float x = 0;
	Float y = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_FLOAT(x, argv[1]);
	WGL_GET_FLOAT(y, argv[2]);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform2f(location, x, y);
	return ret_val_js;
}

static JSValue wgl_uniform2fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Float * v = NULL;
	u32 v_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[1], (Float **) &v, &v_size, 2, 0)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform2fv(location, v_size, v);
	if (v) gf_free(v);
	return ret_val_js;
}

static JSValue wgl_uniform2i(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	s32 x = 0;
	s32 y = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_S32(x, argv[1]);
	WGL_GET_S32(y, argv[2]);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform2i(location, x, y);
	return ret_val_js;
}

static JSValue wgl_uniform2iv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	s32 * v = NULL;
	u32 v_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	if (!WGL_LOAD_INT32_VEC(ctx, argv[1], (s32 **) &v, &v_size, 1)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform2iv(location, v_size, v);
	if (v) gf_free(v);
	return ret_val_js;
}

static JSValue wgl_uniform3f(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Float x = 0;
	Float y = 0;
	Float z = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_FLOAT(x, argv[1]);
	WGL_GET_FLOAT(y, argv[2]);
	WGL_GET_FLOAT(z, argv[3]);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform3f(location, x, y, z);
	return ret_val_js;
}

static JSValue wgl_uniform3fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Float * v = NULL;
	u32 v_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[1], (Float **) &v, &v_size, 3, 0)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform3fv(location, v_size, v);
	if (v) gf_free(v);
	return ret_val_js;
}

static JSValue wgl_uniform3i(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	s32 x = 0;
	s32 y = 0;
	s32 z = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_S32(x, argv[1]);
	WGL_GET_S32(y, argv[2]);
	WGL_GET_S32(z, argv[3]);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform3i(location, x, y, z);
	return ret_val_js;
}

static JSValue wgl_uniform3iv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	s32 * v = NULL;
	u32 v_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	if (!WGL_LOAD_INT32_VEC(ctx, argv[1], (s32 **) &v, &v_size, 1)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform3iv(location, v_size, v);
	if (v) gf_free(v);
	return ret_val_js;
}

static JSValue wgl_uniform4f(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Float x = 0;
	Float y = 0;
	Float z = 0;
	Float w = 0;
	WGL_CHECK_CONTEXT
	if (argc<5) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_FLOAT(x, argv[1]);
	WGL_GET_FLOAT(y, argv[2]);
	WGL_GET_FLOAT(z, argv[3]);
	WGL_GET_FLOAT(w, argv[4]);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform4f(location, x, y, z, w);
	return ret_val_js;
}

static JSValue wgl_uniform4fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Float * v = NULL;
	u32 v_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[1], (Float **) &v, &v_size, 4, 0)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform4fv(location, v_size, v);
	if (v) gf_free(v);
	return ret_val_js;
}

static JSValue wgl_uniform4i(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	s32 x = 0;
	s32 y = 0;
	s32 z = 0;
	s32 w = 0;
	WGL_CHECK_CONTEXT
	if (argc<5) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_S32(x, argv[1]);
	WGL_GET_S32(y, argv[2]);
	WGL_GET_S32(z, argv[3]);
	WGL_GET_S32(w, argv[4]);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform4i(location, x, y, z, w);
	return ret_val_js;
}

static JSValue wgl_uniform4iv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	s32 * v = NULL;
	u32 v_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	if (!WGL_LOAD_INT32_VEC(ctx, argv[1], (s32 **) &v, &v_size, 1)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniform4iv(location, v_size, v);
	if (v) gf_free(v);
	return ret_val_js;
}

static JSValue wgl_uniformMatrix2fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Bool transpose = 0;
	Float * value = NULL;
	u32 value_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_BOOL(transpose, argv[1]);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[2], (Float **) &value, &value_size, 2, 1)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniformMatrix2fv(location, value_size, transpose, value);
	if (value) gf_free(value);
	return ret_val_js;
}

static JSValue wgl_uniformMatrix3fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Bool transpose = 0;
	Float * value = NULL;
	u32 value_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_BOOL(transpose, argv[1]);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[2], (Float **) &value, &value_size, 3, 1)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniformMatrix3fv(location, value_size, transpose, value);
	if (value) gf_free(value);
	return ret_val_js;
}

static JSValue wgl_uniformMatrix4fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint location = 0;
	Bool transpose = 0;
	Float * value = NULL;
	u32 value_size = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(location, argv[0], WebGLUniformLocation_class_id);
	WGL_GET_BOOL(transpose, argv[1]);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[2], (Float **) &value, &value_size, 4, 1)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	/*hack for GPAC textures, we create uniforms with loc -2 for such textures*/
	if ((s32) location>=0)
		glUniformMatrix4fv(location, value_size, transpose, value);
	if (value) gf_free(value);
	return ret_val_js;
}

static JSValue wgl_useProgram(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

static JSValue wgl_validateProgram(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	GLuint program = 0;
	WGL_CHECK_CONTEXT
	if (argc<1) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_GLID(program, argv[0], WebGLProgram_class_id);
	glValidateProgram(program);
	return ret_val_js;
}

static JSValue wgl_vertexAttrib1f(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 indx = 0;
	Float x = 0;
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(indx, argv[0]);
	WGL_GET_FLOAT(x, argv[1]);
	glVertexAttrib1f(indx, x);
	return ret_val_js;
}

static JSValue wgl_vertexAttrib1fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 indx = 0;
	Float values[1];
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(indx, argv[0]);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[1], (Float **) &values, NULL, 1, 0)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	glVertexAttrib1fv(indx, values);
	return ret_val_js;
}

static JSValue wgl_vertexAttrib2f(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 indx = 0;
	Float x = 0;
	Float y = 0;
	WGL_CHECK_CONTEXT
	if (argc<3) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(indx, argv[0]);
	WGL_GET_FLOAT(x, argv[1]);
	WGL_GET_FLOAT(y, argv[2]);
	glVertexAttrib2f(indx, x, y);
	return ret_val_js;
}

static JSValue wgl_vertexAttrib2fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 indx = 0;
	Float values[2];
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(indx, argv[0]);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[1], (Float **) &values, NULL, 2, 0)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	glVertexAttrib2fv(indx, values);
	return ret_val_js;
}

static JSValue wgl_vertexAttrib3f(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 indx = 0;
	Float x = 0;
	Float y = 0;
	Float z = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(indx, argv[0]);
	WGL_GET_FLOAT(x, argv[1]);
	WGL_GET_FLOAT(y, argv[2]);
	WGL_GET_FLOAT(z, argv[3]);
	glVertexAttrib3f(indx, x, y, z);
	return ret_val_js;
}

static JSValue wgl_vertexAttrib3fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 indx = 0;
	Float values[3];
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(indx, argv[0]);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[1], (Float **) &values, NULL, 3, 0)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	glVertexAttrib3fv(indx, values);
	return ret_val_js;
}

static JSValue wgl_vertexAttrib4f(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 indx = 0;
	Float x = 0;
	Float y = 0;
	Float z = 0;
	Float w = 0;
	WGL_CHECK_CONTEXT
	if (argc<5) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(indx, argv[0]);
	WGL_GET_FLOAT(x, argv[1]);
	WGL_GET_FLOAT(y, argv[2]);
	WGL_GET_FLOAT(z, argv[3]);
	WGL_GET_FLOAT(w, argv[4]);
	glVertexAttrib4f(indx, x, y, z, w);
	return ret_val_js;
}

static JSValue wgl_vertexAttrib4fv(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 indx = 0;
	Float values[4];
	WGL_CHECK_CONTEXT
	if (argc<2) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(indx, argv[0]);
	if (!WGL_LOAD_FLOAT_VEC(ctx, argv[1], (Float **) &values, NULL, 4, 0)) return js_throw_err(ctx, WGL_INVALID_VALUE);
	glVertexAttrib4fv(indx, values);
	return ret_val_js;
}

static JSValue wgl_vertexAttribPointer(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	u32 indx = 0;
	s32 size = 0;
	u32 type = 0;
	Bool normalized = 0;
	u32 stride = 0;
	u64 offset = 0;
	WGL_CHECK_CONTEXT
	if (argc<6) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_U32(indx, argv[0]);
	WGL_GET_S32(size, argv[1]);
	WGL_GET_U32(type, argv[2]);
	WGL_GET_BOOL(normalized, argv[3]);
	WGL_GET_U32(stride, argv[4]);
	WGL_GET_U64(offset, argv[5]);
#ifdef GPAC_64_BITS
	glVertexAttribPointer(indx, size, type, normalized, stride, (void *)offset);
#else
	glVertexAttribPointer(indx, size, type, normalized, stride, (void *)(u32)offset);
#endif
	return ret_val_js;
}

static JSValue wgl_viewport(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
{
	JSValue ret_val_js = JS_UNDEFINED;
	s32 x = 0;
	s32 y = 0;
	u32 width = 0;
	u32 height = 0;
	WGL_CHECK_CONTEXT
	if (argc<4) return js_throw_err(ctx, WGL_INVALID_VALUE);
	WGL_GET_S32(x, argv[0]);
	WGL_GET_S32(y, argv[1]);
	WGL_GET_U32(width, argv[2]);
	WGL_GET_U32(height, argv[3]);
	glViewport(x, y, width, height);
	return ret_val_js;
}
static const JSCFunctionListEntry WebGLRenderingContextBase_funcs[] =
{
	JS_PROP_INT32_DEF("DEPTH_BUFFER_BIT", 0x00000100, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_BUFFER_BIT", 0x00000400, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("COLOR_BUFFER_BIT", 0x00004000, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("POINTS", 0x0000, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LINES", 0x0001, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LINE_LOOP", 0x0002, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LINE_STRIP", 0x0003, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TRIANGLES", 0x0004, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TRIANGLE_STRIP", 0x0005, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TRIANGLE_FAN", 0x0006, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ZERO", 0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ONE", 1, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SRC_COLOR", 0x0300, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ONE_MINUS_SRC_COLOR", 0x0301, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SRC_ALPHA", 0x0302, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ONE_MINUS_SRC_ALPHA", 0x0303, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DST_ALPHA", 0x0304, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ONE_MINUS_DST_ALPHA", 0x0305, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DST_COLOR", 0x0306, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ONE_MINUS_DST_COLOR", 0x0307, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SRC_ALPHA_SATURATE", 0x0308, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FUNC_ADD", 0x8006, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BLEND_EQUATION", 0x8009, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BLEND_EQUATION_ALPHA", 0x883D, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FUNC_SUBTRACT", 0x800A, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FUNC_REVERSE_SUBTRACT", 0x800B, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BLEND_DST_RGB", 0x80C8, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BLEND_SRC_RGB", 0x80C9, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BLEND_DST_ALPHA", 0x80CA, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BLEND_SRC_ALPHA", 0x80CB, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("CONSTANT_COLOR", 0x8001, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ONE_MINUS_CONSTANT_COLOR", 0x8002, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("CONSTANT_ALPHA", 0x8003, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ONE_MINUS_CONSTANT_ALPHA", 0x8004, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BLEND_COLOR", 0x8005, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ARRAY_BUFFER", 0x8892, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ELEMENT_ARRAY_BUFFER", 0x8893, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ARRAY_BUFFER_BINDING", 0x8894, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ELEMENT_ARRAY_BUFFER_BINDING", 0x8895, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STREAM_DRAW", 0x88E0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STATIC_DRAW", 0x88E4, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DYNAMIC_DRAW", 0x88E8, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BUFFER_SIZE", 0x8764, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BUFFER_USAGE", 0x8765, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("CURRENT_VERTEX_ATTRIB", 0x8626, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRONT", 0x0404, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BACK", 0x0405, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRONT_AND_BACK", 0x0408, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("CULL_FACE", 0x0B44, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BLEND", 0x0BE2, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DITHER", 0x0BD0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_TEST", 0x0B90, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_TEST", 0x0B71, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SCISSOR_TEST", 0x0C11, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("POLYGON_OFFSET_FILL", 0x8037, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SAMPLE_ALPHA_TO_COVERAGE", 0x809E, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SAMPLE_COVERAGE", 0x80A0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("NO_ERROR", 0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INVALID_ENUM", 0x0500, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INVALID_VALUE", 0x0501, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INVALID_OPERATION", 0x0502, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("OUT_OF_MEMORY", 0x0505, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("CW", 0x0900, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("CCW", 0x0901, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LINE_WIDTH", 0x0B21, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ALIASED_POINT_SIZE_RANGE", 0x846D, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ALIASED_LINE_WIDTH_RANGE", 0x846E, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("CULL_FACE_MODE", 0x0B45, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRONT_FACE", 0x0B46, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_RANGE", 0x0B70, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_WRITEMASK", 0x0B72, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_CLEAR_VALUE", 0x0B73, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_FUNC", 0x0B74, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_CLEAR_VALUE", 0x0B91, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_FUNC", 0x0B92, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_FAIL", 0x0B94, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_PASS_DEPTH_FAIL", 0x0B95, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_PASS_DEPTH_PASS", 0x0B96, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_REF", 0x0B97, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_VALUE_MASK", 0x0B93, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_WRITEMASK", 0x0B98, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_BACK_FUNC", 0x8800, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_BACK_FAIL", 0x8801, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_BACK_PASS_DEPTH_FAIL", 0x8802, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_BACK_PASS_DEPTH_PASS", 0x8803, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_BACK_REF", 0x8CA3, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_BACK_VALUE_MASK", 0x8CA4, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_BACK_WRITEMASK", 0x8CA5, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VIEWPORT", 0x0BA2, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SCISSOR_BOX", 0x0C10, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("COLOR_CLEAR_VALUE", 0x0C22, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("COLOR_WRITEMASK", 0x0C23, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("UNPACK_ALIGNMENT", 0x0CF5, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("PACK_ALIGNMENT", 0x0D05, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_TEXTURE_SIZE", 0x0D33, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_VIEWPORT_DIMS", 0x0D3A, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SUBPIXEL_BITS", 0x0D50, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RED_BITS", 0x0D52, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("GREEN_BITS", 0x0D53, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BLUE_BITS", 0x0D54, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ALPHA_BITS", 0x0D55, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_BITS", 0x0D56, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_BITS", 0x0D57, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("POLYGON_OFFSET_UNITS", 0x2A00, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("POLYGON_OFFSET_FACTOR", 0x8038, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_BINDING_2D", 0x8069, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SAMPLE_BUFFERS", 0x80A8, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SAMPLES", 0x80A9, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SAMPLE_COVERAGE_VALUE", 0x80AA, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SAMPLE_COVERAGE_INVERT", 0x80AB, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("COMPRESSED_TEXTURE_FORMATS", 0x86A3, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DONT_CARE", 0x1100, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FASTEST", 0x1101, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("NICEST", 0x1102, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("GENERATE_MIPMAP_HINT", 0x8192, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BYTE", 0x1400, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("UNSIGNED_BYTE", 0x1401, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SHORT", 0x1402, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("UNSIGNED_SHORT", 0x1403, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INT", 0x1404, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("UNSIGNED_INT", 0x1405, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FLOAT", 0x1406, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_COMPONENT", 0x1902, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ALPHA", 0x1906, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RGB", 0x1907, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RGBA", 0x1908, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LUMINANCE", 0x1909, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LUMINANCE_ALPHA", 0x190A, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("UNSIGNED_SHORT_4_4_4_4", 0x8033, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("UNSIGNED_SHORT_5_5_5_1", 0x8034, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("UNSIGNED_SHORT_5_6_5", 0x8363, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAGMENT_SHADER", 0x8B30, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VERTEX_SHADER", 0x8B31, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_VERTEX_ATTRIBS", 0x8869, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_VERTEX_UNIFORM_VECTORS", 0x8DFB, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_VARYING_VECTORS", 0x8DFC, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_COMBINED_TEXTURE_IMAGE_UNITS", 0x8B4D, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_VERTEX_TEXTURE_IMAGE_UNITS", 0x8B4C, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_TEXTURE_IMAGE_UNITS", 0x8872, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_FRAGMENT_UNIFORM_VECTORS", 0x8DFD, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SHADER_TYPE", 0x8B4F, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DELETE_STATUS", 0x8B80, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LINK_STATUS", 0x8B82, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VALIDATE_STATUS", 0x8B83, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ATTACHED_SHADERS", 0x8B85, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ACTIVE_UNIFORMS", 0x8B86, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ACTIVE_ATTRIBUTES", 0x8B89, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SHADING_LANGUAGE_VERSION", 0x8B8C, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("CURRENT_PROGRAM", 0x8B8D, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("NEVER", 0x0200, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LESS", 0x0201, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("EQUAL", 0x0202, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LEQUAL", 0x0203, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("GREATER", 0x0204, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("NOTEQUAL", 0x0205, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("GEQUAL", 0x0206, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ALWAYS", 0x0207, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("KEEP", 0x1E00, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("REPLACE", 0x1E01, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INCR", 0x1E02, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DECR", 0x1E03, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INVERT", 0x150A, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INCR_WRAP", 0x8507, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DECR_WRAP", 0x8508, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VENDOR", 0x1F00, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERER", 0x1F01, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VERSION", 0x1F02, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("NEAREST", 0x2600, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LINEAR", 0x2601, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("NEAREST_MIPMAP_NEAREST", 0x2700, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LINEAR_MIPMAP_NEAREST", 0x2701, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("NEAREST_MIPMAP_LINEAR", 0x2702, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LINEAR_MIPMAP_LINEAR", 0x2703, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_MAG_FILTER", 0x2800, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_MIN_FILTER", 0x2801, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_WRAP_S", 0x2802, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_WRAP_T", 0x2803, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_2D", 0x0DE1, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE", 0x1702, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_CUBE_MAP", 0x8513, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_BINDING_CUBE_MAP", 0x8514, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_CUBE_MAP_POSITIVE_X", 0x8515, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_CUBE_MAP_NEGATIVE_X", 0x8516, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_CUBE_MAP_POSITIVE_Y", 0x8517, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_CUBE_MAP_NEGATIVE_Y", 0x8518, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_CUBE_MAP_POSITIVE_Z", 0x8519, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE_CUBE_MAP_NEGATIVE_Z", 0x851A, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_CUBE_MAP_TEXTURE_SIZE", 0x851C, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE0", 0x84C0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE1", 0x84C1, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE2", 0x84C2, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE3", 0x84C3, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE4", 0x84C4, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE5", 0x84C5, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE6", 0x84C6, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE7", 0x84C7, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE8", 0x84C8, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE9", 0x84C9, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE10", 0x84CA, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE11", 0x84CB, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE12", 0x84CC, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE13", 0x84CD, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE14", 0x84CE, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE15", 0x84CF, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE16", 0x84D0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE17", 0x84D1, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE18", 0x84D2, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE19", 0x84D3, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE20", 0x84D4, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE21", 0x84D5, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE22", 0x84D6, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE23", 0x84D7, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE24", 0x84D8, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE25", 0x84D9, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE26", 0x84DA, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE27", 0x84DB, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE28", 0x84DC, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE29", 0x84DD, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE30", 0x84DE, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("TEXTURE31", 0x84DF, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("ACTIVE_TEXTURE", 0x84E0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("REPEAT", 0x2901, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("CLAMP_TO_EDGE", 0x812F, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MIRRORED_REPEAT", 0x8370, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FLOAT_VEC2", 0x8B50, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FLOAT_VEC3", 0x8B51, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FLOAT_VEC4", 0x8B52, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INT_VEC2", 0x8B53, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INT_VEC3", 0x8B54, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INT_VEC4", 0x8B55, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BOOL", 0x8B56, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BOOL_VEC2", 0x8B57, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BOOL_VEC3", 0x8B58, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BOOL_VEC4", 0x8B59, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FLOAT_MAT2", 0x8B5A, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FLOAT_MAT3", 0x8B5B, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FLOAT_MAT4", 0x8B5C, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SAMPLER_2D", 0x8B5E, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("SAMPLER_CUBE", 0x8B60, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VERTEX_ATTRIB_ARRAY_ENABLED", 0x8622, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VERTEX_ATTRIB_ARRAY_SIZE", 0x8623, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VERTEX_ATTRIB_ARRAY_STRIDE", 0x8624, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VERTEX_ATTRIB_ARRAY_TYPE", 0x8625, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VERTEX_ATTRIB_ARRAY_NORMALIZED", 0x886A, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VERTEX_ATTRIB_ARRAY_POINTER", 0x8645, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("VERTEX_ATTRIB_ARRAY_BUFFER_BINDING", 0x889F, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("IMPLEMENTATION_COLOR_READ_TYPE", 0x8B9A, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("IMPLEMENTATION_COLOR_READ_FORMAT", 0x8B9B, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("COMPILE_STATUS", 0x8B81, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LOW_FLOAT", 0x8DF0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MEDIUM_FLOAT", 0x8DF1, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("HIGH_FLOAT", 0x8DF2, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("LOW_INT", 0x8DF3, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MEDIUM_INT", 0x8DF4, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("HIGH_INT", 0x8DF5, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER", 0x8D40, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER", 0x8D41, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RGBA4", 0x8056, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RGB5_A1", 0x8057, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RGB565", 0x8D62, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_COMPONENT16", 0x81A5, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_INDEX", 0x1901, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_INDEX8", 0x8D48, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_STENCIL", 0x84F9, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER_WIDTH", 0x8D42, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER_HEIGHT", 0x8D43, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER_INTERNAL_FORMAT", 0x8D44, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER_RED_SIZE", 0x8D50, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER_GREEN_SIZE", 0x8D51, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER_BLUE_SIZE", 0x8D52, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER_ALPHA_SIZE", 0x8D53, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER_DEPTH_SIZE", 0x8D54, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER_STENCIL_SIZE", 0x8D55, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE", 0x8CD0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER_ATTACHMENT_OBJECT_NAME", 0x8CD1, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL", 0x8CD2, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE", 0x8CD3, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("COLOR_ATTACHMENT0", 0x8CE0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_ATTACHMENT", 0x8D00, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("STENCIL_ATTACHMENT", 0x8D20, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("DEPTH_STENCIL_ATTACHMENT", 0x821A, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("NONE", 0, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER_COMPLETE", 0x8CD5, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER_INCOMPLETE_ATTACHMENT", 0x8CD6, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT", 0x8CD7, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER_INCOMPLETE_DIMENSIONS", 0x8CD9, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER_UNSUPPORTED", 0x8CDD, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("FRAMEBUFFER_BINDING", 0x8CA6, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("RENDERBUFFER_BINDING", 0x8CA7, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("MAX_RENDERBUFFER_SIZE", 0x84E8, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("INVALID_FRAMEBUFFER_OPERATION", 0x0506, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("UNPACK_FLIP_Y_WEBGL", 0x9240, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("UNPACK_PREMULTIPLY_ALPHA_WEBGL", 0x9241, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("CONTEXT_LOST_WEBGL", 0x9242, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("UNPACK_COLORSPACE_CONVERSION_WEBGL", 0x9243, JS_PROP_CONFIGURABLE),
	JS_PROP_INT32_DEF("BROWSER_DEFAULT_WEBGL", 0x9244, JS_PROP_CONFIGURABLE),
	JS_CGETSET_MAGIC_DEF("canvas", WebGLRenderingContextBase_getProperty, NULL, WebGLRenderingContextBase_PROP_canvas),
	JS_CGETSET_MAGIC_DEF("drawingBufferWidth", WebGLRenderingContextBase_getProperty, NULL, WebGLRenderingContextBase_PROP_drawingBufferWidth),
	JS_CGETSET_MAGIC_DEF("drawingBufferHeight", WebGLRenderingContextBase_getProperty, NULL, WebGLRenderingContextBase_PROP_drawingBufferHeight),
	JS_CFUNC_DEF("getContextAttributes", 0, wgl_getContextAttributes),
	JS_CFUNC_DEF("isContextLost", 0, wgl_isContextLost),
	JS_CFUNC_DEF("getSupportedExtensions", 0, wgl_getSupportedExtensions),
	JS_CFUNC_DEF("getExtension", 0, wgl_getExtension),
	JS_CFUNC_DEF("activeTexture", 0, wgl_activeTexture),
	JS_CFUNC_DEF("attachShader", 0, wgl_attachShader),
	JS_CFUNC_DEF("bindAttribLocation", 0, wgl_bindAttribLocation),
	JS_CFUNC_DEF("bindBuffer", 0, wgl_bindBuffer),
	JS_CFUNC_DEF("bindFramebuffer", 0, wgl_bindFramebuffer),
	JS_CFUNC_DEF("bindRenderbuffer", 0, wgl_bindRenderbuffer),
	JS_CFUNC_DEF("bindTexture", 0, wgl_bindTexture),
	JS_CFUNC_DEF("blendColor", 0, wgl_blendColor),
	JS_CFUNC_DEF("blendEquation", 0, wgl_blendEquation),
	JS_CFUNC_DEF("blendEquationSeparate", 0, wgl_blendEquationSeparate),
	JS_CFUNC_DEF("blendFunc", 0, wgl_blendFunc),
	JS_CFUNC_DEF("blendFuncSeparate", 0, wgl_blendFuncSeparate),
	JS_CFUNC_DEF("bufferData", 0, wgl_bufferData),
	JS_CFUNC_DEF("bufferSubData", 0, wgl_bufferSubData),
	JS_CFUNC_DEF("checkFramebufferStatus", 0, wgl_checkFramebufferStatus),
	JS_CFUNC_DEF("clear", 0, wgl_clear),
	JS_CFUNC_DEF("clearColor", 0, wgl_clearColor),
	JS_CFUNC_DEF("clearDepth", 0, wgl_clearDepth),
	JS_CFUNC_DEF("clearStencil", 0, wgl_clearStencil),
	JS_CFUNC_DEF("colorMask", 0, wgl_colorMask),
	JS_CFUNC_DEF("compileShader", 0, wgl_compileShader),
	JS_CFUNC_DEF("compressedTexImage2D", 0, wgl_compressedTexImage2D),
	JS_CFUNC_DEF("compressedTexSubImage2D", 0, wgl_compressedTexSubImage2D),
	JS_CFUNC_DEF("copyTexImage2D", 0, wgl_copyTexImage2D),
	JS_CFUNC_DEF("copyTexSubImage2D", 0, wgl_copyTexSubImage2D),
	JS_CFUNC_DEF("createBuffer", 0, wgl_createBuffer),
	JS_CFUNC_DEF("createFramebuffer", 0, wgl_createFramebuffer),
	JS_CFUNC_DEF("createProgram", 0, wgl_createProgram),
	JS_CFUNC_DEF("createRenderbuffer", 0, wgl_createRenderbuffer),
	JS_CFUNC_DEF("createShader", 0, wgl_createShader),
	JS_CFUNC_DEF("createTexture", 0, wgl_createTexture),
	JS_CFUNC_DEF("cullFace", 0, wgl_cullFace),
	JS_CFUNC_DEF("deleteBuffer", 0, wgl_deleteBuffer),
	JS_CFUNC_DEF("deleteFramebuffer", 0, wgl_deleteFramebuffer),
	JS_CFUNC_DEF("deleteProgram", 0, wgl_deleteProgram),
	JS_CFUNC_DEF("deleteRenderbuffer", 0, wgl_deleteRenderbuffer),
	JS_CFUNC_DEF("deleteShader", 0, wgl_deleteShader),
	JS_CFUNC_DEF("deleteTexture", 0, wgl_deleteTexture),
	JS_CFUNC_DEF("depthFunc", 0, wgl_depthFunc),
	JS_CFUNC_DEF("depthMask", 0, wgl_depthMask),
	JS_CFUNC_DEF("depthRange", 0, wgl_depthRange),
	JS_CFUNC_DEF("detachShader", 0, wgl_detachShader),
	JS_CFUNC_DEF("disable", 0, wgl_disable),
	JS_CFUNC_DEF("disableVertexAttribArray", 0, wgl_disableVertexAttribArray),
	JS_CFUNC_DEF("drawArrays", 0, wgl_drawArrays),
	JS_CFUNC_DEF("drawElements", 0, wgl_drawElements),
	JS_CFUNC_DEF("enable", 0, wgl_enable),
	JS_CFUNC_DEF("enableVertexAttribArray", 0, wgl_enableVertexAttribArray),
	JS_CFUNC_DEF("finish", 0, wgl_finish),
	JS_CFUNC_DEF("flush", 0, wgl_flush),
	JS_CFUNC_DEF("framebufferRenderbuffer", 0, wgl_framebufferRenderbuffer),
	JS_CFUNC_DEF("framebufferTexture2D", 0, wgl_framebufferTexture2D),
	JS_CFUNC_DEF("frontFace", 0, wgl_frontFace),
	JS_CFUNC_DEF("generateMipmap", 0, wgl_generateMipmap),
	JS_CFUNC_DEF("getActiveAttrib", 0, wgl_getActiveAttrib),
	JS_CFUNC_DEF("getActiveUniform", 0, wgl_getActiveUniform),
	JS_CFUNC_DEF("getAttachedShaders", 0, wgl_getAttachedShaders),
	JS_CFUNC_DEF("getAttribLocation", 0, wgl_getAttribLocation),
	JS_CFUNC_DEF("getBufferParameter", 0, wgl_getBufferParameter),
	JS_CFUNC_DEF("getParameter", 0, wgl_getParameter),
	JS_CFUNC_DEF("getError", 0, wgl_getError),
	JS_CFUNC_DEF("getFramebufferAttachmentParameter", 0, wgl_getFramebufferAttachmentParameter),
	JS_CFUNC_DEF("getProgramParameter", 0, wgl_getProgramParameter),
	JS_CFUNC_DEF("getProgramInfoLog", 0, wgl_getProgramInfoLog),
	JS_CFUNC_DEF("getRenderbufferParameter", 0, wgl_getRenderbufferParameter),
	JS_CFUNC_DEF("getShaderParameter", 0, wgl_getShaderParameter),
	JS_CFUNC_DEF("getShaderPrecisionFormat", 0, wgl_getShaderPrecisionFormat),
	JS_CFUNC_DEF("getShaderInfoLog", 0, wgl_getShaderInfoLog),
	JS_CFUNC_DEF("getShaderSource", 0, wgl_getShaderSource),
	JS_CFUNC_DEF("getTexParameter", 0, wgl_getTexParameter),
	JS_CFUNC_DEF("getUniform", 0, wgl_getUniform),
	JS_CFUNC_DEF("getUniformLocation", 0, wgl_getUniformLocation),
	JS_CFUNC_DEF("getVertexAttrib", 0, wgl_getVertexAttrib),
	JS_CFUNC_DEF("getVertexAttribOffset", 0, wgl_getVertexAttribOffset),
	JS_CFUNC_DEF("hint", 0, wgl_hint),
	JS_CFUNC_DEF("isBuffer", 0, wgl_isBuffer),
	JS_CFUNC_DEF("isEnabled", 0, wgl_isEnabled),
	JS_CFUNC_DEF("isFramebuffer", 0, wgl_isFramebuffer),
	JS_CFUNC_DEF("isProgram", 0, wgl_isProgram),
	JS_CFUNC_DEF("isRenderbuffer", 0, wgl_isRenderbuffer),
	JS_CFUNC_DEF("isShader", 0, wgl_isShader),
	JS_CFUNC_DEF("isTexture", 0, wgl_isTexture),
	JS_CFUNC_DEF("lineWidth", 0, wgl_lineWidth),
	JS_CFUNC_DEF("linkProgram", 0, wgl_linkProgram),
	JS_CFUNC_DEF("pixelStorei", 0, wgl_pixelStorei),
	JS_CFUNC_DEF("polygonOffset", 0, wgl_polygonOffset),
	JS_CFUNC_DEF("readPixels", 0, wgl_readPixels),
	JS_CFUNC_DEF("renderbufferStorage", 0, wgl_renderbufferStorage),
	JS_CFUNC_DEF("sampleCoverage", 0, wgl_sampleCoverage),
	JS_CFUNC_DEF("scissor", 0, wgl_scissor),
	JS_CFUNC_DEF("shaderSource", 0, wgl_shaderSource),
	JS_CFUNC_DEF("stencilFunc", 0, wgl_stencilFunc),
	JS_CFUNC_DEF("stencilFuncSeparate", 0, wgl_stencilFuncSeparate),
	JS_CFUNC_DEF("stencilMask", 0, wgl_stencilMask),
	JS_CFUNC_DEF("stencilMaskSeparate", 0, wgl_stencilMaskSeparate),
	JS_CFUNC_DEF("stencilOp", 0, wgl_stencilOp),
	JS_CFUNC_DEF("stencilOpSeparate", 0, wgl_stencilOpSeparate),
	JS_CFUNC_DEF("texImage2D", 0, wgl_texImage2D),
	JS_CFUNC_DEF("texParameterf", 0, wgl_texParameterf),
	JS_CFUNC_DEF("texParameteri", 0, wgl_texParameteri),
	JS_CFUNC_DEF("texSubImage2D", 0, wgl_texSubImage2D),
	JS_CFUNC_DEF("uniform1f", 0, wgl_uniform1f),
	JS_CFUNC_DEF("uniform1fv", 0, wgl_uniform1fv),
	JS_CFUNC_DEF("uniform1i", 0, wgl_uniform1i),
	JS_CFUNC_DEF("uniform1iv", 0, wgl_uniform1iv),
	JS_CFUNC_DEF("uniform2f", 0, wgl_uniform2f),
	JS_CFUNC_DEF("uniform2fv", 0, wgl_uniform2fv),
	JS_CFUNC_DEF("uniform2i", 0, wgl_uniform2i),
	JS_CFUNC_DEF("uniform2iv", 0, wgl_uniform2iv),
	JS_CFUNC_DEF("uniform3f", 0, wgl_uniform3f),
	JS_CFUNC_DEF("uniform3fv", 0, wgl_uniform3fv),
	JS_CFUNC_DEF("uniform3i", 0, wgl_uniform3i),
	JS_CFUNC_DEF("uniform3iv", 0, wgl_uniform3iv),
	JS_CFUNC_DEF("uniform4f", 0, wgl_uniform4f),
	JS_CFUNC_DEF("uniform4fv", 0, wgl_uniform4fv),
	JS_CFUNC_DEF("uniform4i", 0, wgl_uniform4i),
	JS_CFUNC_DEF("uniform4iv", 0, wgl_uniform4iv),
	JS_CFUNC_DEF("uniformMatrix2fv", 0, wgl_uniformMatrix2fv),
	JS_CFUNC_DEF("uniformMatrix3fv", 0, wgl_uniformMatrix3fv),
	JS_CFUNC_DEF("uniformMatrix4fv", 0, wgl_uniformMatrix4fv),
	JS_CFUNC_DEF("useProgram", 0, wgl_useProgram),
	JS_CFUNC_DEF("validateProgram", 0, wgl_validateProgram),
	JS_CFUNC_DEF("vertexAttrib1f", 0, wgl_vertexAttrib1f),
	JS_CFUNC_DEF("vertexAttrib1fv", 0, wgl_vertexAttrib1fv),
	JS_CFUNC_DEF("vertexAttrib2f", 0, wgl_vertexAttrib2f),
	JS_CFUNC_DEF("vertexAttrib2fv", 0, wgl_vertexAttrib2fv),
	JS_CFUNC_DEF("vertexAttrib3f", 0, wgl_vertexAttrib3f),
	JS_CFUNC_DEF("vertexAttrib3fv", 0, wgl_vertexAttrib3fv),
	JS_CFUNC_DEF("vertexAttrib4f", 0, wgl_vertexAttrib4f),
	JS_CFUNC_DEF("vertexAttrib4fv", 0, wgl_vertexAttrib4fv),
	JS_CFUNC_DEF("vertexAttribPointer", 0, wgl_vertexAttribPointer),
	JS_CFUNC_DEF("viewport", 0, wgl_viewport),
};
