//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cffilesecurity?language=objc)
///
/// This is toll-free bridged with `NSFileSecurity`.
#[doc(alias = "CFFileSecurityRef")]
#[repr(C)]
pub struct CFFileSecurity {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFFileSecurity {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFFileSecurity"> for CFFileSecurity {}
);

unsafe impl ConcreteType for CFFileSecurity {
    #[doc(alias = "CFFileSecurityGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFFileSecurityGetTypeID() -> CFTypeID;
        }
        unsafe { CFFileSecurityGetTypeID() }
    }
}

impl CFFileSecurity {
    #[doc(alias = "CFFileSecurityCreate")]
    #[inline]
    pub fn new(allocator: Option<&CFAllocator>) -> Option<CFRetained<CFFileSecurity>> {
        extern "C-unwind" {
            fn CFFileSecurityCreate(
                allocator: Option<&CFAllocator>,
            ) -> Option<NonNull<CFFileSecurity>>;
        }
        let ret = unsafe { CFFileSecurityCreate(allocator) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFFileSecurityCreateCopy")]
    #[inline]
    pub fn new_copy(
        allocator: Option<&CFAllocator>,
        file_sec: Option<&CFFileSecurity>,
    ) -> Option<CFRetained<CFFileSecurity>> {
        extern "C-unwind" {
            fn CFFileSecurityCreateCopy(
                allocator: Option<&CFAllocator>,
                file_sec: Option<&CFFileSecurity>,
            ) -> Option<NonNull<CFFileSecurity>>;
        }
        let ret = unsafe { CFFileSecurityCreateCopy(allocator, file_sec) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `owner_uuid` must be a valid pointer.
    #[doc(alias = "CFFileSecurityCopyOwnerUUID")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub unsafe fn owner_uuid(&self, owner_uuid: *mut *const CFUUID) -> bool {
        extern "C-unwind" {
            fn CFFileSecurityCopyOwnerUUID(
                file_sec: &CFFileSecurity,
                owner_uuid: *mut *const CFUUID,
            ) -> Boolean;
        }
        let ret = unsafe { CFFileSecurityCopyOwnerUUID(self, owner_uuid) };
        ret != 0
    }

    #[doc(alias = "CFFileSecuritySetOwnerUUID")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub fn set_owner_uuid(&self, owner_uuid: Option<&CFUUID>) -> bool {
        extern "C-unwind" {
            fn CFFileSecuritySetOwnerUUID(
                file_sec: &CFFileSecurity,
                owner_uuid: Option<&CFUUID>,
            ) -> Boolean;
        }
        let ret = unsafe { CFFileSecuritySetOwnerUUID(self, owner_uuid) };
        ret != 0
    }

    /// # Safety
    ///
    /// `group_uuid` must be a valid pointer.
    #[doc(alias = "CFFileSecurityCopyGroupUUID")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub unsafe fn group_uuid(&self, group_uuid: *mut *const CFUUID) -> bool {
        extern "C-unwind" {
            fn CFFileSecurityCopyGroupUUID(
                file_sec: &CFFileSecurity,
                group_uuid: *mut *const CFUUID,
            ) -> Boolean;
        }
        let ret = unsafe { CFFileSecurityCopyGroupUUID(self, group_uuid) };
        ret != 0
    }

    #[doc(alias = "CFFileSecuritySetGroupUUID")]
    #[cfg(feature = "CFUUID")]
    #[inline]
    pub fn set_group_uuid(&self, group_uuid: Option<&CFUUID>) -> bool {
        extern "C-unwind" {
            fn CFFileSecuritySetGroupUUID(
                file_sec: &CFFileSecurity,
                group_uuid: Option<&CFUUID>,
            ) -> Boolean;
        }
        let ret = unsafe { CFFileSecuritySetGroupUUID(self, group_uuid) };
        ret != 0
    }

    /// # Safety
    ///
    /// `owner` must be a valid pointer.
    #[doc(alias = "CFFileSecurityGetOwner")]
    #[cfg(feature = "libc")]
    #[inline]
    pub unsafe fn owner(&self, owner: *mut libc::uid_t) -> bool {
        extern "C-unwind" {
            fn CFFileSecurityGetOwner(
                file_sec: &CFFileSecurity,
                owner: *mut libc::uid_t,
            ) -> Boolean;
        }
        let ret = unsafe { CFFileSecurityGetOwner(self, owner) };
        ret != 0
    }

    #[doc(alias = "CFFileSecuritySetOwner")]
    #[cfg(feature = "libc")]
    #[inline]
    pub fn set_owner(&self, owner: libc::uid_t) -> bool {
        extern "C-unwind" {
            fn CFFileSecuritySetOwner(file_sec: &CFFileSecurity, owner: libc::uid_t) -> Boolean;
        }
        let ret = unsafe { CFFileSecuritySetOwner(self, owner) };
        ret != 0
    }

    /// # Safety
    ///
    /// `group` must be a valid pointer.
    #[doc(alias = "CFFileSecurityGetGroup")]
    #[cfg(feature = "libc")]
    #[inline]
    pub unsafe fn group(&self, group: *mut libc::gid_t) -> bool {
        extern "C-unwind" {
            fn CFFileSecurityGetGroup(
                file_sec: &CFFileSecurity,
                group: *mut libc::gid_t,
            ) -> Boolean;
        }
        let ret = unsafe { CFFileSecurityGetGroup(self, group) };
        ret != 0
    }

    #[doc(alias = "CFFileSecuritySetGroup")]
    #[cfg(feature = "libc")]
    #[inline]
    pub fn set_group(&self, group: libc::gid_t) -> bool {
        extern "C-unwind" {
            fn CFFileSecuritySetGroup(file_sec: &CFFileSecurity, group: libc::gid_t) -> Boolean;
        }
        let ret = unsafe { CFFileSecuritySetGroup(self, group) };
        ret != 0
    }

    /// # Safety
    ///
    /// `mode` must be a valid pointer.
    #[doc(alias = "CFFileSecurityGetMode")]
    #[cfg(feature = "libc")]
    #[inline]
    pub unsafe fn mode(&self, mode: *mut libc::mode_t) -> bool {
        extern "C-unwind" {
            fn CFFileSecurityGetMode(file_sec: &CFFileSecurity, mode: *mut libc::mode_t)
                -> Boolean;
        }
        let ret = unsafe { CFFileSecurityGetMode(self, mode) };
        ret != 0
    }

    #[doc(alias = "CFFileSecuritySetMode")]
    #[cfg(feature = "libc")]
    #[inline]
    pub fn set_mode(&self, mode: libc::mode_t) -> bool {
        extern "C-unwind" {
            fn CFFileSecuritySetMode(file_sec: &CFFileSecurity, mode: libc::mode_t) -> Boolean;
        }
        let ret = unsafe { CFFileSecuritySetMode(self, mode) };
        ret != 0
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cffilesecurityclearoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFFileSecurityClearOptions(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFFileSecurityClearOptions: CFOptionFlags {
        #[doc(alias = "kCFFileSecurityClearOwner")]
        const Owner = 1<<0;
        #[doc(alias = "kCFFileSecurityClearGroup")]
        const Group = 1<<1;
        #[doc(alias = "kCFFileSecurityClearMode")]
        const Mode = 1<<2;
        #[doc(alias = "kCFFileSecurityClearOwnerUUID")]
        const OwnerUUID = 1<<3;
        #[doc(alias = "kCFFileSecurityClearGroupUUID")]
        const GroupUUID = 1<<4;
        #[doc(alias = "kCFFileSecurityClearAccessControlList")]
        const AccessControlList = 1<<5;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFFileSecurityClearOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFFileSecurityClearOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFFileSecurity {
    #[doc(alias = "CFFileSecurityClearProperties")]
    #[inline]
    pub fn clear_properties(&self, clear_property_mask: CFFileSecurityClearOptions) -> bool {
        extern "C-unwind" {
            fn CFFileSecurityClearProperties(
                file_sec: &CFFileSecurity,
                clear_property_mask: CFFileSecurityClearOptions,
            ) -> Boolean;
        }
        let ret = unsafe { CFFileSecurityClearProperties(self, clear_property_mask) };
        ret != 0
    }
}

#[deprecated = "renamed to `CFFileSecurity::new`"]
#[inline]
pub extern "C-unwind" fn CFFileSecurityCreate(
    allocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFFileSecurity>> {
    extern "C-unwind" {
        fn CFFileSecurityCreate(allocator: Option<&CFAllocator>)
            -> Option<NonNull<CFFileSecurity>>;
    }
    let ret = unsafe { CFFileSecurityCreate(allocator) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFFileSecurity::new_copy`"]
#[inline]
pub extern "C-unwind" fn CFFileSecurityCreateCopy(
    allocator: Option<&CFAllocator>,
    file_sec: Option<&CFFileSecurity>,
) -> Option<CFRetained<CFFileSecurity>> {
    extern "C-unwind" {
        fn CFFileSecurityCreateCopy(
            allocator: Option<&CFAllocator>,
            file_sec: Option<&CFFileSecurity>,
        ) -> Option<NonNull<CFFileSecurity>>;
    }
    let ret = unsafe { CFFileSecurityCreateCopy(allocator, file_sec) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFFileSecurity::owner_uuid`"]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityCopyOwnerUUID(
    file_sec: &CFFileSecurity,
    owner_uuid: *mut *const CFUUID,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityCopyOwnerUUID(
            file_sec: &CFFileSecurity,
            owner_uuid: *mut *const CFUUID,
        ) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityCopyOwnerUUID(file_sec, owner_uuid) };
    ret != 0
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFFileSecurity::set_owner_uuid`"]
#[inline]
pub extern "C-unwind" fn CFFileSecuritySetOwnerUUID(
    file_sec: &CFFileSecurity,
    owner_uuid: Option<&CFUUID>,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecuritySetOwnerUUID(
            file_sec: &CFFileSecurity,
            owner_uuid: Option<&CFUUID>,
        ) -> Boolean;
    }
    let ret = unsafe { CFFileSecuritySetOwnerUUID(file_sec, owner_uuid) };
    ret != 0
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFFileSecurity::group_uuid`"]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityCopyGroupUUID(
    file_sec: &CFFileSecurity,
    group_uuid: *mut *const CFUUID,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityCopyGroupUUID(
            file_sec: &CFFileSecurity,
            group_uuid: *mut *const CFUUID,
        ) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityCopyGroupUUID(file_sec, group_uuid) };
    ret != 0
}

#[cfg(feature = "CFUUID")]
#[deprecated = "renamed to `CFFileSecurity::set_group_uuid`"]
#[inline]
pub extern "C-unwind" fn CFFileSecuritySetGroupUUID(
    file_sec: &CFFileSecurity,
    group_uuid: Option<&CFUUID>,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecuritySetGroupUUID(
            file_sec: &CFFileSecurity,
            group_uuid: Option<&CFUUID>,
        ) -> Boolean;
    }
    let ret = unsafe { CFFileSecuritySetGroupUUID(file_sec, group_uuid) };
    ret != 0
}

#[cfg(feature = "libc")]
#[deprecated = "renamed to `CFFileSecurity::owner`"]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityGetOwner(
    file_sec: &CFFileSecurity,
    owner: *mut libc::uid_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityGetOwner(file_sec: &CFFileSecurity, owner: *mut libc::uid_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityGetOwner(file_sec, owner) };
    ret != 0
}

#[cfg(feature = "libc")]
#[deprecated = "renamed to `CFFileSecurity::set_owner`"]
#[inline]
pub extern "C-unwind" fn CFFileSecuritySetOwner(
    file_sec: &CFFileSecurity,
    owner: libc::uid_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecuritySetOwner(file_sec: &CFFileSecurity, owner: libc::uid_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecuritySetOwner(file_sec, owner) };
    ret != 0
}

#[cfg(feature = "libc")]
#[deprecated = "renamed to `CFFileSecurity::group`"]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityGetGroup(
    file_sec: &CFFileSecurity,
    group: *mut libc::gid_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityGetGroup(file_sec: &CFFileSecurity, group: *mut libc::gid_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityGetGroup(file_sec, group) };
    ret != 0
}

#[cfg(feature = "libc")]
#[deprecated = "renamed to `CFFileSecurity::set_group`"]
#[inline]
pub extern "C-unwind" fn CFFileSecuritySetGroup(
    file_sec: &CFFileSecurity,
    group: libc::gid_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecuritySetGroup(file_sec: &CFFileSecurity, group: libc::gid_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecuritySetGroup(file_sec, group) };
    ret != 0
}

#[cfg(feature = "libc")]
#[deprecated = "renamed to `CFFileSecurity::mode`"]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityGetMode(
    file_sec: &CFFileSecurity,
    mode: *mut libc::mode_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityGetMode(file_sec: &CFFileSecurity, mode: *mut libc::mode_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityGetMode(file_sec, mode) };
    ret != 0
}

#[cfg(feature = "libc")]
#[deprecated = "renamed to `CFFileSecurity::set_mode`"]
#[inline]
pub extern "C-unwind" fn CFFileSecuritySetMode(
    file_sec: &CFFileSecurity,
    mode: libc::mode_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecuritySetMode(file_sec: &CFFileSecurity, mode: libc::mode_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecuritySetMode(file_sec, mode) };
    ret != 0
}

#[deprecated = "renamed to `CFFileSecurity::clear_properties`"]
#[inline]
pub extern "C-unwind" fn CFFileSecurityClearProperties(
    file_sec: &CFFileSecurity,
    clear_property_mask: CFFileSecurityClearOptions,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityClearProperties(
            file_sec: &CFFileSecurity,
            clear_property_mask: CFFileSecurityClearOptions,
        ) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityClearProperties(file_sec, clear_property_mask) };
    ret != 0
}
