#[burn_tensor_testgen::testgen(cos)]
mod tests {
    use super::*;
    use burn_tensor::{Tensor, TensorData};
    use burn_tensor::{Tolerance, ops::FloatElem};
    type FT = FloatElem<TestBackend>;

    #[test]
    fn should_support_cos_ops() {
        let data = TensorData::from([[0.0, 1.0, 2.0], [3.0, 4.0, 5.0]]);
        let tensor = TestTensor::<2>::from_data(data, &Default::default());

        let output = tensor.cos();
        let expected = TensorData::from([[1.0, 0.54030, -0.41615], [-0.98999, -0.65364, 0.28366]]);

        output.into_data().assert_approx_eq::<FT>(
            &expected,
            Tolerance::rel_abs(1e-5, 1e-5).set_half_precision_relative(1e-3),
        );
    }
}
