(function() {var type_impls = {
"std":[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#182-185\">source</a><a href=\"#impl-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.reverse\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#190\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.reverse\" class=\"fn\">reverse</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Reverse the order of the elements in the vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rotate_elements_left\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#213\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.rotate_elements_left\" class=\"fn\">rotate_elements_left</a>&lt;const OFFSET: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt;(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Rotates the vector such that the first <code>OFFSET</code> elements of the slice move to the end\nwhile the last <code>self.len() - OFFSET</code> elements move to the front. After calling <code>rotate_elements_left</code>,\nthe element previously at index <code>OFFSET</code> will become the first element in the slice.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rotate_elements_right\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#237\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.rotate_elements_right\" class=\"fn\">rotate_elements_right</a>&lt;const OFFSET: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt;(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Rotates the vector such that the first <code>self.len() - OFFSET</code> elements of the vector move to\nthe end while the last <code>OFFSET</code> elements move to the front. After calling <code>rotate_elements_right</code>,\nthe element previously at index <code>self.len() - OFFSET</code> will become the first element in the slice.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.interleave\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#274\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.interleave\" class=\"fn\">interleave</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;) -&gt; (<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;, <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Interleave two vectors.</p>\n<p>The resulting vectors contain elements taken alternatively from <code>self</code> and <code>other</code>, first\nfilling the first result, and then the second.</p>\n<p>The reverse of this operation is <a href=\"std/simd/prelude/struct.Simd.html#method.deinterleave\" title=\"method std::simd::prelude::Simd::deinterleave\"><code>Simd::deinterleave</code></a>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>a = Simd::from_array([<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"kw\">let </span>b = Simd::from_array([<span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>, <span class=\"number\">7</span>]);\n<span class=\"kw\">let </span>(x, y) = a.interleave(b);\n<span class=\"macro\">assert_eq!</span>(x.to_array(), [<span class=\"number\">0</span>, <span class=\"number\">4</span>, <span class=\"number\">1</span>, <span class=\"number\">5</span>]);\n<span class=\"macro\">assert_eq!</span>(y.to_array(), [<span class=\"number\">2</span>, <span class=\"number\">6</span>, <span class=\"number\">3</span>, <span class=\"number\">7</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::Simd;%0Alet+a+=+Simd::from_array(%5B0,+1,+2,+3%5D);%0Alet+b+=+Simd::from_array(%5B4,+5,+6,+7%5D);%0Alet+(x,+y)+=+a.interleave(b);%0Aassert_eq!(x.to_array(),+%5B0,+4,+1,+5%5D);%0Aassert_eq!(y.to_array(),+%5B2,+6,+3,+7%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.deinterleave\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#325\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.deinterleave\" class=\"fn\">deinterleave</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;) -&gt; (<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;, <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Deinterleave two vectors.</p>\n<p>The first result takes every other element of <code>self</code> and then <code>other</code>, starting with\nthe first element.</p>\n<p>The second result takes every other element of <code>self</code> and then <code>other</code>, starting with\nthe second element.</p>\n<p>The reverse of this operation is <a href=\"std/simd/prelude/struct.Simd.html#method.interleave\" title=\"method std::simd::prelude::Simd::interleave\"><code>Simd::interleave</code></a>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>a = Simd::from_array([<span class=\"number\">0</span>, <span class=\"number\">4</span>, <span class=\"number\">1</span>, <span class=\"number\">5</span>]);\n<span class=\"kw\">let </span>b = Simd::from_array([<span class=\"number\">2</span>, <span class=\"number\">6</span>, <span class=\"number\">3</span>, <span class=\"number\">7</span>]);\n<span class=\"kw\">let </span>(x, y) = a.deinterleave(b);\n<span class=\"macro\">assert_eq!</span>(x.to_array(), [<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"macro\">assert_eq!</span>(y.to_array(), [<span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>, <span class=\"number\">7</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::Simd;%0Alet+a+=+Simd::from_array(%5B0,+4,+1,+5%5D);%0Alet+b+=+Simd::from_array(%5B2,+6,+3,+7%5D);%0Alet+(x,+y)+=+a.deinterleave(b);%0Aassert_eq!(x.to_array(),+%5B0,+1,+2,+3%5D);%0Aassert_eq!(y.to_array(),+%5B4,+5,+6,+7%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.resize\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#369-371\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.resize\" class=\"fn\">resize</a>&lt;const M: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt;(self, value: T) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, M&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;M&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Resize a vector.</p>\n<p>If <code>M</code> &gt; <code>N</code>, extends the length of a vector, setting the new elements to <code>value</code>.\nIf <code>M</code> &lt; <code>N</code>, truncates the vector to the first <code>M</code> elements.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x = u32x4::from_array([<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"macro\">assert_eq!</span>(x.resize::&lt;<span class=\"number\">8</span>&gt;(<span class=\"number\">9</span>).to_array(), [<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">9</span>, <span class=\"number\">9</span>, <span class=\"number\">9</span>, <span class=\"number\">9</span>]);\n<span class=\"macro\">assert_eq!</span>(x.resize::&lt;<span class=\"number\">2</span>&gt;(<span class=\"number\">9</span>).to_array(), [<span class=\"number\">0</span>, <span class=\"number\">1</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::u32x4;%0Alet+x+=+u32x4::from_array(%5B0,+1,+2,+3%5D);%0Aassert_eq!(x.resize::%3C8%3E(9).to_array(),+%5B0,+1,+2,+3,+9,+9,+9,+9%5D);%0Aassert_eq!(x.resize::%3C2%3E(9).to_array(),+%5B0,+1%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::simd::prelude::u8x16","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle_dyn.rs.html#4-6\">source</a><a href=\"#impl-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.swizzle_dyn\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle_dyn.rs.html#17\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.swizzle_dyn\" class=\"fn\">swizzle_dyn</a>(self, idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Swizzle a vector of bytes according to the index vector.\nIndices within range select the appropriate byte.\nIndices “out of bounds” instead select 0.</p>\n<p>Note that the current implementation is selected during build-time\nof the standard library, so <code>cargo build -Zbuild-std</code> may be necessary\nto unlock better performance, especially for larger vectors.\nA planned compiler improvement will enable using <code>#[target_feature]</code> instead.</p>\n</div></details></div></details>",0,"std::simd::prelude::u8x16","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#109-112\">source</a><a href=\"#impl-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedconstant.LEN\" class=\"associatedconstant\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#115\">source</a><h4 class=\"code-header\">pub const <a href=\"std/simd/prelude/struct.Simd.html#associatedconstant.LEN\" class=\"constant\">LEN</a>: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a> = N</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Number of elements in this vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.len\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#131\">source</a><h4 class=\"code-header\">pub const fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.len\" class=\"fn\">len</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"primitive.usize.html\">usize</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the number of elements in this SIMD vector.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = u32x4::splat(<span class=\"number\">0</span>);\n<span class=\"macro\">assert_eq!</span>(v.len(), <span class=\"number\">4</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::u32x4;%0Alet+v+=+u32x4::splat(0);%0Aassert_eq!(v.len(),+4);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.splat\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#148\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.splat\" class=\"fn\">splat</a>(value: T) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Constructs a new SIMD vector with all elements set to the given value.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = u32x4::splat(<span class=\"number\">8</span>);\n<span class=\"macro\">assert_eq!</span>(v.as_array(), <span class=\"kw-2\">&amp;</span>[<span class=\"number\">8</span>, <span class=\"number\">8</span>, <span class=\"number\">8</span>, <span class=\"number\">8</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::u32x4;%0Alet+v+=+u32x4::splat(8);%0Aassert_eq!(v.as_array(),+%26%5B8,+8,+8,+8%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_array\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#169\">source</a><h4 class=\"code-header\">pub const fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.as_array\" class=\"fn\">as_array</a>(&amp;self) -&gt; &amp;<a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns an array reference containing the entire SIMD vector.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v: u64x4 = Simd::from_array([<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"macro\">assert_eq!</span>(v.as_array(), <span class=\"kw-2\">&amp;</span>[<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::%7BSimd,+u64x4%7D;%0Alet+v:+u64x4+=+Simd::from_array(%5B0,+1,+2,+3%5D);%0Aassert_eq!(v.as_array(),+%26%5B0,+1,+2,+3%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut_array\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#181\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.as_mut_array\" class=\"fn\">as_mut_array</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns a mutable array reference containing the entire SIMD vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_array\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#233\">source</a><h4 class=\"code-header\">pub const fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.from_array\" class=\"fn\">from_array</a>(array: <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Converts an array to a SIMD vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_array\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#246\">source</a><h4 class=\"code-header\">pub const fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.to_array\" class=\"fn\">to_array</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Converts a SIMD vector to an array.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_slice\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#279\">source</a><h4 class=\"code-header\">pub const fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.from_slice\" class=\"fn\">from_slice</a>(slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Converts a slice to a SIMD vector containing <code>slice[..N]</code>.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the slice’s length is less than the vector’s <code>Simd::N</code>.</p>\n<h5 id=\"example\"><a href=\"#example\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>source = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>];\n<span class=\"kw\">let </span>v = u32x4::from_slice(<span class=\"kw-2\">&amp;</span>source);\n<span class=\"macro\">assert_eq!</span>(v.as_array(), <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::u32x4;%0Alet+source+=+vec!%5B1,+2,+3,+4,+5,+6%5D;%0Alet+v+=+u32x4::from_slice(%26source);%0Aassert_eq!(v.as_array(),+%26%5B1,+2,+3,+4%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copy_to_slice\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#309\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.copy_to_slice\" class=\"fn\">copy_to_slice</a>(self, slice: &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Writes a SIMD vector to the first <code>N</code> elements of a slice.</p>\n<h5 id=\"panics-1\"><a href=\"#panics-1\">Panics</a></h5>\n<p>Panics if the slice’s length is less than the vector’s <code>Simd::N</code>.</p>\n<h5 id=\"example-1\"><a href=\"#example-1\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>dest = <span class=\"macro\">vec!</span>[<span class=\"number\">0</span>; <span class=\"number\">6</span>];\n<span class=\"kw\">let </span>v = u32x4::from_array([<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);\nv.copy_to_slice(<span class=\"kw-2\">&amp;mut </span>dest);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>dest, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::u32x4;%0Alet+mut+dest+=+vec!%5B0;+6%5D;%0Alet+v+=+u32x4::from_array(%5B1,+2,+3,+4%5D);%0Av.copy_to_slice(%26mut+dest);%0Aassert_eq!(%26dest,+%26%5B1,+2,+3,+4,+0,+0%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_or\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#335\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_or\" class=\"fn\">gather_or</a>(\n    slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>,\n    idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;,\n    or: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Reads from potentially discontiguous indices in <code>slice</code> to construct a SIMD vector.\nIf an index is out-of-bounds, the element is instead selected from the <code>or</code> vector.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">5</span>]);  <span class=\"comment\">// Note the index that is out-of-bounds\n</span><span class=\"kw\">let </span>alt = Simd::from_array([-<span class=\"number\">5</span>, -<span class=\"number\">4</span>, -<span class=\"number\">3</span>, -<span class=\"number\">2</span>]);\n\n<span class=\"kw\">let </span>result = Simd::gather_or(<span class=\"kw-2\">&amp;</span>vec, idxs, alt);\n<span class=\"macro\">assert_eq!</span>(result, Simd::from_array([-<span class=\"number\">5</span>, <span class=\"number\">13</span>, <span class=\"number\">10</span>, <span class=\"number\">15</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::Simd;%0Alet+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+5%5D);++//+Note+the+index+that+is+out-of-bounds%0Alet+alt+=+Simd::from_array(%5B-5,+-4,+-3,+-2%5D);%0A%0Alet+result+=+Simd::gather_or(%26vec,+idxs,+alt);%0Aassert_eq!(result,+Simd::from_array(%5B-5,+13,+10,+15%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_or_default\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#354-356\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_or_default\" class=\"fn\">gather_or_default</a>(slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>, idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/default/trait.Default.html\" title=\"trait std::default::Default\">Default</a>,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Reads from indices in <code>slice</code> to construct a SIMD vector.\nIf an index is out-of-bounds, the element is set to the default given by <code>T: Default</code>.</p>\n<h5 id=\"examples-4\"><a href=\"#examples-4\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">5</span>]);  <span class=\"comment\">// Note the index that is out-of-bounds\n\n</span><span class=\"kw\">let </span>result = Simd::gather_or_default(<span class=\"kw-2\">&amp;</span>vec, idxs);\n<span class=\"macro\">assert_eq!</span>(result, Simd::from_array([<span class=\"number\">0</span>, <span class=\"number\">13</span>, <span class=\"number\">10</span>, <span class=\"number\">15</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::Simd;%0Alet+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+5%5D);++//+Note+the+index+that+is+out-of-bounds%0A%0Alet+result+=+Simd::gather_or_default(%26vec,+idxs);%0Aassert_eq!(result,+Simd::from_array(%5B0,+13,+10,+15%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_select\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#379-384\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_select\" class=\"fn\">gather_select</a>(\n    slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;,\n    idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;,\n    or: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Reads from indices in <code>slice</code> to construct a SIMD vector.\nThe mask <code>enable</code>s all <code>true</code> indices and disables all <code>false</code> indices.\nIf an index is disabled or is out-of-bounds, the element is selected from the <code>or</code> vector.</p>\n<h5 id=\"examples-5\"><a href=\"#examples-5\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">5</span>]); <span class=\"comment\">// Includes an out-of-bounds index\n</span><span class=\"kw\">let </span>alt = Simd::from_array([-<span class=\"number\">5</span>, -<span class=\"number\">4</span>, -<span class=\"number\">3</span>, -<span class=\"number\">2</span>]);\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>]); <span class=\"comment\">// Includes a masked element\n\n</span><span class=\"kw\">let </span>result = Simd::gather_select(<span class=\"kw-2\">&amp;</span>vec, enable, idxs, alt);\n<span class=\"macro\">assert_eq!</span>(result, Simd::from_array([-<span class=\"number\">5</span>, <span class=\"number\">13</span>, <span class=\"number\">10</span>, -<span class=\"number\">2</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::%7BSimd,+Mask%7D;%0Alet+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+5%5D);+//+Includes+an+out-of-bounds+index%0Alet+alt+=+Simd::from_array(%5B-5,+-4,+-3,+-2%5D);%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+true,+false%5D);+//+Includes+a+masked+element%0A%0Alet+result+=+Simd::gather_select(%26vec,+enable,+idxs,+alt);%0Aassert_eq!(result,+Simd::from_array(%5B-5,+13,+10,+-2%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_select_unchecked\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#420-425\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_select_unchecked\" class=\"fn\">gather_select_unchecked</a>(\n    slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;,\n    idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;,\n    or: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Reads from indices in <code>slice</code> to construct a SIMD vector.\nThe mask <code>enable</code>s all <code>true</code> indices and disables all <code>false</code> indices.\nIf an index is disabled, the element is selected from the <code>or</code> vector.</p>\n<h5 id=\"safety\"><a href=\"#safety\">Safety</a></h5>\n<p>Calling this function with an <code>enable</code>d out-of-bounds index is <em><a href=\"https://doc.rust-lang.org/reference/behavior-considered-undefined.html\">undefined behavior</a></em>\neven if the resulting value is not used.</p>\n<h5 id=\"examples-6\"><a href=\"#examples-6\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">5</span>]); <span class=\"comment\">// Includes an out-of-bounds index\n</span><span class=\"kw\">let </span>alt = Simd::from_array([-<span class=\"number\">5</span>, -<span class=\"number\">4</span>, -<span class=\"number\">3</span>, -<span class=\"number\">2</span>]);\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>]); <span class=\"comment\">// Includes a masked element\n// If this mask was used to gather, it would be unsound. Let's fix that.\n</span><span class=\"kw\">let </span>enable = enable &amp; idxs.simd_lt(Simd::splat(vec.len()));\n\n<span class=\"comment\">// The out-of-bounds index has been masked, so it's safe to gather now.\n</span><span class=\"kw\">let </span>result = <span class=\"kw\">unsafe </span>{ Simd::gather_select_unchecked(<span class=\"kw-2\">&amp;</span>vec, enable, idxs, alt) };\n<span class=\"macro\">assert_eq!</span>(result, Simd::from_array([-<span class=\"number\">5</span>, <span class=\"number\">13</span>, <span class=\"number\">10</span>, -<span class=\"number\">2</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BSimd,+cmp::SimdPartialOrd,+Mask%7D;%0Alet+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+5%5D);+//+Includes+an+out-of-bounds+index%0Alet+alt+=+Simd::from_array(%5B-5,+-4,+-3,+-2%5D);%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+true,+false%5D);+//+Includes+a+masked+element%0A//+If+this+mask+was+used+to+gather,+it+would+be+unsound.+Let's+fix+that.%0Alet+enable+=+enable+%26+idxs.simd_lt(Simd::splat(vec.len()));%0A%0A//+The+out-of-bounds+index+has+been+masked,+so+it's+safe+to+gather+now.%0Alet+result+=+unsafe+%7B+Simd::gather_select_unchecked(%26vec,+enable,+idxs,+alt)+%7D;%0Aassert_eq!(result,+Simd::from_array(%5B-5,+13,+10,+-2%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_ptr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#454-456\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_ptr\" class=\"fn\">gather_ptr</a>(source: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*const T</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/default/trait.Default.html\" title=\"trait std::default::Default\">Default</a>,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Read elementwise from pointers into a SIMD vector.</p>\n<h5 id=\"safety-1\"><a href=\"#safety-1\">Safety</a></h5>\n<p>Each read must satisfy the same conditions as <a href=\"std/ptr/fn.read.html\" title=\"fn std::ptr::read\"><code>core::ptr::read</code></a>.</p>\n<h5 id=\"example-2\"><a href=\"#example-2\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>values = [<span class=\"number\">6</span>, <span class=\"number\">2</span>, <span class=\"number\">4</span>, <span class=\"number\">9</span>];\n<span class=\"kw\">let </span>offsets = Simd::from_array([<span class=\"number\">1</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">3</span>]);\n<span class=\"kw\">let </span>source = Simd::splat(values.as_ptr()).wrapping_add(offsets);\n<span class=\"kw\">let </span>gathered = <span class=\"kw\">unsafe </span>{ Simd::gather_ptr(source) };\n<span class=\"macro\">assert_eq!</span>(gathered, Simd::from_array([<span class=\"number\">2</span>, <span class=\"number\">6</span>, <span class=\"number\">6</span>, <span class=\"number\">9</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::prelude::*;%0Alet+values+=+%5B6,+2,+4,+9%5D;%0Alet+offsets+=+Simd::from_array(%5B1,+0,+0,+3%5D);%0Alet+source+=+Simd::splat(values.as_ptr()).wrapping_add(offsets);%0Alet+gathered+=+unsafe+%7B+Simd::gather_ptr(source)+%7D;%0Aassert_eq!(gathered,+Simd::from_array(%5B2,+6,+6,+9%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_select_ptr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#488-492\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_select_ptr\" class=\"fn\">gather_select_ptr</a>(\n    source: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*const T</a>, N&gt;,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;,\n    or: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Conditionally read elementwise from pointers into a SIMD vector.\nThe mask <code>enable</code>s all <code>true</code> pointers and disables all <code>false</code> pointers.\nIf a pointer is disabled, the element is selected from the <code>or</code> vector,\nand no read is performed.</p>\n<h5 id=\"safety-2\"><a href=\"#safety-2\">Safety</a></h5>\n<p>Enabled elements must satisfy the same conditions as <a href=\"std/ptr/fn.read.html\" title=\"fn std::ptr::read\"><code>core::ptr::read</code></a>.</p>\n<h5 id=\"example-3\"><a href=\"#example-3\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>values = [<span class=\"number\">6</span>, <span class=\"number\">2</span>, <span class=\"number\">4</span>, <span class=\"number\">9</span>];\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>, <span class=\"bool-val\">true</span>]);\n<span class=\"kw\">let </span>offsets = Simd::from_array([<span class=\"number\">1</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">3</span>]);\n<span class=\"kw\">let </span>source = Simd::splat(values.as_ptr()).wrapping_add(offsets);\n<span class=\"kw\">let </span>gathered = <span class=\"kw\">unsafe </span>{ Simd::gather_select_ptr(source, enable, Simd::splat(<span class=\"number\">0</span>)) };\n<span class=\"macro\">assert_eq!</span>(gathered, Simd::from_array([<span class=\"number\">2</span>, <span class=\"number\">6</span>, <span class=\"number\">0</span>, <span class=\"number\">9</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::prelude::*;%0Alet+values+=+%5B6,+2,+4,+9%5D;%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+false,+true%5D);%0Alet+offsets+=+Simd::from_array(%5B1,+0,+0,+3%5D);%0Alet+source+=+Simd::splat(values.as_ptr()).wrapping_add(offsets);%0Alet+gathered+=+unsafe+%7B+Simd::gather_select_ptr(source,+enable,+Simd::splat(0))+%7D;%0Aassert_eq!(gathered,+Simd::from_array(%5B2,+6,+0,+9%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.scatter\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#514\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.scatter\" class=\"fn\">scatter</a>(self, slice: &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>, idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Writes the values in a SIMD vector to potentially discontiguous indices in <code>slice</code>.\nIf an index is out-of-bounds, the write is suppressed without panicking.\nIf two elements in the scattered vector would write to the same index\nonly the last element is guaranteed to actually be written.</p>\n<h5 id=\"examples-7\"><a href=\"#examples-7\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>]); <span class=\"comment\">// Note the duplicate index.\n</span><span class=\"kw\">let </span>vals = Simd::from_array([-<span class=\"number\">27</span>, <span class=\"number\">82</span>, -<span class=\"number\">41</span>, <span class=\"number\">124</span>]);\n\nvals.scatter(<span class=\"kw-2\">&amp;mut </span>vec, idxs); <span class=\"comment\">// two logical writes means the last wins.\n</span><span class=\"macro\">assert_eq!</span>(vec, <span class=\"macro\">vec!</span>[<span class=\"number\">124</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">82</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::Simd;%0Alet+mut+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+0%5D);+//+Note+the+duplicate+index.%0Alet+vals+=+Simd::from_array(%5B-27,+82,+-41,+124%5D);%0A%0Avals.scatter(%26mut+vec,+idxs);+//+two+logical+writes+means+the+last+wins.%0Aassert_eq!(vec,+vec!%5B124,+11,+12,+82,+14,+15,+16,+17,+18%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.scatter_select\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#539\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.scatter_select\" class=\"fn\">scatter_select</a>(\n    self,\n    slice: &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;,\n    idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;\n)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Writes values from a SIMD vector to multiple potentially discontiguous indices in <code>slice</code>.\nThe mask <code>enable</code>s all <code>true</code> indices and disables all <code>false</code> indices.\nIf an enabled index is out-of-bounds, the write is suppressed without panicking.\nIf two enabled elements in the scattered vector would write to the same index,\nonly the last element is guaranteed to actually be written.</p>\n<h5 id=\"examples-8\"><a href=\"#examples-8\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>]); <span class=\"comment\">// Includes an out-of-bounds index\n</span><span class=\"kw\">let </span>vals = Simd::from_array([-<span class=\"number\">27</span>, <span class=\"number\">82</span>, -<span class=\"number\">41</span>, <span class=\"number\">124</span>]);\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>]); <span class=\"comment\">// Includes a masked element\n\n</span>vals.scatter_select(<span class=\"kw-2\">&amp;mut </span>vec, enable, idxs); <span class=\"comment\">// The last write is masked, thus omitted.\n</span><span class=\"macro\">assert_eq!</span>(vec, <span class=\"macro\">vec!</span>[-<span class=\"number\">41</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">82</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BSimd,+Mask%7D;%0Alet+mut+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+0%5D);+//+Includes+an+out-of-bounds+index%0Alet+vals+=+Simd::from_array(%5B-27,+82,+-41,+124%5D);%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+true,+false%5D);+//+Includes+a+masked+element%0A%0Avals.scatter_select(%26mut+vec,+enable,+idxs);+//+The+last+write+is+masked,+thus+omitted.%0Aassert_eq!(vec,+vec!%5B-41,+11,+12,+82,+14,+15,+16,+17,+18%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.scatter_select_unchecked\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#576-581\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.scatter_select_unchecked\" class=\"fn\">scatter_select_unchecked</a>(\n    self,\n    slice: &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;,\n    idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;\n)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Writes values from a SIMD vector to multiple potentially discontiguous indices in <code>slice</code>.\nThe mask <code>enable</code>s all <code>true</code> indices and disables all <code>false</code> indices.\nIf two enabled elements in the scattered vector would write to the same index,\nonly the last element is guaranteed to actually be written.</p>\n<h5 id=\"safety-3\"><a href=\"#safety-3\">Safety</a></h5>\n<p>Calling this function with an enabled out-of-bounds index is <em><a href=\"https://doc.rust-lang.org/reference/behavior-considered-undefined.html\">undefined behavior</a></em>,\nand may lead to memory corruption.</p>\n<h5 id=\"examples-9\"><a href=\"#examples-9\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>]);\n<span class=\"kw\">let </span>vals = Simd::from_array([-<span class=\"number\">27</span>, <span class=\"number\">82</span>, -<span class=\"number\">41</span>, <span class=\"number\">124</span>]);\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>]); <span class=\"comment\">// Masks the final index\n// If this mask was used to scatter, it would be unsound. Let's fix that.\n</span><span class=\"kw\">let </span>enable = enable &amp; idxs.simd_lt(Simd::splat(vec.len()));\n\n<span class=\"comment\">// We have masked the OOB index, so it's safe to scatter now.\n</span><span class=\"kw\">unsafe </span>{ vals.scatter_select_unchecked(<span class=\"kw-2\">&amp;mut </span>vec, enable, idxs); }\n<span class=\"comment\">// The second write to index 0 was masked, thus omitted.\n</span><span class=\"macro\">assert_eq!</span>(vec, <span class=\"macro\">vec!</span>[-<span class=\"number\">41</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">82</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BSimd,+cmp::SimdPartialOrd,+Mask%7D;%0Alet+mut+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+0%5D);%0Alet+vals+=+Simd::from_array(%5B-27,+82,+-41,+124%5D);%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+true,+false%5D);+//+Masks+the+final+index%0A//+If+this+mask+was+used+to+scatter,+it+would+be+unsound.+Let's+fix+that.%0Alet+enable+=+enable+%26+idxs.simd_lt(Simd::splat(vec.len()));%0A%0A//+We+have+masked+the+OOB+index,+so+it's+safe+to+scatter+now.%0Aunsafe+%7B+vals.scatter_select_unchecked(%26mut+vec,+enable,+idxs);+%7D%0A//+The+second+write+to+index+0+was+masked,+thus+omitted.%0Aassert_eq!(vec,+vec!%5B-41,+11,+12,+82,+14,+15,+16,+17,+18%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.scatter_ptr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#623\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.scatter_ptr\" class=\"fn\">scatter_ptr</a>(self, dest: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>, N&gt;)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Write pointers elementwise into a SIMD vector.</p>\n<h5 id=\"safety-4\"><a href=\"#safety-4\">Safety</a></h5>\n<p>Each write must satisfy the same conditions as <a href=\"std/ptr/fn.write.html\" title=\"fn std::ptr::write\"><code>core::ptr::write</code></a>.</p>\n<h5 id=\"example-4\"><a href=\"#example-4\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>values = [<span class=\"number\">0</span>; <span class=\"number\">4</span>];\n<span class=\"kw\">let </span>offset = Simd::from_array([<span class=\"number\">3</span>, <span class=\"number\">2</span>, <span class=\"number\">1</span>, <span class=\"number\">0</span>]);\n<span class=\"kw\">let </span>ptrs = Simd::splat(values.as_mut_ptr()).wrapping_add(offset);\n<span class=\"kw\">unsafe </span>{ Simd::from_array([<span class=\"number\">6</span>, <span class=\"number\">3</span>, <span class=\"number\">5</span>, <span class=\"number\">7</span>]).scatter_ptr(ptrs); }\n<span class=\"macro\">assert_eq!</span>(values, [<span class=\"number\">7</span>, <span class=\"number\">5</span>, <span class=\"number\">3</span>, <span class=\"number\">6</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BSimd,+ptr::SimdMutPtr%7D;%0Alet+mut+values+=+%5B0;+4%5D;%0Alet+offset+=+Simd::from_array(%5B3,+2,+1,+0%5D);%0Alet+ptrs+=+Simd::splat(values.as_mut_ptr()).wrapping_add(offset);%0Aunsafe+%7B+Simd::from_array(%5B6,+3,+5,+7%5D).scatter_ptr(ptrs);+%7D%0Aassert_eq!(values,+%5B7,+5,+3,+6%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.scatter_select_ptr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#651\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.scatter_select_ptr\" class=\"fn\">scatter_select_ptr</a>(\n    self,\n    dest: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>, N&gt;,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;\n)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Conditionally write pointers elementwise into a SIMD vector.\nThe mask <code>enable</code>s all <code>true</code> pointers and disables all <code>false</code> pointers.\nIf a pointer is disabled, the write to its pointee is skipped.</p>\n<h5 id=\"safety-5\"><a href=\"#safety-5\">Safety</a></h5>\n<p>Enabled pointers must satisfy the same conditions as <a href=\"std/ptr/fn.write.html\" title=\"fn std::ptr::write\"><code>core::ptr::write</code></a>.</p>\n<h5 id=\"example-5\"><a href=\"#example-5\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>values = [<span class=\"number\">0</span>; <span class=\"number\">4</span>];\n<span class=\"kw\">let </span>offset = Simd::from_array([<span class=\"number\">3</span>, <span class=\"number\">2</span>, <span class=\"number\">1</span>, <span class=\"number\">0</span>]);\n<span class=\"kw\">let </span>ptrs = Simd::splat(values.as_mut_ptr()).wrapping_add(offset);\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>, <span class=\"bool-val\">false</span>]);\n<span class=\"kw\">unsafe </span>{ Simd::from_array([<span class=\"number\">6</span>, <span class=\"number\">3</span>, <span class=\"number\">5</span>, <span class=\"number\">7</span>]).scatter_select_ptr(ptrs, enable); }\n<span class=\"macro\">assert_eq!</span>(values, [<span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">3</span>, <span class=\"number\">6</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BMask,+Simd,+ptr::SimdMutPtr%7D;%0Alet+mut+values+=+%5B0;+4%5D;%0Alet+offset+=+Simd::from_array(%5B3,+2,+1,+0%5D);%0Alet+ptrs+=+Simd::splat(values.as_mut_ptr()).wrapping_add(offset);%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+false,+false%5D);%0Aunsafe+%7B+Simd::from_array(%5B6,+3,+5,+7%5D).scatter_select_ptr(ptrs,+enable);+%7D%0Aassert_eq!(values,+%5B0,+0,+3,+6%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::simd::prelude::u8x16","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cusize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Sub-for-Simd%3Cusize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub%3C%26Simd%3CT,+N%3E%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#impl-Sub%3C%26Simd%3CT,+N%3E%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;: <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&lt;Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt;,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub<&Simd<T, N>>","std::simd::prelude::u8x16","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Sub-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Sub-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Sub-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.i64.html\">i64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cu16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Sub-for-Simd%3Cu16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.u16.html\">u16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cf32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#236-261\">source</a><a href=\"#impl-Sub-for-Simd%3Cf32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.f32.html\">f32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#236-261\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cf64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#236-261\">source</a><a href=\"#impl-Sub-for-Simd%3Cf64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#236-261\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Sub-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cu64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Sub-for-Simd%3Cu64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.u64.html\">u64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Sub-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Sub-for-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::prelude::u8x16","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cu32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Sub-for-Simd%3Cu32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ShrAssign%3CU%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-ShrAssign%3CU%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.ShrAssign.html\" title=\"trait std::ops::ShrAssign\">ShrAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;: <a class=\"trait\" href=\"std/ops/trait.Shr.html\" title=\"trait std::ops::Shr\">Shr</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.shr_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.shr_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.ShrAssign.html#tymethod.shr_assign\" class=\"fn\">shr_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>&gt;&gt;=</code> operation. <a href=\"std/ops/trait.ShrAssign.html#tymethod.shr_assign\">Read more</a></div></details></div></details>","ShrAssign<U>","std::simd::prelude::u8x16","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#717-720\">source</a><a href=\"#impl-PartialOrd-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a> + <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#723\">source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"std/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1125\">source</a></span><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1142\">source</a></span><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;=</code>\noperator. <a href=\"std/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1158\">source</a></span><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1175\">source</a></span><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;=</code>\noperator. <a href=\"std/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details></div></details>","PartialOrd","std::simd::prelude::u8x16","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#impl-Product-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cf64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#impl-Product-for-Simd%3Cf64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cu16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#impl-Product-for-Simd%3Cu16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cf32,+N%3E%3E-for-Simd%3Cf32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#impl-Product%3C%26Simd%3Cf32,+N%3E%3E-for-Simd%3Cf32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<f32, N>>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cu16,+N%3E%3E-for-Simd%3Cu16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#impl-Product%3C%26Simd%3Cu16,+N%3E%3E-for-Simd%3Cu16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<u16, N>>","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cu64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#impl-Product-for-Simd%3Cu64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#impl-Product-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#impl-Product-for-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::prelude::u8x16","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cf64,+N%3E%3E-for-Simd%3Cf64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#impl-Product%3C%26Simd%3Cf64,+N%3E%3E-for-Simd%3Cf64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<f64, N>>","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#impl-Product-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cu32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#impl-Product-for-Simd%3Cu32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Ci16,+N%3E%3E-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#impl-Product%3C%26Simd%3Ci16,+N%3E%3E-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<i16, N>>","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#impl-Product-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cu8,+N%3E%3E-for-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#impl-Product%3C%26Simd%3Cu8,+N%3E%3E-for-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<u8, N>>","std::simd::prelude::u8x16","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cisize,+N%3E%3E-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#impl-Product%3C%26Simd%3Cisize,+N%3E%3E-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<isize, N>>","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cusize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#impl-Product-for-Simd%3Cusize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cu64,+N%3E%3E-for-Simd%3Cu64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#impl-Product%3C%26Simd%3Cu64,+N%3E%3E-for-Simd%3Cu64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<u64, N>>","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cf32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#impl-Product-for-Simd%3Cf32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#impl-Product-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Ci8,+N%3E%3E-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#impl-Product%3C%26Simd%3Ci8,+N%3E%3E-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<i8, N>>","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Ci64,+N%3E%3E-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#impl-Product%3C%26Simd%3Ci64,+N%3E%3E-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<i64, N>>","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Ci32,+N%3E%3E-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#impl-Product%3C%26Simd%3Ci32,+N%3E%3E-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<i32, N>>","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cusize,+N%3E%3E-for-Simd%3Cusize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#impl-Product%3C%26Simd%3Cusize,+N%3E%3E-for-Simd%3Cusize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<usize, N>>","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cu32,+N%3E%3E-for-Simd%3Cu32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#impl-Product%3C%26Simd%3Cu32,+N%3E%3E-for-Simd%3Cu32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<div class=\"where\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;&gt;,</div></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<u32, N>>","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Cu64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Add-for-Simd%3Cu64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.u64.html\">u64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Cusize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Add-for-Simd%3Cusize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Add-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Cf64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#236-261\">source</a><a href=\"#impl-Add-for-Simd%3Cf64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#236-261\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Cu16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Add-for-Simd%3Cu16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.u16.html\">u16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Add-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Cf32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#236-261\">source</a><a href=\"#impl-Add-for-Simd%3Cf32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.f32.html\">f32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#236-261\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Cu32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Add-for-Simd%3Cu32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add%3C%26Simd%3CT,+N%3E%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#impl-Add%3C%26Simd%3CT,+N%3E%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;: <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&lt;Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt;,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add<&Simd<T, N>>","std::simd::prelude::u8x16","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Add-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.i64.html\">i64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Add-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Add-for-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::prelude::u8x16","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#impl-Add-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<div class=\"where\">where\n    <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#175-232\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Add.html#associatedtype.Output\" title=\"type std::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"std/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdInt-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#impl-SimdInt-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.i16.html\">i16</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Unsigned\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Unsigned\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" class=\"associatedtype\">Unsigned</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector of unsigned integers with the same element size.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Cast\" title=\"type std::simd::prelude::SimdInt::Cast\">Cast</a>&lt;T&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</div></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise absolute value, implemented in Rust.\nEvery element becomes its absolute value. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating absolute value, implemented in Rust.\nAs abs(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating negation, implemented in Rust.\nAs neg(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_neg\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.is_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each positive element and false if it is zero or negative.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.is_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each negative element and false if it is zero or positive.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns numbers representing the sign of each element. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the elements of the vector, with wrapping addition. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the elements of the vector, with wrapping multiplication. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum element in the vector. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum element in the vector. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.swap_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.swap_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.swap_bytes\" class=\"fn\">swap_bytes</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reverses the byte order of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reverse_bits\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reverse_bits\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reverse_bits\" class=\"fn\">reverse_bits</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reverses the order of bits in each elemnent.\nThe least significant bit becomes the most significant bit, second least-significant bit becomes second most-significant bit, etc.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_zeros\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.leading_zeros\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.leading_zeros\" class=\"fn\">leading_zeros</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of leading zeros in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_zeros\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.trailing_zeros\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.trailing_zeros\" class=\"fn\">trailing_zeros</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of trailing zeros in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_ones\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.leading_ones\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.leading_ones\" class=\"fn\">leading_ones</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of leading ones in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_ones\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.trailing_ones\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.trailing_ones\" class=\"fn\">trailing_ones</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of trailing ones in the binary representation of each element.</div></details></div></details>","SimdInt","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdInt-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#impl-SimdInt-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.i64.html\">i64</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Unsigned\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Unsigned\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" class=\"associatedtype\">Unsigned</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector of unsigned integers with the same element size.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Cast\" title=\"type std::simd::prelude::SimdInt::Cast\">Cast</a>&lt;T&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</div></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise absolute value, implemented in Rust.\nEvery element becomes its absolute value. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating absolute value, implemented in Rust.\nAs abs(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating negation, implemented in Rust.\nAs neg(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_neg\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.is_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each positive element and false if it is zero or negative.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.is_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each negative element and false if it is zero or positive.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns numbers representing the sign of each element. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the elements of the vector, with wrapping addition. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the elements of the vector, with wrapping multiplication. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum element in the vector. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum element in the vector. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.swap_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.swap_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.swap_bytes\" class=\"fn\">swap_bytes</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reverses the byte order of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reverse_bits\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reverse_bits\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reverse_bits\" class=\"fn\">reverse_bits</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reverses the order of bits in each elemnent.\nThe least significant bit becomes the most significant bit, second least-significant bit becomes second most-significant bit, etc.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_zeros\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.leading_zeros\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.leading_zeros\" class=\"fn\">leading_zeros</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of leading zeros in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_zeros\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.trailing_zeros\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.trailing_zeros\" class=\"fn\">trailing_zeros</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of trailing zeros in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_ones\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.leading_ones\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.leading_ones\" class=\"fn\">leading_ones</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of leading ones in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_ones\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.trailing_ones\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.trailing_ones\" class=\"fn\">trailing_ones</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of trailing ones in the binary representation of each element.</div></details></div></details>","SimdInt","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdInt-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#impl-SimdInt-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.isize.html\">isize</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Unsigned\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Unsigned\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" class=\"associatedtype\">Unsigned</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector of unsigned integers with the same element size.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Cast\" title=\"type std::simd::prelude::SimdInt::Cast\">Cast</a>&lt;T&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</div></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise absolute value, implemented in Rust.\nEvery element becomes its absolute value. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating absolute value, implemented in Rust.\nAs abs(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating negation, implemented in Rust.\nAs neg(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_neg\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.is_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each positive element and false if it is zero or negative.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.is_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each negative element and false if it is zero or positive.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns numbers representing the sign of each element. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the elements of the vector, with wrapping addition. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the elements of the vector, with wrapping multiplication. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum element in the vector. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum element in the vector. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.swap_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.swap_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.swap_bytes\" class=\"fn\">swap_bytes</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reverses the byte order of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reverse_bits\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reverse_bits\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reverse_bits\" class=\"fn\">reverse_bits</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reverses the order of bits in each elemnent.\nThe least significant bit becomes the most significant bit, second least-significant bit becomes second most-significant bit, etc.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_zeros\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.leading_zeros\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.leading_zeros\" class=\"fn\">leading_zeros</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of leading zeros in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_zeros\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.trailing_zeros\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.trailing_zeros\" class=\"fn\">trailing_zeros</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of trailing zeros in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_ones\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.leading_ones\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.leading_ones\" class=\"fn\">leading_ones</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of leading ones in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_ones\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.trailing_ones\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.trailing_ones\" class=\"fn\">trailing_ones</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of trailing ones in the binary representation of each element.</div></details></div></details>","SimdInt","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdInt-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#impl-SimdInt-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.i8.html\">i8</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Unsigned\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Unsigned\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" class=\"associatedtype\">Unsigned</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector of unsigned integers with the same element size.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Cast\" title=\"type std::simd::prelude::SimdInt::Cast\">Cast</a>&lt;T&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</div></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise absolute value, implemented in Rust.\nEvery element becomes its absolute value. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating absolute value, implemented in Rust.\nAs abs(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating negation, implemented in Rust.\nAs neg(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_neg\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.is_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each positive element and false if it is zero or negative.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.is_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each negative element and false if it is zero or positive.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns numbers representing the sign of each element. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the elements of the vector, with wrapping addition. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the elements of the vector, with wrapping multiplication. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum element in the vector. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum element in the vector. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.swap_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.swap_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.swap_bytes\" class=\"fn\">swap_bytes</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reverses the byte order of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reverse_bits\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reverse_bits\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reverse_bits\" class=\"fn\">reverse_bits</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reverses the order of bits in each elemnent.\nThe least significant bit becomes the most significant bit, second least-significant bit becomes second most-significant bit, etc.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_zeros\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.leading_zeros\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.leading_zeros\" class=\"fn\">leading_zeros</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of leading zeros in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_zeros\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.trailing_zeros\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.trailing_zeros\" class=\"fn\">trailing_zeros</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of trailing zeros in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_ones\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.leading_ones\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.leading_ones\" class=\"fn\">leading_ones</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of leading ones in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_ones\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.trailing_ones\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.trailing_ones\" class=\"fn\">trailing_ones</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of trailing ones in the binary representation of each element.</div></details></div></details>","SimdInt","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdInt-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#impl-SimdInt-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.i32.html\">i32</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Unsigned\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Unsigned\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" class=\"associatedtype\">Unsigned</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector of unsigned integers with the same element size.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Cast\" title=\"type std::simd::prelude::SimdInt::Cast\">Cast</a>&lt;T&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</div></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise absolute value, implemented in Rust.\nEvery element becomes its absolute value. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating absolute value, implemented in Rust.\nAs abs(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.saturating_neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating negation, implemented in Rust.\nAs neg(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.saturating_neg\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.is_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each positive element and false if it is zero or negative.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.is_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each negative element and false if it is zero or positive.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns numbers representing the sign of each element. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the elements of the vector, with wrapping addition. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the elements of the vector, with wrapping multiplication. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum element in the vector. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum element in the vector. <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the elements of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.swap_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.swap_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.swap_bytes\" class=\"fn\">swap_bytes</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reverses the byte order of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reverse_bits\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.reverse_bits\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.reverse_bits\" class=\"fn\">reverse_bits</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reverses the order of bits in each elemnent.\nThe least significant bit becomes the most significant bit, second least-significant bit becomes second most-significant bit, etc.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_zeros\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.leading_zeros\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.leading_zeros\" class=\"fn\">leading_zeros</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of leading zeros in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_zeros\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.trailing_zeros\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.trailing_zeros\" class=\"fn\">trailing_zeros</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of trailing zeros in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_ones\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.leading_ones\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.leading_ones\" class=\"fn\">leading_ones</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of leading ones in the binary representation of each element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_ones\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/simd/num/int.rs.html#371\">source</a><a href=\"#method.trailing_ones\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdInt.html#tymethod.trailing_ones\" class=\"fn\">trailing_ones</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdInt.html\" title=\"trait std::simd::prelude::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdInt.html#associatedtype.Unsigned\" title=\"type std::simd::prelude::SimdInt::Unsigned\">Unsigned</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the number of trailing ones in the binary representation of each element.</div></details></div></details>","SimdInt","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-DivAssign%3CU%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-DivAssign%3CU%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.DivAssign.html\" title=\"trait std::ops::DivAssign\">DivAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;: <a class=\"trait\" href=\"std/ops/trait.Div.html\" title=\"trait std::ops::Div\">Div</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.div_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.div_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.DivAssign.html#tymethod.div_assign\" class=\"fn\">div_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>/=</code> operation. <a href=\"std/ops/trait.DivAssign.html#tymethod.div_assign\">Read more</a></div></details></div></details>","DivAssign<U>","std::simd::prelude::u8x16","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ShlAssign%3CU%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-ShlAssign%3CU%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.ShlAssign.html\" title=\"trait std::ops::ShlAssign\">ShlAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;: <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.shl_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.ShlAssign.html#tymethod.shl_assign\" class=\"fn\">shl_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;=</code> operation. <a href=\"std/ops/trait.ShlAssign.html#tymethod.shl_assign\">Read more</a></div></details></div></details>","ShlAssign<U>","std::simd::prelude::u8x16","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AddAssign%3CU%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-AddAssign%3CU%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.AddAssign.html\" title=\"trait std::ops::AddAssign\">AddAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;: <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.add_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.add_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.AddAssign.html#tymethod.add_assign\" class=\"fn\">add_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>+=</code> operation. <a href=\"std/ops/trait.AddAssign.html#tymethod.add_assign\">Read more</a></div></details></div></details>","AddAssign<U>","std::simd::prelude::u8x16","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu32,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu32,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#13}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u32x1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cusize,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cusize,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#25}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::usizex8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu16,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu16,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#11}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u16x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci32,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci32,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#43}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i32x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci8,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci8,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#28}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i8x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci64,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci64,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#46}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i64x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci32,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci32,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#41}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i32x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci8,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci8,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#29}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i8x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu8,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu8,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#3}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u8x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cf32,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cf32,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#55}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::f32x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cisize,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cisize,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#50}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::isizex4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu16,+32%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu16,+32%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#12}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u16x32"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci64,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci64,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#45}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i64x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu8,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu8,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#0}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u8x1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci32,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci32,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#40}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i32x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci32,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci32,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#42}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i32x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu32,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu32,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#17}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u32x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu8,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu8,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#1}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u8x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci64,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci64,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#44}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i64x1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu8,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu8,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#2}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u8x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci16,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci16,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#33}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i16x1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu32,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu32,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#16}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u32x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci8,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci8,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#26}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i8x1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cf32,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cf32,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#53}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::f32x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci8,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci8,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#30}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i8x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cf32,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cf32,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#56}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::f32x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci16,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci16,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#36}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i16x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cusize,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cusize,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#24}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::usizex4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cusize,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cusize,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#23}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::usizex2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cf64,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cf64,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#59}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::f64x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu8,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu8,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#4}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::prelude::u8x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cf64,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cf64,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#57}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::f64x1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci16,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci16,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#35}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i16x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu64,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu64,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#21}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u64x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu32,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu32,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#14}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u32x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cf32,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cf32,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#52}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::f32x1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci16,+32%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci16,+32%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#38}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i16x32"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci32,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci32,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#39}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#137\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i32x1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu16,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu16,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#9}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u16x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci16,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci16,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#37}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i16x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci8,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci8,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#27}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i8x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci64,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci64,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#47}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#138\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i64x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cisize,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cisize,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#48}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::isizex1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu16,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu16,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#10}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u16x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cf32,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cf32,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#54}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#144\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::f32x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cf64,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cf64,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#60}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::f64x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu64,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu64,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#19}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u64x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu64,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu64,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#18}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u64x1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cf64,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cf64,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#58}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#145\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::f64x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cisize,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cisize,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#51}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::isizex8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu8,+64%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu8,+64%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#6}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cisize,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cisize,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#49}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#142\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::isizex2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci16,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci16,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#34}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#136\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i16x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci8,+32%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci8,+32%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#31}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i8x32"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Ci8,+64%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#impl-ToBytes-for-Simd%3Ci8,+64%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#32}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#135\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu64,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu64,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#20}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#129\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u64x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu16,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu16,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#7}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u16x1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu32,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu32,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#15}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#128\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u32x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cusize,+1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cusize,+1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 1&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#22}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#133\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 1&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 1&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::usizex1"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu8,+32%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu8,+32%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#5}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#126\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u8x32"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ToBytes-for-Simd%3Cu16,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#impl-ToBytes-for-Simd%3Cu16,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Bytes\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" class=\"associatedtype\">Bytes</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, core::::core_simd::to_bytes::{impl#8}::Bytes::{constant#0}&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>This type, reinterpreted as bytes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in native byte\norder.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in big-endian\n(network) byte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.to_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Return the memory representation of this integer as a byte array in little-endian\nbyte order.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_ne_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create a native endian integer value from its memory representation as a byte array\nin native endianness.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_be_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in big endian.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/to_bytes.rs.html#127\">source</a><a href=\"#method.from_le_bytes\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.ToBytes.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 2&gt; as <a class=\"trait\" href=\"std/simd/trait.ToBytes.html\" title=\"trait std::simd::ToBytes\">ToBytes</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.ToBytes.html#associatedtype.Bytes\" title=\"type std::simd::ToBytes::Bytes\">Bytes</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 2&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Create an integer value from its representation as a byte array in little endian.</div></details></div></details>","ToBytes","std::simd::u16x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAndAssign%3CU%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-BitAndAssign%3CU%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAndAssign.html\" title=\"trait std::ops::BitAndAssign\">BitAndAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;: <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.bitand_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAndAssign.html#tymethod.bitand_assign\" class=\"fn\">bitand_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>&amp;=</code> operation. <a href=\"std/ops/trait.BitAndAssign.html#tymethod.bitand_assign\">Read more</a></div></details></div></details>","BitAndAssign<U>","std::simd::prelude::u8x16","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open>