#ifndef _CA_IOWRAP_H_
#define _CA_IOWRAP_H_

#ifndef __CABYTE_
#define	__CABYTE_
typedef unsigned char CAByte;
#endif

typedef struct t_CAIOLibProcs{
	//	void*   (*caiolibCreate)(CAIOLibProcs** ppProcs); 
	void    (*caiolibDestroy)(void* pLibCxt);
	int     (*caiolibOpen)(void* pLibCxt, char* pDevURI);
	int     (*caiolibClose)(void* pLibCxt);
	ssize_t (*caiolibRead)(void* pLibCxt, CAByte* pReadBuf, size_t nReadSize);
	ssize_t (*caiolibWrite)(void* pLibCxt, CAByte* pWreiteBuf, 
							size_t nWreiteSize);
	int     (*caiolibControl)(void* pLibCxt, int nCmd, void* pArgs, 
							  void* pRes);
} CAIOLibProcs;


typedef struct t_caWrapCxt{
	void* pModuleHandle;
	CAIOLibProcs *pProcs;
	void* pLibCxt;
	int nError;
	void*   (*caiolibCreate)(CAIOLibProcs* pProcs); 

} CAIOCxt;

CAIOCxt* caioCreate(char* pModuleName);
void caioDestroy(CAIOCxt* pCxt);
int caioOpen(CAIOCxt* pCxt, char* pDevURI);
int caioClose(CAIOCxt* pCxt);
ssize_t caioRead(CAIOCxt* pCxt, CAByte* pBuf, size_t nReadSize);
ssize_t caioWrite(CAIOCxt* pCxt, CAByte* pBuf, size_t nWriteSize);
int caioControl(CAIOCxt* pCxt, int nCmd, void* pArgv, void *pRes);
int caioGetError(CAIOCxt* pCxt);

#define CAIO_EINTR         -2
#define CAIO_INV_HANDLE    -3
#define CAIO_NOTSUPPORT    -4
#define CAIO_INV_ARG       -5
#define CAIO_EMODULE       -6
#endif // _CA_IOWRAP_H_
