/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/

#include "bn.hpp"

struct BNBwdTestTestHalf
    : BNBwdTest<half_float::half, float, float, float, half_float::half, float, float>
{
};

struct BNBwdTestFloat : BNBwdTest<float, float, float, float, float, float, float>
{
};

struct BNBwdTestBFloat16 : BNBwdTest<bfloat16, float, float, float, bfloat16, float, float>
{
};

struct BNBwdTestDouble : BNBwdTest<double, double, double, double, double, double, double>
{
};

TEST_P(BNBwdTestTestHalf, BnBwdCKHalf) {}

TEST_P(BNBwdTestFloat, BnBwdCKFloat) {}

// Currently disabled since miopen::batchnorm::MakeForwardTrainingNetworkConfig
// only supports half and float
TEST_P(BNBwdTestBFloat16, DISABLED_BnBwdCKBFloat16) {}
TEST_P(BNBwdTestDouble, DISABLED_BnBwdCKDouble) {}

INSTANTIATE_TEST_SUITE_P(BNBwdTestTestHalfNHWCSuite,
                         BNBwdTestTestHalf,
                         testing::Combine(testing::ValuesIn(Network1<BNTestCase>()),
                                          testing::Values(miopenTensorNHWC)));

INSTANTIATE_TEST_SUITE_P(BNBwdTestFloatNHWCSuite,
                         BNBwdTestFloat,
                         testing::Combine(testing::ValuesIn(Network1<BNTestCase>()),
                                          testing::Values(miopenTensorNHWC)));

INSTANTIATE_TEST_SUITE_P(BNBwdTestBFloat16NHWCSuite,
                         BNBwdTestBFloat16,
                         testing::Combine(testing::ValuesIn(Network1<BNTestCase>()),
                                          testing::Values(miopenTensorNHWC)));

INSTANTIATE_TEST_SUITE_P(BNBwdTestDoubleNHWCSuite,
                         BNBwdTestDouble,
                         testing::Combine(testing::ValuesIn(Network1<BNTestCase>()),
                                          testing::Values(miopenTensorNHWC)));
