/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 * 
 */

#ifndef __SBP2_MAIN_H__
#define __SBP2_MAIN_H__


#include <glib.h>

#include <libraw1394/raw1394.h>

#include <libsbp2/sbp2pointer.h>


typedef struct _SBP2Tag SBP2Tag;

typedef gboolean (*SBP2TagProcessFunc) (gpointer  data);
typedef void     (*SBP2TagFreeFunc)    (gpointer  data);


guint    sbp2_watch_handle (raw1394handle_t     handle,
			    GMainContext       *context);

SBP2Tag *sbp2_tag_new      (SBP2TagProcessFunc  process,
			    SBP2TagFreeFunc     free,
			    gpointer            data);

void     sbp2_write_data   (raw1394handle_t     handle,
			    gsize               chunk_size,
			    nodeid_t            node,
			    SBP2Pointer        *pointer,
			    gpointer            data,
			    gsize               length);

void     sbp2_read_data    (raw1394handle_t     handle,
                            gsize               chunk_size,
			    nodeid_t            node,
			    SBP2Pointer        *pointer,
			    gpointer            data,
			    gsize               length,
			    SBP2Tag            *tag);


#endif /* __SBP2_MAIN_H__ */
